/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm.estiPBN;

import PBN.BitSetPBN;
import PBN.Property;
import functionLib.Parameters;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import parameterEstimation.particleSwarm.FitnessFunction;
import simulationMethod.GelmanFullStateParallel;
import simulationMethod.SimulationMethod;
import simulationMethod.TwoStateBitSet;
import simulationMethod.TwoStateMultiProperty;
import simulationMethod.TwostateMultiPropertyParallel;
import userInterface.AssaLog;

public class PBNFitnessFunction
extends FitnessFunction {
    private List<Double>[] measurementData;
    private List<Double>[] lastFittedData;
    private List<Double>[] bestFittedData;
    private double bestFit;
    private double[] lastPosition;
    private List<Double>[] weight;
    private List<Property>[] properties;
    private List<int[]> parameterIndices;
    private int[] cumPositionIndex;
    private int evaluateMethod;
    private SimulationMethod ts = null;
    private AssaLog assalog = null;
    private int simulationMethod;
    private double precision;
    private double confidence;
    private int additionalPara;
    private List<BitSetPBN> pbns;

    public PBNFitnessFunction() throws Exception {
        throw new Exception("set log file please!");
    }

    public PBNFitnessFunction(AssaLog assalog) {
        this.assalog = assalog;
    }

    public void setMeasurementData(List<Double>[] measurementData) {
        this.measurementData = measurementData;
    }

    public void setCumPositionIndex(int[] cumPositionIndex) {
        this.cumPositionIndex = cumPositionIndex;
    }

    public void setLastPosition(double[] lastPosition) {
        this.lastPosition = lastPosition;
    }

    public void setBestFittedData(List<Double>[] bestFittedData) {
        this.bestFittedData = bestFittedData;
    }

    public void setLastFittedData(List<Double>[] lastFittedData) {
        this.lastFittedData = lastFittedData;
    }

    public void setWeight(List<Double>[] weight) {
        this.weight = weight;
    }

    public void setProperties(List<Property>[] properties) {
        this.properties = properties;
    }

    public void setEvaluateMethod(int evaluateMethod) {
        this.evaluateMethod = evaluateMethod;
    }

    public void setSimulationMethod() throws Exception {
        this.setSimulationMethod(0.001, 0.95);
    }

    public void setSimulationMethod(double precision, double confidence) throws Exception {
        this.setSimulationMethod(precision, confidence, 0, 0);
    }

    public void setSimulationMethod(double precision, double confidence, int simulationMethod, int additionalPara) throws Exception {
        double[] parameters = new double[]{precision, confidence};
        this.confidence = confidence;
        this.precision = precision;
        this.additionalPara = additionalPara;
        this.simulationMethod = simulationMethod;
        String output = "Method used for computing steady-state probability: ";
        switch (simulationMethod) {
            case 0: {
                this.ts = new TwoStateBitSet(this.assalog, precision, confidence, Parameters.epsilon, 1);
                output = String.valueOf(output) + "two-state Markov chain approach.";
                break;
            }
            case 1: {
                this.ts = new GelmanFullStateParallel(null, this.assalog);
                output = String.valueOf(output) + "two-state Markov chain approach parallel version.";
                break;
            }
            case 2: {
                this.ts = new TwostateMultiPropertyParallel(null, this.assalog);
                output = String.valueOf(output) + "two-state Markov chain approach parallel multiple properties version.";
                if (additionalPara != 0) {
                    ((TwostateMultiPropertyParallel)this.ts).setM(additionalPara);
                    break;
                }
                ((TwostateMultiPropertyParallel)this.ts).setM(Runtime.getRuntime().availableProcessors());
                break;
            }
            case 3: {
                this.ts = new TwoStateMultiProperty(this.assalog);
                output = String.valueOf(output) + "two-state Markov chain approach multiple properties version.";
                break;
            }
            default: {
                this.ts = new TwoStateBitSet(this.assalog, precision, confidence, Parameters.epsilon, 1);
                output = String.valueOf(output) + "two-state Markov chain approach.";
            }
        }
        output = String.valueOf(output) + "\nprecision is " + precision + ", confidence level is " + confidence + ".";
        this.assalog.println(output);
        this.ts.setParameters(parameters);
        this.ts.setEnableOutput(false);
    }

    public void setPBNs(List<BitSetPBN> pbns) {
        this.pbns = pbns;
    }

    public List<int[]> getParameterIndices() {
        return this.parameterIndices;
    }

    public int[] getCumPositionIndex() {
        return this.cumPositionIndex;
    }

    public List<Double>[] getLastFittedData() {
        return this.lastFittedData;
    }

    public List<Double>[] getBestFittedData() {
        return this.bestFittedData;
    }

    public double getBestFit() {
        return this.bestFit;
    }

    public List<Double>[] getMeasurementData() {
        return this.measurementData;
    }

    public double[] getLastPostion() {
        return this.lastPosition;
    }

    public void setParameterIndices(String parameterFile) throws Exception {
        if (this.pbns == null) {
            throw new Exception("PBNs are not defined. Please define PBNs before set parameters of PSO.");
        }
        String line = "";
        this.parameterIndices = new ArrayList<int[]>();
        this.assalog.println("\nAssigning the nodes which are to be fitted.");
        InputStreamReader reader = new InputStreamReader(new FileInputStream(parameterFile));
        BufferedReader br = new BufferedReader(reader);
        int[] nf = this.pbns.get(0).getNf();
        while ((line = br.readLine()) != null) {
            int nodeIndex = Integer.parseInt(line);
            int[] indices = new int[]{nodeIndex, nf[nodeIndex] - 1};
            this.parameterIndices.add(indices);
        }
        this.cumPositionIndex = new int[this.parameterIndices.size() + 1];
        this.cumPositionIndex[0] = 0;
        int i = 1;
        while (i < this.parameterIndices.size() + 1) {
            this.cumPositionIndex[i] = this.cumPositionIndex[i - 1] + this.parameterIndices.get(i - 1)[1];
            ++i;
        }
        this.lastPosition = new double[this.cumPositionIndex[this.cumPositionIndex.length - 1]];
        List<double[]> cijs = this.pbns.get(0).getCij();
        int count = 0;
        int i2 = 0;
        while (i2 < this.parameterIndices.size()) {
            double[] cijElement = cijs.get(this.parameterIndices.get(i2)[0]);
            int j = 0;
            while (j < cijElement.length - 1) {
                this.lastPosition[count] = cijElement[j];
                ++count;
                ++j;
            }
            ++i2;
        }
        br.close();
        this.assalog.println("Finish assigning the nodes which are to be fitted.");
    }

    public void setParameterIndices(List<int[]> parameterIndices) {
        this.parameterIndices = parameterIndices;
    }

    public void setProperties(String propertyFile) throws Exception {
        String line = "";
        int pbnIndex = 0;
        this.assalog.println("\nAssigning measurement data for fitting.");
        if (this.pbns == null) {
            throw new Exception("Please set PBNs first!");
        }
        this.measurementData = new ArrayList[this.pbns.size()];
        this.lastFittedData = new ArrayList[this.pbns.size()];
        this.bestFittedData = new ArrayList[this.pbns.size()];
        this.bestFit = this.maximize ? 0.0 : Double.MAX_VALUE;
        this.weight = new ArrayList[this.pbns.size()];
        this.properties = new ArrayList[this.pbns.size()];
        InputStreamReader reader = new InputStreamReader(new FileInputStream(propertyFile));
        BufferedReader br = new BufferedReader(reader);
        int i = 0;
        while (i < this.pbns.size()) {
            this.measurementData[i] = new ArrayList<Double>();
            this.lastFittedData[i] = new ArrayList<Double>();
            this.bestFittedData[i] = new ArrayList<Double>();
            this.weight[i] = new ArrayList<Double>();
            this.properties[i] = new ArrayList<Property>();
            ++i;
        }
        while ((line = br.readLine()) != null) {
            int value;
            StringTokenizer token;
            if (line.startsWith("//")) continue;
            if (line.trim().toLowerCase().startsWith("pbnindex")) {
                token = new StringTokenizer(line, "=");
                token.nextToken();
                pbnIndex = Integer.parseInt(token.nextToken());
                continue;
            }
            ArrayList<Integer> positiveIndex = new ArrayList<Integer>();
            ArrayList<Integer> negativeIndex = new ArrayList<Integer>();
            token = new StringTokenizer(line, " ");
            while (token.hasMoreTokens()) {
                value = Integer.parseInt(token.nextToken());
                if (value < 0) continue;
                positiveIndex.add(value);
            }
            while ((line = br.readLine()).startsWith("//")) {
            }
            token = new StringTokenizer(line, " ");
            while (token.hasMoreTokens()) {
                value = Integer.parseInt(token.nextToken());
                if (value < 0) continue;
                negativeIndex.add(value);
            }
            Property property = new Property();
            property.setExpressions(positiveIndex, negativeIndex);
            this.properties[pbnIndex].add(property);
            while ((line = br.readLine()).startsWith("//")) {
            }
            this.measurementData[pbnIndex].add(Double.parseDouble(line));
            while ((line = br.readLine()).startsWith("//")) {
            }
            this.weight[pbnIndex].add(Double.parseDouble(line));
            this.lastFittedData[pbnIndex].add(0.0);
            this.bestFittedData[pbnIndex].add(0.0);
        }
        br.close();
        this.assalog.println("Finish assigning measurement data for fitting.");
    }

    public double squareMean(double[] position) throws Exception {
        int i;
        double[] steadys = null;
        double sum = 0.0;
        double fitness = 0.0;
        int divisor = 0;
        ArrayList<Property> tmpProperty = new ArrayList<Property>();
        int index = 0;
        while (index < this.pbns.size()) {
            List<double[]> cij = this.pbns.get(index).getCij();
            i = 0;
            while (i < this.parameterIndices.size()) {
                double[] cijElement = cij.get(this.parameterIndices.get(i)[0]);
                sum = 0.0;
                int j = 0;
                while (j < cijElement.length - 1) {
                    cijElement[j] = position[this.cumPositionIndex[i] + j];
                    sum += cijElement[j];
                    ++j;
                }
                cijElement[cijElement.length - 1] = 1.0 - sum;
                ++i;
            }
            if (this.simulationMethod == 2 || this.simulationMethod == 3) {
                tmpProperty.clear();
                for (Property e : this.properties[index]) {
                    tmpProperty.add(e);
                }
                this.ts.setExpressions(tmpProperty);
                steadys = this.ts.run(this.pbns.get(index), true)[0];
            } else {
                steadys = new double[this.properties[index].size()];
                i = 0;
                while (i < steadys.length) {
                    tmpProperty.clear();
                    tmpProperty.add(this.properties[index].get(i));
                    this.ts.setExpressions(tmpProperty);
                    steadys[i] = this.ts.run(this.pbns.get(index))[0];
                    ++i;
                }
            }
            sum = 0.0;
            this.lastFittedData[index].clear();
            i = 0;
            while (i < steadys.length) {
                double tmp = this.weight[index].get(i) * (steadys[i] - this.measurementData[index].get(i));
                sum += tmp * tmp;
                this.lastFittedData[index].add(steadys[i]);
                ++i;
            }
            divisor += steadys.length;
            fitness += sum;
            ++index;
        }
        fitness = divisor == 0 ? 0.0 : (fitness /= (double)divisor);
        this.lastPosition = position;
        if (this.isBetterThan(this.bestFit, fitness)) {
            this.bestFit = fitness;
            index = 0;
            while (index < this.pbns.size()) {
                this.bestFittedData[index].clear();
                i = 0;
                while (i < steadys.length) {
                    this.bestFittedData[index].add(steadys[i]);
                    ++i;
                }
                ++index;
            }
        }
        return fitness;
    }

    @Override
    public double evaluate(double[] position) {
        double result = 0.0;
        switch (this.evaluateMethod) {
            case 0: {
                try {
                    result = this.squareMean(position);
                }
                catch (Exception e) {
                    this.assalog.println("Error happens when evaluating a position: " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                break;
            }
            default: {
                return 0.0;
            }
        }
        return result;
    }

    public void setBestFit(double bestFit) {
        this.bestFit = bestFit;
    }

    public PBNFitnessFunction clone() throws CloneNotSupportedException {
        PBNFitnessFunction fitnessFunction = null;
        fitnessFunction = new PBNFitnessFunction(this.assalog);
        fitnessFunction.setEvaluateMethod(this.evaluateMethod);
        fitnessFunction.setPBNs(this.pbns);
        fitnessFunction.setMeasurementData(this.measurementData);
        fitnessFunction.setParameterIndices(this.parameterIndices);
        fitnessFunction.setCumPositionIndex(this.cumPositionIndex);
        double[] lastPosition = (double[])this.lastPosition.clone();
        fitnessFunction.setLastPosition(lastPosition);
        ArrayList[] bestFittedData = new ArrayList[this.bestFittedData.length];
        ArrayList[] lastFittedData = new ArrayList[this.lastFittedData.length];
        int i = 0;
        while (i < this.bestFittedData.length) {
            double tmp;
            bestFittedData[i] = new ArrayList();
            for (Double d : this.bestFittedData[i]) {
                tmp = d;
                bestFittedData[i].add(tmp);
            }
            lastFittedData[i] = new ArrayList();
            for (Double d : this.lastFittedData[i]) {
                tmp = d;
                lastFittedData[i].add(tmp);
            }
            ++i;
        }
        fitnessFunction.setBestFittedData(bestFittedData);
        fitnessFunction.setLastFittedData(lastFittedData);
        ArrayList[] properties = new ArrayList[this.properties.length];
        int i2 = 0;
        while (i2 < this.properties.length) {
            properties[i2] = new ArrayList();
            for (Property p : this.properties[i2]) {
                properties[i2].add(p);
            }
            ++i2;
        }
        fitnessFunction.setProperties(properties);
        try {
            fitnessFunction.setSimulationMethod(this.precision, this.confidence, this.simulationMethod, this.additionalPara);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fitnessFunction.setMaximize(false);
        fitnessFunction.setBestFit(this.bestFit);
        fitnessFunction.setWeight(this.weight);
        return fitnessFunction;
    }
}

