/*
 * Decompiled with CFR 0.152.
 */
package parameterEstimation.particleSwarm.estiPBN;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import parameterEstimation.particleSwarm.Particle;

public class PBNParticle
extends Particle {
    private static int dimension;
    private PrintWriter pw;

    public PBNParticle() {
        super(dimension);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        String outputName = "PSO" + df.format(new Date()) + this.hashCode() + ".txt";
        try {
            this.pw = new PrintWriter(new FileWriter(outputName, true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PBNParticle(int dimension) {
        super(dimension);
        PBNParticle.dimension = dimension;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        String outputName = "PSO" + df.format(new Date()) + this.hashCode() + ".txt";
        try {
            this.pw = new PrintWriter(new FileWriter(outputName, true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closePW() {
        this.pw.close();
    }

    public void applyMoreConstraints(int[] cumPositionIndex, int in) {
        if (cumPositionIndex != null) {
            this.pw.print(String.valueOf(this.hashCode()) + "\t");
            int i = 0;
            while (i < cumPositionIndex.length - 1) {
                double sum = 0.0;
                int j = cumPositionIndex[i];
                while (j < cumPositionIndex[i + 1]) {
                    sum += this.position[j];
                    ++j;
                }
                if (sum > 1.0) {
                    j = cumPositionIndex[i];
                    while (j < cumPositionIndex[i + 1]) {
                        this.pw.print(String.valueOf(this.position[j] - this.velocity[j] - this.position[j] / sum) + "\t");
                        int n = j++;
                        this.position[n] = this.position[n] / sum;
                    }
                } else {
                    j = cumPositionIndex[i];
                    while (j < cumPositionIndex[i + 1]) {
                        this.pw.print(String.valueOf(this.velocity[j]) + "\t");
                        ++j;
                    }
                }
                ++i;
            }
            this.pw.println();
        }
    }
}

