/*
 * Decompiled with CFR 0.152.
 */
package parser;

public class Error
extends Exception {
    private int row_;
    private int col_;
    private int id_;
    private String msg_;

    Error(int id, String str) {
        this.row_ = -1;
        this.col_ = -1;
        this.id_ = id;
        this.msg_ = String.format(this.errorMsg(this.id_), str);
    }

    Error(int id) {
        this.row_ = -1;
        this.col_ = -1;
        this.id_ = id;
        this.msg_ = this.errorMsg(this.id_);
    }

    Error(int row, int col, int id, String str) {
        this.row_ = row;
        this.col_ = col;
        this.id_ = id;
        this.msg_ = String.format(this.errorMsg(this.id_), str);
    }

    Error(int row, int col, int id) {
        this.row_ = row;
        this.col_ = col;
        this.id_ = id;
        this.msg_ = this.errorMsg(this.id_);
    }

    final String get() {
        String res = this.row_ == -1 ? (this.col_ == -1 ? String.format("Error: %s", this.msg_) : String.format("Error: %s (col %d)", this.msg_, this.col_)) : String.format("Error: %s (ln %d, col %d)", this.msg_, this.row_, this.col_);
        return res;
    }

    int get_id() {
        return this.id_;
    }

    private String errorMsg(int id) {
        switch (id) {
            case 1: {
                return "Syntax error in part \"%s\"";
            }
            case 2: {
                return "Syntax error";
            }
            case 3: {
                return "Parentesis ) missing";
            }
            case 4: {
                return "Empty expression";
            }
            case 5: {
                return "Unexpected part \"%s\"";
            }
            case 6: {
                return "Unexpected end of expression";
            }
            case 7: {
                return "Value expected";
            }
            case 101: {
                return "Unknown operator %s";
            }
            case 102: {
                return "Unknown function %s";
            }
            case 103: {
                return "Unknown variable %s";
            }
            case 104: {
                return "Unknown operator";
            }
            case 200: {
                return "Too long expression, maximum number of characters exceeded";
            }
            case 300: {
                return "Defining variable failed";
            }
            case 400: {
                return "Integer value expected in function %s";
            }
            case 500: {
                return "%s";
            }
        }
        return "Unknown error";
    }
}

