/*
 * Decompiled with CFR 0.152.
 */
package parser;

import functionLib.AssaException;
import java.util.BitSet;
import parser.AssaKeyWords;

public class Expression
implements AssaKeyWords {
    private int type;
    private Expression leftChild;
    private Expression rightChild;
    private int operator;
    private int variableID;
    private String variableName;

    public Expression() {
        this.variableID = -1;
        this.type = -1;
    }

    public Expression(int variableID, String variableName) {
        this.variableID = variableID;
        this.variableName = variableName;
        this.type = 0;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public void setLeftChild(Expression leftChild) {
        this.leftChild = leftChild;
    }

    public void setRightChild(Expression rightChild) {
        this.rightChild = rightChild;
        this.type = 3;
    }

    public int getType() {
        return this.type;
    }

    public int getID() {
        return this.variableID;
    }

    public Expression getLeftChild() {
        return this.leftChild;
    }

    public Expression getRightChild() {
        return this.rightChild;
    }

    public String toString() {
        String res = "";
        switch (this.type) {
            case 0: {
                res = String.valueOf(res) + this.variableName;
                break;
            }
            case 1: {
                if (this.leftChild == null) {
                    res = String.valueOf(res) + "!" + this.variableName;
                    break;
                }
                res = String.valueOf(res) + "!" + this.leftChild.toString();
                break;
            }
            case 2: {
                res = String.valueOf(res) + "(" + this.leftChild.toString() + ")";
                break;
            }
            case 3: {
                try {
                    res = String.valueOf(res) + this.leftChild.toString() + this.getOperatorString(this.operator) + this.rightChild.toString();
                }
                catch (AssaException e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                res = null;
            }
        }
        return res;
    }

    private String getOperatorString(int operator) throws AssaException {
        String res;
        switch (operator) {
            case 0: {
                res = "!";
                break;
            }
            case 1: {
                res = "&";
                break;
            }
            case 2: {
                res = "|";
                break;
            }
            case 3: {
                res = "^";
                break;
            }
            default: {
                throw new AssaException("Unknown operator!");
            }
        }
        return res;
    }

    public int getOperator() {
        return this.operator;
    }

    public Boolean evaluate(BitSet bt) {
        return false;
    }
}

