/*
 * Decompiled with CFR 0.152.
 */
package parser;

import functionLib.AssaException;
import parser.AssaKeyWords;
import parser.Error;
import parser.Expression;
import parser.Model;
import parser.OPERATOR;

public class ExpressionParser
implements AssaKeyWords {
    private Expression expression;
    private String expr;
    private int expr_pos;
    private char expr_c;
    private String token;
    private TOKENTYPE token_type;
    private Model model;

    public void setModel(Model model) {
        this.model = model;
    }

    public Expression parseExpression(String new_expr) throws AssaException, Error {
        if (this.model == null) {
            throw new AssaException("Model is not set!");
        }
        this.expr = new_expr;
        this.getFirstChar();
        this.getToken();
        if (this.token_type == TOKENTYPE.DELIMITER && this.expr_c == '\u0000') {
            throw new Error(this.row(), this.col(), 4);
        }
        this.expression = this.parse_type3();
        if (this.token_type != TOKENTYPE.DELIMITER || this.token.length() > 0) {
            if (this.token_type == TOKENTYPE.DELIMITER) {
                throw new Error(this.row(), this.col(), 101, this.token);
            }
            throw new Error(this.row(), this.col(), 5, this.token);
        }
        return this.expression;
    }

    Expression parse_type3() throws Error, AssaException {
        Expression ans = this.parse_type1();
        OPERATOR op_id = this.get_operator_id(this.token);
        while (op_id == OPERATOR.AND || op_id == OPERATOR.OR || op_id == OPERATOR.XOR) {
            this.getToken();
            ans = this.eval_operator(op_id, ans, this.parse_type1());
            op_id = this.get_operator_id(this.token);
        }
        return ans;
    }

    Expression parse_type1() throws Error, AssaException {
        Expression ans;
        OPERATOR op_id = this.get_operator_id(this.token);
        if (op_id == OPERATOR.NOT) {
            this.getToken();
            ans = new Expression();
            Expression ans1 = this.parse_type2or0();
            ans.setOperator(0);
            ans.setLeftChild(ans1);
            ans.setType(1);
        } else {
            ans = this.parse_type2or0();
        }
        return ans;
    }

    Expression parse_type2or0() throws Error, AssaException {
        Expression ans = null;
        if (this.token_type == TOKENTYPE.DELIMITER && this.token.equals("(")) {
            this.getToken();
            Expression res = this.parse_type3();
            ans = new Expression();
            ans.setLeftChild(res);
            ans.setType(2);
            if (this.token_type != TOKENTYPE.DELIMITER || !this.token.equals(")")) {
                throw new Error(this.row(), this.col(), 3);
            }
            this.getToken();
            return ans;
        }
        return this.parse_type0();
    }

    Expression parse_type0() throws AssaException, Error {
        int id = this.model.getNodeID(this.token);
        Expression ans = new Expression(id, this.token);
        this.getToken();
        return ans;
    }

    boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t';
    }

    boolean isDELIMITER(char c) {
        return "&|^!".indexOf(c) != -1;
    }

    boolean isAlpha(char c) {
        char cUpper = Character.toUpperCase(c);
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ_".indexOf(cUpper) != -1;
    }

    boolean isDigitDot(char c) {
        return "0123456789.".indexOf(c) != -1;
    }

    boolean isDigit(char c) {
        return "0123456789".indexOf(c) != -1;
    }

    void getChar() {
        ++this.expr_pos;
        this.expr_c = this.expr_pos < this.expr.length() ? this.expr.charAt(this.expr_pos) : (char)'\u0000';
    }

    void getFirstChar() {
        this.expr_pos = 0;
        this.expr_c = this.expr_pos < this.expr.length() ? this.expr.charAt(this.expr_pos) : (char)'\u0000';
    }

    void getToken() throws Error {
        this.token_type = TOKENTYPE.NOTHING;
        this.token = "";
        while (this.isWhiteSpace(this.expr_c)) {
            this.getChar();
        }
        if (this.expr_c == '\u0000') {
            this.token_type = TOKENTYPE.DELIMITER;
            return;
        }
        if (this.expr_c == '(' || this.expr_c == ')') {
            this.token_type = TOKENTYPE.DELIMITER;
            this.token = String.valueOf(this.token) + this.expr_c;
            this.getChar();
            return;
        }
        if (this.isDELIMITER(this.expr_c)) {
            this.token_type = TOKENTYPE.DELIMITER;
            while (this.isDELIMITER(this.expr_c)) {
                this.token = String.valueOf(this.token) + this.expr_c;
                this.getChar();
            }
            return;
        }
        if (this.isAlpha(this.expr_c)) {
            while (this.isAlpha(this.expr_c) || this.isDigit(this.expr_c)) {
                this.token = String.valueOf(this.token) + this.expr_c;
                this.getChar();
            }
            while (this.isWhiteSpace(this.expr_c)) {
                this.getChar();
            }
            this.token_type = TOKENTYPE.VARIABLE;
            return;
        }
        this.token_type = TOKENTYPE.UNKNOWN;
        while (this.expr_c != '\u0000') {
            this.token = String.valueOf(this.token) + this.expr_c;
            this.getChar();
        }
        throw new Error(this.row(), this.col(), 1, this.token);
    }

    int row() {
        return -1;
    }

    int col() {
        return this.expr_pos - this.token.length() + 1;
    }

    OPERATOR get_operator_id(String op_name) {
        if (op_name.equals("&")) {
            return OPERATOR.AND;
        }
        if (op_name.equals("|")) {
            return OPERATOR.OR;
        }
        if (op_name.equals("^")) {
            return OPERATOR.XOR;
        }
        if (op_name.equals("!")) {
            return OPERATOR.NOT;
        }
        return OPERATOR.UNKNOWN;
    }

    Expression eval_operator(OPERATOR op_id, Expression lhs, Expression rhs) throws Error {
        int operator;
        Expression exp = new Expression();
        exp.setLeftChild(lhs);
        exp.setRightChild(rhs);
        switch (op_id) {
            case NOT: {
                operator = 0;
                break;
            }
            case AND: {
                operator = 1;
                break;
            }
            case OR: {
                operator = 2;
                break;
            }
            case XOR: {
                operator = 3;
                break;
            }
            default: {
                throw new Error(this.row(), this.col(), 104);
            }
        }
        exp.setOperator(operator);
        return exp;
    }

    private static enum TOKENTYPE {
        NOTHING,
        DELIMITER,
        VARIABLE,
        UNKNOWN;

    }
}

