/*
 * Decompiled with CFR 0.152.
 */
package parser;

public class JBDDNode {
    private long ptr;

    static {
        try {
            System.loadLibrary("jbdd");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    private native boolean DDN_IsConstant(long var1);

    private native int DDN_GetIndex(long var1);

    private native double DDN_GetValue(long var1);

    private native long DDN_GetThen(long var1);

    private native long DDN_GetElse(long var1);

    public JBDDNode(long p, boolean increased_reference) {
        this.ptr = p;
    }

    public JBDDNode(long p) {
        this(p, true);
    }

    public JBDDNode(JBDDNode dd) {
        this(dd.ptr());
    }

    public long ptr() {
        return this.ptr;
    }

    public boolean isConstant() {
        return this.DDN_IsConstant(this.ptr);
    }

    public int getIndex() {
        return this.DDN_GetIndex(this.ptr);
    }

    public double getValue() {
        return this.DDN_GetValue(this.ptr);
    }

    public JBDDNode getThen() {
        assert (!this.isConstant());
        return new JBDDNode(this.DDN_GetThen(this.ptr), false);
    }

    public JBDDNode getElse() {
        assert (!this.isConstant());
        return new JBDDNode(this.DDN_GetElse(this.ptr), false);
    }

    public boolean equals(Object o) {
        return o instanceof JBDDNode && ((JBDDNode)o).ptr == this.ptr;
    }

    public int hashCode() {
        return (int)this.ptr;
    }

    public String toString() {
        String result = "" + this.ptr;
        if (this.ptr != 0L && this.isConstant()) {
            result = String.valueOf(result) + " value=" + this.getValue();
        }
        return result;
    }
}

