/*
 * Decompiled with CFR 0.152.
 */
package parser;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import cern.colt.bitvector.BitVector;
import functionLib.AssaException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import org.apache.commons.lang3.ArrayUtils;
import parser.AssaKeyWords;
import parser.Error;
import parser.Expression;
import parser.ExpressionParser;
import userInterface.AssaLog;

public class Model
implements AssaKeyWords {
    private AssaLog assalog;
    private List<String> names;
    private int n;
    private int modelType;
    private List<Expression> functions;
    private JDDVars BDDFunctions;
    private int[] orderFunction;
    private List<double[]> cij;
    private int[] nf;
    private double p;
    private int[] permutation;
    private List<Integer> leaves;
    private int[] cumNf;
    private List<Integer> npNode;
    private final double ZERO = 1.0E-11;

    public Model(AssaLog assalog) {
        this.assalog = assalog;
        this.cij = new ArrayList<double[]>();
        this.functions = new ArrayList<Expression>();
        this.names = new ArrayList<String>();
        this.BDDFunctions = new JDDVars();
    }

    public void setLeaves(List<Integer> leaves) {
        this.leaves = leaves;
    }

    public void setPermutation(int[] permutation) {
        this.permutation = permutation;
    }

    public List<double[]> getCij() {
        return this.cij;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<Expression> getFunctions() {
        return this.functions;
    }

    public Expression getFunction(String nodeName, int functionIndex) throws AssaException {
        int id = this.names.indexOf(nodeName);
        if (id == -1) {
            return null;
        }
        int index = 0;
        if (this.nf == null) {
            throw new AssaException("The model is not initialised!");
        }
        if (this.cumNf == null) {
            this.setNf(this.nf);
        }
        while (id != this.orderFunction[index] && index < this.n) {
            ++index;
        }
        if (index == this.n) {
            throw new AssaException("The model is not correctly initialised!");
        }
        if (this.cumNf[index + 1] - this.cumNf[index] <= functionIndex) {
            return null;
        }
        return this.functions.get(this.cumNf[index] + functionIndex);
    }

    public void setN(int n) {
        this.n = n;
        this.orderFunction = new int[n];
        int i = 0;
        while (i < n) {
            this.orderFunction[i] = i;
            ++i;
        }
        this.cumNf = new int[n + 1];
    }

    public void setNf(int[] nf) {
        this.nf = nf;
        if (this.cumNf == null) {
            this.cumNf = new int[nf.length + 1];
        }
        this.cumNf[0] = 0;
        int i = 1;
        while (i < nf.length + 1) {
            this.cumNf[i] = this.cumNf[i - 1] + nf[i - 1];
            ++i;
        }
    }

    public void setPerturbation(double p) {
        this.p = p;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public int getModelType() {
        return this.modelType;
    }

    public JDDVars getBDDFunctions() {
        return this.BDDFunctions;
    }

    public void loadModel(String fileName) throws AssaException, Error {
        long cpu;
        ThreadMXBean thread;
        block50: {
            thread = ManagementFactory.getThreadMXBean();
            cpu = thread.getCurrentThreadCpuTime();
            this.assalog.println("Start loading model from file " + fileName + ".");
            File file = new File(fileName);
            BufferedReader reader = null;
            String tempString = null;
            boolean numModel = false;
            int line = 0;
            int count = 0;
            int nodeNum = 0;
            ExpressionParser expParser = new ExpressionParser();
            expParser.setModel(this);
            ArrayList<Double> cijEle = new ArrayList<Double>();
            double sum = 0.0;
            this.npNode = new ArrayList<Integer>();
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    while ((tempString = reader.readLine()) != null) {
                        ++count;
                        if (!tempString.startsWith("//") && !tempString.trim().equals("")) {
                            boolean column = false;
                            StringTokenizer st = new StringTokenizer(tempString, " \t\n\r\f:");
                            block21: while (st != null && st.hasMoreTokens()) {
                                String str = st.nextToken();
                                if (column && str.toLowerCase().contains("source=matlab")) {
                                    numModel = true;
                                    st = null;
                                    this.assalog.println("This is a number format model.");
                                    continue;
                                }
                                switch (line) {
                                    case 0: {
                                        if (str.toLowerCase().contains("type=synchronous")) {
                                            this.modelType = 0;
                                            line = 1;
                                            break;
                                        }
                                        throw new AssaException("Model type is not defined at line " + count);
                                    }
                                    case 1: {
                                        if (str.startsWith("n=")) {
                                            st = new StringTokenizer(tempString, " \t\n\r\f=");
                                            str = st.nextToken();
                                            if (!st.hasMoreTokens()) {
                                                throw new AssaException("Grammar error at line " + count);
                                            }
                                            this.n = Integer.parseInt(st.nextToken());
                                            this.orderFunction = new int[this.n];
                                            this.nf = new int[this.n];
                                            line = 6;
                                            break;
                                        }
                                        throw new AssaException("Number nodes is not defined at line " + count);
                                    }
                                    case 2: {
                                        if (str.equals("nodeNames")) {
                                            line = 3;
                                            if (!st.hasMoreTokens()) continue block21;
                                            throw new AssaException("Grammar error at line " + count);
                                        }
                                        throw new AssaException("Node list is not defined at line " + count);
                                    }
                                    case 3: {
                                        if (!str.equals("endNodeNames")) {
                                            this.names.add(str);
                                            break;
                                        }
                                        if (this.names.size() != this.n) {
                                            throw new AssaException("Nodes number is not consistant with the given nodes names.");
                                        }
                                        line = 4;
                                        break;
                                    }
                                    case 4: {
                                        if (str.equals("node")) {
                                            if (!st.hasMoreTokens()) {
                                                throw new AssaException("Grammar error at line " + count);
                                            }
                                            str = st.nextToken();
                                            int id = this.names.indexOf(str);
                                            if (id == -1) {
                                                throw new AssaException("Grammar error at line " + count);
                                            }
                                            this.orderFunction[nodeNum] = id;
                                            line = 5;
                                            break;
                                        }
                                        if (str.equals("npNode")) {
                                            line = 7;
                                            break;
                                        }
                                        throw new AssaException("Grammar error at line " + count);
                                    }
                                    case 5: {
                                        if (str.equals("endNode")) {
                                            if (st.hasMoreTokens()) {
                                                throw new AssaException("Grammar error at line " + count);
                                            }
                                            line = 4;
                                            double[] cijElement = ArrayUtils.toPrimitive((Double[])cijEle.toArray(new Double[cijEle.size()]));
                                            if (1.0 - sum > 1.0E-11 || sum - 1.0 > 1.0E-11) {
                                                int i = 0;
                                                while (i < cijElement.length) {
                                                    cijElement[i] = cijElement[i] / sum;
                                                    ++i;
                                                }
                                            }
                                            this.cij.add(cijElement);
                                            cijEle.clear();
                                            sum = 0.0;
                                            ++nodeNum;
                                            break;
                                        }
                                        int n = nodeNum;
                                        this.nf[n] = this.nf[n] + 1;
                                        cijEle.add(Double.parseDouble(str));
                                        sum += ((Double)cijEle.get(cijEle.size() - 1)).doubleValue();
                                        if (!st.hasMoreTokens()) {
                                            throw new AssaException("Grammar error at line " + count);
                                        }
                                        str = st.nextToken();
                                        Expression exp = expParser.parseExpression(str);
                                        this.functions.add(exp);
                                        break;
                                    }
                                    case 6: {
                                        if (str.startsWith("perturbation=")) {
                                            st = new StringTokenizer(tempString, " \t\n\r\f=");
                                            str = st.nextToken();
                                            if (!st.hasMoreTokens()) {
                                                throw new AssaException("Grammar error at line " + count);
                                            }
                                        } else {
                                            throw new AssaException("Perturbation is not defined at line " + count);
                                        }
                                        this.p = Double.parseDouble(st.nextToken());
                                        line = 2;
                                        break;
                                    }
                                    case 7: {
                                        if (str.startsWith("endNpNode")) {
                                            line = 8;
                                            break;
                                        }
                                        if (this.npNode.contains(this.getNodeID(str.trim()))) continue block21;
                                        this.npNode.add(this.getNodeID(str.trim()));
                                        break;
                                    }
                                    default: {
                                        throw new AssaException("Grammar error at line " + count);
                                    }
                                }
                            }
                        }
                        if (!numModel) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block50;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.npNode.add(this.n);
        Collections.sort(this.npNode);
        if (this.cumNf == null) {
            this.cumNf = new int[this.n + 1];
        }
        this.cumNf[0] = 0;
        int i = 1;
        while (i <= this.n) {
            this.cumNf[i] = this.cumNf[i - 1] + this.nf[i - 1];
            ++i;
        }
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        this.assalog.println("Finish loading model. Time cost: " + cpucost + "s.");
    }

    public BDDPBN convertToBDDPBN() throws AssaException {
        BDDPBN pbn = new BDDPBN(this.n);
        pbn.setAssaLog(this.assalog);
        int[] local_nf = null;
        ArrayList<boolean[]> F = new ArrayList<boolean[]>();
        ArrayList<BitSet> varF = new ArrayList<BitSet>();
        local_nf = new int[this.n];
        int i = 0;
        while (i < this.n) {
            local_nf[this.orderFunction[i]] = this.nf[i];
            ++i;
        }
        pbn.setNf(local_nf);
        int[] cumNf = new int[this.n + 1];
        cumNf[0] = 0;
        int i2 = 1;
        while (i2 <= this.n) {
            cumNf[i2] = this.cij.get(i2 - 1).length + cumNf[i2 - 1];
            ++i2;
        }
        ArrayList<Integer> nv = new ArrayList<Integer>();
        ArrayList<Expression> tmpFunctions = new ArrayList<Expression>();
        ArrayList<double[]> tmpCij = new ArrayList<double[]>();
        int i3 = 0;
        while (i3 < this.n) {
            int index = 0;
            while (i3 != this.orderFunction[index]) {
                ++index;
            }
            int j = cumNf[index];
            while (j < cumNf[index + 1]) {
                tmpFunctions.add(this.functions.get(j));
                ++j;
            }
            tmpCij.add(this.cij.get(index));
            ++i3;
        }
        JDDVars vars = new JDDVars();
        int i4 = 0;
        while (i4 < this.n) {
            vars.addVar(JDD.Var(i4));
            ++i4;
        }
        JDDNode cube = null;
        int i5 = 0;
        while (i5 < tmpFunctions.size()) {
            Expression exp = (Expression)tmpFunctions.get(i5);
            BitSet elementVarF = new BitSet(this.n);
            int numV = this.doVarF(exp, elementVarF);
            nv.add(numV);
            varF.add(elementVarF);
            this.BDDFunctions.addVar(JDD.DD_CreateFromExpression(exp));
            boolean[] elementF = new boolean[(int)Math.pow(2.0, numV)];
            BitVector bv = new BitVector(numV);
            int j = 0;
            while (j < elementF.length) {
                bv.putLongFromTo((long)j, 0, numV - 1);
                int index = -1;
                int count = 0;
                cube = null;
                while ((index = elementVarF.nextSetBit(index + 1)) != -1) {
                    JDDNode tmp;
                    if (bv.get(count)) {
                        if (cube == null) {
                            cube = vars.getVar(index);
                            JDD.Ref(cube);
                        } else {
                            tmp = vars.getVar(index);
                            JDD.Ref(tmp);
                            cube = JDD.And(tmp, cube);
                        }
                    } else if (cube == null) {
                        cube = vars.getVar(index);
                        JDD.Ref(cube);
                        cube = JDD.Not(cube);
                    } else {
                        tmp = vars.getVar(index);
                        JDD.Ref(tmp);
                        cube = JDD.And(JDD.Not(tmp), cube);
                    }
                    ++count;
                }
                JDDNode fun = this.BDDFunctions.getVar(i5);
                JDD.Ref(fun);
                cube = JDD.Restrict(fun, cube);
                if (!cube.isConstant()) {
                    throw new AssaException("Error while passing Boolean function " + i5);
                }
                elementF[j] = cube.getValue() > 0.5;
                JDD.Deref(cube);
                ++j;
            }
            F.add(elementF);
            ++i5;
        }
        vars.derefAll();
        pbn.setNv(nv);
        pbn.setF(F);
        pbn.setvarF(varF);
        pbn.setCij(tmpCij);
        pbn.setPerturbation(this.p);
        pbn.setNpNode(this.npNode);
        pbn.setModel(this);
        return pbn;
    }

    public BitSetPBN convertToBitSetPBN() throws AssaException {
        BitSetPBN pbn = new BitSetPBN(this.n);
        pbn.setAssaLog(this.assalog);
        int[] local_nf = null;
        ArrayList<boolean[]> F = new ArrayList<boolean[]>();
        ArrayList<BitSet> varF = new ArrayList<BitSet>();
        local_nf = new int[this.n];
        int i = 0;
        while (i < this.n) {
            local_nf[this.orderFunction[i]] = this.nf[i];
            ++i;
        }
        pbn.setNf(local_nf);
        int[] cumNf = new int[this.n + 1];
        cumNf[0] = 0;
        int i2 = 1;
        while (i2 <= this.n) {
            cumNf[i2] = this.cij.get(i2 - 1).length + cumNf[i2 - 1];
            ++i2;
        }
        ArrayList<Integer> nv = new ArrayList<Integer>();
        ArrayList<Expression> tmpFunctions = new ArrayList<Expression>();
        ArrayList<double[]> tmpCij = new ArrayList<double[]>();
        int i3 = 0;
        while (i3 < this.n) {
            int index = 0;
            while (i3 != this.orderFunction[index]) {
                ++index;
            }
            int j = cumNf[index];
            while (j < cumNf[index + 1]) {
                tmpFunctions.add(this.functions.get(j));
                ++j;
            }
            tmpCij.add(this.cij.get(index));
            ++i3;
        }
        JDDVars vars = new JDDVars();
        int i4 = 0;
        while (i4 < this.n) {
            vars.addVar(JDD.Var(i4));
            ++i4;
        }
        JDDNode cube = null;
        int i5 = 0;
        while (i5 < tmpFunctions.size()) {
            Expression exp = (Expression)tmpFunctions.get(i5);
            BitSet elementVarF = new BitSet(this.n);
            int numV = this.doVarF(exp, elementVarF);
            nv.add(numV);
            varF.add(elementVarF);
            this.BDDFunctions.addVar(JDD.DD_CreateFromExpression(exp));
            boolean[] elementF = new boolean[(int)Math.pow(2.0, numV)];
            BitVector bv = new BitVector(numV);
            int j = 0;
            while (j < elementF.length) {
                bv.putLongFromTo((long)j, 0, numV - 1);
                int index = -1;
                int count = 0;
                cube = null;
                while ((index = elementVarF.nextSetBit(index + 1)) != -1) {
                    JDDNode tmp;
                    if (bv.get(count)) {
                        if (cube == null) {
                            cube = vars.getVar(index);
                            JDD.Ref(cube);
                        } else {
                            tmp = vars.getVar(index);
                            JDD.Ref(tmp);
                            cube = JDD.And(tmp, cube);
                        }
                    } else if (cube == null) {
                        cube = vars.getVar(index);
                        JDD.Ref(cube);
                        cube = JDD.Not(cube);
                    } else {
                        tmp = vars.getVar(index);
                        JDD.Ref(tmp);
                        cube = JDD.And(JDD.Not(tmp), cube);
                    }
                    ++count;
                }
                JDDNode fun = this.BDDFunctions.getVar(i5);
                JDD.Ref(fun);
                cube = JDD.Restrict(fun, cube);
                if (!cube.isConstant()) {
                    throw new AssaException("Error while passing Boolean function " + i5);
                }
                elementF[j] = cube.getValue() > 0.5;
                JDD.Deref(cube);
                ++j;
            }
            F.add(elementF);
            ++i5;
        }
        vars.derefAll();
        pbn.setNv(nv);
        pbn.setF(F);
        pbn.setvarF(varF);
        pbn.setCij(tmpCij);
        pbn.setPerturbation(this.p);
        pbn.setNpNode(this.npNode);
        return pbn;
    }

    private int doVarF(Expression exp, BitSet varF) throws AssaException {
        switch (exp.getType()) {
            case 0: {
                varF.set(exp.getID());
                break;
            }
            case 1: {
                if (exp.getLeftChild() == null) {
                    varF.set(exp.getID());
                    break;
                }
                this.doVarF(exp.getLeftChild(), varF);
                break;
            }
            case 2: {
                this.doVarF(exp.getLeftChild(), varF);
                break;
            }
            case 3: {
                this.doVarF(exp.getLeftChild(), varF);
                this.doVarF(exp.getRightChild(), varF);
                break;
            }
            default: {
                throw new AssaException("Unknown Expression type!");
            }
        }
        return varF.cardinality();
    }

    public int getNodeID(String name) throws AssaException {
        int id = this.names.indexOf(name);
        if (id == -1) {
            throw new AssaException("Node named " + name + " does not exist!");
        }
        return this.names.indexOf(name);
    }

    public int getN() {
        return this.n;
    }

    public String toString() {
        int i;
        String res = "";
        res = String.valueOf(res) + "type=synchronous\n";
        res = this.leaves == null ? String.valueOf(res) + "n=" + this.n + "\n" : String.valueOf(res) + "n=" + (this.n - this.leaves.size()) + "\n";
        res = String.valueOf(res) + "perturbation=" + this.p + "\n";
        res = String.valueOf(res) + "nodeNames\n";
        if (this.permutation != null) {
            i = 0;
            while (i < this.names.size()) {
                res = String.valueOf(res) + "\t" + this.names.get(this.permutation[i]) + "\n";
                ++i;
            }
        } else {
            i = 0;
            while (i < this.names.size()) {
                if (this.leaves == null || !this.leaves.contains(i)) {
                    res = String.valueOf(res) + "\t" + this.names.get(i) + "\n";
                }
                ++i;
            }
        }
        res = String.valueOf(res) + "endNodeNames\n";
        i = 0;
        while (i < this.n) {
            if (this.leaves == null || !this.leaves.contains(i)) {
                res = String.valueOf(res) + "node " + this.names.get(this.orderFunction[i]) + "\n";
                double[] cijElement = this.cij.get(i);
                int j = 0;
                while (j < cijElement.length) {
                    res = String.valueOf(res) + "\t" + cijElement[j] + " : " + this.functions.get(this.cumNf[i] + j).toString() + "\n";
                    ++j;
                }
                res = String.valueOf(res) + "endNode\n";
            }
            ++i;
        }
        return res;
    }

    public void close() {
        this.BDDFunctions.derefAll();
    }
}

