/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetEngine;
import PBN.BitSetEnginePara;
import PBN.BitSetPBN;
import PBN.ContextEngine;
import PBN.ContextPBN;
import PBN.Engine;
import PBN.OptimizePBN;
import PBN.PBN;
import PBN.StateBit;
import java.util.ArrayList;
import simulationMethod.GelmanFullStateParallel;
import simulationMethod.ParallelEngine;
import simulationMethod.SimulationMethod;

public class BitSetPBNSimulationEngine
extends ParallelEngine {
    PBN pbn;
    Engine engine;
    private static final int BITSETENGINE = 0;
    private static final int PARAENGINE = 1;
    private static long length;

    public BitSetPBNSimulationEngine() {
    }

    public BitSetPBNSimulationEngine(PBN pbn, SimulationMethod sm) {
        this.pbn = pbn;
        if (pbn instanceof BitSetPBN) {
            this.engine = new BitSetEngine(pbn);
            ((BitSetEngine)this.engine).generateAlias();
        } else if (pbn instanceof ContextPBN) {
            this.engine = new ContextEngine(pbn);
        }
        this.sm = sm;
    }

    public BitSetPBNSimulationEngine(PBN pbn, SimulationMethod sm, int engineType) {
        this.pbn = pbn;
        if (pbn instanceof BitSetPBN) {
            switch (engineType) {
                case 0: {
                    this.engine = new BitSetEngine(pbn);
                    ((BitSetEngine)this.engine).generateAlias();
                    break;
                }
                case 1: {
                    this.engine = new BitSetEnginePara(pbn);
                    ((BitSetEnginePara)this.engine).generateAlias();
                }
            }
        } else if (pbn instanceof ContextPBN) {
            this.engine = new ContextEngine(pbn);
        }
        this.sm = sm;
    }

    public void setNumLeaves(int numLeaves) {
        ((BitSetEnginePara)this.engine).setNumLeaves(numLeaves);
    }

    public void setDisableGlobalAlias(boolean dis) {
        ((BitSetEngine)this.engine).setdisableGlobalcij(dis);
    }

    public void setPara(OptimizePBN opt) {
        ((BitSetEnginePara)this.engine).setPara(opt);
    }

    @Override
    public Object simulate(long length, Object initialState) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        long i = 0L;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            int re = this.engine.pbnNextState(next);
            this.sm.updateTransition(next, re);
            current = next;
            ++i;
        }
        return current;
    }

    @Override
    public Object simulate(int length, Object initialState) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        int i = 0;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            this.engine.pbnNextState(next);
            this.sm.updateTransition(next, 0);
            current = next;
            ++i;
        }
        return current;
    }

    @Override
    public Object simulate(long length, Object initialState, int chainIndex) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        long i = 0L;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            this.engine.pbnNextState(next);
            this.sm.updateTransition(next, chainIndex);
            current = next;
            ++i;
        }
        return current;
    }

    public ArrayList<StateBit> simulateGUI(long length, Object initialState) throws Exception {
        ArrayList<StateBit> sb = new ArrayList<StateBit>();
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        long i = 0L;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            sb.add((StateBit)current.clone());
            this.engine.pbnNextState(next);
            current = next;
            ++i;
        }
        return sb;
    }

    @Override
    public StateBit simulate(int length, StateBit initialState) throws Exception {
        int i = 0;
        while (i < length) {
            int re = this.engine.pbnNextState(initialState);
            this.sm.updateTransition(initialState, re);
            ++i;
        }
        return initialState;
    }

    @Override
    public StateBit simulate(long length, StateBit initialState) throws Exception {
        long i = 0L;
        while (i < length) {
            this.engine.pbnNextState(initialState);
            this.sm.updateTransition(initialState, 0);
            ++i;
        }
        return initialState;
    }

    @Override
    public StateBit simulate(long length, StateBit initialState, int chainIndex) throws Exception {
        BitSetPBNSimulationEngine.length = length;
        long i = 0L;
        while (i < BitSetPBNSimulationEngine.length) {
            this.engine.pbnNextState(initialState);
            this.sm.updateTransition(initialState, chainIndex);
            ++i;
        }
        if (((GelmanFullStateParallel)this.sm).convergeRun) {
            BitSetPBNSimulationEngine.length /= 2L;
        }
        return initialState;
    }
}

