/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetEnginePara;
import PBN.BitSetPBN;
import PBN.OptimizePBN;
import PBN.PBN;
import PBN.StateBit;
import java.util.ArrayList;
import simulationMethod.GelmanFullStatePara;
import simulationMethod.ParallelEngine;
import simulationMethod.SimulationMethod;

public class BitSetPBNSimulationEnginePara
extends ParallelEngine {
    PBN pbn;
    BitSetEnginePara engine;
    private GelmanFullStatePara smPara;
    private static final int BITSETENGINE = 0;
    private static final int PARAENGINE = 1;

    public BitSetPBNSimulationEnginePara() {
    }

    public BitSetPBNSimulationEnginePara(PBN pbn, SimulationMethod sm) {
        this.pbn = pbn;
        this.engine = new BitSetEnginePara(pbn);
        this.sm = sm;
        if (sm instanceof GelmanFullStatePara) {
            this.smPara = (GelmanFullStatePara)sm;
        }
    }

    public BitSetPBNSimulationEnginePara(PBN pbn, SimulationMethod sm, int engineType) {
        this.pbn = pbn;
        if (pbn instanceof BitSetPBN) {
            this.engine = new BitSetEnginePara(pbn);
        }
        this.sm = sm;
        if (sm instanceof GelmanFullStatePara) {
            this.smPara = (GelmanFullStatePara)sm;
        }
    }

    public void setNumLeaves(int numLeaves) {
        this.engine.setNumLeaves(numLeaves);
    }

    public void setDisableGlobalAlias(boolean dis) {
        this.engine.setdisableGlobalcij(dis);
    }

    public void setPara(OptimizePBN opt) {
        this.engine.setPara(opt);
    }

    @Override
    public Object simulate(long length, Object initialState) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        long i = 0L;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            int re = this.engine.pbnNextState(next);
            this.sm.updateTransition(next, re);
            current = next;
            ++i;
        }
        return current;
    }

    @Override
    public Object simulate(int length, Object initialState) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        int i = 0;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            this.engine.pbnNextState(next);
            this.sm.updateTransition(next, 0);
            current = next;
            ++i;
        }
        return current;
    }

    public StateBit[] simulate(int length, StateBit[] sts) {
        int i = 0;
        while (i < length) {
            int[] para = this.engine.pbnNextState(sts);
            this.smPara.updateTransition(sts, para);
            ++i;
        }
        return sts;
    }

    public StateBit[] simulate(long length, StateBit[] sts) {
        long i = 0L;
        while (i < length) {
            int[] para = this.engine.pbnNextState(sts);
            this.smPara.updateTransition(sts, para);
            ++i;
        }
        return sts;
    }

    @Override
    public Object simulate(long length, Object initialState, int chainIndex) throws Exception {
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        long i = 0L;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            this.engine.pbnNextState(next);
            this.sm.updateTransition(next, chainIndex);
            current = next;
            ++i;
        }
        return current;
    }

    public ArrayList<StateBit> simulateGUI(long length, Object initialState) throws Exception {
        ArrayList<StateBit> sb = new ArrayList<StateBit>();
        if (!(initialState instanceof StateBit)) {
            throw new Exception("Incorrect state type!");
        }
        StateBit current = (StateBit)initialState;
        long i = 0L;
        while (i < length) {
            StateBit next = (StateBit)current.clone();
            sb.add((StateBit)current.clone());
            this.engine.pbnNextState(next);
            current = next;
            ++i;
        }
        return sb;
    }

    @Override
    public StateBit simulate(int length, StateBit initialState) throws Exception {
        int i = 0;
        while (i < length) {
            int re = this.engine.pbnNextState(initialState);
            this.sm.updateTransition(initialState, re);
            ++i;
        }
        return initialState;
    }

    @Override
    public StateBit simulate(long length, StateBit initialState) throws Exception {
        long i = 0L;
        while (i < length) {
            this.engine.pbnNextState(initialState);
            this.sm.updateTransition(initialState, 0);
            ++i;
        }
        return initialState;
    }

    @Override
    public StateBit simulate(long length, StateBit initialState, int chainIndex) throws Exception {
        if ((double)length < Math.pow(2.0, 31.0)) {
            return this.simulate((int)length, initialState, chainIndex);
        }
        long i = 0L;
        while (i < length) {
            this.engine.pbnNextState(initialState);
            this.sm.updateTransition(initialState, chainIndex);
            ++i;
        }
        return initialState;
    }

    private StateBit simulate(int length, StateBit initialState, int chainIndex) throws Exception {
        int i = 0;
        while (i < length) {
            this.engine.pbnNextState(initialState);
            this.sm.updateTransition(initialState, chainIndex);
            ++i;
        }
        return initialState;
    }
}

