/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Iterator;
import javafx.application.Platform;
import simulationMethod.GaussSeidel;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;

public class GaussSeidelGUI
extends GaussSeidel {
    private MainGUIController gui;

    public GaussSeidelGUI(BitSetPBN pbn, AssaLog assalog) {
        super(pbn, assalog);
    }

    public void setGUI(MainGUIController gui) {
        this.gui = gui;
    }

    @Override
    public double[] run() throws Exception {
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        this.initialize();
        long count = 0L;
        double probability = 0.0;
        while (!this.done && count < this.maxIteration) {
            ++count;
            this.updatePai();
        }
        if (this.done) {
            int i;
            String s = "";
            s = String.valueOf(s) + "The Gauss-Seidel method ends within " + count + " iterations.\n";
            s = String.valueOf(s) + "CPU Time cost: " + (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9 + "s.\n";
            this.normalize();
            if (this.stateSet != null) {
                Iterator iterator = this.stateSet.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    probability += this.pai[i];
                }
                s = String.valueOf(s) + "The probability to check is " + probability + ".\n";
            } else {
                s = String.valueOf(s) + "The steady-state distribution is\n";
                i = 0;
                while (i < this.pai.length) {
                    s = String.valueOf(s) + this.pai[i] + "\t";
                    if ((i + 1) % 5 == 0) {
                        s = String.valueOf(s) + "\n";
                    }
                    ++i;
                }
                s = String.valueOf(s) + "\n";
            }
            String tmp = s = String.valueOf(s) + "\n----------------\n";
            Platform.runLater(() -> this.gui.setAnalyseTextField(tmp, false));
            return this.pai;
        }
        throw new Exception("The GaussSeidel method does not converge within " + this.maxIteration + " iterations!");
    }
}

