/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.PBN;
import PBN.Property;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import functionLib.Parameters;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.Covariance;
import parallel.Simulate;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class GelmanFullStateParallel
extends SimulationMethod {
    private List<StateBit> trajectory;
    private List<List> trajectories;
    private BitSetPBN pbn;
    private String outputName;
    private int m;
    private int n;
    private int twon;
    private int count;
    private int previousIndex;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private StateBit[] initialState;
    BitSetPBNSimulationEngine engine;
    int statesize;
    public boolean convergeRun = false;
    int Nmax;
    int kstep = 1;
    private double threshold = 0.001;
    private double precision = 0.01;
    private double confidence = 0.95;
    private double epsilon = Parameters.epsilon;
    private double alpha;
    private double beta;
    private int countStep = 0;
    private long[] stateA;
    private long[] stateB;
    private int maxRecord = 60000;
    private int[][] transitionsLast;
    private int[][][] transitionsLastChain;
    private int[][] transitionsBurnIn;
    private boolean transitionBurnInComputed;
    int[] index1;
    int[] index2;
    private long[] countSteps;
    private Simulate parallelSimulate;
    private ForkJoinPool pool;
    private int burnIn;
    private boolean disableGlobalAlias;
    private static StateBit positiveStateBit;
    private static StateBit negativeStateBit;
    private static StateBit[] newSt;

    public GelmanFullStateParallel(BitSetPBN pbn, AssaLog assalog) {
        super(assalog);
        this.pbn = pbn;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.m = 10;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.index2 = new int[this.m];
        this.stateA = new long[this.m];
        this.stateB = new long[this.m];
        this.countSteps = new long[this.m];
        this.transitionsLast = new int[2][2];
        this.transitionsBurnIn = new int[2][2];
        this.transitionsLastChain = new int[this.m][2][2];
        this.threshold /= Math.log(this.m);
        this.setInstanceName();
    }

    public void setParameters(double precision, double confidence) {
        this.precision = precision;
        this.confidence = confidence;
    }

    @Override
    public void setDisableGlobalAlias(boolean dis) {
        this.disableGlobalAlias = dis;
        if (this.engine != null) {
            this.engine.setDisableGlobalAlias(dis);
        }
    }

    @Override
    public void setParameters(double[] parameters) {
        this.precision = parameters[0];
        this.confidence = parameters[1];
        if (parameters.length > 2) {
            this.setM((int)parameters[2]);
        }
        if (parameters.length > 3) {
            this.epsilon = parameters[3];
        }
    }

    public void setM(int m) {
        this.m = m;
        this.index1 = new int[m];
        this.index2 = new int[m];
        this.stateA = new long[m];
        this.stateB = new long[m];
        this.countSteps = new long[m];
        this.transitionsLastChain = new int[m][2][2];
        this.threshold /= Math.log(m);
    }

    public void setKstep(int kstep) {
        this.kstep = kstep;
    }

    public void initialise() {
        this.initialState = new StateBit[this.m];
        this.engine = new BitSetPBNSimulationEngine(this.pbn, this);
        if (this.disableGlobalAlias) {
            this.engine.setDisableGlobalAlias(this.disableGlobalAlias);
        }
        this.statesize = this.pbn.getN();
    }

    public void reInitialise() {
        this.trajectories = null;
        this.reInitialiseAlphaBeta();
        this.convergeRun = false;
        this.setM(10);
        this.n = 10;
        this.twon = 2 * this.n;
    }

    private void reInitialiseAlphaBeta() {
        this.countStep = 0;
        if (this.transitionsLast == null) {
            this.transitionsLast = new int[2][2];
            this.transitionsBurnIn = new int[2][2];
            this.transitionsLastChain = new int[this.m][2][2];
        } else {
            this.transitionsLast[0][0] = 0;
            this.transitionsLast[0][1] = 0;
            this.transitionsLast[1][0] = 0;
            this.transitionsLast[1][1] = 0;
            this.transitionsBurnIn[0][0] = 0;
            this.transitionsBurnIn[0][1] = 0;
            this.transitionsBurnIn[1][0] = 0;
            this.transitionsBurnIn[1][1] = 0;
        }
    }

    @Override
    public String getLogFile() {
        return this.outputName;
    }

    @Override
    public void setLogFile(String outputName) {
        this.outputName = outputName;
    }

    public void runConverge() throws Exception {
        this.initialise();
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        double[] meansquare = new double[this.m];
        boolean done = false;
        boolean done1 = false;
        int endIndex = this.pbn.getN() - 1;
        Covariance covariance = new Covariance();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<StateBit>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = this.n;
        this.previousIndex = 0;
        this.parallelSimulate = new Simulate(this.trajectories, extension * 2, 0, this.trajectories.size() - 1, this.engine, this.initialState);
        this.pool = new ForkJoinPool();
        while (!done) {
            this.parallelSimulate.reinitialize();
            this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
            this.parallelSimulate.setMinIndex(0);
            this.parallelSimulate.setSteps(extension * 2 * this.kstep);
            this.pool.invoke(this.parallelSimulate);
            this.updateTransition();
            double within = 0.0;
            double grandmean = 0.0;
            double[] values = new double[this.n];
            i = 0;
            while (i < this.m) {
                mean[i] = 0.0;
                int j = 0;
                while (j < this.n) {
                    int n = i;
                    mean[n] = mean[n] + ((StateBit)this.trajectories.get(i).get(j + this.n)).getDoubleValue(0, endIndex);
                    ++j;
                }
                mean[i] = mean[i] / (double)this.n;
                meansquare[i] = Math.pow(mean[i], 2.0);
                sj[i] = 0.0;
                j = this.n;
                while (j < this.twon) {
                    values[j - this.n] = ((StateBit)this.trajectories.get(i).get(j)).getDoubleValue(0, endIndex);
                    ++j;
                }
                sj[i] = StatUtils.variance(values);
                ++i;
            }
            within = StatUtils.mean(sj);
            grandmean = StatUtils.mean(mean);
            double between = (double)this.n * StatUtils.variance(mean);
            double varianceW = StatUtils.variance(sj);
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = covariance.covariance(sj, meansquare);
            double covwx = covariance.covariance(sj, mean);
            double covwb = (double)(this.n / this.m) * (covwxsquare - 2.0 * grandmean * covwx);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double varianceV = (Math.pow(this.n - 1, 2.0) * (varianceW /= (double)this.m) + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            if (Math.abs(1.0 - psrf) > this.threshold || varianceV == 0.0) {
                done = false;
                done1 = false;
                extension = this.n;
                this.n += extension;
                this.twon = this.n * 2;
                if (this.twon <= this.maxRecord) continue;
                done = true;
                this.twon = this.n;
                this.n -= extension;
                continue;
            }
            if (done1) {
                done = true;
                continue;
            }
            done1 = true;
            extension = this.n;
            this.n += extension;
            this.twon = this.n * 2;
            if (this.twon <= this.maxRecord) continue;
            this.maxRecord = this.twon;
        }
        this.convergeRun = true;
    }

    private void updateTransition() {
        this.transitionsLast[0][0] = 0;
        this.transitionsLast[0][1] = 0;
        this.transitionsLast[1][0] = 0;
        this.transitionsLast[1][1] = 0;
        int i = 0;
        while (i < this.m) {
            int[] nArray = this.transitionsLast[0];
            nArray[0] = nArray[0] + this.transitionsLastChain[i][0][0];
            int[] nArray2 = this.transitionsLast[0];
            nArray2[1] = nArray2[1] + this.transitionsLastChain[i][0][1];
            int[] nArray3 = this.transitionsLast[1];
            nArray3[0] = nArray3[0] + this.transitionsLastChain[i][1][0];
            int[] nArray4 = this.transitionsLast[1];
            nArray4[1] = nArray4[1] + this.transitionsLastChain[i][1][1];
            ++i;
        }
    }

    public void quickTestSimulation(int n) throws Exception {
        this.initialise();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<StateBit>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = n;
        this.previousIndex = 0;
        this.parallelSimulate = new Simulate(this.trajectories, extension, 0, this.trajectories.size() - 1, this.engine, this.initialState);
        this.pool = new ForkJoinPool();
        this.parallelSimulate.reinitialize();
        this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
        this.parallelSimulate.setMinIndex(0);
        this.parallelSimulate.setSteps(extension);
        this.pool.invoke(this.parallelSimulate);
    }

    public double calDistribution() {
        long stateA = 0L;
        long stateB = 0L;
        int i = 0;
        while (i < this.m) {
            stateA += this.stateA[i];
            stateB += this.stateB[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m) {
            int j = 0;
            while (j < this.burnIn) {
                if (this.evaluateState((StateBit)this.trajectories.get(i2).get(j))) {
                    --stateA;
                } else {
                    --stateB;
                }
                ++j;
            }
            ++i2;
        }
        long total = stateA + stateB;
        if (total != 0L) {
            return (double)stateA / (double)total;
        }
        return 0.0;
    }

    public double[] computeSteadyState() throws Exception {
        int extentionPerChain;
        positiveStateBit = new StateBit(this.pbn.getN());
        negativeStateBit = new StateBit(this.pbn.getN());
        newSt = new StateBit[this.m];
        int i = 0;
        while (i < this.m) {
            GelmanFullStateParallel.newSt[i] = new StateBit(this.pbn.getN());
            ++i;
        }
        long time = System.nanoTime();
        double[] result = new double[4];
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + this.confidence), false);
        int M = 0;
        double threshold = 0.0;
        int round = 0;
        int current = 0;
        this.burnIn = this.n;
        PrintWriter pw = new PrintWriter(new FileWriter(this.outputName, true));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        pw.println("Program started at " + df.format(start));
        pw.println("Starting the two-state parallel kenel. Number of cores = " + this.m + ".");
        pw.println("Total number of nodes is " + this.pbn.getN() + ".");
        pw.print("Checking states where ");
        if (this.positiveIndex.size() != 0) {
            pw.print("nodes with index ");
            for (int i2 : this.positiveIndex) {
                pw.print(String.valueOf(i2) + " ");
                positiveStateBit.set(i2);
            }
            pw.print("should have value 1 and ");
        }
        if (this.negativeIndex.size() != 0) {
            int i2;
            pw.print("nodes with index ");
            i2 = 0;
            while (i2 < this.negativeIndex.size()) {
                pw.print(this.negativeIndex.get(i2) + " ");
                negativeStateBit.set(this.negativeIndex.get(i2));
                ++i2;
            }
            pw.println("should have value 0.");
        } else {
            pw.println("no requirements on other nodes.");
        }
        pw.println("Approximation is " + this.precision + ", confidence is " + this.confidence + ", fetch sample every " + this.kstep + " steps.");
        if (!this.convergeRun) {
            this.runConverge();
        }
        this.index1 = new int[this.m];
        this.calAlphaBeta(this.burnIn);
        long countStep = 0L;
        int i3 = 0;
        while (i3 < this.m) {
            countStep += this.countSteps[i3];
            ++i3;
        }
        pw.println("alpha=" + this.alpha + ",beta=" + this.beta);
        threshold = 3.0 / (double)countStep;
        while (this.alpha < threshold || this.beta < threshold || this.alpha > 0.9999999 && this.beta > 0.9999999) {
            extentionPerChain = this.n;
            this.assalog.println("Alpha=" + this.alpha + ", beta=" + this.beta + ", extend for avaiable alpha beta by " + extentionPerChain * this.kstep + " per chain");
            this.simulate(extentionPerChain * this.m * this.kstep);
            this.calAlphaBeta(this.burnIn);
            pw.println("alpha=" + this.alpha + ",beta=" + this.beta);
            countStep = 0L;
            i3 = 0;
            while (i3 < this.m) {
                countStep += this.countSteps[i3];
                ++i3;
            }
            threshold = 3.0 / (double)countStep;
            ++round;
        }
        int N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0))) * this.kstep;
        current = this.twon - 1;
        this.count = 0;
        pw.println("N=" + N);
        int maxLength = this.transitionsLast[0][0] + this.transitionsLast[0][1] + this.transitionsLast[1][0] + this.transitionsLast[1][1] - this.m * (this.n - 1);
        while (N > maxLength) {
            extentionPerChain = (int)Math.ceil((double)((N - maxLength) * this.kstep) / (double)this.m);
            this.simulate(extentionPerChain * this.m);
            this.calAlphaBeta(this.burnIn);
            N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
            maxLength = this.transitionsLast[0][0] + this.transitionsLast[0][1] + this.transitionsLast[1][0] + this.transitionsLast[1][1] - this.m * (this.burnIn - 1);
            pw.println("Re-estimating round " + ++round + ": alpha=" + this.alpha + ", beta=" + this.beta + ", N=" + N + ", current length=" + maxLength + ".");
            if (N >= maxLength || (M = (int)Math.ceil(Math.log(this.epsilon * (this.alpha + this.beta) / Math.max(this.alpha, this.beta)) / Math.log(Math.abs(1.0 - this.alpha - this.beta)))) <= this.burnIn) continue;
            this.burnIn = M;
            this.calAlphaBeta(this.burnIn);
            N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
            maxLength = this.transitionsLast[0][0] + this.transitionsLast[0][1] + this.transitionsLast[1][0] + this.transitionsLast[1][1] - this.m * (this.burnIn - 1);
            pw.println("Changing burnIn length to " + M + ". Recomputing result: alpha=" + this.alpha + ", beta=" + this.beta + ", N=" + N + ", current length=" + maxLength + ".");
        }
        this.assalog.println("Total extending times: " + round + ".");
        pw.println("Re-estimation times=" + round);
        pw.println("final M=" + M * this.kstep);
        pw.println("final N=" + N);
        long simulationsteps = 0L;
        int i4 = 0;
        while (i4 < this.countSteps.length) {
            simulationsteps += this.countSteps[i4];
            ++i4;
        }
        pw.println("Total simulation steps = " + simulationsteps + ".");
        result[0] = this.calDistribution();
        result[1] = simulationsteps;
        result[2] = (double)(System.nanoTime() - time) / 1.0E9;
        result[3] = round;
        if (N > this.Nmax) {
            this.Nmax = N;
        }
        pw.close();
        return result;
    }

    public void calAlphaBeta(int length) throws Exception {
        int j;
        int i;
        int[] index1 = new int[this.m];
        int index2 = 0;
        int[][] transitionsLast = new int[2][2];
        if (!this.transitionBurnInComputed) {
            i = 0;
            while (i < this.m) {
                index1[i] = this.evaluateState((StateBit)this.trajectories.get(i).get(0)) ? 1 : 0;
                j = 1;
                while (j < length + 1) {
                    int bridge = index1[i];
                    if (this.evaluateState((StateBit)this.trajectories.get(i).get(j))) {
                        index1[i] = 1;
                        index2 = 1;
                    } else {
                        index1[i] = 0;
                        index2 = 0;
                    }
                    int[] nArray = this.transitionsBurnIn[bridge];
                    int n = index2;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                ++i;
            }
            this.transitionBurnInComputed = true;
        }
        i = 0;
        while (i < 2) {
            j = 0;
            while (j < 2) {
                transitionsLast[i][j] = this.transitionsLast[i][j] - this.transitionsBurnIn[i][j];
                ++j;
            }
            ++i;
        }
        this.beta = transitionsLast[0][0] + transitionsLast[0][1] == 0 ? 0.0 : (double)transitionsLast[0][1] / (double)(transitionsLast[0][0] + transitionsLast[0][1]);
        this.alpha = transitionsLast[1][0] + transitionsLast[1][1] == 0 ? 0.0 : (double)transitionsLast[1][0] / (double)(transitionsLast[1][0] + transitionsLast[1][1]);
    }

    public void runPlot() throws Exception {
        StateBit[] initialState = new StateBit[this.m];
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        int statesize = this.pbn.getN();
        double mean_meansquare = 0.0;
        boolean done = false;
        BitSetPBNSimulationEngine engine = new BitSetPBNSimulationEngine(this.pbn, this);
        Random ran = RandomProvider.getInstance().getRandom();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            initialState[i] = new StateBit(statesize);
            initialState[i].putLongFromTo(statespace * (long)i, 0, statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<StateBit>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        this.previousIndex = 0;
        int extension = this.n;
        int k = 1;
        while (k < 501) {
            int i2 = 0;
            while (i2 < this.m) {
                this.count = i2;
                initialState[i2] = engine.simulate(extension * 2 * this.kstep, initialState[i2]);
                ++i2;
            }
            double within = 0.0;
            double grandmean = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                mean[i2] = 0.0;
                int j = 0;
                while (j < this.n) {
                    int n = i2;
                    mean[n] = mean[n] + (double)((Long)this.trajectories.get(i2).get(j + this.n)).longValue();
                    ++j;
                }
                mean[i2] = mean[i2] / (double)this.n;
                mean_meansquare += mean[i2] * mean[i2];
                grandmean += mean[i2];
                sj[i2] = 0.0;
                j = this.n;
                while (j < this.twon) {
                    int n = i2;
                    sj[n] = sj[n] + Math.pow((double)((Long)this.trajectories.get(i2).get(j)).longValue() - mean[i2], 2.0);
                    ++j;
                }
                sj[i2] = sj[i2] / (double)(this.n - 1);
                within += sj[i2];
                ++i2;
            }
            within /= (double)this.m;
            grandmean /= (double)this.m;
            mean_meansquare /= (double)this.m;
            double between = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                between += Math.pow(grandmean - mean[i2], 2.0);
                ++i2;
            }
            between = between * (double)this.n / (double)(this.m - 1);
            double varianceW = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                varianceW += Math.pow(sj[i2] - within, 2.0);
                ++i2;
            }
            varianceW /= (double)(this.m - 1);
            varianceW /= (double)this.m;
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = 0.0;
            double covwx = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                covwxsquare += (sj[i2] - within) * (mean[i2] * mean[i2] - mean_meansquare);
                covwx += (sj[i2] - within) * (mean[i2] - grandmean);
                ++i2;
            }
            double covwb = (double)(this.n / this.m) * ((covwxsquare /= (double)(this.m - 1)) - 2.0 * grandmean * (covwx /= (double)(this.m - 1)));
            double varianceV = (Math.pow(this.n - 1, 2.0) * varianceW + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            extension = 5;
            this.n += extension;
            this.twon = this.n * 2;
            ++k;
        }
    }

    @Override
    public void updateTransition(StateBit st, int para) {
        int n = para;
        this.countSteps[n] = this.countSteps[n] + 1L;
        if ((this.countSteps[para] - 1L) % (long)this.kstep != 0L) {
            return;
        }
        int size = this.trajectories.get(para).size();
        boolean eva = this.evaluateState(st, para);
        int bridge = this.index1[para];
        if (eva) {
            int n2 = para;
            this.stateA[n2] = this.stateA[n2] + 1L;
            this.index1[para] = 1;
            this.index2[para] = 1;
            if (this.countSteps[para] > 1L) {
                int[] nArray = this.transitionsLastChain[para][bridge];
                int n3 = this.index2[para];
                nArray[n3] = nArray[n3] + 1;
            }
        } else {
            int n4 = para;
            this.stateB[n4] = this.stateB[n4] + 1L;
            this.index1[para] = 0;
            this.index2[para] = 0;
            if (this.countSteps[para] > 1L) {
                int[] nArray = this.transitionsLastChain[para][bridge];
                int n5 = this.index2[para];
                nArray[n5] = nArray[n5] + 1;
            }
        }
        if (size < this.maxRecord) {
            this.trajectories.get(para).add(st.clone());
        }
    }

    public boolean evaluateState(StateBit st) {
        int i;
        if (this.positiveIndex != null) {
            i = 0;
            while (i < this.positiveIndex.size()) {
                if (!st.get(this.positiveIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (this.negativeIndex != null) {
            i = 0;
            while (i < this.negativeIndex.size()) {
                if (st.get(this.negativeIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean evaluateState(StateBit st, int test) {
        newSt[test].clear();
        newSt[test].or(st);
        newSt[test].and(positiveStateBit);
        newSt[test].xor(positiveStateBit);
        if (newSt[test].cardinality() != 0) {
            return false;
        }
        newSt[test].clear();
        newSt[test].or(st);
        newSt[test].and(negativeStateBit);
        return newSt[test].cardinality() == 0;
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    @Override
    public void setExpressions(List<Property> properties) {
        this.positiveIndex = properties.get(0).getPositiveIndex();
        this.negativeIndex = properties.get(0).getNegativeIndex();
    }

    public double[][] computeDistribution() throws Exception {
        if (this.positiveIndex == null) {
            this.positiveIndex = new ArrayList<Integer>();
            this.negativeIndex = new ArrayList<Integer>();
        } else {
            this.positiveIndex.clear();
            this.negativeIndex.clear();
        }
        BitVector bs = new BitVector(this.pbn.getN());
        double[][] dis = new double[(int)Math.pow(2.0, this.pbn.getN())][2];
        this.runConverge();
        int i = 0;
        while ((double)i < Math.pow(2.0, this.pbn.getN())) {
            bs.clear();
            bs.putLongFromTo((long)i, 0, bs.size() - 1);
            int j = 0;
            while (j < bs.size()) {
                if (bs.get(j)) {
                    this.positiveIndex.add(j);
                } else {
                    this.negativeIndex.add(j);
                }
                ++j;
            }
            dis[i] = this.computeSteadyState();
            this.positiveIndex.clear();
            this.negativeIndex.clear();
            ++i;
        }
        return dis;
    }

    public void simulate(int N) throws Exception {
        int extentionPerChain = (int)Math.ceil((double)N / (double)this.m) + 1;
        this.parallelSimulate.reinitialize();
        this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
        this.parallelSimulate.setMinIndex(0);
        this.parallelSimulate.setSteps(extentionPerChain);
        this.pool.invoke(this.parallelSimulate);
        this.updateTransition();
    }

    public void printStatistic() {
        this.assalog.println("m=" + this.m + ", n=" + this.n + ", burnIn=" + this.burnIn + ", Nmax=" + this.Nmax + ", each chain length=" + this.countSteps[0] + ", fetch samples every " + this.kstep + " step(s).");
    }

    public int getNmax() {
        return this.Nmax;
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        this.pbn = (BitSetPBN)pbn;
        return this.computeSteadyState();
    }

    @Override
    public void setInstanceName() {
        this.instanceName = "parallel version Two-state Markov Chain approach";
    }
}

