/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.PBN;
import PBN.Property;
import PBN.ReducePBN;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import functionLib.AssaException;
import functionLib.Parameters;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.Covariance;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.BitSetPBNSimulationEngineReduce;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class GelmanFullStateReducedModel
extends SimulationMethod {
    private StateBit trajectory;
    private List<StateBit> trajectories;
    private String outputName;
    private int m;
    private int n;
    private int twon;
    private int count;
    private int previousIndex;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private StateBit[] initialState;
    BitSetPBNSimulationEngineReduce engine;
    int statesize;
    private boolean convergeRun = false;
    int Nmax;
    int kstep = 1;
    int chainLength = 0;
    private double threshold = 0.001;
    private double precision = 0.01;
    private double confidence = 0.95;
    private double alpha;
    private double beta;
    private long meta1 = 0L;
    private long meta2 = 0L;
    private int countStep = 0;
    StateBit newSt;
    private long[] stateA;
    private long[] stateB;
    private long[] burnInStateA;
    private long[] burnInStateB;
    private int maxRecord = 60000;
    private int countSteps = 0;
    private int traIndex = 0;
    private long[][] transitionsLast;
    int[] index1;
    int[] index2;
    private StateBit positiveStateBit;
    private StateBit negativeStateBit;
    private int numLeaves;
    private ReducePBN opt;

    public GelmanFullStateReducedModel(AssaLog assalog) {
        super(assalog);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.m = Parameters.NUM_PARALLEL;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.index2 = new int[this.m];
        this.transitionsLast = new long[2][2];
        this.stateA = new long[this.m];
        this.stateB = new long[this.m];
        this.enableOutput = true;
        this.setInstanceName();
    }

    public GelmanFullStateReducedModel(BitSetPBN pbn, AssaLog assalog) {
        super(assalog);
        this.pbn = pbn;
        this.newSt = new StateBit(pbn.getN());
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.m = Parameters.NUM_PARALLEL;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.index2 = new int[this.m];
        this.transitionsLast = new long[2][2];
        this.stateA = new long[this.m];
        this.stateB = new long[this.m];
        this.enableOutput = true;
        this.setInstanceName();
    }

    public GelmanFullStateReducedModel(PBN pbn, AssaLog assalog, double approximation, double confidence, int kstep) {
        super(assalog);
        this.pbn = (BitSetPBN)pbn;
        this.precision = approximation;
        this.confidence = confidence;
        this.kstep = kstep;
        this.transitionsLast = new long[2][2];
        this.newSt = new StateBit(pbn.getN());
        this.m = Parameters.NUM_PARALLEL;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.index2 = new int[this.m];
        this.transitionsLast = new long[2][2];
        this.stateA = new long[this.m];
        this.stateB = new long[this.m];
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.enableOutput = true;
        this.setInstanceName();
    }

    @Override
    public void setLogFile(String logFileName) {
        this.outputName = logFileName;
    }

    public void setParameters(double precision, double confidence) {
        this.precision = precision;
        this.confidence = confidence;
    }

    public void setM(int m) {
        this.m = m;
        this.index1 = new int[m];
    }

    public void setKstep(int kstep) {
        this.kstep = kstep;
    }

    public void initialise() {
        this.initialState = new StateBit[this.m];
        this.engine = new BitSetPBNSimulationEngineReduce(this.pbn, this);
        this.engine.setNumLeaves(this.numLeaves);
        this.statesize = this.pbn.getN();
    }

    public void reInitialise() {
        this.trajectories = null;
        this.reInitialiseAlphaBeta();
        this.convergeRun = false;
    }

    private void reInitialiseAlphaBeta() {
        this.meta1 = 0L;
        this.meta2 = 0L;
        this.countStep = 0;
        if (this.transitionsLast == null) {
            this.transitionsLast = new long[2][2];
        } else {
            this.transitionsLast[0][0] = 0L;
            this.transitionsLast[0][1] = 0L;
            this.transitionsLast[1][0] = 0L;
            this.transitionsLast[1][1] = 0L;
        }
    }

    public void runConverge() throws Exception {
        this.initialise();
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        double[] meansquare = new double[this.m];
        double mean_meansquare = 0.0;
        boolean done = false;
        boolean done1 = false;
        Covariance covariance = new Covariance();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<StateBit>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new StateBit(this.pbn.getN());
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = this.n;
        this.previousIndex = 0;
        while (!done) {
            this.initialState = this.engine.simulate(extension * 2, this.initialState);
            double within = 0.0;
            double grandmean = 0.0;
            mean_meansquare = 0.0;
            double[] values = new double[this.n];
            i = 0;
            while (i < this.m) {
                mean[i] = 0.0;
                int j = 0;
                while (j < this.n) {
                    if (this.trajectories.get(i).get(j + this.n)) {
                        int n = i;
                        mean[n] = mean[n] + 1.0;
                    }
                    ++j;
                }
                mean[i] = mean[i] / (double)this.n;
                meansquare[i] = Math.pow(mean[i], 2.0);
                sj[i] = 0.0;
                j = this.n;
                while (j < this.twon) {
                    values[j - this.n] = this.trajectories.get(i).get(j) ? 1.0 : 0.0;
                    ++j;
                }
                sj[i] = StatUtils.variance(values);
                ++i;
            }
            within = StatUtils.mean(sj);
            grandmean = StatUtils.mean(mean);
            mean_meansquare = StatUtils.mean(meansquare);
            double between = (double)this.n * StatUtils.variance(mean);
            double varianceW = StatUtils.variance(sj);
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = covariance.covariance(sj, meansquare);
            double covwx = covariance.covariance(sj, mean);
            double covwb = (double)(this.n / this.m) * (covwxsquare - 2.0 * grandmean * covwx);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double varianceV = (Math.pow(this.n - 1, 2.0) * (varianceW /= (double)this.m) + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            if (Math.abs(1.0 - psrf) > this.threshold || varianceV == 0.0) {
                done = false;
                done1 = false;
                extension = this.n;
                this.n += extension;
                this.twon = this.n * 2;
                if (this.twon <= this.maxRecord) continue;
                done = true;
                this.twon = this.n;
                this.n -= extension;
                continue;
            }
            if (done1) {
                done = true;
                continue;
            }
            done1 = true;
            extension = this.n;
            this.n += extension;
            this.twon = this.n * 2;
            if (this.twon <= this.maxRecord) continue;
            this.maxRecord = this.twon;
        }
        this.convergeRun = true;
    }

    public void runConvergeFixedN(int n) throws Exception {
        this.n = n;
        this.twon = 2 * n;
        this.initialise();
        boolean done = false;
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        double divide = (double)statespace / (double)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo((long)(divide * (double)i), 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<StateBit>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new StateBit(this.pbn.getN());
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = n;
        this.previousIndex = 0;
        while (!done) {
            i = 0;
            while (i < this.m) {
                this.count = i;
                this.initialState[i] = this.engine.simulate(extension * 2, this.initialState[i]);
                ++i;
            }
            done = true;
        }
        this.convergeRun = true;
    }

    public double[] computeSteadyState() throws Exception {
        int extentionPerChain;
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        PrintWriter pw = null;
        pw = new PrintWriter(new FileWriter(this.outputName, true));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = new Date();
        long start = System.currentTimeMillis();
        long cpu = thread.getCurrentThreadCpuTime();
        pw.println("Program started at " + df.format(startDate));
        pw.println("Total number of nodes is " + this.pbn.getN() + ".");
        pw.print("Checking states where ");
        if (this.positiveIndex.size() != 0) {
            pw.print("nodes with index ");
            for (int i : this.positiveIndex) {
                pw.print(String.valueOf(i) + " ");
                this.positiveStateBit.set(i);
            }
            pw.print("should have value 1 and ");
        }
        if (this.negativeIndex.size() != 0) {
            int i;
            pw.print("nodes with index ");
            i = 0;
            while (i < this.negativeIndex.size()) {
                pw.print(this.negativeIndex.get(i) + " ");
                this.negativeStateBit.set(this.negativeIndex.get(i));
                ++i;
            }
            pw.println("should have value 0.");
        } else {
            pw.println("no requirements on other nodes.");
        }
        pw.println("Approximation is " + this.precision + ", confidence is " + this.confidence + ", fetch sample every " + this.kstep + " steps.");
        if (!this.convergeRun) {
            this.runConverge();
        }
        pw.println("converged with " + this.twon + " steps.");
        double[] result = new double[4];
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + this.confidence), false);
        this.index1 = new int[this.m];
        this.meta1 = 0L;
        this.meta2 = 0L;
        this.calAlphaBeta(this.n);
        pw.println("alpha=" + this.alpha + ",beta=" + this.beta);
        double threshold = 0.0;
        threshold = 3.0 / (double)(this.countStep * this.m);
        while (this.alpha < threshold || this.beta < threshold || this.alpha > 0.9999999 && this.beta > 0.9999999) {
            extentionPerChain = this.n;
            this.simulate(extentionPerChain * this.m + this.trajectories.get(0).size() * this.m);
            this.calAlphaBeta(this.n);
            threshold = 3.0 / (double)(this.countStep * this.m);
            if (this.countStep <= 2147483547 && this.countStep >= 0) continue;
            this.assalog.println("Not able to find suitable alpha and beta values after 2147483647 steps.");
            throw new AssaException("Not able to find suitable alpha and beta values!");
        }
        int N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
        int current = 0;
        current = this.twon - 1;
        this.count = 0;
        int round = 0;
        pw.println("N=" + N);
        while ((long)N > this.meta1 + this.meta2) {
            extentionPerChain = (int)Math.ceil((double)(((long)N - this.meta1 - this.meta2) * (long)this.kstep) / (double)this.m);
            this.simulate(extentionPerChain * this.m + this.trajectories.get(0).size() * this.m);
            this.calAlphaBeta(this.n);
            N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
            if (this.countStep > 2147483547 || this.countStep < 0) {
                this.assalog.println("N is too large. I will stop simulation.");
                break;
            }
            pw.println("N=" + N + ", current length= " + (this.meta1 + this.meta2));
            ++round;
        }
        int M = (int)Math.ceil(Math.log(Parameters.epsilon * (this.alpha + this.beta) / Math.max(this.alpha, this.beta)) / Math.log(Math.abs(1.0 - this.alpha - this.beta)));
        pw.println("Total extending times: " + round + ".");
        pw.println("final N=" + N);
        pw.println("Verifying M: " + M);
        result[0] = (double)this.meta1 / (double)(this.meta1 + this.meta2);
        result[1] = this.meta1 + this.meta2 + (long)(this.m * this.n);
        result[2] = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        result[3] = (double)(System.currentTimeMillis() - start) / 1000.0;
        pw.println("alpha=" + this.alpha + ",beta=" + this.beta);
        pw.println("distribution=" + result[0] + "\n");
        pw.close();
        if (N > this.Nmax) {
            this.Nmax = N;
        }
        return result;
    }

    public double[] computeSteadyStateFixedN(int n) throws Exception {
        int extentionPerChain;
        if (!this.convergeRun) {
            this.runConvergeFixedN(n);
        }
        this.reInitialiseAlphaBeta();
        double[] result = new double[3];
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + this.confidence), false);
        this.index1 = new int[this.m];
        this.meta1 = 0L;
        this.meta2 = 0L;
        this.calAlphaBeta(n);
        double threshold = 0.0;
        threshold = 3.0 / (double)(this.countStep * this.m);
        while (this.alpha < threshold || this.beta < threshold || this.alpha > 0.9999999 && this.beta > 0.9999999) {
            extentionPerChain = n;
            this.simulate(extentionPerChain * this.m + this.trajectories.get(0).size() * this.m);
            this.calAlphaBeta(extentionPerChain);
            threshold = 3.0 / (double)(this.countStep * this.m);
        }
        int N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
        int current = 0;
        current = this.twon - 1;
        this.count = 0;
        boolean round = false;
        while ((long)N > this.meta1 + this.meta2) {
            extentionPerChain = (int)Math.ceil((double)((long)N - this.meta1 - this.meta2) / (double)this.m);
            this.simulate(extentionPerChain * this.m + this.trajectories.get(0).size() * this.m);
            this.calAlphaBeta(extentionPerChain);
            N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
        }
        result[0] = (double)this.meta1 / (double)(this.meta1 + this.meta2);
        result[1] = N;
        if (N > this.Nmax) {
            this.Nmax = N;
        }
        return result;
    }

    public void calAlphaBeta(int length, boolean isTotalLength) throws Exception {
        if (isTotalLength) {
            if (length < this.countStep) {
                throw new Exception("The number of processed samples is bigger than the length. No need to recompute.");
            }
            this.calAlphaBeta(length - this.countStep);
        } else {
            this.calAlphaBeta(length);
        }
    }

    public void calAlphaBeta(int length) throws Exception {
        int index1 = 0;
        int index2 = 0;
        long[][] transitionsLast = new long[2][2];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                transitionsLast[i][j] = this.transitionsLast[i][j];
                ++j;
            }
            ++i;
        }
        this.meta1 = 0L;
        this.meta2 = 0L;
        i = 0;
        while (i < this.m) {
            this.meta1 += this.stateA[i];
            this.meta2 += this.stateB[i];
            ++i;
        }
        int k = 0;
        while (k < this.m) {
            index1 = this.trajectories.get(k).get(0) ? 1 : 0;
            int i2 = 0;
            while (i2 < this.n) {
                int bridge = index1;
                if (this.trajectories.get(k).get(i2)) {
                    index1 = 1;
                    index2 = 1;
                } else {
                    index1 = 0;
                    index2 = 0;
                }
                long[] lArray = transitionsLast[bridge];
                int n = index2;
                lArray[n] = lArray[n] - 1L;
                ++i2;
            }
            ++k;
        }
        this.beta = transitionsLast[0][0] + transitionsLast[0][1] == 0L ? 0.0 : (double)transitionsLast[0][1] / (double)(transitionsLast[0][0] + transitionsLast[0][1]);
        this.alpha = transitionsLast[1][0] + transitionsLast[1][1] == 0L ? 0.0 : (double)transitionsLast[1][0] / (double)(transitionsLast[1][0] + transitionsLast[1][1]);
    }

    public void runPlot() throws Exception {
        StateBit[] initialState = new StateBit[this.m];
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        int statesize = this.pbn.getN();
        double mean_meansquare = 0.0;
        boolean done = false;
        BitSetPBNSimulationEngine engine = new BitSetPBNSimulationEngine(this.pbn, this);
        Random ran = RandomProvider.getInstance().getRandom();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            initialState[i] = new StateBit(statesize);
            initialState[i].putLongFromTo(statespace * (long)i, 0, statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<StateBit>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new StateBit(this.pbn.getN());
            this.trajectories.add(this.trajectory);
            ++i;
        }
        this.previousIndex = 0;
        int extension = this.n;
        int k = 1;
        while (k < 501) {
            int i2 = 0;
            while (i2 < this.m) {
                this.count = i2;
                initialState[i2] = engine.simulate(extension * 2, initialState[i2]);
                ++i2;
            }
            double within = 0.0;
            double grandmean = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                mean[i2] = 0.0;
                int j = 0;
                while (j < this.n) {
                    if (this.trajectories.get(i2).get(j + this.n)) {
                        int n = i2;
                        mean[n] = mean[n] + 1.0;
                    }
                    ++j;
                }
                mean[i2] = mean[i2] / (double)this.n;
                mean_meansquare += mean[i2] * mean[i2];
                grandmean += mean[i2];
                sj[i2] = 0.0;
                j = this.n;
                while (j < this.twon) {
                    double tt = this.trajectories.get(i2).get(j) ? 1.0 - mean[i2] : 0.0 - mean[i2];
                    int n = i2;
                    sj[n] = sj[n] + Math.pow(tt, 2.0);
                    ++j;
                }
                sj[i2] = sj[i2] / (double)(this.n - 1);
                within += sj[i2];
                ++i2;
            }
            within /= (double)this.m;
            grandmean /= (double)this.m;
            mean_meansquare /= (double)this.m;
            double between = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                between += Math.pow(grandmean - mean[i2], 2.0);
                ++i2;
            }
            between = between * (double)this.n / (double)(this.m - 1);
            double varianceW = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                varianceW += Math.pow(sj[i2] - within, 2.0);
                ++i2;
            }
            varianceW /= (double)(this.m - 1);
            varianceW /= (double)this.m;
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = 0.0;
            double covwx = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                covwxsquare += (sj[i2] - within) * (mean[i2] * mean[i2] - mean_meansquare);
                covwx += (sj[i2] - within) * (mean[i2] - grandmean);
                ++i2;
            }
            double covwb = (double)(this.n / this.m) * ((covwxsquare /= (double)(this.m - 1)) - 2.0 * grandmean * (covwx /= (double)(this.m - 1)));
            double varianceV = (Math.pow(this.n - 1, 2.0) * varianceW + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            extension = 5;
            this.n += extension;
            this.twon = this.n * 2;
            ++k;
        }
    }

    @Override
    public void updateTransition(StateBit st, int para) {
        long tmp = st.getLongFromTo(0, st.getN());
    }

    public void updateTransition(StateBit[] sts, int[] para) {
        this.countStep += Parameters.NUM_PARALLEL;
        int i = 0;
        while (i < this.m) {
            boolean eva = para[i] == 1 ? this.evaluateState(sts[i], 0) : this.index1[i] == 1;
            int bridge = this.index1[i];
            if (eva) {
                int n = i;
                this.stateA[n] = this.stateA[n] + 1L;
                this.index1[i] = 1;
                this.index2[i] = 1;
                if (this.traIndex != 0) {
                    long[] lArray = this.transitionsLast[bridge];
                    int n2 = this.index2[i];
                    lArray[n2] = lArray[n2] + 1L;
                }
            } else {
                int n = i;
                this.stateB[n] = this.stateB[n] + 1L;
                this.index1[i] = 0;
                this.index2[i] = 0;
                if (this.traIndex != 0) {
                    long[] lArray = this.transitionsLast[bridge];
                    int n3 = this.index2[i];
                    lArray[n3] = lArray[n3] + 1L;
                }
            }
            if (this.traIndex < this.maxRecord) {
                this.trajectories.get(i).set(this.traIndex, eva);
            }
            ++i;
        }
        ++this.traIndex;
    }

    public boolean evaluateState(StateBit st) {
        int i;
        if (this.positiveIndex != null) {
            i = 0;
            while (i < this.positiveIndex.size()) {
                if (!st.get(this.positiveIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (this.negativeIndex != null) {
            i = 0;
            while (i < this.negativeIndex.size()) {
                if (st.get(this.negativeIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean evaluateState(StateBit st, int test) {
        this.newSt.clear();
        this.newSt.or(st);
        this.newSt.and(this.positiveStateBit);
        this.newSt.xor(this.positiveStateBit);
        if (this.newSt.cardinality() != 0) {
            return false;
        }
        this.newSt.clear();
        this.newSt.or(st);
        this.newSt.and(this.negativeStateBit);
        return this.newSt.cardinality() == 0;
    }

    public void evaluateState(StateBit[] sts, int test, boolean[] eva) {
        int i = 0;
        while (i < this.m) {
            this.newSt.clear();
            this.newSt.or(sts[i]);
            this.newSt.and(this.positiveStateBit);
            this.newSt.xor(this.positiveStateBit);
            if (this.newSt.cardinality() != 0) {
                eva[i] = false;
            } else {
                this.newSt.clear();
                this.newSt.or(sts[i]);
                this.newSt.and(this.negativeStateBit);
                eva[i] = this.newSt.cardinality() == 0;
            }
            ++i;
        }
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    public double[][] computeDistribution() throws Exception {
        if (this.positiveIndex == null) {
            this.positiveIndex = new ArrayList<Integer>();
            this.negativeIndex = new ArrayList<Integer>();
        } else {
            this.positiveIndex.clear();
            this.negativeIndex.clear();
        }
        BitVector bs = new BitVector(this.pbn.getN());
        double[][] dis = new double[(int)Math.pow(2.0, this.pbn.getN())][2];
        this.runConverge();
        int i = 0;
        while ((double)i < Math.pow(2.0, this.pbn.getN())) {
            bs.clear();
            bs.putLongFromTo((long)i, 0, bs.size() - 1);
            int j = 0;
            while (j < bs.size()) {
                if (bs.get(j)) {
                    this.positiveIndex.add(j);
                } else {
                    this.negativeIndex.add(j);
                }
                ++j;
            }
            dis[i] = this.computeSteadyState();
            this.positiveIndex.clear();
            this.negativeIndex.clear();
            ++i;
        }
        return dis;
    }

    public void simulate(int N) throws Exception {
        int extentionPerChain = (int)(Math.ceil(N / this.m) - (double)this.trajectories.get(0).size()) + 1;
        if (extentionPerChain > 0) {
            this.initialState = this.engine.simulate(extentionPerChain, this.initialState);
        }
    }

    public void printStatistic() {
        this.assalog.println("m=" + this.m + ", n=" + this.n + ", Nmax=" + this.Nmax + ", each chain length=" + this.trajectories.get(0).size());
    }

    public int getNmax() {
        return this.Nmax;
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        this.pbn = (BitSetPBN)pbn;
        this.newSt = new StateBit(pbn.getN());
        return this.computeSteadyState();
    }

    @Override
    public void setInstanceName() {
        this.instanceName = "Two-state Markov chain structure-based parallel version";
    }

    @Override
    public void setExpressions(List<Property> properties) {
        this.positiveIndex = properties.get(0).getPositiveIndex();
        this.negativeIndex = properties.get(0).getNegativeIndex();
        this.positiveStateBit = new StateBit(this.pbn.getN());
        this.negativeStateBit = new StateBit(this.pbn.getN());
        if (this.positiveIndex.size() != 0) {
            for (int i : this.positiveIndex) {
                this.positiveStateBit.set(i);
            }
        }
        if (this.negativeIndex.size() != 0) {
            int i;
            i = 0;
            while (i < this.negativeIndex.size()) {
                this.negativeStateBit.set(this.negativeIndex.get(i));
                ++i;
            }
        }
    }

    @Override
    public String getLogFile() {
        return this.outputName;
    }

    public void setNumLeaves(int numLeaves) {
        this.numLeaves = numLeaves;
    }

    public void setOptimizePBN(ReducePBN opt) {
        this.opt = opt;
    }

    @Override
    public void setParameters(double[] parameters) throws Exception {
    }
}

