/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.OptimizePBN;
import PBN.PBN;
import PBN.Property;
import PBN.StateBit;
import cern.colt.bitvector.BitVector;
import functionLib.Parameters;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.Covariance;
import parallel.Simulate;
import simulationMethod.BitSetPBNSimulationEnginePara;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class GermanAndStructure
extends SimulationMethod {
    private List<StateBit> trajectory;
    private List<List> trajectories;
    private String outputName;
    private int m;
    private int n;
    private int twon;
    private int count;
    private int previousIndex;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private StateBit[] initialState;
    BitSetPBNSimulationEnginePara engine;
    int statesize;
    private boolean convergeRun = false;
    long Nmax;
    int kstep = 1;
    int chainLength = 0;
    private double threshold = 0.001;
    private double precision = 0.01;
    private double confidence = 0.95;
    private double alpha;
    private double beta;
    private long meta1 = 0L;
    private long meta2 = 0L;
    StateBit newSt;
    private long[] stateA;
    private long[] stateB;
    private long[] burnInStateA;
    private long[] burnInStateB;
    private int maxRecord = 60000;
    private int traIndex = 0;
    private long[][] transitionsLast;
    private int[][][] transitionsLastChain;
    private int[][] transitionsBurnIn;
    private boolean transitionBurnInComputed = false;
    int[] index1;
    int[] index2;
    private long[] countSteps;
    private StateBit positiveStateBit;
    private StateBit negativeStateBit;
    private int numLeaves;
    private Simulate parallelSimulate;
    private ForkJoinPool pool;
    private int burnIn;
    private OptimizePBN opt;
    private double epsilon = Parameters.epsilon;

    public GermanAndStructure(AssaLog assalog) {
        super(assalog);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.m = Parameters.NUM_PARALLEL;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.index2 = new int[this.m];
        this.transitionsLast = new long[2][2];
        this.transitionsLastChain = new int[this.m][2][2];
        this.transitionsBurnIn = new int[2][2];
        this.threshold /= Math.log(this.m);
        this.countSteps = new long[this.m];
        this.stateA = new long[this.m];
        this.stateB = new long[this.m];
        this.enableOutput = true;
        this.setInstanceName();
    }

    public GermanAndStructure(BitSetPBN pbn, AssaLog assalog) {
        super(assalog);
        this.pbn = pbn;
        this.newSt = new StateBit(pbn.getN());
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.m = Parameters.NUM_PARALLEL;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.index2 = new int[this.m];
        this.transitionsLast = new long[2][2];
        this.transitionsLastChain = new int[this.m][2][2];
        this.transitionsBurnIn = new int[2][2];
        this.threshold /= Math.log(this.m);
        this.countSteps = new long[this.m];
        this.stateA = new long[this.m];
        this.stateB = new long[this.m];
        this.enableOutput = true;
        this.setInstanceName();
    }

    public GermanAndStructure(PBN pbn, AssaLog assalog, double approximation, double confidence, int kstep) {
        super(assalog);
        this.pbn = (BitSetPBN)pbn;
        this.precision = approximation;
        this.confidence = confidence;
        this.kstep = kstep;
        this.transitionsLast = new long[2][2];
        this.newSt = new StateBit(pbn.getN());
        this.m = Parameters.NUM_PARALLEL;
        this.n = 10;
        this.twon = 2 * this.n;
        this.index1 = new int[this.m];
        this.index2 = new int[this.m];
        this.transitionsLast = new long[2][2];
        this.transitionsLastChain = new int[this.m][2][2];
        this.transitionsBurnIn = new int[2][2];
        this.threshold /= Math.log(this.m);
        this.countSteps = new long[this.m];
        this.stateA = new long[this.m];
        this.stateB = new long[this.m];
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gelman" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.enableOutput = true;
        this.setInstanceName();
    }

    @Override
    public void setLogFile(String logFileName) {
        this.outputName = logFileName;
    }

    public void setParameters(double precision, double confidence) {
        this.precision = precision;
        this.confidence = confidence;
    }

    public void setM(int m) {
        this.m = m;
        this.index1 = new int[m];
        this.index2 = new int[m];
        this.stateA = new long[m];
        this.stateB = new long[m];
        this.countSteps = new long[m];
        this.transitionsLastChain = new int[m][2][2];
        this.threshold /= Math.log(m);
    }

    public void setKstep(int kstep) {
        this.kstep = kstep;
    }

    public void initialise() {
        this.initialState = new StateBit[this.m];
        this.engine = new BitSetPBNSimulationEnginePara(this.pbn, this);
        this.engine.setNumLeaves(this.numLeaves);
        this.engine.setPara(this.opt);
        this.statesize = this.pbn.getN();
    }

    public void reInitialise() {
        this.trajectories = null;
        this.reInitialiseAlphaBeta();
        this.convergeRun = false;
        this.setM(this.m);
        this.n = 10;
        this.twon = 2 * this.n;
    }

    private void reInitialiseAlphaBeta() {
        this.meta1 = 0L;
        this.meta2 = 0L;
        if (this.transitionsLast == null) {
            this.transitionsLast = new long[2][2];
            this.transitionsBurnIn = new int[2][2];
            this.transitionsLastChain = new int[this.m][2][2];
        } else {
            this.transitionsLast[0][0] = 0L;
            this.transitionsLast[0][1] = 0L;
            this.transitionsLast[1][0] = 0L;
            this.transitionsLast[1][1] = 0L;
        }
    }

    private void updateTransition() {
        this.transitionsLast[0][0] = 0L;
        this.transitionsLast[0][1] = 0L;
        this.transitionsLast[1][0] = 0L;
        this.transitionsLast[1][1] = 0L;
        int i = 0;
        while (i < this.m) {
            long[] lArray = this.transitionsLast[0];
            lArray[0] = lArray[0] + (long)this.transitionsLastChain[i][0][0];
            long[] lArray2 = this.transitionsLast[0];
            lArray2[1] = lArray2[1] + (long)this.transitionsLastChain[i][0][1];
            long[] lArray3 = this.transitionsLast[1];
            lArray3[0] = lArray3[0] + (long)this.transitionsLastChain[i][1][0];
            long[] lArray4 = this.transitionsLast[1];
            lArray4[1] = lArray4[1] + (long)this.transitionsLastChain[i][1][1];
            ++i;
        }
    }

    public void runConverge() throws Exception {
        this.initialise();
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        double[] meansquare = new double[this.m];
        boolean done = false;
        boolean done1 = false;
        int endIndex = this.pbn.getN() - 1;
        Covariance covariance = new Covariance();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<StateBit>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = this.n;
        this.previousIndex = 0;
        this.parallelSimulate = new Simulate(this.trajectories, extension * 2, 0, this.trajectories.size() - 1, this.engine, this.initialState);
        this.pool = new ForkJoinPool();
        while (!done) {
            this.parallelSimulate.reinitialize();
            this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
            this.parallelSimulate.setMinIndex(0);
            this.parallelSimulate.setSteps(extension * 2 * this.kstep);
            this.pool.invoke(this.parallelSimulate);
            this.updateTransition();
            double within = 0.0;
            double grandmean = 0.0;
            double[] values = new double[this.n];
            i = 0;
            while (i < this.m) {
                mean[i] = 0.0;
                int j = 0;
                while (j < this.n) {
                    int n = i;
                    mean[n] = mean[n] + ((StateBit)this.trajectories.get(i).get(j + this.n)).getDoubleValue(0, endIndex);
                    ++j;
                }
                mean[i] = mean[i] / (double)this.n;
                meansquare[i] = Math.pow(mean[i], 2.0);
                sj[i] = 0.0;
                j = this.n;
                while (j < this.twon) {
                    values[j - this.n] = ((StateBit)this.trajectories.get(i).get(j)).getDoubleValue(0, endIndex);
                    ++j;
                }
                sj[i] = StatUtils.variance(values);
                ++i;
            }
            within = StatUtils.mean(sj);
            grandmean = StatUtils.mean(mean);
            double between = (double)this.n * StatUtils.variance(mean);
            double varianceW = StatUtils.variance(sj);
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = covariance.covariance(sj, meansquare);
            double covwx = covariance.covariance(sj, mean);
            double covwb = (double)(this.n / this.m) * (covwxsquare - 2.0 * grandmean * covwx);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double varianceV = (Math.pow(this.n - 1, 2.0) * (varianceW /= (double)this.m) + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            if (Math.abs(1.0 - psrf) > this.threshold || varianceV == 0.0) {
                done = false;
                done1 = false;
                extension = this.n;
                this.n += extension;
                this.twon = this.n * 2;
                if (this.twon <= this.maxRecord) continue;
                done = true;
                this.twon = this.n;
                this.n -= extension;
                continue;
            }
            if (done1) {
                done = true;
                continue;
            }
            done1 = true;
            extension = this.n;
            this.n += extension;
            this.twon = this.n * 2;
            if (this.twon <= this.maxRecord) continue;
            this.maxRecord = this.twon + 100;
        }
        this.convergeRun = true;
    }

    public double calDistribution() {
        long stateA = 0L;
        long stateB = 0L;
        int i = 0;
        while (i < this.m) {
            stateA += this.stateA[i];
            stateB += this.stateB[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m) {
            int j = 0;
            while (j < this.burnIn) {
                if (this.evaluateState((StateBit)this.trajectories.get(i2).get(j))) {
                    --stateA;
                } else {
                    --stateB;
                }
                ++j;
            }
            ++i2;
        }
        long total = stateA + stateB;
        if (total != 0L) {
            return (double)stateA / (double)total;
        }
        return 0.0;
    }

    public double[] computeSteadyState() throws Exception {
        int extentionPerChain;
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        PrintWriter pw = null;
        pw = new PrintWriter(new FileWriter(this.outputName, true));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = new Date();
        long start = System.currentTimeMillis();
        long cpu = thread.getCurrentThreadCpuTime();
        int round = 0;
        pw.println("Program started at " + df.format(startDate));
        pw.println("Total number of nodes is " + this.pbn.getN() + ".");
        pw.print("Checking states where ");
        if (this.positiveIndex.size() != 0) {
            pw.print("nodes with index ");
            for (int i : this.positiveIndex) {
                pw.print(String.valueOf(i) + " ");
                this.positiveStateBit.set(i);
            }
            pw.print("should have value 1 and ");
        }
        if (this.negativeIndex.size() != 0) {
            int i;
            pw.print("nodes with index ");
            i = 0;
            while (i < this.negativeIndex.size()) {
                pw.print(this.negativeIndex.get(i) + " ");
                this.negativeStateBit.set(this.negativeIndex.get(i));
                ++i;
            }
            pw.println("should have value 0.");
        } else {
            pw.println("no requirements on other nodes.");
        }
        pw.println("Approximation is " + this.precision + ", confidence is " + this.confidence + ", fetch sample every " + this.kstep + " steps.");
        if (!this.convergeRun) {
            this.runConverge();
        }
        this.burnIn = this.n;
        pw.println("converged with " + this.twon + " steps.");
        double[] result = new double[4];
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + this.confidence), false);
        this.index1 = new int[this.m];
        this.calAlphaBeta(this.burnIn);
        long countStep = 0L;
        int i = 0;
        while (i < this.m) {
            countStep += this.countSteps[i];
            ++i;
        }
        pw.println("alpha=" + this.alpha + ",beta=" + this.beta);
        double threshold = 0.0;
        threshold = 3.0 / (double)countStep;
        while (this.alpha < threshold || this.beta < threshold || this.alpha > 0.9999999 && this.beta > 0.9999999) {
            extentionPerChain = this.n;
            this.assalog.println("Alpha=" + this.alpha + ", beta=" + this.beta + ", extend for avaiable alpha beta by " + extentionPerChain * this.kstep + " per chain");
            this.simulate(extentionPerChain * this.m * this.kstep);
            this.calAlphaBeta(this.burnIn);
            pw.println("alpha=" + this.alpha + ",beta=" + this.beta);
            countStep = 0L;
            int i2 = 0;
            while (i2 < this.m) {
                countStep += this.countSteps[i2];
                ++i2;
            }
            threshold = 3.0 / (double)countStep;
            ++round;
        }
        long N = (long)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
        int M = 0;
        int current = 0;
        current = this.twon - 1;
        this.count = 0;
        pw.println("N=" + N);
        long maxLength = this.transitionsLast[0][0] + this.transitionsLast[0][1] + this.transitionsLast[1][0] + this.transitionsLast[1][1] - (long)(this.m * (this.n - 1));
        while (N > maxLength) {
            extentionPerChain = (int)Math.ceil((double)((N - maxLength) * (long)this.kstep) / (double)this.m);
            this.simulate(extentionPerChain * this.m);
            this.calAlphaBeta(this.burnIn);
            N = (long)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
            maxLength = this.transitionsLast[0][0] + this.transitionsLast[0][1] + this.transitionsLast[1][0] + this.transitionsLast[1][1] - (long)(this.m * (this.burnIn - 1));
            pw.println("Re-estimating round " + ++round + ": alpha=" + this.alpha + ", beta=" + this.beta + ", N=" + N + ", current length=" + maxLength + ".");
            this.assalog.println("Re-estimating round " + round + ": alpha=" + this.alpha + ", beta=" + this.beta + ", N=" + N + ", current length=" + maxLength + ".");
            if (N >= maxLength || (M = (int)Math.ceil(Math.log(this.epsilon * (this.alpha + this.beta) / Math.max(this.alpha, this.beta)) / Math.log(Math.abs(1.0 - this.alpha - this.beta)))) <= this.burnIn) continue;
            this.burnIn = M;
            this.calAlphaBeta(this.burnIn);
            N = (int)Math.ceil(this.alpha * this.beta * (2.0 - this.alpha - this.beta) / (Math.pow(this.alpha + this.beta, 3.0) * Math.pow(this.precision / invPhi, 2.0)));
            maxLength = this.transitionsLast[0][0] + this.transitionsLast[0][1] + this.transitionsLast[1][0] + this.transitionsLast[1][1] - (long)(this.m * (this.burnIn - 1));
            pw.println("Changing burnIn length to " + M + ". Recomputing result: alpha=" + this.alpha + ", beta=" + this.beta + ", N=" + N + ", current length=" + maxLength + ".");
        }
        pw.println("Re-estimation times=" + round);
        pw.println("final M=" + M * this.kstep);
        pw.println("final N=" + N);
        long simulationsteps = 0L;
        int i3 = 0;
        while (i3 < this.countSteps.length) {
            simulationsteps += this.countSteps[i3];
            ++i3;
        }
        pw.println("Total simulation steps = " + simulationsteps + ".");
        result[0] = this.calDistribution();
        result[1] = simulationsteps;
        result[2] = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        result[3] = (double)(System.currentTimeMillis() - start) / 1000.0;
        pw.println("alpha=" + this.alpha + ",beta=" + this.beta);
        pw.println("distribution=" + result[0] + "\n");
        pw.close();
        if (N > this.Nmax) {
            this.Nmax = N;
        }
        return result;
    }

    public void calAlphaBeta(int length) throws Exception {
        int j;
        int[] index1 = new int[this.m];
        int index2 = 0;
        long[][] transitionsLast = new long[2][2];
        int i = 0;
        while (i < 2) {
            j = 0;
            while (j < 2) {
                transitionsLast[i][j] = this.transitionsLast[i][j];
                ++j;
            }
            ++i;
        }
        if (!this.transitionBurnInComputed) {
            i = 0;
            while (i < this.m) {
                index1[i] = this.evaluateState((StateBit)this.trajectories.get(i).get(0)) ? 1 : 0;
                j = 1;
                while (j < length + 1) {
                    int bridge = index1[i];
                    if (this.evaluateState((StateBit)this.trajectories.get(i).get(j))) {
                        index1[i] = 1;
                        index2 = 1;
                    } else {
                        index1[i] = 0;
                        index2 = 0;
                    }
                    int[] nArray = this.transitionsBurnIn[bridge];
                    int n = index2;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                ++i;
            }
            this.transitionBurnInComputed = true;
        }
        i = 0;
        while (i < 2) {
            j = 0;
            while (j < 2) {
                transitionsLast[i][j] = this.transitionsLast[i][j] - (long)this.transitionsBurnIn[i][j];
                ++j;
            }
            ++i;
        }
        this.beta = transitionsLast[0][0] + transitionsLast[0][1] == 0L ? 0.0 : (double)transitionsLast[0][1] / (double)(transitionsLast[0][0] + transitionsLast[0][1]);
        this.alpha = transitionsLast[1][0] + transitionsLast[1][1] == 0L ? 0.0 : (double)transitionsLast[1][0] / (double)(transitionsLast[1][0] + transitionsLast[1][1]);
    }

    @Override
    public void updateTransition(StateBit st, int para) {
        int n = para;
        this.countSteps[n] = this.countSteps[n] + 1L;
        if ((this.countSteps[para] - 1L) % (long)this.kstep != 0L) {
            return;
        }
        int size = this.trajectories.get(para).size();
        boolean eva = this.evaluateState(st);
        int bridge = this.index1[para];
        if (eva) {
            int n2 = para;
            this.stateA[n2] = this.stateA[n2] + 1L;
            this.index1[para] = 1;
            this.index2[para] = 1;
            if (this.countSteps[para] > 1L) {
                int[] nArray = this.transitionsLastChain[para][bridge];
                int n3 = this.index2[para];
                nArray[n3] = nArray[n3] + 1;
            }
        } else {
            int n4 = para;
            this.stateB[n4] = this.stateB[n4] + 1L;
            this.index1[para] = 0;
            this.index2[para] = 0;
            if (this.countSteps[para] > 1L) {
                int[] nArray = this.transitionsLastChain[para][bridge];
                int n5 = this.index2[para];
                nArray[n5] = nArray[n5] + 1;
            }
        }
        if (size < this.maxRecord) {
            StateBit tmp = new StateBit(st.getN());
            tmp.xor(st);
            this.trajectories.get(para).add(tmp);
        }
    }

    public boolean evaluateState(StateBit st) {
        int i;
        if (this.positiveIndex != null) {
            i = 0;
            while (i < this.positiveIndex.size()) {
                if (!st.get(this.positiveIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (this.negativeIndex != null) {
            i = 0;
            while (i < this.negativeIndex.size()) {
                if (st.get(this.negativeIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean evaluateState(StateBit st, int test) {
        this.newSt.clear();
        this.newSt.or(st);
        this.newSt.and(this.positiveStateBit);
        this.newSt.xor(this.positiveStateBit);
        if (this.newSt.cardinality() != 0) {
            return false;
        }
        this.newSt.clear();
        this.newSt.or(st);
        this.newSt.and(this.negativeStateBit);
        return this.newSt.cardinality() == 0;
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    public double[][] computeDistribution() throws Exception {
        if (this.positiveIndex == null) {
            this.positiveIndex = new ArrayList<Integer>();
            this.negativeIndex = new ArrayList<Integer>();
        } else {
            this.positiveIndex.clear();
            this.negativeIndex.clear();
        }
        BitVector bs = new BitVector(this.pbn.getN());
        double[][] dis = new double[(int)Math.pow(2.0, this.pbn.getN())][2];
        this.runConverge();
        int i = 0;
        while ((double)i < Math.pow(2.0, this.pbn.getN())) {
            bs.clear();
            bs.putLongFromTo((long)i, 0, bs.size() - 1);
            int j = 0;
            while (j < bs.size()) {
                if (bs.get(j)) {
                    this.positiveIndex.add(j);
                } else {
                    this.negativeIndex.add(j);
                }
                ++j;
            }
            dis[i] = this.computeSteadyState();
            this.positiveIndex.clear();
            this.negativeIndex.clear();
            ++i;
        }
        return dis;
    }

    public void simulate(int N) throws Exception {
        int extentionPerChain = (int)Math.ceil((double)N / (double)this.m) + 1;
        this.parallelSimulate.reinitialize();
        this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
        this.parallelSimulate.setMinIndex(0);
        this.parallelSimulate.setSteps(extentionPerChain);
        this.pool.invoke(this.parallelSimulate);
        this.updateTransition();
    }

    public void printStatistic() {
        this.assalog.println("m=" + this.m + ", n=" + this.n + ", Nmax=" + this.Nmax + ", each chain length=" + this.trajectories.get(0).size());
    }

    public long getNmax() {
        return this.Nmax;
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        this.pbn = (BitSetPBN)pbn;
        this.newSt = new StateBit(pbn.getN());
        return this.computeSteadyState();
    }

    @Override
    public void setInstanceName() {
        this.instanceName = "German and Rubin structure-based parallel version";
    }

    @Override
    public void setExpressions(List<Property> properties) {
        this.positiveIndex = properties.get(0).getPositiveIndex();
        this.negativeIndex = properties.get(0).getNegativeIndex();
        this.positiveStateBit = new StateBit(this.pbn.getN());
        this.negativeStateBit = new StateBit(this.pbn.getN());
        if (this.positiveIndex.size() != 0) {
            for (int i : this.positiveIndex) {
                this.positiveStateBit.set(i);
            }
        }
        if (this.negativeIndex.size() != 0) {
            int i;
            i = 0;
            while (i < this.negativeIndex.size()) {
                this.negativeStateBit.set(this.negativeIndex.get(i));
                ++i;
            }
        }
    }

    @Override
    public String getLogFile() {
        return this.outputName;
    }

    public void setNumLeaves(int numLeaves) {
        this.numLeaves = numLeaves;
    }

    public void setOptimizePBN(OptimizePBN opt) {
        this.opt = opt;
    }

    @Override
    public void setParameters(double[] parameters) throws Exception {
    }
}

