/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.PBN;
import PBN.Property;
import PBN.StateBit;
import functionLib.AssaException;
import functionLib.RandomProvider;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import simulationMethod.TwoState;
import userInterface.AssaConsoleLog;
import userInterface.AssaLog;

public class GermanGPU
extends TwoState {
    private String outputName;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private StateBit positiveStateBit;
    private StateBit negativeStateBit;

    static {
        try {
            System.loadLibrary("gpu");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    private static native void initialGPUPBN(PBN var0);

    private static native void initialGPUExpression(long[] var0, long[] var1);

    private static native void initialGerman(double[] var0);

    private static native void setOutputName(String var0);

    private static native double[] run();

    private static native int getCudaDeviceCount();

    public GermanGPU(AssaLog assalog) {
        super(assalog);
        this.setInstanceName();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gpu" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.setLogFile(this.outputName);
    }

    public GermanGPU(AssaLog assalog, double approximation, double confidence, double epsilon) {
        super(assalog, approximation, confidence, epsilon);
        this.setInstanceName();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gpu" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.setLogFile(this.outputName);
    }

    public GermanGPU(AssaLog assalog, double approximation, double confidence, double epsilon, int kstep) {
        super(assalog, approximation, confidence, epsilon, kstep);
        this.setInstanceName();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "gpu" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.setLogFile(this.outputName);
    }

    @Override
    public String getLogFile() {
        return this.outputName;
    }

    @Override
    public void setLogFile(String outputName) {
        this.outputName = outputName;
        GermanGPU.setOutputName(outputName);
    }

    @Override
    public void setPBN(PBN pbn) {
        this.pbn = pbn;
        GermanGPU.initialGPUPBN(pbn);
    }

    @Override
    public void setExpressions(List<Property> properties) throws AssaException {
        this.positiveIndex = properties.get(0).getPositiveIndex();
        this.negativeIndex = properties.get(0).getNegativeIndex();
        int n = this.pbn.getN();
        this.positiveStateBit = new StateBit(n);
        this.negativeStateBit = new StateBit(n);
        if (this.positiveIndex.size() != 0) {
            for (int i : this.positiveIndex) {
                this.positiveStateBit.set(i);
            }
        }
        if (this.negativeIndex.size() != 0) {
            int i;
            i = 0;
            while (i < this.negativeIndex.size()) {
                this.negativeStateBit.set(this.negativeIndex.get(i));
                ++i;
            }
        }
        if (this.positiveStateBit.nextSetBit(n) > 0 || this.negativeStateBit.nextSetBit(n) > 0) {
            throw new AssaException("The property provided is not consistant with the given PBN.");
        }
        GermanGPU.initialGPUExpression(this.positiveStateBit.toLongArray(), this.negativeStateBit.toLongArray());
    }

    public double[] run(PBN pbn, StateBit initialState) throws Exception {
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        long time = System.currentTimeMillis();
        return new double[]{0.0};
    }

    private String getTimeCost(Date start, Date end, String work) {
        long l = end.getTime() - start.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return "Total time for " + work + " is " + day + " days " + hour + " hours " + min + " mins " + s + " seconds";
    }

    @Override
    public void updateTransition(StateBit current, int para) {
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        if (GermanGPU.getCudaDeviceCount() == 1) {
            throw new AssaException("No Cuda device is detected!");
        }
        long start = System.nanoTime();
        double[] res = GermanGPU.run();
        res[2] = (double)(System.nanoTime() - start) / 1.0E9;
        return res;
    }

    @Override
    public void setInstanceName() {
        this.instanceName = "Two-state Markov Chain approach GPU version";
    }

    @Override
    public void calAlphaBeta() {
    }

    @Override
    public void setParameters(double[] parameters) {
        GermanGPU.initialGerman(parameters);
    }

    public static void main(String[] args) {
        AssaConsoleLog assalog = new AssaConsoleLog();
        GermanGPU gpu = new GermanGPU(assalog);
        BitSetPBNIO io = new BitSetPBNIO(assalog);
        BitSetPBN pbn = null;
        try {
            pbn = io.loadPBN("model/PBN_3.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        gpu.setPBN(pbn);
        gpu.setParameters(new double[]{0.01, 0.95, 1.0E-5});
        double[] re = null;
        try {
            re = gpu.run(pbn);
            assalog.println(re[0]);
            assalog.println(re[1]);
            assalog.println(re[2]);
            assalog.println(re[3]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

