/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.StateBit;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Iterator;
import simulationMethod.IterationMethod;
import userInterface.AssaLog;

public class Jacob
extends IterationMethod {
    private double[][] transitionMatrix;
    private int maxNodeNum = 14;
    private int maxTransitionElements = (int)Math.pow(2.0, this.maxNodeNum);

    public Jacob(BitSetPBN pbn, AssaLog assalog) {
        super(pbn, assalog);
    }

    @Override
    public double[] run() throws Exception {
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        this.initialize();
        long count = 0L;
        while (!this.done && count < this.maxIteration) {
            ++count;
            this.updatePai();
        }
        double probability = 0.0;
        if (this.done) {
            this.assalog.println("The Jacobi method ends within " + count + " iterations.");
            this.assalog.println("CPU Time cost: " + (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9 + "s.");
            this.normalize();
            if (this.stateSet != null) {
                Iterator iterator = this.stateSet.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    probability += this.pai[i];
                }
                this.assalog.println("The probability to check is " + probability + ".");
            } else {
                this.assalog.println("The steady-state distribution is");
                int i = 0;
                while (i < this.pai.length) {
                    this.assalog.print(String.valueOf(this.pai[i]) + "\t");
                    if ((i + 1) % 5 == 0) {
                        this.assalog.println();
                    }
                    ++i;
                }
                this.assalog.println();
            }
            return this.pai;
        }
        throw new Exception("The Jacob method does not converge within " + this.maxIteration + " iterations!");
    }

    @Override
    public void updatePai() throws Exception {
        double[] paiCopy = new double[this.pai.length];
        int i = 0;
        while (i < this.pai.length) {
            double[] probability = this.getColumTransitionProbability(i);
            double sum = 0.0;
            int j = 0;
            while (j < this.pai.length) {
                sum += -this.pai[j] * probability[j];
                ++j;
            }
            paiCopy[i] = (sum += this.pai[i] * probability[i]) / (probability[i] - 1.0);
            ++i;
        }
        this.testDone(paiCopy);
        this.pai = paiCopy;
    }

    private double[] getColumTransitionProbability(int state) throws Exception {
        int n = this.pbn.getN();
        if (state < this.maxTransitionElements) {
            if (this.transitionMatrix == null) {
                this.computeTransitionMatrix();
            }
            return this.transitionMatrix[state];
        }
        StateBit st = new StateBit(n);
        st.putLongFromTo(state, 0, n - 1);
        BitSetPBNIO io = new BitSetPBNIO(this.pbn, this.assalog);
        return io.getColumTransitionProbability(st);
    }

    private void computeTransitionMatrix() throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.pbn, this.assalog);
        StateBit st = new StateBit(this.pbn.getN());
        if (this.pbn.getN() > this.maxNodeNum) {
            this.transitionMatrix = new double[this.maxTransitionElements][this.pai.length];
            int i = 0;
            while (i < this.transitionMatrix.length) {
                st.putLongFromTo(i, 0, st.getN() - 1);
                this.transitionMatrix[i] = io.getColumTransitionProbability(st);
                ++i;
            }
        } else {
            this.transitionMatrix = new double[this.pai.length][this.pai.length];
            int i = 0;
            while (i < this.transitionMatrix.length) {
                st.putLongFromTo(i, 0, st.getN() - 1);
                this.transitionMatrix[i] = io.getTransitionProbability(st);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.transitionMatrix.length) {
                int j = i2 + 1;
                while (j < this.transitionMatrix.length) {
                    double bridge = this.transitionMatrix[i2][j];
                    this.transitionMatrix[i2][j] = this.transitionMatrix[j][i2];
                    this.transitionMatrix[j][i2] = bridge;
                    ++j;
                }
                ++i2;
            }
        }
    }

    public void updatePai_standard() throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.pbn, this.assalog);
        StateBit st = new StateBit(this.pbn.getN());
        double[] paiCopy = new double[this.pai.length];
        int i = 0;
        while (i < this.pai.length) {
            st.putLongFromTo(i, 0, st.getN() - 1);
            double[] probability = io.getColumTransitionProbability(st);
            double sum = 0.0;
            int j = 0;
            while (j < this.pai.length) {
                sum += this.pai[j] * probability[j];
                ++j;
            }
            paiCopy[i] = sum;
            ++i;
        }
        this.testDone(paiCopy);
        this.pai = paiCopy;
    }
}

