/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.PBN;
import PBN.Property;
import PBN.StateBit;
import functionLib.StatUtil;
import java.util.ArrayList;
import java.util.List;
import jsc.distributions.StudentsT;
import simulationMethod.MM1SimulationEngine;
import simulationMethod.SimulationEngine;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class Skart
extends SimulationMethod {
    private List<Double> trajectory;
    private int n;
    private int traIndex;
    private boolean precisionSet = false;
    private double precision;
    private boolean isRelative = false;
    private double alpha;
    private final double ZERO = 1.0E-12;

    public Skart(AssaLog assalog) {
        super(assalog);
    }

    public void setPrecision(double precision) {
        this.precision = precision;
        this.precisionSet = true;
    }

    public void setPrecision(double precision, boolean isRelative) {
        this.precision = precision;
        this.isRelative = isRelative;
        this.precisionSet = true;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double[] run() throws Exception {
        double yjm_element;
        int m;
        int d_max = 10;
        double alpha_ran = 0.2;
        int b = 0;
        this.n = 1280;
        this.traIndex = 0;
        int l = 1024;
        this.trajectory = new ArrayList<Double>();
        MM1SimulationEngine engine = new MM1SimulationEngine();
        List tra = (List)((Object)((SimulationEngine)engine).simulate(this.n, (StateBit)null));
        this.trajectory.addAll(tra);
        double skewness = this.skewness(tra, 0, tra.size());
        if (Math.abs(skewness) <= 4.0) {
            m = 1;
        } else {
            m = 16;
            tra = (List)((Object)((SimulationEngine)engine).simulate(this.n * (m - 1), (StateBit)null));
            this.trajectory.addAll(tra);
        }
        int k = this.n;
        this.n = k * m;
        ArrayList<Double> yjm = new ArrayList<Double>();
        int i = 0;
        while (i < k) {
            yjm_element = 0.0;
            int j = 0;
            while (j < m) {
                yjm_element += this.trajectory.get(m * i + j).doubleValue();
                ++j;
            }
            yjm.add(yjm_element /= (double)m);
            ++i;
        }
        skewness = this.skewness(yjm, (int)(0.2 * (double)k), k);
        if (Math.abs(skewness) > 0.5) {
            d_max = 3;
        }
        this.assalog.println("Finish step 1, d_max=" + d_max);
        int d = 0;
        boolean pass = false;
        double invPhi = StatUtil.getInvCDF(1.0 - alpha_ran / 2.0, false);
        int k_prime = k;
        while (!pass) {
            double Ck;
            int j;
            int i2;
            if (b != 0 || d != 0) {
                yjm = new ArrayList();
                System.gc();
                i2 = 0;
                while (i2 < k_prime) {
                    yjm_element = 0.0;
                    j = 0;
                    while (j < m) {
                        yjm_element += this.trajectory.get(m * ((i2 + 1) * (d + 1) - 1) + j).doubleValue();
                        ++j;
                    }
                    yjm.add(yjm_element /= (double)m);
                    ++i2;
                }
            }
            if (Math.abs(Ck = this.Ck(yjm, 0, yjm.size())) <= invPhi * Math.sqrt(((double)k_prime - 2.0) / ((double)k_prime * (double)k_prime - 1.0))) {
                pass = true;
                continue;
            }
            k_prime = (int)Math.floor(this.n / ((++d + 1) * m));
            if (d <= d_max) continue;
            m = (int)Math.ceil((double)m * Math.sqrt(2.0));
            k = (int)Math.ceil(0.9 * (double)k);
            int previousN = this.n;
            this.n = k * m;
            tra = (List)((Object)((SimulationEngine)engine).simulate(this.n - previousN, (StateBit)null));
            this.trajectory.addAll(tra);
            d = 0;
            d_max = 10;
            this.assalog.println("k=" + k + ",b=" + ++b);
            yjm = new ArrayList();
            i2 = 0;
            while (i2 < k) {
                yjm_element = 0.0;
                j = 0;
                while (j < m) {
                    yjm_element += this.trajectory.get(m * i2 + j).doubleValue();
                    ++j;
                }
                yjm.add(yjm_element /= (double)m);
                ++i2;
            }
            skewness = this.skewness(yjm, (int)(0.2 * (double)k), k);
            if (Math.abs(skewness) > 0.5) {
                d_max = 3;
            }
            k_prime = k;
        }
        if (Math.floor(this.n / (k_prime = (int)Math.ceil((double)k_prime * Math.pow(1.1111111111111112, b)))) > (double)m) {
            m = (int)Math.floor(this.n / k_prime);
        }
        this.assalog.println("Finish step 2, k_prime=" + k_prime + ",m=" + m);
        double[] estimator = this.thirdStep(m, d, k_prime, engine);
        this.assalog.println("Finish step 3, varEstimator=" + estimator[0]);
        double[] CI = this.fourthStep(d, m, k_prime, estimator);
        this.assalog.println("Finish step 4, CI=[" + CI[0] + "," + CI[1] + "]");
        if (this.precisionSet) {
            double average = CI[2];
            double halfLength = Math.abs(CI[0] - average);
            if (halfLength < Math.abs(CI[1] - average)) {
                halfLength = Math.abs(CI[1] - average);
            }
            double absolutePrecision = this.isRelative ? average * this.precision : this.precision;
            while (halfLength > absolutePrecision) {
                int k_star = (int)Math.ceil(Math.pow(halfLength / absolutePrecision, 2.0) * (double)k_prime);
                if (k_star > 1024) {
                    k_prime = 1024;
                    m = (int)Math.ceil((double)m * this.mid(1.02, k_star / k_prime, 2.0));
                } else {
                    k_prime = k_star;
                }
                estimator = this.thirdStep(m, d, k_prime, engine);
                CI = this.fourthStep(d, m, k_prime, estimator);
                average = CI[2];
                halfLength = Math.abs(CI[0] - average);
                if (!(halfLength < Math.abs(CI[1] - average))) continue;
                halfLength = Math.abs(CI[1] - average);
            }
        }
        this.assalog.println("The CI is [" + CI[0] + "," + CI[1] + "],+n=" + this.n);
        return CI;
    }

    @Override
    public void updateTransition(StateBit current, int para) {
    }

    public boolean evaluateState(StateBit st) {
        return true;
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    public double variance(List<Double> yjm, int start, int end) throws Exception {
        if (start > end || start < 0) {
            throw new Exception("start index should be smaller than end index");
        }
        double mean = this.mean(yjm, start, end);
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += (yjm.get(i) - mean) * (yjm.get(i) - mean);
            ++i;
        }
        return total / (double)(end - start - 1);
    }

    public double skewness(List<Double> yjm, int start, int end) throws Exception {
        double mean = this.mean(yjm, start, end);
        double variance = this.variance(yjm, start, end);
        double total = 0.0;
        double l = end - start;
        int i = start;
        while (i < end) {
            total += (yjm.get(i) - mean) * (yjm.get(i) - mean) * (yjm.get(i) - mean);
            ++i;
        }
        return total * l / ((l - 1.0) * (l - 2.0) * Math.pow(variance, 1.5));
    }

    public double Ck(List<Double> yjm, int start, int end) {
        double mean = this.mean(yjm, start, end);
        double total1 = 0.0;
        double total2 = 0.0;
        int i = start;
        while (i < end - 1) {
            total1 += Math.pow(yjm.get(i + 1) - yjm.get(i), 2.0);
            total2 += Math.pow(yjm.get(i) - mean, 2.0);
            ++i;
        }
        double result = 1.0 - total1 / (2.0 * (total2 += Math.pow(yjm.get(end - 1) - mean, 2.0)));
        return result;
    }

    public double phiym(List<Double> yjm, int start, int end) throws Exception {
        int k_prime = yjm.size();
        double total = 0.0;
        double mean = this.mean(yjm, start, end);
        double variance = this.variance(yjm, start, end);
        int i = 0;
        while (i < k_prime - 1) {
            total += (yjm.get(i) - mean) * (yjm.get(i + 1) - mean);
            ++i;
        }
        return total / ((double)(k_prime - 1) * variance);
    }

    public double Gr(double r, double skewnessSample, double sVariance, int k_doubleprime) {
        double beta = skewnessSample / (6.0 * Math.sqrt(k_doubleprime));
        double tmp = 1.0 + 6.0 * beta * (r - beta);
        double result = Math.cbrt(tmp);
        result = (result - 1.0) / (2.0 * beta);
        return result;
    }

    public double mid(double a, double x, double b) {
        if (x < a) {
            return a;
        }
        if (x > b) {
            return b;
        }
        return x;
    }

    private double[] thirdStep(int m, int d, int k_prime, SimulationEngine engine) throws Exception {
        if (m * (d + k_prime) > this.n) {
            int previousN = this.n;
            this.n = m * (d + k_prime);
            List tra = (List)((Object)engine.simulate(this.n - previousN, (StateBit)null));
            this.trajectory.addAll(tra);
        }
        ArrayList<Double> yjm = new ArrayList<Double>();
        System.gc();
        int i = 0;
        while (i < k_prime) {
            double yjm_element = 0.0;
            int j = 0;
            while (j < m) {
                yjm_element += this.trajectory.get(m * (i + d) + j).doubleValue();
                ++j;
            }
            yjm.add(yjm_element /= (double)m);
            ++i;
        }
        double mean = this.mean(yjm, 0, yjm.size());
        double phiym = this.phiym(yjm, 0, yjm.size());
        double A = (1.0 + phiym) / (1.0 - phiym);
        double varEstimator = A * this.variance(yjm, 0, yjm.size()) / (double)k_prime;
        return new double[]{varEstimator, mean};
    }

    private double[] fourthStep(int d, int m, int k_prime, double[] estimator) throws Exception {
        double skewness;
        int d_prime = (int)Math.ceil(d * m / m);
        int k_doubleprime = 1 + (int)Math.floor((k_prime - 1) / (d_prime + 1));
        ArrayList<Double> yjm = new ArrayList<Double>();
        System.gc();
        int i = 0;
        while (i < k_doubleprime) {
            double yjm_element = 0.0;
            int j = 0;
            while (j < m) {
                yjm_element += this.trajectory.get(m * (i * (d_prime + 1) + d) + j).doubleValue();
                ++j;
            }
            yjm.add(yjm_element /= (double)m);
            ++i;
        }
        double sVariance = Math.sqrt(this.variance(yjm, 0, yjm.size()));
        double skewnessSample = skewness = this.skewness(yjm, 0, yjm.size());
        StudentsT studentT = new StudentsT((double)(k_doubleprime - 1));
        if (this.alpha < 1.0E-12) {
            this.assalog.println("Alpha value is not set, using defalut value 0.05");
            this.alpha = 0.05;
        }
        double left = studentT.inverseCdf(1.0 - this.alpha / 2.0);
        double right = studentT.inverseCdf(this.alpha / 2.0);
        double CI_bottom = estimator[1] - this.Gr(left, skewnessSample, sVariance, k_doubleprime) * Math.sqrt(estimator[0]);
        double CI_top = estimator[1] - this.Gr(right, skewnessSample, sVariance, k_doubleprime) * Math.sqrt(estimator[0]);
        return new double[]{CI_bottom, CI_top, estimator[1]};
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        return null;
    }

    @Override
    public void setInstanceName() {
    }

    @Override
    public void setExpressions(List<Property> properties) {
    }

    @Override
    public String getLogFile() {
        return null;
    }

    @Override
    public void setParameters(double[] parameters) throws Exception {
    }
}

