/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.PBN;
import PBN.Property;
import PBN.StateBit;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import jsc.distributions.StudentsT;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.Covariance;
import parallel.Simulate;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class SkartPBNParallel
extends SimulationMethod {
    private List<StateBit> trajectory1;
    private List<List> trajectories1;
    private int maxRecord = 12000;
    private BitSet trajectory;
    private List<BitSet> trajectories2;
    private int n;
    private int[] traIndex;
    private BitSetPBN pbn;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private boolean precisionSet = false;
    private double precision;
    private boolean isRelative = false;
    private double alpha;
    private final double ZERO = 1.0E-12;
    private boolean debug = false;
    private String outputName;
    private boolean disableGlobalAlias;
    private StateBit[] initialState;
    private BitSetPBNSimulationEngine engine;
    private int m;
    private int n_gelman;
    private int twon;
    private int statesize;
    private int previousIndex;
    private Simulate parallelSimulate;
    private ForkJoinPool pool;
    private double threshold = 0.001;
    private boolean convergeRun = false;
    private PrintWriter pw;

    public SkartPBNParallel(BitSetPBN pbn, AssaLog assalog) {
        super(assalog);
        this.pbn = pbn;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "skart" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.n_gelman = 10;
        this.twon = 2 * this.n_gelman;
        this.setInstanceName();
    }

    public SkartPBNParallel(BitSetPBN pbn, AssaLog assalog, List<Integer> positiveIndex, List<Integer> negativeIndex) {
        super(assalog);
        this.pbn = pbn;
        this.positiveIndex = positiveIndex;
        this.negativeIndex = negativeIndex;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "skart" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.n_gelman = 10;
        this.twon = 2 * this.n_gelman;
        this.setInstanceName();
    }

    public void setM(int m) {
        this.m = m;
        this.trajectories2 = new ArrayList<BitSet>();
        this.traIndex = new int[m];
        int i = 0;
        while (i < m) {
            this.traIndex[i] = 0;
            ++i;
        }
    }

    @Override
    public String getLogFile() {
        return this.outputName;
    }

    @Override
    public void setLogFile(String outputName) {
        this.outputName = outputName;
        try {
            this.pw = new PrintWriter(new FileWriter(outputName, true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initialise() {
        this.initialState = new StateBit[this.m];
        this.engine = new BitSetPBNSimulationEngine(this.pbn, this);
        this.statesize = this.pbn.getN();
    }

    public void runConverge() throws Exception {
        this.initialise();
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        double[] meansquare = new double[this.m];
        boolean done = false;
        boolean done1 = false;
        int endIndex = this.pbn.getN() - 1;
        Covariance covariance = new Covariance();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories1 = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory1 = new ArrayList<StateBit>();
            this.trajectories1.add(this.trajectory1);
            this.trajectory = new BitSet();
            this.trajectories2.add(this.trajectory);
            ++i;
        }
        int extension = this.n_gelman;
        this.previousIndex = 0;
        this.parallelSimulate = new Simulate(this.trajectories1, extension * 2, 0, this.trajectories1.size() - 1, this.engine, this.initialState);
        this.pool = new ForkJoinPool();
        while (!done) {
            this.parallelSimulate.reinitialize();
            this.parallelSimulate.setMaxIndex(this.trajectories1.size() - 1);
            this.parallelSimulate.setMinIndex(0);
            this.parallelSimulate.setSteps(extension * 2);
            this.pool.invoke(this.parallelSimulate);
            double within = 0.0;
            double grandmean = 0.0;
            double[] values = new double[this.n_gelman];
            i = 0;
            while (i < this.m) {
                mean[i] = 0.0;
                int j = 0;
                while (j < this.n_gelman) {
                    int n = i;
                    mean[n] = mean[n] + ((StateBit)this.trajectories1.get(i).get(j + this.n_gelman)).getDoubleValue(0, endIndex);
                    ++j;
                }
                mean[i] = mean[i] / (double)this.n_gelman;
                meansquare[i] = Math.pow(mean[i], 2.0);
                sj[i] = 0.0;
                j = this.n_gelman;
                while (j < this.twon) {
                    values[j - this.n_gelman] = ((StateBit)this.trajectories1.get(i).get(j)).getDoubleValue(0, endIndex);
                    ++j;
                }
                sj[i] = StatUtils.variance(values);
                ++i;
            }
            within = StatUtils.mean(sj);
            grandmean = StatUtils.mean(mean);
            double between = (double)this.n_gelman * StatUtils.variance(mean);
            double varianceW = StatUtils.variance(sj);
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = covariance.covariance(sj, meansquare);
            double covwx = covariance.covariance(sj, mean);
            double covwb = (double)(this.n_gelman / this.m) * (covwxsquare - 2.0 * grandmean * covwx);
            double variance = (1.0 - 1.0 / (double)this.n_gelman) * within + (double)(this.m + 1) / (double)(this.m * this.n_gelman) * between;
            double varianceV = (Math.pow(this.n_gelman - 1, 2.0) * (varianceW /= (double)this.m) + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n_gelman - 1)) * covwb) / Math.pow(this.n_gelman, 2.0);
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            if (Math.abs(1.0 - psrf) > this.threshold || varianceV == 0.0) {
                done = false;
                done1 = false;
                extension = this.n_gelman;
                this.n_gelman += extension;
                this.twon = this.n_gelman * 2;
                continue;
            }
            if (done1) {
                done = true;
                continue;
            }
            done1 = true;
            extension = this.n_gelman;
            this.n_gelman += extension;
            this.twon = this.n_gelman * 2;
        }
        int i2 = 0;
        while (i2 < this.m) {
            List st = this.trajectories1.get(i2);
            int j = this.n_gelman;
            while (j < this.twon) {
                boolean eva = this.evaluateState((StateBit)st.get(j));
                this.trajectories2.get(i2).set(this.traIndex[i2], eva);
                int n = i2;
                this.traIndex[n] = this.traIndex[n] + 1;
                ++j;
            }
            ++i2;
        }
        this.pw.println("Finish running convergency. Burn-in steps for each chain=" + this.n_gelman);
        this.convergeRun = true;
    }

    public void setPrecision(double precision) {
        this.precision = precision;
        this.precisionSet = true;
    }

    public void setPrecision(double precision, boolean isRelative) {
        this.precision = precision;
        this.isRelative = isRelative;
        this.precisionSet = true;
    }

    @Override
    public void setDisableGlobalAlias(boolean dis) {
        this.disableGlobalAlias = dis;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public double[] run() throws Exception {
        double yjm_element;
        int a;
        int m_batchSize;
        if (this.positiveIndex == null && this.negativeIndex == null) {
            throw new Exception("Meta states not defined!");
        }
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        long time = System.currentTimeMillis();
        if (this.pw == null) {
            this.pw = new PrintWriter(new FileWriter(this.outputName, true));
        }
        this.assalog.println("Detailed informaton is stored in the file " + this.outputName + ".");
        if (!this.convergeRun) {
            this.runConverge();
        }
        int ext_step2 = 0;
        int ext_step5 = 0;
        int d_max = 10;
        this.pw.print("Start Skart: confidence=" + (1.0 - this.alpha));
        if (this.precisionSet) {
            if (this.isRelative) {
                this.pw.println(", relative precision = " + this.precision);
            } else {
                this.pw.println(", absolute precision = " + this.precision);
            }
        } else {
            this.pw.println(", no precision requirement.");
        }
        double alpha_ran = 0.2;
        int b = 0;
        this.n = 1280;
        this.n = (int)Math.ceil((double)this.n / (double)this.m) * this.m;
        if (this.disableGlobalAlias) {
            this.engine.setDisableGlobalAlias(this.disableGlobalAlias);
        }
        if (this.n > this.m * this.traIndex[0]) {
            this.simulate(this.n - this.m * this.traIndex[0]);
        }
        int fetchEachChain = (int)Math.ceil((double)this.n / (double)this.m);
        int l = this.n;
        ArrayList<Double> yjm = new ArrayList<Double>();
        int i = 0;
        while (i < this.m) {
            BitSet bs = this.trajectories2.get(i);
            int j = 0;
            while (j < fetchEachChain) {
                if (bs.get(j)) {
                    yjm.add(1.0);
                } else {
                    yjm.add(0.0);
                }
                ++j;
            }
            ++i;
        }
        double average = this.mean(yjm, 0, yjm.size());
        double sVariance = this.variance(yjm, 0, yjm.size(), average);
        double skewness = this.skewness(yjm, 0, yjm.size(), sVariance, average);
        if (Math.abs(skewness) <= 4.0) {
            m_batchSize = 1;
        } else {
            m_batchSize = 16;
            int requiredLength = (int)Math.ceil((double)this.n / (double)this.m) * m_batchSize;
            if (Math.ceil((double)this.n / (double)this.m) * (double)m_batchSize > (double)this.traIndex[0]) {
                this.simulate(this.m * (requiredLength - this.traIndex[0]));
            }
        }
        int k = (int)Math.ceil((double)this.n / (double)this.m) * this.m;
        this.n = k * m_batchSize;
        yjm = new ArrayList();
        i = 0;
        while (i < this.m) {
            this.trajectory = this.trajectories2.get(i);
            a = 0;
            while (a < k / this.m) {
                yjm_element = 0.0;
                int j = 0;
                while (j < m_batchSize) {
                    if (this.trajectory.get(m_batchSize * a + j)) {
                        yjm_element += 1.0;
                    }
                    ++j;
                }
                yjm.add(yjm_element /= (double)m_batchSize);
                ++a;
            }
            ++i;
        }
        skewness = this.skewness(yjm, (int)(0.2 * (double)k), k);
        if (Math.abs(skewness) > 0.5) {
            d_max = 3;
        }
        if (this.debug) {
            this.assalog.println("Finish step 1, d_max=" + d_max);
        }
        this.pw.println("Finish step 1, d_max=" + d_max);
        int d = 0;
        boolean pass = false;
        double invPhi = StatUtil.getInvCDF(1.0 - alpha_ran / 2.0, false);
        int k_prime = k;
        while (!pass) {
            double Ck;
            int j;
            ++ext_step2;
            if (b != 0 || d != 0) {
                yjm = new ArrayList();
                System.gc();
                a = 0;
                while (a < this.m) {
                    this.trajectory = this.trajectories2.get(a);
                    int i2 = 0;
                    while (i2 < k_prime / this.m) {
                        yjm_element = 0.0;
                        j = 0;
                        while (j < m_batchSize) {
                            if (this.trajectory.get(m_batchSize * ((i2 + 1) * (d + 1) - 1) + j)) {
                                yjm_element += 1.0;
                            }
                            ++j;
                        }
                        yjm.add(yjm_element /= (double)m_batchSize);
                        ++i2;
                    }
                    ++a;
                }
            }
            if (Math.abs(Ck = this.Ck(yjm, 0, yjm.size())) <= invPhi * Math.sqrt(((double)k_prime - 2.0) / ((double)k_prime * (double)k_prime - 1.0))) {
                pass = true;
                continue;
            }
            k_prime = (int)Math.floor(this.n / (this.m * (++d + 1) * m_batchSize)) * this.m;
            if (d <= d_max) continue;
            m_batchSize = (int)Math.ceil((double)m_batchSize * Math.sqrt(2.0));
            k = (int)Math.ceil(0.9 * (double)k);
            k = (int)Math.ceil((double)k / (double)this.m) * this.m;
            int previousN = this.n;
            this.n = k * m_batchSize;
            this.simulate(this.n - previousN);
            d = 0;
            ++b;
            d_max = 10;
            if (this.debug) {
                this.assalog.println("k=" + k + ",b=" + b);
            }
            this.pw.println("k=" + k + ",b=" + b);
            yjm = new ArrayList();
            int i3 = 0;
            while (i3 < this.m) {
                this.trajectory = this.trajectories2.get(i3);
                int a2 = 0;
                while (a2 < k / this.m) {
                    yjm_element = 0.0;
                    j = 0;
                    while (j < m_batchSize) {
                        if (this.trajectory.get(m_batchSize * a2 + j)) {
                            yjm_element += 1.0;
                        }
                        ++j;
                    }
                    yjm.add(yjm_element /= (double)m_batchSize);
                    ++a2;
                }
                ++i3;
            }
            skewness = this.skewness(yjm, (int)(0.2 * (double)k), k);
            if (Math.abs(skewness) > 0.5) {
                d_max = 3;
            }
            k_prime = k;
        }
        int w = d * m_batchSize;
        k_prime = (int)Math.ceil((double)k_prime * Math.pow(1.1111111111111112, b));
        if (Math.floor(this.n / (k_prime = (int)Math.ceil((double)k_prime / (double)this.m) * this.m)) > (double)m_batchSize) {
            m_batchSize = (int)Math.floor(this.n / k_prime);
        }
        if (this.debug) {
            this.assalog.println("Finish step 2, k_prime=" + k_prime + ",m_batchSize=" + m_batchSize);
        }
        this.pw.println("Finish step 2, k_prime=" + k_prime + ",m_batchSize=" + m_batchSize + ", extensions= " + ext_step2);
        double[] estimator = this.thirdStep(m_batchSize, k_prime);
        if (this.debug) {
            this.assalog.println("Finish step 3, varEstimator=" + estimator[0] + ", mean=" + estimator[1]);
        }
        this.pw.println("Finish step 3, varEstimator=" + estimator[0] + ", mean=" + estimator[1]);
        double[] CI = this.fourthStep(w, d, m_batchSize, k_prime, estimator);
        if (this.debug) {
            this.assalog.println("Finish step 4, CI=[" + CI[0] + "," + CI[1] + "], mean=" + CI[2]);
        }
        this.pw.println("Finish step 4, CI=[" + CI[0] + "," + CI[1] + "], mean=" + CI[2]);
        if (this.precisionSet) {
            this.pw.println("Starting step5...");
            average = CI[2];
            double halfLength = Math.abs(CI[0] - average);
            if (halfLength < Math.abs(CI[1] - average)) {
                halfLength = Math.abs(CI[1] - average);
            }
            double absolutePrecision = this.isRelative ? average * this.precision : this.precision;
            while (halfLength > absolutePrecision) {
                this.pw.println("Round " + ++ext_step5 + ", precision and trajectory size before this round are " + halfLength + " and " + this.n + " respectively.");
                int k_star = (int)Math.ceil(Math.pow(halfLength / absolutePrecision, 2.0) * (double)k_prime);
                if (k_star > 1024) {
                    k_prime = 1024;
                    m_batchSize = (int)Math.ceil((double)m_batchSize * this.mid(1.02, k_star / k_prime, 2.0));
                } else {
                    k_prime = k_star;
                }
                k_prime = (int)Math.ceil((double)k_prime / (double)this.m) * this.m;
                estimator = this.thirdStep(m_batchSize, k_prime);
                CI = this.fourthStep(w, d, m_batchSize, k_prime, estimator);
                average = CI[2];
                halfLength = Math.abs(CI[0] - average);
                if (!(halfLength < Math.abs(CI[1] - average))) continue;
                halfLength = Math.abs(CI[1] - average);
            }
            this.pw.println("Finish step 5, extensionNum=" + ext_step5 + ", precision=" + halfLength + ", trajectory length=" + this.n);
        }
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        double timecost = (double)(System.currentTimeMillis() - time) / 1000.0;
        if (this.debug) {
            this.assalog.println("The CI is [" + CI[0] + "," + CI[1] + "], mean=" + CI[2]);
        }
        this.pw.println("Skart algorithm is finished. Time cost is " + timecost + ".\nThe CI is [" + CI[0] + "," + CI[1] + "], mean=" + CI[2] + ".\n");
        this.pw.close();
        return new double[]{CI[0], CI[1], CI[2], this.m * (this.traIndex[0] + this.n_gelman), cpucost, timecost, ext_step2, ext_step5};
    }

    public void simulate(int N) throws Exception {
        int extentionPerChain = (int)Math.ceil((double)N / (double)this.m) + 1;
        this.parallelSimulate.reinitialize();
        this.parallelSimulate.setMaxIndex(this.trajectories1.size() - 1);
        this.parallelSimulate.setMinIndex(0);
        this.parallelSimulate.setSteps(extentionPerChain);
        this.pool.invoke(this.parallelSimulate);
    }

    @Override
    public void updateTransition(StateBit current, int para) {
        if (this.convergeRun) {
            boolean eva = this.evaluateState(current);
            this.trajectories2.get(para).set(this.traIndex[para], eva);
            int n = para;
            this.traIndex[n] = this.traIndex[n] + 1;
        } else {
            this.trajectories1.get(para).add(current);
        }
    }

    public boolean evaluateState(StateBit st) {
        int i;
        if (this.positiveIndex != null) {
            i = 0;
            while (i < this.positiveIndex.size()) {
                if (!st.get(this.positiveIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (this.negativeIndex != null) {
            i = 0;
            while (i < this.negativeIndex.size()) {
                if (st.get(this.negativeIndex.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    public double variance(List<Double> yjm, int start, int end) throws Exception {
        double mean = this.mean(yjm, start, end);
        return this.variance(yjm, start, end, mean);
    }

    public double variance(List<Double> yjm, int start, int end, double mean) throws Exception {
        if (start > end || start < 0) {
            throw new Exception("start index should be smaller than end index");
        }
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += (yjm.get(i) - mean) * (yjm.get(i) - mean);
            ++i;
        }
        return total / (double)(end - start - 1);
    }

    public double skewness(List<Double> yjm, int start, int end) throws Exception {
        double mean = this.mean(yjm, start, end);
        double variance = this.variance(yjm, start, end, mean);
        return this.skewness(yjm, start, end, variance, mean);
    }

    public double skewness(List<Double> yjm, int start, int end, double variance, double mean) throws Exception {
        double total = 0.0;
        double l = end - start;
        int i = start;
        while (i < end) {
            total += (yjm.get(i) - mean) * (yjm.get(i) - mean) * (yjm.get(i) - mean);
            ++i;
        }
        return total * l / ((l - 1.0) * (l - 2.0) * Math.pow(variance, 1.5));
    }

    public double Ck(List<Double> yjm, int start, int end) {
        double mean = this.mean(yjm, start, end);
        double total1 = 0.0;
        double total2 = 0.0;
        int i = start;
        while (i < end - 1) {
            total1 += Math.pow(yjm.get(i + 1) - yjm.get(i), 2.0);
            total2 += Math.pow(yjm.get(i) - mean, 2.0);
            ++i;
        }
        double result = 1.0 - total1 / (2.0 * (total2 += Math.pow(yjm.get(end - 1) - mean, 2.0)));
        return result;
    }

    public double phiym(List<Double> yjm, int start, int end) throws Exception {
        int k_prime = yjm.size();
        double total = 0.0;
        double mean = this.mean(yjm, start, end);
        double variance = this.variance(yjm, start, end);
        int i = 0;
        while (i < k_prime - 1) {
            total += (yjm.get(i) - mean) * (yjm.get(i + 1) - mean);
            ++i;
        }
        return total / ((double)(k_prime - 1) * variance);
    }

    public double Gr(double r, double skewnessSample, double sVariance, int k_doubleprime) {
        double beta = skewnessSample / (6.0 * Math.sqrt(k_doubleprime));
        double tmp = 1.0 + 6.0 * beta * (r - beta);
        double result = Math.cbrt(tmp);
        result = (result - 1.0) / (2.0 * beta);
        return result;
    }

    public double mid(double a, double x, double b) {
        if (x < a) {
            return a;
        }
        if (x > b) {
            return b;
        }
        return x;
    }

    private double[] thirdStep(int m_batchSize, int k_prime) throws Exception {
        if (m_batchSize * k_prime > this.n) {
            int previousN = this.n;
            this.n = m_batchSize * k_prime;
            this.simulate(this.n - previousN);
        }
        ArrayList<Double> yjm = new ArrayList<Double>();
        System.gc();
        int a = 0;
        while (a < this.m) {
            this.trajectory = this.trajectories2.get(a);
            int i = 0;
            while (i < k_prime / this.m) {
                double yjm_element = 0.0;
                int j = 0;
                while (j < m_batchSize) {
                    if (this.trajectory.get(m_batchSize * i + j)) {
                        yjm_element += 1.0;
                    }
                    ++j;
                }
                yjm.add(yjm_element /= (double)m_batchSize);
                ++i;
            }
            ++a;
        }
        double mean = this.mean(yjm, 0, yjm.size());
        double phiym = this.phiym(yjm, 0, yjm.size());
        double A = (1.0 + phiym) / (1.0 - phiym);
        double varEstimator = A * this.variance(yjm, 0, yjm.size()) / (double)k_prime;
        return new double[]{varEstimator, mean};
    }

    private double[] fourthStep(int w, int d, int m_batchSize, int k_prime, double[] estimator) throws Exception {
        double skewness;
        int d_prime = (int)Math.ceil((double)w / (double)m_batchSize);
        int k_doubleprime = (1 + (int)Math.floor((k_prime / this.m - 1) / (d_prime + 1))) * this.m;
        ArrayList<Double> yjm = new ArrayList<Double>();
        System.gc();
        int a = 0;
        while (a < this.m) {
            this.trajectory = this.trajectories2.get(a);
            int i = 0;
            while (i < k_doubleprime / this.m) {
                double yjm_element = 0.0;
                int j = 0;
                while (j < m_batchSize) {
                    if (this.trajectory.get(w + m_batchSize * (i * (d_prime + 1)) + j)) {
                        yjm_element += 1.0;
                    }
                    ++j;
                }
                yjm.add(yjm_element /= (double)m_batchSize);
                ++i;
            }
            ++a;
        }
        double sVariance = Math.sqrt(this.variance(yjm, 0, yjm.size()));
        double skewnessSample = skewness = this.skewness(yjm, 0, yjm.size());
        StudentsT studentT = new StudentsT((double)(k_doubleprime - 1));
        if (this.alpha < 1.0E-12) {
            this.assalog.println("Alpha value is not set, using defalut value 0.05");
            this.alpha = 0.05;
        }
        if (this.debug) {
            this.assalog.println("m_batchSize=" + m_batchSize + ",k=" + k_doubleprime + ",n=" + this.n + ",d=" + d);
        }
        double left = studentT.inverseCdf(1.0 - this.alpha / 2.0);
        double right = studentT.inverseCdf(this.alpha / 2.0);
        double CI_bottom = estimator[1] - this.Gr(left, skewnessSample, sVariance, k_doubleprime) * Math.sqrt(estimator[0]);
        double CI_top = estimator[1] - this.Gr(right, skewnessSample, sVariance, k_doubleprime) * Math.sqrt(estimator[0]);
        return new double[]{CI_bottom, CI_top, estimator[1]};
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        this.pbn = (BitSetPBN)pbn;
        return this.run();
    }

    @Override
    public void setInstanceName() {
        this.instanceName = "parallel version Skart";
    }

    @Override
    public void setParameters(double[] parameters) {
        this.precision = parameters[0];
        this.alpha = 1.0 - parameters[1];
        if (parameters.length > 2) {
            this.setM((int)parameters[2]);
        }
    }

    @Override
    public void setExpressions(List<Property> properties) {
        this.positiveIndex = properties.get(0).getPositiveIndex();
        this.negativeIndex = properties.get(0).getNegativeIndex();
    }
}

