/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetEngine;
import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.StateBit;
import functionLib.HammingDistance;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import simulator.AliasMethod;
import userInterface.AssaLog;

public class StepPerfectSimulationWalkerBitSet {
    private AssaLog assalog;
    private List<StateBit> stateList;
    private BitSetPBN pbn;
    PrintWriter pw;
    private int sampleSize;
    private long stateA;
    private long stateB;
    private BitSet expa;
    private BitSet expb;
    private int dimension;
    private List<Integer> non_zero_num_row;
    private List<AliasMethod> aliasMethodList;
    private StateBit[] state;
    private StateBit[] stateCopy;
    private StateBit bridge;
    private boolean aliasGenerated;
    private boolean initialized;
    protected List<StateBit> metaA;
    protected List<StateBit> metaB;
    private Random rng;
    private BitSetEngine engine;
    private int[][] transitionsLast;
    private int index1;
    private int index2;
    int countStep = 0;
    double alpha;
    double beta;
    protected double approximation;
    protected double confidence;
    private boolean cost;
    private AliasMethod perturbationList;
    private boolean useAlias = false;
    private boolean aliasSet = false;

    public static final StepPerfectSimulationWalkerBitSet getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private StepPerfectSimulationWalkerBitSet() {
        this.stateA = 0L;
        this.stateB = 0L;
        this.metaA = new ArrayList<StateBit>();
        this.metaB = new ArrayList<StateBit>();
        this.non_zero_num_row = new ArrayList<Integer>();
        this.aliasMethodList = new ArrayList<AliasMethod>();
        this.aliasGenerated = false;
        this.initialized = false;
        this.rng = RandomProvider.getInstance().getRandom();
    }

    private StepPerfectSimulationWalkerBitSet(BitSetPBN pbn, String outputSimulation) throws FileNotFoundException {
        this.pbn = pbn;
        this.stateA = 0L;
        this.stateB = 0L;
        this.metaA = new ArrayList<StateBit>();
        this.metaB = new ArrayList<StateBit>();
        this.pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputSimulation)), true);
        this.non_zero_num_row = new ArrayList<Integer>();
        this.aliasMethodList = new ArrayList<AliasMethod>();
        this.aliasGenerated = false;
        this.initialized = false;
        this.rng = RandomProvider.getInstance().getRandom();
    }

    public void setAssaLog(AssaLog assalog) {
        this.assalog = assalog;
    }

    public void setIO(BitSetPBN pbn, String outputSimulation) throws FileNotFoundException {
        this.pbn = pbn;
        this.engine = new BitSetEngine(pbn);
        this.pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(outputSimulation)), true);
        double p = pbn.getPerturbation();
        int n = pbn.getN();
        int[] y = new int[(int)Math.pow(2.0, n)];
        double[] prob = new double[y.length];
        int i = 0;
        while (i < y.length) {
            y[i] = i;
            int hamm = HammingDistance.getDistance(0, i);
            prob[i] = Math.pow(p, hamm) * Math.pow(1.0 - p, n - hamm);
            ++i;
        }
        this.perturbationList = new AliasMethod(prob, y);
        this.expa = new BitSet(n);
        this.expb = new BitSet(n);
        this.bridge = new StateBit(n);
        this.transitionsLast = new int[2][2];
    }

    public void setCost(boolean cost) {
        this.cost = cost;
    }

    public void setUseAlias(boolean useAlias) {
        this.useAlias = useAlias;
        this.aliasSet = true;
    }

    public void reInitialise() {
        this.initialized = false;
        this.aliasGenerated = false;
        this.metaA.clear();
        this.metaB.clear();
        this.state = null;
        this.stateCopy = null;
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                this.transitionsLast[i][j] = 0;
                ++j;
            }
            ++i;
        }
        System.gc();
    }

    public void initialise() throws Exception {
        if (this.initialized) {
            return;
        }
        this.pw.println("Start initialising states...");
        long time = System.currentTimeMillis();
        int n = this.pbn.getN();
        if (n > 31) {
            throw new Exception("States number exceed the max value: 2147483647");
        }
        this.stateList = new ArrayList<StateBit>();
        this.dimension = (int)Math.pow(2.0, n);
        int i = 0;
        while (i < this.dimension) {
            StateBit stateListElement = new StateBit(n);
            stateListElement.putLongFromTo(i, 0, n - 1);
            this.stateList.add(stateListElement);
            ++i;
        }
        this.pw.println("Total states generated: " + this.stateList.size() + ". Time cost: " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
        this.initialized = true;
    }

    private void generateAlias() throws Exception {
        if (this.aliasGenerated) {
            return;
        }
        this.pw.println("\nStart generating alias table...");
        long time = System.currentTimeMillis();
        this.non_zero_num_row.add(0);
        int nonZeroRow = 0;
        BitSetPBNIO io = new BitSetPBNIO(this.pbn, this.assalog);
        int numElements = 0;
        int i = 0;
        while (i < this.stateList.size()) {
            List<Double> re = io.getTransitionProbabilityNoPerturbe(this.stateList.get(i));
            int[] y = new int[re.size() / 2];
            double[] prob = new double[y.length];
            int j = 0;
            while (j < y.length) {
                y[j] = re.get(j * 2).intValue();
                prob[j] = re.get(j * 2 + 1);
                ++j;
            }
            re = null;
            System.gc();
            numElements += y.length;
            AliasMethod aliasmethod = new AliasMethod(prob, y);
            this.aliasMethodList.add(aliasmethod);
            ++i;
        }
        this.non_zero_num_row.add(nonZeroRow);
        this.aliasGenerated = true;
        this.pw.println("Finish generating alias table, time cost: " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
    }

    public void setSampleSize(double delta, double epsilon) {
        this.confidence = delta;
        this.approximation = epsilon;
        delta = 1.0 - delta;
        this.sampleSize = (int)(Math.log(2.0 / delta) / (2.0 * epsilon * epsilon));
    }

    public void updateTransitionWalker(boolean re) {
        if (re) {
            ++this.stateA;
        } else {
            ++this.stateB;
        }
        ++this.countStep;
    }

    public void setProperty(String property) throws IOException {
        int index;
        String line = "";
        InputStreamReader reader = new InputStreamReader(new FileInputStream(property));
        BufferedReader br = new BufferedReader(reader);
        line = br.readLine();
        StringTokenizer token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            index = Integer.parseInt(token.nextToken());
            if (index < 0) continue;
            this.expa.set(index);
            this.expb.set(index);
        }
        line = br.readLine();
        token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            index = Integer.parseInt(token.nextToken());
            if (index < 0) continue;
            this.expa.set(index);
        }
        br.close();
        reader.close();
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public double[] runWalker(String fileProperty) throws Exception {
        return this.runWalker(fileProperty, this.sampleSize, false);
    }

    public double[] runWalker(String fileProperty, boolean reInitialise) throws Exception {
        return this.runWalker(fileProperty, this.sampleSize, reInitialise);
    }

    public double[] runWalker(String fileProperty, int sampleSize) throws Exception {
        return this.runWalker(fileProperty, sampleSize, false);
    }

    public double[] runWalker(String fileProperty, int sampleSize, boolean reInitialise) throws Exception {
        String[] split;
        String re;
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        if (this.pbn.getN() < 15 && !this.aliasSet) {
            this.setUseAlias(true);
        }
        int coupling = 0;
        if (reInitialise) {
            this.reInitialise();
        }
        this.setProperty(fileProperty);
        this.pw.println();
        this.pw.print("Properties to check: S=?[ ");
        int index = 0;
        while (index < this.pbn.getN() && (index = this.expa.nextSetBit(index)) != -1) {
            this.pw.print("Node " + index + "=" + this.expb.get(index) + " ");
            ++index;
        }
        this.pw.println("]");
        this.pw.println("Approximation is " + this.approximation + ", confidence is " + this.confidence);
        long time = System.currentTimeMillis();
        this.initialise();
        if (this.useAlias) {
            this.generateAlias();
        }
        int simulateLength = 0;
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + this.confidence), false);
        this.stateA = 0L;
        this.stateB = 0L;
        int i = 0;
        while (i < sampleSize) {
            re = this.generateCouplingPath();
            split = re.split(" ");
            coupling += Integer.parseInt(split[0]);
            ++i;
        }
        int maxLength = sampleSize;
        int N = (int)Math.ceil((double)(this.stateA * this.stateB) / Math.pow((double)(this.stateA + this.stateB) * this.approximation / invPhi, 2.0));
        this.pw.println("N=" + N);
        int reest = 0;
        while (maxLength < N) {
            simulateLength = N - maxLength;
            int i2 = 0;
            while (i2 < simulateLength) {
                re = this.generateCouplingPath();
                split = re.split(" ");
                coupling += Integer.parseInt(split[0]);
                ++i2;
            }
            maxLength = N;
            N = (int)Math.ceil((double)(this.stateA * this.stateB) / Math.pow((double)(this.stateA + this.stateB) * this.approximation / invPhi, 2.0));
            this.pw.println("Re-estimating round " + ++reest + ": N" + N + ".");
            this.pw.println("N=" + N);
        }
        this.pw.println("Average coupling steps: " + (double)coupling / (double)this.countStep);
        time = System.currentTimeMillis() - time;
        this.pw.println("generating " + this.countStep + " samples cost " + (double)time / 1000.0 + "s");
        double distribution = this.calculateDistribution();
        this.pw.println("Distribution is: " + distribution);
        double[] result = new double[]{distribution, (double)coupling / (double)this.countStep, (double)coupling * (double)this.dimension, this.countStep, (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9, (double)time / 1000.0};
        return result;
    }

    private String generateCouplingPath() throws Exception {
        this.initiliseWalkerStates();
        int n = this.pbn.getN();
        int loop = 0;
        StateBit bridge = new StateBit(n);
        while (!this.testDone()) {
            ++loop;
            int i = 0;
            while (i < this.dimension) {
                double random1 = this.rng.nextDouble();
                double random2 = this.rng.nextDouble();
                int resultIndex = this.perturbationList.next(random1, random2);
                this.state[i].xor(this.state[i]);
                if (resultIndex == 0) {
                    if (this.useAlias) {
                        random1 = this.rng.nextDouble();
                        random2 = this.rng.nextDouble();
                        this.state[i].xor(this.stateCopy[this.aliasMethodList.get(i).next(random1, random2)]);
                    } else {
                        bridge.xor(bridge);
                        bridge.xor(this.stateList.get(i));
                        this.engine.pbnNextState(bridge, false);
                        this.state[i].xor(this.stateCopy[(int)bridge.getLongFromTo(0, n - 1)]);
                    }
                } else {
                    this.state[i].xor(this.stateCopy[resultIndex ^= i]);
                }
                ++i;
            }
            i = 0;
            while (i < this.stateCopy.length) {
                this.stateCopy[i].xor(this.stateCopy[i]);
                this.stateCopy[i].xor(this.state[i]);
                ++i;
            }
        }
        return String.valueOf(loop) + " " + this.state[0].getLongFromTo(0, this.pbn.getN() - 1);
    }

    private boolean testDone() {
        if (this.cost) {
            return this.testCostDone();
        }
        int i = 1;
        while (i < this.state.length) {
            this.state[0].xor(this.state[i]);
            if (this.state[0].cardinality() != 0) {
                this.state[0].xor(this.state[i]);
                return false;
            }
            this.state[0].xor(this.state[i]);
            ++i;
        }
        boolean inA = false;
        this.bridge.clear();
        this.bridge.xor(this.state[0]);
        this.bridge.and(this.expa);
        this.bridge.xor(this.expb);
        if (this.bridge.cardinality() == 0) {
            inA = true;
        }
        this.updateTransitionWalker(inA);
        return true;
    }

    private boolean testCostDone() {
        boolean inA = false;
        this.bridge.clear();
        this.bridge.xor(this.state[0]);
        this.bridge.and(this.expa);
        this.bridge.xor(this.expb);
        if (this.bridge.cardinality() == 0) {
            inA = true;
        }
        int i = 1;
        while (i < this.state.length) {
            this.bridge.clear();
            this.bridge.xor(this.state[i]);
            this.bridge.and(this.expa);
            this.bridge.xor(this.expb);
            if (this.bridge.cardinality() != 0 ? inA : !inA) {
                return false;
            }
            ++i;
        }
        this.updateTransitionWalker(inA);
        return true;
    }

    private void initiliseWalkerStates() throws IOException {
        int i;
        if (this.state == null) {
            this.state = new StateBit[this.dimension];
            this.stateCopy = new StateBit[this.dimension];
            i = 0;
            while (i < this.dimension) {
                this.state[i] = new StateBit(this.pbn.getN());
                this.stateCopy[i] = new StateBit(this.pbn.getN());
                ++i;
            }
        }
        i = 0;
        while (i < this.dimension) {
            this.state[i].xor(this.state[i]);
            this.state[i].xor(this.stateList.get(i));
            this.stateCopy[i].xor(this.stateCopy[i]);
            this.stateCopy[i].xor(this.state[i]);
            ++i;
        }
    }

    public double calculateDistribution() {
        return (double)this.stateA / (double)(this.stateA + this.stateB);
    }

    public double[] doSteadyState(int steadySize) throws Exception {
        this.initialise();
        this.generateAlias();
        int[] stateNum = new int[this.stateList.size()];
        int i = 0;
        while (i < steadySize) {
            String re = this.generateCouplingPath();
            String[] tmp = re.split(" ");
            int n = Integer.parseInt(tmp[1]);
            stateNum[n] = stateNum[n] + 1;
            ++i;
        }
        return this.calculateSteady(stateNum, steadySize);
    }

    private double[] calculateSteady(int[] stateNum, int steadySize) {
        double[] distribution = new double[stateNum.length];
        int i = 0;
        while (i < stateNum.length) {
            distribution[i] = (double)stateNum[i] / (double)steadySize;
            ++i;
        }
        return distribution;
    }

    public double[] doSteadyState(long steadySize) throws Exception {
        this.initialise();
        this.generateAlias();
        long[] stateNum = new long[this.stateList.size()];
        long i = 0L;
        while (i < steadySize) {
            String re = this.generateCouplingPath();
            String[] tmp = re.split(" ");
            int n = Integer.parseInt(tmp[1]);
            stateNum[n] = stateNum[n] + 1L;
            ++i;
        }
        return this.calculateSteady(stateNum, steadySize);
    }

    private double[] calculateSteady(long[] stateNum, long steadySize) {
        double[] distribution = new double[stateNum.length];
        int i = 0;
        while (i < stateNum.length) {
            distribution[i] = (double)stateNum[i] / (double)steadySize;
            ++i;
        }
        return distribution;
    }

    public void calAlphaBeta() {
        this.beta = this.transitionsLast[0][0] + this.transitionsLast[0][1] == 0 ? 0.0 : (double)this.transitionsLast[0][1] / (double)(this.transitionsLast[0][0] + this.transitionsLast[0][1]);
        this.alpha = this.transitionsLast[1][0] + this.transitionsLast[1][1] == 0 ? 0.0 : (double)this.transitionsLast[1][0] / (double)(this.transitionsLast[1][0] + this.transitionsLast[1][1]);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    /* synthetic */ StepPerfectSimulationWalkerBitSet(StepPerfectSimulationWalkerBitSet stepPerfectSimulationWalkerBitSet) {
        this();
    }

    private class Property {
        int nodeIndex;
        boolean nodeValue;

        public Property(int nodeIndex, boolean nodeValue) {
            this.nodeIndex = nodeIndex;
            this.nodeValue = nodeValue;
        }
    }

    private static class SingletonHolder {
        private static final StepPerfectSimulationWalkerBitSet INSTANCE = new StepPerfectSimulationWalkerBitSet(null);

        private SingletonHolder() {
        }
    }
}

