/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.OptimizePBN;
import PBN.PBN;
import PBN.ParseProperty;
import PBN.Property;
import PBN.StateBit;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import jdd.JDDPBN;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.TwoStateBitSetPara;
import userInterface.AssaLog;

public class TwoStateMTBDDPara
extends TwoStateBitSetPara {
    private BitSet trajectory;
    private int traIndex;
    private int updateIndex;
    private short[] transitions = new short[this.maxRecord - 2];
    private boolean[] state = new boolean[this.maxRecord - 1];
    private int maxRecord = 1000;
    private long countSteps;
    private long transitionAlpha = 0L;
    private long transitionBeta = 0L;
    private long transitionMinusAlpha = 0L;
    private long transitionMinusBeta = 0L;
    private int[][] transitionsLast = new int[2][2];
    private int index1;
    private int index2;
    private long stateA = 0L;
    private long stateB = 0L;
    private long fixStateA;
    private long fixStateB;
    private String outputName;
    private Object previous;
    private List<Integer> positiveIndex;
    private List<Integer> negativeIndex;
    private StateBit positiveStateBit;
    private StateBit negativeStateBit;
    private boolean disableGlobalAlias;
    private int numLeaves;
    private OptimizePBN opt;
    StateBit newSt;
    private final int size = 10;
    private int indexS;
    private short[] localStateA;
    private int[][] fixTransitionsLast;

    public TwoStateMTBDDPara(AssaLog assalog) {
        super(assalog);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "twostate" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.enableOutput = true;
        this.setInstanceName();
    }

    public TwoStateMTBDDPara(AssaLog assalog, double approximation, double confidence, double epsilon) {
        super(assalog, approximation, confidence, epsilon);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "twostate" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.enableOutput = true;
        this.setInstanceName();
    }

    public TwoStateMTBDDPara(AssaLog assalog, double approximation, double confidence, double epsilon, int kstep) {
        super(assalog, approximation, confidence, epsilon, kstep);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "twostate" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.enableOutput = true;
        this.setInstanceName();
    }

    @Override
    public void setNumLeaves(int numLeaves) {
        this.numLeaves = numLeaves;
    }

    @Override
    public void setOptimizePBN(OptimizePBN opt) {
        this.opt = opt;
    }

    @Override
    public void initIndices() {
        this.positiveIndex = new ArrayList<Integer>();
        this.negativeIndex = new ArrayList<Integer>();
    }

    @Override
    public void addPositiveIndex(int index) {
        this.positiveIndex.add(index);
    }

    @Override
    public void addNegativeIndex(int index) {
        this.negativeIndex.add(index);
    }

    @Override
    public void setEnableOutput(boolean enableOutput) {
        this.enableOutput = enableOutput;
    }

    @Override
    public String getLogFile() {
        return this.outputName;
    }

    @Override
    public void setLogFile(String outputName) {
        this.outputName = outputName;
    }

    @Override
    public void initialise() {
        this.transitions = new short[this.maxRecord - 2];
        this.state = new boolean[this.maxRecord - 1];
        this.countSteps = 0L;
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                this.transitionsLast[i][j] = 0;
                ++j;
            }
            ++i;
        }
        this.traIndex = 0;
        this.stateA = 0L;
        this.stateB = 0L;
        this.previous = null;
    }

    @Override
    public void setDisableGlobalAlias(boolean dis) {
        this.disableGlobalAlias = dis;
    }

    @Override
    public void setExpressions(List<Property> properties) {
        this.positiveIndex = properties.get(0).getPositiveIndex();
        this.negativeIndex = properties.get(0).getNegativeIndex();
    }

    @Override
    public double[] run(PBN pbn, StateBit initialState, String property) throws Exception {
        this.setExpressions(ParseProperty.getProperties(pbn, property));
        return this.run(pbn, initialState);
    }

    @Override
    public double[] run(PBN pbn, StateBit initialState) throws Exception {
        this.indexS = 0;
        this.localStateA = new short[10];
        this.positiveStateBit = new StateBit(pbn.getN());
        this.negativeStateBit = new StateBit(pbn.getN());
        this.newSt = new StateBit(pbn.getN());
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        long time = System.currentTimeMillis();
        this.initialise();
        double confidence = this.confidence;
        double approximation = this.approximation;
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + confidence), false);
        int burnIn = this.initialBurnIn;
        int reest = 0;
        int maxLength = 0;
        PrintWriter pw = null;
        if (this.enableOutput) {
            pw = new PrintWriter(new FileWriter(this.outputName, true));
        }
        int Nmin = (int)Math.ceil(invPhi * invPhi * this.qMinN * (1.0 - this.qMinN) / (approximation * approximation)) * this.kstep;
        BitSetPBNSimulationEngine simulationEngine = new BitSetPBNSimulationEngine(pbn, this, 1);
        JDDPBN.setNumLeaves(pbn.getPerturbation(), this.numLeaves);
        JDDPBN.initialiseAmP(pbn.getP_groupNum(), pbn.getP_firstSize(), pbn.getP_Mask()[pbn.getP_Mask().length - 1], pbn.getP_cij());
        simulationEngine.setPara(this.opt);
        if (this.disableGlobalAlias) {
            simulationEngine.setDisableGlobalAlias(this.disableGlobalAlias);
        }
        if (initialState == null) {
            initialState = new StateBit(pbn.getStateLength());
        } else if (initialState.getN() != pbn.getStateLength()) {
            initialState = new StateBit(pbn.getStateLength());
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        if (this.enableOutput) {
            pw.println("Program started at " + df.format(start));
        }
        this.traIndex = 0;
        this.trajectory = new BitSet(Nmin);
        this.updateIndex = 0;
        if (this.enableOutput) {
            pw.println("Total number of nodes is " + pbn.getN() + ".");
        }
        if (this.enableOutput) {
            pw.print("Checking states where ");
            if (this.positiveIndex.size() != 0) {
                pw.print("nodes with index ");
                for (int i : this.positiveIndex) {
                    pw.print(String.valueOf(i) + " ");
                    this.positiveStateBit.set(i);
                }
                pw.print("should have value 1 and ");
            }
            if (this.negativeIndex.size() != 0) {
                int i;
                pw.print("nodes with index ");
                i = 0;
                while (i < this.negativeIndex.size()) {
                    pw.print(this.negativeIndex.get(i) + " ");
                    this.negativeStateBit.set(this.negativeIndex.get(i));
                    ++i;
                }
                pw.println("should have value 0.");
            } else {
                pw.println("no requirements on other nodes.");
            }
            pw.println("Approximation is " + approximation + ", confidence is " + confidence + ", epsilon is " + this.epsilon + ", fetch sample every " + this.kstep + " steps.");
        }
        JDDPBN.initialiseProperty(this.positiveStateBit.toLongArray(), this.negativeStateBit.toLongArray());
        this.simulateInitial();
        this.calAlphaBeta(burnIn);
        double alpha = this.getAlpha();
        double beta = this.getBeta();
        if (this.enableOutput) {
            pw.println("Initial simulation steps are " + Nmin);
            pw.println("alpha=" + alpha + ",beta=" + beta);
        }
        double threshold = 3.0 / (double)(this.countSteps / (long)this.kstep - (long)burnIn);
        while (alpha < threshold || beta < threshold || alpha > 0.9999999 && beta > 0.9999999) {
            this.simulate(this.countSteps * 2L);
            this.calAlphaBeta(burnIn);
            alpha = this.getAlpha();
            beta = this.getBeta();
            if (this.enableOutput) {
                pw.println("alpha=" + alpha + ",beta=" + beta);
            }
            threshold = 3.0 / (double)(this.countSteps / (long)this.kstep - (long)burnIn);
        }
        maxLength = (int)this.countSteps - burnIn * this.kstep;
        int M = (int)Math.ceil(Math.log(this.epsilon * (alpha + beta) / Math.max(alpha, beta)) / Math.log(Math.abs(1.0 - alpha - beta)));
        int N = (int)Math.ceil(alpha * beta * (2.0 - alpha - beta) / (Math.pow(alpha + beta, 3.0) * Math.pow(approximation / invPhi, 2.0))) * this.kstep;
        if (this.enableOutput) {
            pw.println("M=" + M * this.kstep);
            pw.println("N=" + N);
        }
        while (maxLength < N) {
            int simulateLength = N - maxLength;
            this.simulate(simulateLength);
            maxLength = N;
            this.calAlphaBeta(M);
            alpha = this.getAlpha();
            beta = this.getBeta();
            threshold = 3.0 / (double)((int)this.countSteps / this.kstep - M);
            while (alpha < threshold || beta < threshold || alpha > 0.9999999 && beta > 0.9999999) {
                this.simulate(simulateLength);
                maxLength = N + simulateLength;
                this.calAlphaBeta(M);
                alpha = this.getAlpha();
                beta = this.getBeta();
                threshold = 3.0 / (double)((int)this.countSteps / this.kstep - M);
            }
            M = (int)Math.ceil(Math.log(this.epsilon * (alpha + beta) / Math.max(alpha, beta)) / Math.log(Math.abs(1.0 - alpha - beta)));
            N = (int)Math.ceil(alpha * beta * (2.0 - alpha - beta) / (Math.pow(alpha + beta, 3.0) * Math.pow(approximation / invPhi, 2.0))) * this.kstep;
            ++reest;
            if (!this.enableOutput) continue;
            pw.println("Re-estimating round " + reest + ": alpha=" + alpha + ", beta=" + beta + ", M=" + M + ", N" + N + ".");
            pw.println("M=" + Math.log(this.epsilon * (alpha + beta) / Math.max(alpha, beta)) / Math.log(Math.abs(1.0 - alpha - beta)) + ", N=" + alpha * beta * (2.0 - alpha - beta) / (Math.pow(alpha + beta, 3.0) * Math.pow(approximation / invPhi, 2.0)));
        }
        if (this.enableOutput) {
            pw.println("Total extending times: " + reest);
            this.assalog.println("Total extending times: " + reest + ".");
            pw.println("final M=" + M * this.kstep);
            pw.println("final N=" + N);
        }
        double distribution = this.calDistribution(M);
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        if (this.enableOutput) {
            pw.println("Total CPU time cost is " + cpucost);
            pw.println("alpha=" + alpha + ",beta=" + beta);
            pw.println("distribution=" + distribution + "\n");
            pw.close();
        }
        return new double[]{distribution, this.stateA + this.stateB, cpucost, (double)(System.currentTimeMillis() - time) / 1000.0, reest};
    }

    @Override
    public void addMetaA(StateBit st) {
        this.metaA.add(st);
    }

    @Override
    public List<Object> getMetaA() {
        return this.metaA;
    }

    @Override
    public void addMetaB(StateBit st) {
        this.metaB.add(st);
    }

    @Override
    public List<Object> getMetaB() {
        return this.metaB;
    }

    @Override
    public void calAlphaBeta(int M) {
        int index1 = 0;
        int index2 = 0;
        int[][] transitionsLast = new int[2][2];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                transitionsLast[i][j] = this.transitionsLast[i][j];
                ++j;
            }
            ++i;
        }
        index1 = this.trajectory.get(0) ? 1 : 0;
        i = 1;
        while (i < M) {
            int bridge = index1;
            if (this.trajectory.get(i)) {
                index1 = 1;
                index2 = 1;
            } else {
                index1 = 0;
                index2 = 0;
            }
            int[] nArray = transitionsLast[bridge];
            int n = index2;
            nArray[n] = nArray[n] - 1;
            ++i;
        }
        this.beta = transitionsLast[0][0] + transitionsLast[0][1] == 0 ? 0.0 : (double)transitionsLast[0][1] / (double)(transitionsLast[0][0] + transitionsLast[0][1]);
        this.alpha = transitionsLast[1][0] + transitionsLast[1][1] == 0 ? 0.0 : (double)transitionsLast[1][0] / (double)(transitionsLast[1][0] + transitionsLast[1][1]);
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public double getBeta() {
        return this.beta;
    }

    @Override
    public double calDistribution(int M) {
        long stateA = this.stateA;
        long stateB = this.stateB;
        int i = 0;
        while (i < M) {
            if (this.trajectory.get(i)) {
                --stateA;
            } else {
                --stateB;
            }
            ++i;
        }
        long total = stateA + stateB;
        if (total != 0L) {
            return (double)stateA / (double)total;
        }
        return 0.0;
    }

    private String getTimeCost(Date start, Date end, String work) {
        long l = end.getTime() - start.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return "Total time for " + work + " is " + day + " days " + hour + " hours " + min + " mins " + s + " seconds";
    }

    @Override
    public void calAlphaBeta() {
    }

    @Override
    public boolean evaluateState(StateBit st) {
        int i = 0;
        while (i < this.positiveIndex.size()) {
            if (!st.get(this.positiveIndex.get(i))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.negativeIndex.size()) {
            if (st.get(this.negativeIndex.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean evaluateState(StateBit st, int test) {
        this.newSt.clear();
        this.newSt.or(st);
        this.newSt.and(this.positiveStateBit);
        this.newSt.xor(this.positiveStateBit);
        if (this.newSt.cardinality() != 0) {
            return false;
        }
        this.newSt.clear();
        this.newSt.or(st);
        this.newSt.and(this.negativeStateBit);
        return this.newSt.cardinality() == 0;
    }

    @Override
    public void updateTransition(StateBit current, int para) {
        ++this.countSteps;
        if ((this.countSteps - 1L) % (long)this.kstep != 0L) {
            return;
        }
        boolean eva = para == 1 ? this.evaluateState(current, 0) : this.index1 == 1;
        int bridge = this.index1;
        if (eva) {
            ++this.stateA;
            this.index1 = 1;
            this.index2 = 1;
            if (this.traIndex != 0) {
                int[] nArray = this.transitionsLast[bridge];
                int n = this.index2;
                nArray[n] = nArray[n] + 1;
            }
        } else {
            ++this.stateB;
            this.index1 = 0;
            this.index2 = 0;
            if (this.traIndex != 0) {
                int[] nArray = this.transitionsLast[bridge];
                int n = this.index2;
                nArray[n] = nArray[n] + 1;
            }
        }
        if (this.traIndex < this.maxRecord) {
            this.trajectory.set(this.traIndex, eva);
            ++this.traIndex;
        }
    }

    @Override
    public void updateTransitionOld(StateBit current, int para) {
        ++this.countSteps;
        if ((this.countSteps - 1L) % (long)this.kstep != 0L) {
            return;
        }
        boolean eva = para == 1 ? this.evaluateState(current, 0) : this.index1 == 1;
        int bridge = this.index1;
        if (eva) {
            ++this.stateA;
            this.index1 = 1;
            this.index2 = 1;
            if (this.traIndex != 0) {
                int[] nArray = this.transitionsLast[bridge];
                int n = this.index2;
                nArray[n] = nArray[n] + 1;
            }
        } else {
            ++this.stateB;
            this.index1 = 0;
            this.index2 = 0;
            if (this.traIndex != 0) {
                int[] nArray = this.transitionsLast[bridge];
                int n = this.index2;
                nArray[n] = nArray[n] + 1;
            }
        }
        if (this.traIndex < this.maxRecord) {
            this.trajectory.set(this.traIndex, eva);
            ++this.traIndex;
        }
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        return this.run(pbn, null);
    }

    @Override
    public void setInstanceName() {
        this.instanceName = "Two-state Markov Chain approach";
    }

    private void simulateInitial() {
        long i = 0L;
        while (i < (long)this.maxRecord) {
            this.MTBDDupdate(JDDPBN.nextState());
            ++i;
        }
        this.fixTransitionsLast = new int[2][2];
        this.fixStateA = this.stateA;
        this.fixStateB = this.stateB;
        this.fixTransitionsLast[0][0] = this.transitionsLast[0][0];
        this.fixTransitionsLast[0][1] = this.transitionsLast[0][1];
        this.fixTransitionsLast[1][0] = this.transitionsLast[1][0];
        this.fixTransitionsLast[1][1] = this.transitionsLast[1][1];
    }

    private void simulate(long length) {
        long[] result = JDDPBN.nextState((int)length);
        this.transitionsLast[0][0] = (int)((long)this.fixTransitionsLast[0][0] + result[0]);
        this.transitionsLast[0][1] = (int)((long)this.fixTransitionsLast[0][1] + result[1]);
        this.transitionsLast[1][0] = (int)((long)this.fixTransitionsLast[1][0] + result[2]);
        this.transitionsLast[1][1] = (int)((long)this.fixTransitionsLast[1][1] + result[3]);
        this.stateA = this.fixStateA + result[4];
        this.stateB = this.fixStateB + result[5];
    }

    private void MTBDDupdate(boolean eva) {
        ++this.countSteps;
        if ((this.countSteps - 1L) % (long)this.kstep != 0L) {
            return;
        }
        int bridge = this.index1;
        if (eva) {
            ++this.stateA;
            this.index1 = 1;
            this.index2 = 1;
            if (this.traIndex != 0) {
                int[] nArray = this.transitionsLast[bridge];
                int n = this.index2;
                nArray[n] = nArray[n] + 1;
            }
        } else {
            ++this.stateB;
            this.index1 = 0;
            this.index2 = 0;
            if (this.traIndex != 0) {
                int[] nArray = this.transitionsLast[bridge];
                int n = this.index2;
                nArray[n] = nArray[n] + 1;
            }
        }
        if (this.traIndex < this.maxRecord) {
            this.trajectory.set(this.traIndex, eva);
            ++this.traIndex;
        }
    }
}

