/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.PBN;
import PBN.ParseProperty;
import PBN.Property;
import PBN.StateBit;
import functionLib.Parameters;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class TwoStateMultiProperty
extends SimulationMethod {
    private List<BitSet> trajectories;
    private int[] traIndex;
    private int maxRecord = 1000;
    private long countSteps;
    private long[][][] transitionsLast;
    private int[] index1;
    private int[] index2;
    private long[] stateA;
    private long[] stateB;
    private String outputName;
    private List<List> positiveIndex;
    private List<List> negativeIndex;
    private int numProperty = 1;
    private boolean disableGlobalAlias;
    public static final int minPriority = 0;
    public static final int maxPriority = 1;
    private int extensionPolicy = 0;
    private double[] alpha;
    private double[] beta;
    boolean[] propertyDone;
    private double precision = 0.01;
    private double confidence = 0.95;
    private double epsilon = Parameters.epsilon;
    private int kstep = 1;
    long Nmax;
    protected double qMinN = 0.002;
    protected int initialBurnIn = 10;

    public TwoStateMultiProperty(AssaLog assalog) {
        super(assalog);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "twostate" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.enableOutput = true;
        this.setInstanceName();
    }

    @Override
    public void setEnableOutput(boolean enableOutput) {
        this.enableOutput = enableOutput;
    }

    @Override
    public String getLogFile() {
        return this.outputName;
    }

    @Override
    public void setLogFile(String outputName) {
        this.outputName = outputName;
    }

    public void initialise() {
        this.countSteps = 0L;
        this.index1 = new int[this.numProperty];
        this.index2 = new int[this.numProperty];
        this.trajectories = new ArrayList<BitSet>();
        int i = 0;
        while (i < this.numProperty) {
            StateBit trajectory = new StateBit(this.maxRecord);
            this.trajectories.add(trajectory);
            ++i;
        }
        this.traIndex = new int[this.numProperty];
        this.stateA = new long[this.numProperty];
        this.stateB = new long[this.numProperty];
        this.transitionsLast = new long[this.numProperty][2][2];
        this.alpha = new double[this.numProperty];
        this.beta = new double[this.numProperty];
        this.propertyDone = new boolean[this.numProperty];
    }

    @Override
    public void setDisableGlobalAlias(boolean dis) {
        this.disableGlobalAlias = dis;
    }

    public void setExtensionPolicy(int policy) {
        this.extensionPolicy = policy;
    }

    @Override
    public void setExpressions(List<Property> properties) {
        this.positiveIndex = new ArrayList<List>();
        this.negativeIndex = new ArrayList<List>();
        for (Property p : properties) {
            this.positiveIndex.add(p.getPositiveIndex());
            this.negativeIndex.add(p.getNegativeIndex());
        }
        this.numProperty = this.positiveIndex.size();
    }

    @Override
    public void setParameters(double[] parameters) {
        this.precision = parameters[0];
        this.confidence = parameters[1];
        if (parameters.length > 2) {
            this.epsilon = parameters[2];
        }
    }

    public void setParameters(double precision, double confidence) {
        this.precision = precision;
        this.confidence = confidence;
    }

    public double[][] run(PBN pbn, StateBit initialState, String property) throws Exception {
        this.setExpressions(ParseProperty.getProperties(pbn, property));
        return this.run(pbn, initialState);
    }

    public double[][] run(PBN pbn, StateBit initialState) throws Exception {
        long simulateLength;
        int i;
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        long cpu = thread.getCurrentThreadCpuTime();
        this.initialise();
        double confidence = this.confidence;
        double precision = this.precision;
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + confidence), false);
        int[] M = new int[this.numProperty];
        int reest = 0;
        double[][] result = new double[3][this.numProperty];
        int i2 = 0;
        while (i2 < this.numProperty) {
            M[i2] = this.initialBurnIn;
            ++i2;
        }
        PrintWriter pw = null;
        if (this.enableOutput) {
            pw = new PrintWriter(new FileWriter(this.outputName, true));
        }
        int Nmin = (int)Math.ceil(invPhi * invPhi * this.qMinN * (1.0 - this.qMinN) / (precision * precision)) * this.kstep;
        BitSetPBNSimulationEngine simulationEngine = new BitSetPBNSimulationEngine(pbn, this);
        if (this.disableGlobalAlias) {
            simulationEngine.setDisableGlobalAlias(this.disableGlobalAlias);
        }
        if (initialState == null) {
            initialState = new StateBit(pbn.getStateLength());
        } else if (initialState.getN() != pbn.getStateLength()) {
            initialState = new StateBit(pbn.getStateLength());
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        if (this.enableOutput) {
            pw.println("Program started at " + df.format(start));
            pw.println("Total number of nodes is " + pbn.getN() + ".");
            pw.println("Total number of properties to check is " + this.numProperty + ".");
            pw.println("===============================================");
            pw.println("property index: (nodes with value 1,nodes with value 2)");
            int i3 = 0;
            while (i3 < this.numProperty) {
                int j;
                pw.print("Property " + i3 + ": (");
                List element = this.positiveIndex.get(i3);
                Iterator iterator = element.iterator();
                while (iterator.hasNext()) {
                    j = (Integer)iterator.next();
                    pw.print(" " + j);
                }
                pw.print(",");
                element = this.negativeIndex.get(i3);
                iterator = element.iterator();
                while (iterator.hasNext()) {
                    j = (Integer)iterator.next();
                    pw.print(" " + j);
                }
                pw.println(")");
                ++i3;
            }
            pw.println("===============================================");
            pw.println("Approximation is " + precision + ", confidence is " + confidence + ", fetch sample every " + this.kstep + " steps.");
            pw.println("Initial simulation steps are " + Nmin);
        }
        long[] N = new long[this.numProperty];
        long[] maxLength = new long[this.numProperty];
        initialState = simulationEngine.simulate(Nmin, initialState);
        this.calAlphaBeta(M);
        if (this.enableOutput) {
            i = 0;
            while (i < this.numProperty) {
                if (!this.propertyDone[i]) {
                    pw.println("property " + i + ": alpha=" + this.alpha[i] + ",beta=" + this.beta[i]);
                }
                ++i;
            }
        }
        while (this.checkAlphaBeta()) {
            initialState = simulationEngine.simulate((int)this.countSteps * 2, initialState);
            this.calAlphaBeta(M);
            if (!this.enableOutput) continue;
            i = 0;
            while (i < this.numProperty) {
                if (!this.propertyDone[i]) {
                    pw.println("property " + i + ": alpha=" + this.alpha[i] + ",beta=" + this.beta[i]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.numProperty) {
            if (!this.propertyDone[i]) {
                N[i] = (long)Math.ceil(this.alpha[i] * this.beta[i] * (2.0 - this.alpha[i] - this.beta[i]) / (Math.pow(this.alpha[i] + this.beta[i], 3.0) * Math.pow(precision / invPhi, 2.0))) * (long)this.kstep;
                M[i] = (int)Math.ceil(Math.log(this.epsilon * (this.alpha[i] + this.beta[i]) / Math.max(this.alpha[i], this.beta[i])) / Math.log(Math.abs(1.0 - this.alpha[i] - this.beta[i])));
                maxLength[i] = this.transitionsLast[i][0][0] + this.transitionsLast[i][0][1] + this.transitionsLast[i][1][0] + this.transitionsLast[i][1][1] - (long)(M[i] * this.kstep);
            }
            ++i;
        }
        if (this.enableOutput) {
            i = 0;
            while (i < this.numProperty) {
                if (!this.propertyDone[i]) {
                    pw.println("property " + i + ": N=" + N[i] + ", M=" + M[i] * this.kstep);
                }
                ++i;
            }
        }
        while ((simulateLength = this.getExtensionLength(N, maxLength)) > 0L) {
            initialState = simulationEngine.simulate(simulateLength, initialState);
            maxLength = (long[])N.clone();
            this.calAlphaBeta(M);
            while (this.checkAlphaBeta()) {
                initialState = simulationEngine.simulate(simulateLength, initialState);
                i = 0;
                while (i < this.numProperty) {
                    if (!this.propertyDone[i]) {
                        maxLength[i] = N[i] + simulateLength;
                    }
                    ++i;
                }
                this.calAlphaBeta(M);
            }
            i = 0;
            while (i < this.numProperty) {
                if (!this.propertyDone[i]) {
                    N[i] = (long)Math.ceil(this.alpha[i] * this.beta[i] * (2.0 - this.alpha[i] - this.beta[i]) / (Math.pow(this.alpha[i] + this.beta[i], 3.0) * Math.pow(precision / invPhi, 2.0))) * (long)this.kstep;
                    M[i] = (int)Math.ceil(Math.log(this.epsilon * (this.alpha[i] + this.beta[i]) / Math.max(this.alpha[i], this.beta[i])) / Math.log(Math.abs(1.0 - this.alpha[i] - this.beta[i])));
                    maxLength[i] = this.transitionsLast[i][0][0] + this.transitionsLast[i][0][1] + this.transitionsLast[i][1][0] + this.transitionsLast[i][1][1] - (long)(M[i] * this.kstep);
                }
                ++i;
            }
            ++reest;
        }
        if (this.enableOutput) {
            pw.println("Re-estimation times=" + reest);
        }
        result[0] = this.calDistribution(M);
        i = 0;
        while (i < this.numProperty) {
            result[1][i] = N[i];
            result[2][i] = maxLength[i];
            ++i;
        }
        this.Nmax = 0L;
        i = 0;
        while (i < this.numProperty) {
            if (this.enableOutput) {
                pw.println("property " + i + ": final M=" + M[i] * this.kstep + ", final N=" + N[i] + ", probability=" + result[0][i] + ",sample size=" + result[1][i] + ",actual size=" + maxLength[i]);
            }
            if (N[i] > this.Nmax) {
                this.Nmax = N[i];
            }
            ++i;
        }
        double cpucost = (double)(thread.getCurrentThreadCpuTime() - cpu) / 1.0E9;
        if (this.enableOutput) {
            pw.println("Total CPU time cost is " + cpucost);
            pw.close();
        }
        return result;
    }

    private long getExtensionLength(long[] N, long[] maxLength) {
        long extension;
        boolean minPri = true;
        boolean needExtension = false;
        if (this.extensionPolicy == 0) {
            extension = Long.MAX_VALUE;
        } else {
            extension = 0L;
            minPri = false;
        }
        int i = 0;
        while (i < this.numProperty) {
            if (!this.propertyDone[i]) {
                if (N[i] < maxLength[i]) {
                    this.propertyDone[i] = true;
                } else if (minPri && N[i] - maxLength[i] < extension) {
                    extension = N[i] - maxLength[i];
                    needExtension = true;
                } else if (!minPri && N[i] - maxLength[i] > extension) {
                    extension = N[i] - maxLength[i];
                    needExtension = true;
                }
            }
            ++i;
        }
        if (!needExtension) {
            extension = 0L;
        }
        return extension;
    }

    public void calAlphaBeta(int[] M) {
        int[] index1 = new int[this.numProperty];
        int index2 = 0;
        long[][][] transitionsLast = new long[this.numProperty][2][2];
        long[][][] transitionsBurnIn = new long[this.numProperty][2][2];
        int iProp = 0;
        while (iProp < this.numProperty) {
            if (!this.propertyDone[iProp]) {
                index1[iProp] = this.trajectories.get(iProp).get(0) ? 1 : 0;
                int i = 0;
                while (i < M[iProp]) {
                    int bridge = index1[iProp];
                    if (this.trajectories.get(iProp).get(i)) {
                        index2 = 1;
                        index1[iProp] = 1;
                    } else {
                        index2 = 0;
                        index1[iProp] = 0;
                    }
                    long[] lArray = transitionsBurnIn[iProp][bridge];
                    int n = index2;
                    lArray[n] = lArray[n] + 1L;
                    ++i;
                }
                i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 2) {
                        transitionsLast[iProp][i][j] = this.transitionsLast[iProp][i][j] - transitionsBurnIn[iProp][i][j];
                        ++j;
                    }
                    ++i;
                }
                long tmp = transitionsLast[iProp][0][0] + transitionsLast[iProp][0][1];
                this.beta[iProp] = tmp == 0L ? 0.0 : (double)transitionsLast[iProp][0][1] / (double)tmp;
                tmp = transitionsLast[iProp][1][0] + transitionsLast[iProp][1][1];
                this.alpha[iProp] = tmp == 0L ? 0.0 : (double)transitionsLast[iProp][1][0] / (double)tmp;
            }
            ++iProp;
        }
    }

    public double[] getAlpha() {
        return this.alpha;
    }

    public double[] getBeta() {
        return this.beta;
    }

    public double[] calDistribution(int[] M) {
        long[] stateA = this.stateA;
        long[] stateB = this.stateB;
        long[] total = new long[stateA.length];
        double[] result = new double[stateA.length];
        int iProp = 0;
        while (iProp < this.numProperty) {
            int i = 0;
            while (i < M[iProp]) {
                if (this.trajectories.get(iProp).get(i)) {
                    int n = iProp;
                    stateA[n] = stateA[n] - 1L;
                } else {
                    int n = iProp;
                    stateB[n] = stateB[n] - 1L;
                }
                ++i;
            }
            total[iProp] = stateA[iProp] + stateB[iProp];
            if (total[iProp] != 0L) {
                result[iProp] = (double)stateA[iProp] / (double)total[iProp];
            }
            ++iProp;
        }
        return result;
    }

    private boolean checkAlphaBeta() {
        double threshold = 3.0 / (double)this.countSteps;
        int i = 0;
        while (i < this.numProperty) {
            if (!this.propertyDone[i] && (this.alpha[i] < threshold || this.beta[i] < threshold || this.alpha[i] > 0.9999999 && this.beta[i] > 0.9999999)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean evaluateState(StateBit st, int propertyIndex) {
        int i;
        List elementPositive = this.positiveIndex.get(propertyIndex);
        List elementNegative = this.negativeIndex.get(propertyIndex);
        if (elementPositive != null) {
            i = 0;
            while (i < elementPositive.size()) {
                if (!st.get((Integer)elementPositive.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (elementNegative != null) {
            i = 0;
            while (i < elementNegative.size()) {
                if (st.get((Integer)elementNegative.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public void updateTransition(StateBit current, int para) {
        boolean eva = false;
        ++this.countSteps;
        if ((this.countSteps - 1L) % (long)this.kstep != 0L) {
            return;
        }
        int size = this.trajectories.get(0).size();
        int i = 0;
        while (i < this.numProperty) {
            if (!this.propertyDone[i]) {
                eva = this.evaluateState(current, i);
                int bridge = this.index1[i];
                if (eva) {
                    int n = i;
                    this.stateA[n] = this.stateA[n] + 1L;
                    this.index1[i] = 1;
                    this.index2[i] = 1;
                    if (size != 0) {
                        long[] lArray = this.transitionsLast[i][bridge];
                        int n2 = this.index2[i];
                        lArray[n2] = lArray[n2] + 1L;
                    }
                } else {
                    int n = i;
                    this.stateB[n] = this.stateB[n] + 1L;
                    this.index1[i] = 0;
                    this.index2[i] = 0;
                    if (size != 0) {
                        long[] lArray = this.transitionsLast[i][bridge];
                        int n3 = this.index2[i];
                        lArray[n3] = lArray[n3] + 1L;
                    }
                }
                if (this.traIndex[i] < this.maxRecord) {
                    this.trajectories.get(i).set(this.traIndex[i], eva);
                    int n = i;
                    this.traIndex[n] = this.traIndex[n] + 1;
                }
            }
            ++i;
        }
    }

    @Override
    public double[][] run(PBN pbn, boolean multiple) throws Exception {
        return this.run(pbn, null);
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        return null;
    }

    @Override
    public void setInstanceName() {
        this.instanceName = "Two state multiple property version";
    }
}

