/*
 * Decompiled with CFR 0.152.
 */
package simulationMethod;

import PBN.BitSetPBN;
import PBN.PBN;
import PBN.Property;
import PBN.StateBit;
import functionLib.Parameters;
import functionLib.RandomProvider;
import functionLib.StatUtil;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.Covariance;
import parallel.Simulate;
import simulationMethod.BitSetPBNSimulationEngine;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;

public class TwostateMultiPropertyParallel
extends SimulationMethod {
    private List<StateBit> trajectory;
    private List<List> trajectories;
    private BitSetPBN pbn;
    private String outputName;
    private int m;
    private int n;
    private int twon;
    private int count;
    private int previousIndex;
    private List<List> positiveIndex;
    private List<List> negativeIndex;
    private StateBit[] initialState;
    BitSetPBNSimulationEngine engine;
    int statesize;
    private boolean convergeRun = false;
    long Nmax;
    int kstep = 1;
    private double threshold = 0.001;
    private double precision = 0.01;
    private double confidence = 0.95;
    private double epsilon = Parameters.epsilon;
    private double[] alpha;
    private double[] beta;
    private int countStep = 0;
    private long[][] stateA;
    private long[][] stateB;
    private long[] burnInStateA;
    private long[] burnInStateB;
    private int maxRecord = 60000;
    private long[][][] transitionsLast;
    private long[][][][] transitionsLastChain;
    private long[][][] transitionsBurnIn;
    private boolean[] transitionBurnInComputed;
    int[][] index1;
    int[][] index2;
    private long[] countSteps;
    private Simulate parallelSimulate;
    private ForkJoinPool pool;
    private boolean expressionSet = false;
    private int numProperty = 1;
    boolean[] propertyDone;
    public static final int minPriority = 0;
    public static final int maxPriority = 1;
    private int extensionPolicy = 0;

    public TwostateMultiPropertyParallel(BitSetPBN pbn, AssaLog assalog) {
        super(assalog);
        this.pbn = pbn;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
        this.outputName = "twostatePM" + df.format(new Date()) + RandomProvider.getInstance().getRandom().nextInt() + ".txt";
        this.m = 10;
        this.n = 10;
        this.twon = 2 * this.n;
        this.countSteps = new long[this.m];
        this.setInstanceName();
    }

    public void setExtensionPolicy(int policy) {
        this.extensionPolicy = policy;
    }

    @Override
    public void setParameters(double[] parameters) {
        this.precision = parameters[0];
        this.confidence = parameters[1];
        if (parameters.length > 2) {
            this.epsilon = parameters[2];
        }
    }

    public void setParameters(double precision, double confidence) {
        this.precision = precision;
        this.confidence = confidence;
    }

    public void setM(int m) {
        this.m = m;
        this.countSteps = new long[m];
    }

    public void setKstep(int kstep) {
        this.kstep = kstep;
    }

    public void initialise() {
        this.initialState = new StateBit[this.m];
        this.engine = new BitSetPBNSimulationEngine(this.pbn, this);
        this.statesize = this.pbn.getN();
        this.stateA = new long[this.numProperty][this.m];
        this.stateB = new long[this.numProperty][this.m];
        this.burnInStateA = new long[this.numProperty];
        this.burnInStateB = new long[this.numProperty];
        this.index1 = new int[this.numProperty][this.m];
        this.index2 = new int[this.numProperty][this.m];
        this.transitionsLast = new long[this.numProperty][2][2];
        this.transitionsLastChain = new long[this.m][this.numProperty][2][2];
        this.transitionsBurnIn = new long[this.numProperty][2][2];
        this.transitionBurnInComputed = new boolean[this.numProperty];
        this.alpha = new double[this.numProperty];
        this.beta = new double[this.numProperty];
        this.propertyDone = new boolean[this.numProperty];
    }

    public void reInitialise() {
        this.trajectories = null;
        this.n = 10;
        this.twon = this.n * 2;
        this.reInitialiseAlphaBeta();
        this.convergeRun = false;
        this.engine = new BitSetPBNSimulationEngine(this.pbn, this);
    }

    private void reInitialiseAlphaBeta() {
        this.countStep = 0;
        this.transitionsLast = new long[this.numProperty][2][2];
        this.transitionsBurnIn = new long[this.numProperty][2][2];
        this.transitionsLastChain = new long[this.m][this.numProperty][2][2];
        int i = 0;
        while (i < this.numProperty) {
            this.transitionsLast[i][0][0] = 0L;
            this.transitionsLast[i][0][1] = 0L;
            this.transitionsLast[i][1][0] = 0L;
            this.transitionsLast[i][1][1] = 0L;
            this.transitionsBurnIn[i][0][0] = 0L;
            this.transitionsBurnIn[i][0][1] = 0L;
            this.transitionsBurnIn[i][1][0] = 0L;
            this.transitionsBurnIn[i][1][1] = 0L;
            ++i;
        }
    }

    @Override
    public String getLogFile() {
        return this.outputName;
    }

    @Override
    public void setLogFile(String outputName) {
        this.outputName = outputName;
    }

    public void runConverge() throws Exception {
        if (!this.expressionSet) {
            throw new Exception("Please set the property before running convergency!");
        }
        this.initialise();
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        double[] meansquare = new double[this.m];
        double mean_meansquare = 0.0;
        boolean done = false;
        boolean done1 = false;
        int endIndex = this.pbn.getN() - 1;
        Covariance covariance = new Covariance();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<StateBit>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = this.n;
        this.previousIndex = 0;
        this.parallelSimulate = new Simulate(this.trajectories, extension * 2, 0, this.trajectories.size() - 1, this.engine, this.initialState);
        this.pool = new ForkJoinPool();
        while (!done) {
            this.parallelSimulate.reinitialize();
            this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
            this.parallelSimulate.setMinIndex(0);
            this.parallelSimulate.setSteps(extension * 2 * this.kstep);
            this.pool.invoke(this.parallelSimulate);
            this.updateTransition();
            double within = 0.0;
            double grandmean = 0.0;
            mean_meansquare = 0.0;
            double[] values = new double[this.n];
            i = 0;
            while (i < this.m) {
                mean[i] = 0.0;
                int j = 0;
                while (j < this.n) {
                    int n = i;
                    mean[n] = mean[n] + ((StateBit)this.trajectories.get(i).get(j + this.n)).getDoubleValue(0, endIndex);
                    ++j;
                }
                mean[i] = mean[i] / (double)this.n;
                meansquare[i] = Math.pow(mean[i], 2.0);
                sj[i] = 0.0;
                j = this.n;
                while (j < this.twon) {
                    values[j - this.n] = ((StateBit)this.trajectories.get(i).get(j)).getDoubleValue(0, endIndex);
                    ++j;
                }
                sj[i] = StatUtils.variance(values);
                ++i;
            }
            within = StatUtils.mean(sj);
            grandmean = StatUtils.mean(mean);
            mean_meansquare = StatUtils.mean(meansquare);
            double between = (double)this.n * StatUtils.variance(mean);
            double varianceW = StatUtils.variance(sj);
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = covariance.covariance(sj, meansquare);
            double covwx = covariance.covariance(sj, mean);
            double covwb = (double)(this.n / this.m) * (covwxsquare - 2.0 * grandmean * covwx);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double varianceV = (Math.pow(this.n - 1, 2.0) * (varianceW /= (double)this.m) + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            if (Math.abs(1.0 - psrf) > this.threshold || varianceV == 0.0) {
                done = false;
                done1 = false;
                extension = this.n;
                this.n += extension;
                this.twon = this.n * 2;
                if (this.twon <= this.maxRecord) continue;
                this.maxRecord = 1000 + this.twon;
                continue;
            }
            if (done1) {
                done = true;
            } else {
                done1 = true;
                extension = this.n;
                this.n += extension;
                this.twon = this.n * 2;
            }
            if (this.twon <= this.maxRecord) continue;
            this.maxRecord = 1000 + this.twon;
        }
        this.convergeRun = true;
    }

    private void updateTransition() {
        int j = 0;
        while (j < this.numProperty) {
            this.transitionsLast[j][0][0] = 0L;
            this.transitionsLast[j][0][1] = 0L;
            this.transitionsLast[j][1][0] = 0L;
            this.transitionsLast[j][1][1] = 0L;
            int i = 0;
            while (i < this.m) {
                long[] lArray = this.transitionsLast[j][0];
                lArray[0] = lArray[0] + this.transitionsLastChain[i][j][0][0];
                long[] lArray2 = this.transitionsLast[j][0];
                lArray2[1] = lArray2[1] + this.transitionsLastChain[i][j][0][1];
                long[] lArray3 = this.transitionsLast[j][1];
                lArray3[0] = lArray3[0] + this.transitionsLastChain[i][j][1][0];
                long[] lArray4 = this.transitionsLast[j][1];
                lArray4[1] = lArray4[1] + this.transitionsLastChain[i][j][1][1];
                ++i;
            }
            ++j;
        }
    }

    public void quickTestSimulation(int n) throws Exception {
        this.initialise();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            this.initialState[i] = new StateBit(this.statesize);
            this.initialState[i].putLongFromTo(statespace * (long)i, 0, this.statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<StateBit>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        int extension = n;
        this.previousIndex = 0;
        this.parallelSimulate = new Simulate(this.trajectories, extension, 0, this.trajectories.size() - 1, this.engine, this.initialState);
        this.pool = new ForkJoinPool();
        this.parallelSimulate.reinitialize();
        this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
        this.parallelSimulate.setMinIndex(0);
        this.parallelSimulate.setSteps(extension);
        this.pool.invoke(this.parallelSimulate);
    }

    public double[] calDistribution() {
        long[] stateA = new long[this.numProperty];
        long[] stateB = new long[this.numProperty];
        double[] result = new double[this.numProperty];
        int j = 0;
        while (j < this.numProperty) {
            int n = j;
            stateA[n] = stateA[n] - this.burnInStateA[j];
            int n2 = j;
            stateB[n2] = stateB[n2] - this.burnInStateB[j];
            int i = 0;
            while (i < this.m) {
                int n3 = j;
                stateA[n3] = stateA[n3] + this.stateA[j][i];
                int n4 = j;
                stateB[n4] = stateB[n4] + this.stateB[j][i];
                ++i;
            }
            long total = stateA[j] + stateB[j];
            result[j] = total != 0L ? (double)stateA[j] / (double)total : 0.0;
            ++j;
        }
        return result;
    }

    public double[][] computeSteadyState() throws Exception {
        long extensionPerChain;
        int i;
        if (!this.convergeRun) {
            this.runConverge();
        }
        double[][] result = new double[3][this.numProperty];
        double invPhi = StatUtil.getInvCDF(0.5 * (1.0 + this.confidence), false);
        PrintWriter pw = null;
        if (this.enableOutput) {
            pw = new PrintWriter(new FileWriter(this.outputName, true));
        }
        if (this.enableOutput) {
            System.out.println("Detailed information is stored in " + this.outputName);
        }
        this.calAlphaBeta(this.n);
        long countStep = 0L;
        int i2 = 0;
        while (i2 < this.m) {
            countStep += this.countSteps[i2];
            ++i2;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        if (this.enableOutput) {
            pw.println("Program started at " + df.format(start));
            pw.println("Total number of nodes is " + this.pbn.getN() + ".");
            pw.println("Total number of properties to check is " + this.numProperty + ".");
            pw.println("===============================================");
            pw.println("property index: (nodes with value 1,nodes with value 2)");
            int i3 = 0;
            while (i3 < this.numProperty) {
                int j;
                pw.print("Property " + i3 + ": (");
                List element = this.positiveIndex.get(i3);
                Iterator iterator = element.iterator();
                while (iterator.hasNext()) {
                    j = (Integer)iterator.next();
                    pw.print(" " + j);
                }
                pw.print(",");
                element = this.negativeIndex.get(i3);
                iterator = element.iterator();
                while (iterator.hasNext()) {
                    j = (Integer)iterator.next();
                    pw.print(" " + j);
                }
                pw.println(")");
                ++i3;
            }
            pw.println("===============================================");
            pw.println("Approximation is " + this.precision + ", confidence is " + this.confidence + ", fetch sample every " + this.kstep + " steps.");
            i3 = 0;
            while (i3 < this.numProperty) {
                if (!this.propertyDone[i3]) {
                    pw.println("property " + i3 + ": alpha=" + this.alpha[i3] + ",beta=" + this.beta[i3]);
                }
                ++i3;
            }
        }
        long[] N = new long[this.numProperty];
        long[] maxLength = new long[this.numProperty];
        int round = 0;
        while (this.checkAlphaBeta()) {
            long extensionPerChain2 = this.n;
            if (this.enableOutput) {
                System.out.println("Extend for avaiable alpha beta by " + extensionPerChain2 * (long)this.kstep + " per chain");
            }
            this.simulate(extensionPerChain2 * (long)this.m * (long)this.kstep);
            this.calAlphaBeta(extensionPerChain2);
            if (this.enableOutput) {
                i = 0;
                while (i < this.numProperty) {
                    if (!this.propertyDone[i]) {
                        pw.println("property " + i + ": alpha=" + this.alpha[i] + ",beta=" + this.beta[i]);
                    }
                    ++i;
                }
            }
            ++round;
        }
        i = 0;
        while (i < this.numProperty) {
            if (!this.propertyDone[i]) {
                N[i] = (long)Math.ceil(this.alpha[i] * this.beta[i] * (2.0 - this.alpha[i] - this.beta[i]) / (Math.pow(this.alpha[i] + this.beta[i], 3.0) * Math.pow(this.precision / invPhi, 2.0))) * (long)this.kstep;
                maxLength[i] = this.transitionsLast[i][0][0] + this.transitionsLast[i][0][1] + this.transitionsLast[i][1][0] + this.transitionsLast[i][1][1] - (long)(this.m * (this.n - 1));
            }
            ++i;
        }
        this.count = 0;
        if (this.enableOutput) {
            i = 0;
            while (i < this.numProperty) {
                if (!this.propertyDone[i]) {
                    pw.println("property " + i + ": N=" + N[i]);
                }
                ++i;
            }
        }
        while ((extensionPerChain = this.getExtensionLength(N, maxLength)) > 0L) {
            ++round;
            extensionPerChain = (long)Math.ceil((double)(extensionPerChain * (long)this.kstep) / (double)this.m);
            this.simulate(extensionPerChain * (long)this.m);
            this.calAlphaBeta(extensionPerChain);
            if (this.enableOutput) {
                pw.println("Re-estimating round " + round);
            }
            i = 0;
            while (i < this.numProperty) {
                if (!this.propertyDone[i]) {
                    N[i] = (long)Math.ceil(this.alpha[i] * this.beta[i] * (2.0 - this.alpha[i] - this.beta[i]) / (Math.pow(this.alpha[i] + this.beta[i], 3.0) * Math.pow(this.precision / invPhi, 2.0))) * (long)this.kstep;
                    maxLength[i] = this.transitionsLast[i][0][0] + this.transitionsLast[i][0][1] + this.transitionsLast[i][1][0] + this.transitionsLast[i][1][1] - (long)(this.m * (this.n - 1));
                    if (this.enableOutput) {
                        pw.println("\t property " + i + ": alpha=" + this.alpha[i] + ", beta=" + this.beta[i] + ", N=" + N[i] + ".");
                    }
                }
                ++i;
            }
        }
        double epsilon = 1.0E-10;
        int[] M = new int[this.numProperty];
        int i4 = 0;
        while (i4 < this.numProperty) {
            M[i4] = (int)Math.ceil(Math.log(epsilon * (this.alpha[i4] + this.beta[i4]) / Math.max(this.alpha[i4], this.beta[i4])) / Math.log(Math.abs(1.0 - this.alpha[i4] - this.beta[i4])));
            ++i4;
        }
        if (this.enableOutput) {
            System.out.println("Total extending times: " + round + "\n");
        }
        if (this.enableOutput) {
            pw.println("Re-estimation times=" + round);
        }
        result[0] = this.calDistribution();
        i4 = 0;
        while (i4 < this.numProperty) {
            result[1][i4] = N[i4];
            result[2][i4] = maxLength[i4];
            ++i4;
        }
        this.Nmax = 0L;
        i4 = 0;
        while (i4 < this.numProperty) {
            if (this.enableOutput) {
                pw.println("property " + i4 + ": final M=" + M[i4] * this.kstep + ", final N=" + N[i4] + ", probability=" + result[0][i4] + ",sample size=" + result[1][i4] + ",actual size=" + maxLength[i4]);
            }
            if (N[i4] > this.Nmax) {
                this.Nmax = N[i4];
            }
            ++i4;
        }
        if (this.enableOutput) {
            pw.close();
        }
        return result;
    }

    private boolean checkAlphaBeta() {
        int countStep = 0;
        int j = 0;
        while (j < this.m) {
            countStep = (int)((long)countStep + this.countSteps[j]);
            ++j;
        }
        double threshold = 3.0 / (double)countStep;
        int i = 0;
        while (i < this.numProperty) {
            if (!this.propertyDone[i] && (this.alpha[i] < threshold || this.beta[i] < threshold || this.alpha[i] > 0.9999999 && this.beta[i] > 0.9999999)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private long getExtensionLength(long[] N, long[] maxLength) {
        long extension;
        boolean minPri = true;
        boolean needExtension = false;
        if (this.extensionPolicy == 0) {
            extension = Long.MAX_VALUE;
        } else {
            extension = 0L;
            minPri = false;
        }
        int i = 0;
        while (i < this.numProperty) {
            if (!this.propertyDone[i]) {
                if (N[i] < maxLength[i]) {
                    this.propertyDone[i] = true;
                } else if (minPri && N[i] - maxLength[i] < extension) {
                    extension = N[i] - maxLength[i];
                    needExtension = true;
                } else if (!minPri && N[i] - maxLength[i] > extension) {
                    extension = N[i] - maxLength[i];
                    needExtension = true;
                }
            }
            ++i;
        }
        if (!needExtension) {
            extension = 0L;
        }
        return extension;
    }

    public void calAlphaBeta(int length, boolean isTotalLength) throws Exception {
        if (isTotalLength) {
            if (length < this.countStep) {
                throw new Exception("The number of processed samples is bigger than the length. No need to recompute.");
            }
            this.calAlphaBeta(length - this.countStep);
        } else {
            this.calAlphaBeta(length);
        }
    }

    public void calAlphaBeta(int length) throws Exception {
        int[][] index1 = new int[this.numProperty][this.m];
        int index2 = 0;
        long[][][] transitionsLast = new long[this.numProperty][2][2];
        int iProp = 0;
        while (iProp < this.numProperty) {
            if (!this.propertyDone[iProp]) {
                int j;
                int i;
                if (!this.transitionBurnInComputed[iProp]) {
                    i = 0;
                    while (i < this.m) {
                        if (this.evaluateState((StateBit)this.trajectories.get(i).get(0), iProp)) {
                            index1[iProp][i] = 1;
                            int n = iProp;
                            this.burnInStateA[n] = this.burnInStateA[n] + 1L;
                        } else {
                            index1[iProp][i] = 0;
                            int n = iProp;
                            this.burnInStateB[n] = this.burnInStateB[n] + 1L;
                        }
                        j = 1;
                        while (j < this.n + 1) {
                            int bridge = index1[iProp][i];
                            if (this.evaluateState((StateBit)this.trajectories.get(i).get(j), iProp)) {
                                index1[iProp][i] = 1;
                                index2 = 1;
                                int n = iProp;
                                this.burnInStateA[n] = this.burnInStateA[n] + 1L;
                            } else {
                                index1[iProp][i] = 0;
                                index2 = 0;
                                int n = iProp;
                                this.burnInStateB[n] = this.burnInStateB[n] + 1L;
                            }
                            long[] lArray = this.transitionsBurnIn[iProp][bridge];
                            int n = index2;
                            lArray[n] = lArray[n] + 1L;
                            ++j;
                        }
                        ++i;
                    }
                    this.transitionBurnInComputed[iProp] = true;
                }
                i = 0;
                while (i < 2) {
                    j = 0;
                    while (j < 2) {
                        transitionsLast[iProp][i][j] = this.transitionsLast[iProp][i][j] - this.transitionsBurnIn[iProp][i][j];
                        ++j;
                    }
                    ++i;
                }
                this.beta[iProp] = transitionsLast[iProp][0][0] + transitionsLast[iProp][0][1] == 0L ? 0.0 : (double)transitionsLast[iProp][0][1] / (double)(transitionsLast[iProp][0][0] + transitionsLast[iProp][0][1]);
                this.alpha[iProp] = transitionsLast[iProp][1][0] + transitionsLast[iProp][1][1] == 0L ? 0.0 : (double)transitionsLast[iProp][1][0] / (double)(transitionsLast[iProp][1][0] + transitionsLast[iProp][1][1]);
            }
            ++iProp;
        }
    }

    public void calAlphaBeta(long length) throws Exception {
        int[][] index1 = new int[this.numProperty][this.m];
        int index2 = 0;
        long[][][] transitionsLast = new long[this.numProperty][2][2];
        int iProp = 0;
        while (iProp < this.numProperty) {
            if (!this.propertyDone[iProp]) {
                int j;
                int i;
                if (!this.transitionBurnInComputed[iProp]) {
                    i = 0;
                    while (i < this.m) {
                        if (this.evaluateState((StateBit)this.trajectories.get(i).get(0), iProp)) {
                            index1[iProp][i] = 1;
                            int n = iProp;
                            this.burnInStateA[n] = this.burnInStateA[n] + 1L;
                        } else {
                            index1[iProp][i] = 0;
                            int n = iProp;
                            this.burnInStateB[n] = this.burnInStateB[n] + 1L;
                        }
                        j = 1;
                        while (j < this.n + 1) {
                            int bridge = index1[iProp][i];
                            if (this.evaluateState((StateBit)this.trajectories.get(i).get(j), iProp)) {
                                index1[iProp][i] = 1;
                                index2 = 1;
                                int n = iProp;
                                this.burnInStateA[n] = this.burnInStateA[n] + 1L;
                            } else {
                                index1[iProp][i] = 0;
                                index2 = 0;
                                int n = iProp;
                                this.burnInStateB[n] = this.burnInStateB[n] + 1L;
                            }
                            long[] lArray = this.transitionsBurnIn[iProp][bridge];
                            int n = index2;
                            lArray[n] = lArray[n] + 1L;
                            ++j;
                        }
                        ++i;
                    }
                    this.transitionBurnInComputed[iProp] = true;
                }
                i = 0;
                while (i < 2) {
                    j = 0;
                    while (j < 2) {
                        transitionsLast[iProp][i][j] = this.transitionsLast[iProp][i][j] - this.transitionsBurnIn[iProp][i][j];
                        ++j;
                    }
                    ++i;
                }
                this.beta[iProp] = transitionsLast[iProp][0][0] + transitionsLast[iProp][0][1] == 0L ? 0.0 : (double)transitionsLast[iProp][0][1] / (double)(transitionsLast[iProp][0][0] + transitionsLast[iProp][0][1]);
                this.alpha[iProp] = transitionsLast[iProp][1][0] + transitionsLast[iProp][1][1] == 0L ? 0.0 : (double)transitionsLast[iProp][1][0] / (double)(transitionsLast[iProp][1][0] + transitionsLast[iProp][1][1]);
            }
            ++iProp;
        }
    }

    public void runPlot() throws Exception {
        StateBit[] initialState = new StateBit[this.m];
        double[] sj = new double[this.m];
        double[] mean = new double[this.m];
        int statesize = this.pbn.getN();
        double mean_meansquare = 0.0;
        boolean done = false;
        BitSetPBNSimulationEngine engine = new BitSetPBNSimulationEngine(this.pbn, this);
        Random ran = RandomProvider.getInstance().getRandom();
        long statespace = (long)Math.pow(2.0, this.pbn.getN());
        statespace /= (long)this.m;
        int i = 0;
        while (i < this.m) {
            initialState[i] = new StateBit(statesize);
            initialState[i].putLongFromTo(statespace * (long)i, 0, statesize - 1);
            ++i;
        }
        this.trajectories = new ArrayList<List>();
        i = 0;
        while (i < this.m) {
            this.trajectory = new ArrayList<StateBit>();
            this.trajectories.add(this.trajectory);
            ++i;
        }
        this.previousIndex = 0;
        int extension = this.n;
        int k = 1;
        while (k < 501) {
            int i2 = 0;
            while (i2 < this.m) {
                this.count = i2;
                initialState[i2] = engine.simulate(extension * 2 * this.kstep, initialState[i2]);
                ++i2;
            }
            double within = 0.0;
            double grandmean = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                mean[i2] = 0.0;
                int j = 0;
                while (j < this.n) {
                    int n = i2;
                    mean[n] = mean[n] + (double)((Long)this.trajectories.get(i2).get(j + this.n)).longValue();
                    ++j;
                }
                mean[i2] = mean[i2] / (double)this.n;
                mean_meansquare += mean[i2] * mean[i2];
                grandmean += mean[i2];
                sj[i2] = 0.0;
                j = this.n;
                while (j < this.twon) {
                    int n = i2;
                    sj[n] = sj[n] + Math.pow((double)((Long)this.trajectories.get(i2).get(j)).longValue() - mean[i2], 2.0);
                    ++j;
                }
                sj[i2] = sj[i2] / (double)(this.n - 1);
                within += sj[i2];
                ++i2;
            }
            within /= (double)this.m;
            grandmean /= (double)this.m;
            mean_meansquare /= (double)this.m;
            double between = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                between += Math.pow(grandmean - mean[i2], 2.0);
                ++i2;
            }
            between = between * (double)this.n / (double)(this.m - 1);
            double varianceW = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                varianceW += Math.pow(sj[i2] - within, 2.0);
                ++i2;
            }
            varianceW /= (double)(this.m - 1);
            varianceW /= (double)this.m;
            double varianceB = 2.0 * between * between / (double)(this.m - 1);
            double covwxsquare = 0.0;
            double covwx = 0.0;
            i2 = 0;
            while (i2 < this.m) {
                covwxsquare += (sj[i2] - within) * (mean[i2] * mean[i2] - mean_meansquare);
                covwx += (sj[i2] - within) * (mean[i2] - grandmean);
                ++i2;
            }
            double covwb = (double)(this.n / this.m) * ((covwxsquare /= (double)(this.m - 1)) - 2.0 * grandmean * (covwx /= (double)(this.m - 1)));
            double varianceV = (Math.pow(this.n - 1, 2.0) * varianceW + Math.pow(1 + 1 / this.m, 2.0) * varianceB + (double)(2 * (1 / this.m + 1) * (this.n - 1)) * covwb) / Math.pow(this.n, 2.0);
            double variance = (1.0 - 1.0 / (double)this.n) * within + (double)(this.m + 1) / (double)(this.m * this.n) * between;
            double df = 2.0 * variance * variance / varianceV;
            double psrf = Math.sqrt(variance / within * (df + 3.0) / (df + 1.0));
            extension = 5;
            this.n += extension;
            this.twon = this.n * 2;
            ++k;
        }
    }

    @Override
    public void updateTransition(StateBit st, int para) {
        int n = para;
        this.countSteps[n] = this.countSteps[n] + 1L;
        if ((this.countSteps[para] - 1L) % (long)this.kstep != 0L) {
            return;
        }
        int size = this.trajectories.get(para).size();
        int i = 0;
        while (i < this.numProperty) {
            if (!this.propertyDone[i]) {
                boolean eva = this.evaluateState(st, i);
                int bridge = this.index1[i][para];
                if (eva) {
                    long[] lArray = this.stateA[i];
                    int n2 = para;
                    lArray[n2] = lArray[n2] + 1L;
                    this.index1[i][para] = 1;
                    this.index2[i][para] = 1;
                    if (size != 0) {
                        long[] lArray2 = this.transitionsLastChain[para][i][bridge];
                        int n3 = this.index2[i][para];
                        lArray2[n3] = lArray2[n3] + 1L;
                    }
                } else {
                    long[] lArray = this.stateB[i];
                    int n4 = para;
                    lArray[n4] = lArray[n4] + 1L;
                    this.index1[i][para] = 0;
                    this.index2[i][para] = 0;
                    if (size != 0) {
                        long[] lArray3 = this.transitionsLastChain[para][i][bridge];
                        int n5 = this.index2[i][para];
                        lArray3[n5] = lArray3[n5] + 1L;
                    }
                }
            }
            ++i;
        }
        if (size < this.maxRecord) {
            this.trajectories.get(para).add(st);
        }
    }

    public boolean evaluateState(StateBit st, int propertyIndex) {
        int i;
        List elementPositive = this.positiveIndex.get(propertyIndex);
        List elementNegative = this.negativeIndex.get(propertyIndex);
        if (elementPositive != null) {
            i = 0;
            while (i < elementPositive.size()) {
                if (!st.get((Integer)elementPositive.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (elementNegative != null) {
            i = 0;
            while (i < elementNegative.size()) {
                if (st.get((Integer)elementNegative.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public double mean(List<Double> yjm, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += yjm.get(i).doubleValue();
            ++i;
        }
        return total / (double)(end - start);
    }

    @Override
    public void setExpressions(List<Property> properties) {
        this.positiveIndex = new ArrayList<List>();
        this.negativeIndex = new ArrayList<List>();
        for (Property p : properties) {
            this.positiveIndex.add(p.getPositiveIndex());
            this.negativeIndex.add(p.getNegativeIndex());
        }
        this.numProperty = this.positiveIndex.size();
        this.expressionSet = true;
    }

    public void simulate(int N) throws Exception {
        int extentionPerChain = (int)Math.ceil(N / this.m) + 1;
        this.parallelSimulate.reinitialize();
        this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
        this.parallelSimulate.setMinIndex(0);
        this.parallelSimulate.setSteps(extentionPerChain);
        this.pool.invoke(this.parallelSimulate);
        this.updateTransition();
    }

    public void simulate(long N) throws Exception {
        long extentionPerChain = (long)Math.ceil(N / (long)this.m) + 1L;
        this.parallelSimulate.reinitialize();
        this.parallelSimulate.setMaxIndex(this.trajectories.size() - 1);
        this.parallelSimulate.setMinIndex(0);
        this.parallelSimulate.setSteps(extentionPerChain);
        this.pool.invoke(this.parallelSimulate);
        this.updateTransition();
    }

    public void printStatistic() {
        this.assalog.println("m=" + this.m + ", n=" + this.n + ", Nmax=" + this.Nmax + ", each chain length=" + this.countSteps[0] + ", fetch samples every " + this.kstep + " step(s).");
    }

    public long getNmax() {
        return this.Nmax;
    }

    @Override
    public double[] run(PBN pbn) throws Exception {
        this.pbn = (BitSetPBN)pbn;
        return this.computeSteadyState()[0];
    }

    @Override
    public double[][] run(PBN pbn, boolean parallel) throws Exception {
        this.pbn = (BitSetPBN)pbn;
        this.reInitialise();
        return this.computeSteadyState();
    }

    @Override
    public void setInstanceName() {
        this.instanceName = "Two state multiple properties parallel version";
    }
}

