/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.concurrent.ThreadLocalRandom;

public class CDFMethod {
    private double[] cdf;

    public CDFMethod(double[] probabilities) {
        if (probabilities == null) {
            throw new NullPointerException();
        }
        if (probabilities.length == 0) {
            throw new IllegalArgumentException("Probability vector must be nonempty.");
        }
        this.cdf = new double[probabilities.length];
        this.cdf[0] = probabilities[0];
        int i = 1;
        while (i < probabilities.length) {
            this.cdf[i] = this.cdf[i - 1] + probabilities[i];
            ++i;
        }
    }

    public int next() {
        double rnd = ThreadLocalRandom.current().nextDouble();
        int i = 0;
        while (rnd > this.cdf[i]) {
            ++i;
        }
        return i;
    }

    public int next(double[] epsilon) {
        double rnd = ThreadLocalRandom.current().nextDouble();
        int i = 0;
        while (rnd > this.cdf[i]) {
            ++i;
        }
        epsilon[0] = i;
        epsilon[1] = this.cdf[i] - rnd;
        if (i > 0) {
            epsilon[2] = rnd - this.cdf[i - 1];
        }
        return i;
    }
}

