/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ObjectAliasMethod {
    private final Random random;
    private List<Integer>[] alias;
    private final double[] probability;
    private List<Integer>[] column;

    public ObjectAliasMethod(double[] probabilities, List<Integer>[] column) {
        this(probabilities, new Random(), column);
    }

    public ObjectAliasMethod(double[] probabilities, Random random, List<Integer>[] column) {
        if (probabilities == null || random == null) {
            throw new NullPointerException();
        }
        if (probabilities.length == 0) {
            throw new IllegalArgumentException("Probability vector must be nonempty.");
        }
        if (column == null) {
            this.column = new ArrayList[probabilities.length];
            int i = 0;
            while (i < probabilities.length) {
                this.column[i] = new ArrayList<Integer>();
                this.column[i].add(i);
                ++i;
            }
        } else {
            this.column = column;
        }
        this.probability = new double[probabilities.length];
        this.alias = new ArrayList[probabilities.length];
        this.random = random;
        double average = 1.0 / (double)probabilities.length;
        probabilities = (double[])probabilities.clone();
        ArrayDeque<Integer> small = new ArrayDeque<Integer>();
        ArrayDeque<Integer> large = new ArrayDeque<Integer>();
        int i = 0;
        while (i < probabilities.length) {
            if (probabilities[i] >= average) {
                large.add(i);
            } else {
                small.add(i);
            }
            ++i;
        }
        while (!small.isEmpty() && !large.isEmpty()) {
            int less = (Integer)small.removeLast();
            int more = (Integer)large.removeLast();
            this.probability[less] = probabilities[less] * (double)probabilities.length;
            this.alias[less] = this.column[more];
            probabilities[more] = probabilities[more] + probabilities[less] - average;
            if (probabilities[more] >= average) {
                large.add(more);
                continue;
            }
            small.add(more);
        }
        while (!small.isEmpty()) {
            this.probability[((Integer)small.removeLast()).intValue()] = 1.0;
        }
        while (!large.isEmpty()) {
            this.probability[((Integer)large.removeLast()).intValue()] = 1.0;
        }
    }

    public List<Integer> next() {
        int columnIndex = this.random.nextInt(this.probability.length);
        boolean coinToss = this.random.nextDouble() < this.probability[columnIndex];
        return coinToss ? this.column[columnIndex] : this.alias[columnIndex];
    }

    public List<Integer> next(double random1, double random2) {
        int columnIndex = (int)(random1 * (double)this.probability.length);
        boolean coinToss = random2 < this.probability[columnIndex];
        return coinToss ? this.column[columnIndex] : this.alias[columnIndex];
    }
}

