/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import cern.jet.random.Exponential;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.util.ArrayList;
import java.util.Date;

public class RandomNumberGenerator {
    private MersenneTwister random = new MersenneTwister(new Date());
    private Uniform uniform = new Uniform((RandomEngine)this.random);
    private Exponential exponential = new Exponential(1.0, (RandomEngine)this.random);

    public int randomUnifInt(int n) {
        return this.uniform.nextIntFromTo(0, n - 1);
    }

    public double randomUnifDouble() {
        return this.random.nextDouble();
    }

    public double randomUnifDouble(double x) {
        return x * this.random.nextDouble();
    }

    public double randomExpDouble(double x) {
        return this.exponential.nextDouble(x);
    }

    public Integer[] randomInt(int n, int low, int high) throws Exception {
        if (low > high) {
            throw new Exception("low cannot be higher than high");
        }
        if (n < 0 || n > high - low + 1) {
            throw new Exception("n must satisfy 0<=n<=high-low+1.");
        }
        Integer[] random = new Integer[n];
        ArrayList<Integer> elements = new ArrayList<Integer>();
        int total = high - low + 1;
        int i = low;
        while (i <= high) {
            elements.add(i);
            ++i;
        }
        i = 0;
        while (i < n) {
            int tmp = this.randomUnifInt(total - i);
            random[i] = (Integer)elements.get(tmp);
            elements.remove(tmp);
            ++i;
        }
        return random;
    }
}

