/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.OptimizePBN;
import PBN.PBN;
import PBN.ParseProperty;
import PBN.Property;
import PBN.ReducePBN;
import PBN.StateBit;
import analysis.influence.LongtermInfluence;
import analysis.influence.LongtermSensitivity;
import chowliuTree.ChouLiu;
import functionLib.AssaException;
import functionLib.Parameters;
import functionLib.RandomProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import jdd.JDD;
import parameterEstimation.particleSwarm.estiPBN.Estimate;
import parser.Model;
import simulationMethod.GaussSeidel;
import simulationMethod.Gelman;
import simulationMethod.GelmanFullStateNoInitial;
import simulationMethod.GelmanFullStatePara;
import simulationMethod.GelmanFullStateParallel;
import simulationMethod.GelmanFullStateReducedModel;
import simulationMethod.GermanAndStructure;
import simulationMethod.GermanGPU;
import simulationMethod.Jacob;
import simulationMethod.SimulationMethod;
import simulationMethod.SkartPBN;
import simulationMethod.SkartPBNLarge;
import simulationMethod.SkartPBNParallel;
import simulationMethod.StepPerfectSimulationWalkerBitSet;
import simulationMethod.TwoStateBitSet;
import simulationMethod.TwoStateBitSetPara;
import simulationMethod.TwoStateMTBDDPara;
import simulationMethod.TwoStateMultiProperty;
import simulationMethod.TwostateMultiPropertyParallel;
import simulator.RandomNumberGenerator;
import userInterface.AssaConsoleLog;
import userInterface.AssaFileLog;
import userInterface.AssaLog;
import userInterface.Version;

public class Assa {
    private AssaLog assalog = new AssaConsoleLog();

    public BitSetPBN defineBitSetPBN(int n, double perturbation) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = n >= 10 ? 10 : n;
        this.assalog.println("Max number of functions and max number of parent nodes are set to " + maxVariableNum);
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBN(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBNFromExpression(int n, double perturbation) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = n >= 10 ? 10 : n;
        this.assalog.println("Max number of functions and max number of parent nodes are set to " + maxVariableNum);
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBNWithExpression(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, double perturbation, int maxFunction, int maxVariable) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBN(n, perturbation);
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxFunction) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariable) + 1);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBN(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, boolean maxVariableNumLimit) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = maxVariableNumLimit && n >= 20 ? 20 : n;
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBN(n, nf, nv);
        pbn.setPerturbation(0.1);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, double perturbation, int maxFunction, int minFunction, int maxVariable, int minVariable) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBN(n, perturbation);
        }
        if ((double)maxFunction > Math.pow(2.0, n)) {
            throw new Exception("Max function number is too large!");
        }
        if (maxFunction > 20) {
            this.assalog.println("Max function number is over 20. Consider changing to smaller one!");
        }
        if (maxVariable > n) {
            throw new Exception("Max variable number is too large!");
        }
        if (maxVariable > 20) {
            this.assalog.println("Max variable number is over 20. Consider changing to smaller one!");
        }
        if (minFunction <= 0) {
            minFunction = 1;
            this.assalog.println("Minimum function number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        if (minVariable <= 0) {
            minVariable = 1;
            this.assalog.println("Minimum variable number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int diffFun = maxFunction - minFunction + 1;
        int diffVar = maxVariable - minVariable + 1;
        int i = 0;
        while (i < nf.length) {
            nf[i] = (int)(rng.randomUnifDouble() * (double)diffFun) + minFunction;
            int j = 0;
            while (j < nf[i]) {
                nv.add((int)(rng.randomUnifDouble() * (double)diffVar) + minVariable);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBN(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBNFromExpression(int n, double perturbation, int maxFunction, int minFunction, int maxVariable, int minVariable) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBNFromExpression(n, perturbation);
        }
        if ((double)maxFunction > Math.pow(2.0, n)) {
            throw new Exception("Max function number is too large!");
        }
        if (maxFunction > 20) {
            this.assalog.println("Max function number is over 20. Consider changing to smaller one!");
        }
        if (maxVariable > n) {
            throw new Exception("Max variable number is too large!");
        }
        if (maxVariable > 20) {
            this.assalog.println("Max variable number is over 20. Consider changing to smaller one!");
        }
        if (minFunction <= 0) {
            minFunction = 1;
            this.assalog.println("Minimum function number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        if (minVariable <= 0) {
            minVariable = 1;
            this.assalog.println("Minimum variable number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int diffFun = maxFunction - minFunction + 1;
        int diffVar = maxVariable - minVariable + 1;
        int i = 0;
        while (i < nf.length) {
            nf[i] = (int)(rng.randomUnifDouble() * (double)diffFun) + minFunction;
            int j = 0;
            while (j < nf[i]) {
                nv.add((int)(rng.randomUnifDouble() * (double)diffVar) + minVariable);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBNWithExpression(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBNFromExpression(int n, double perturbation, int maxFunction, int minFunction, int maxVariable, int minVariable, String distributionFile) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBNFromExpression(n, perturbation);
        }
        if ((double)maxFunction > Math.pow(2.0, n)) {
            throw new Exception("Max function number is too large!");
        }
        if (maxFunction > 20) {
            this.assalog.println("Max function number is over 20. Consider changing to smaller one!");
        }
        if (maxVariable > n) {
            throw new Exception("Max variable number is too large!");
        }
        if (maxVariable > 20) {
            this.assalog.println("Max variable number is over 20. Consider changing to smaller one!");
        }
        if (minFunction <= 0) {
            minFunction = 1;
            this.assalog.println("Minimum function number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        if (minVariable <= 0) {
            minVariable = 1;
            this.assalog.println("Minimum variable number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int diffFun = maxFunction - minFunction + 1;
        int diffVar = maxVariable - minVariable + 1;
        double[] distribution = new double[diffVar];
        File file = new File(distributionFile);
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(file));
        String tempString = null;
        int count = 0;
        tempString = reader.readLine();
        if (tempString != null) {
            StringTokenizer st = new StringTokenizer(tempString);
            while (st.hasMoreTokens()) {
                distribution[count] = Double.parseDouble(st.nextToken());
                if (count > 0) {
                    int n2 = count;
                    distribution[n2] = distribution[n2] + distribution[count - 1];
                }
                ++count;
            }
        }
        int i = 0;
        while (i < nf.length) {
            nf[i] = (int)(rng.randomUnifDouble() * (double)diffFun) + minFunction;
            int j = 0;
            while (j < nf[i]) {
                double random = rng.randomUnifDouble();
                count = 0;
                while (random > distribution[count]) {
                    ++count;
                }
                nv.add(count + minVariable);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBNWithExpression(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    private BitSetPBN defineHighLevelPBN(int n, double perturbation, int maxFunction, int minFunction, int maxVariable, int minVariable, String distributionFile) throws Exception {
        if (distributionFile == null) {
            throw new AssaException("Please specify the distribution file!");
        }
        if (maxFunction == 0 || maxVariable == 0) {
            maxVariable = n > 10 ? 10 : n;
            maxFunction = 5;
        }
        if ((double)maxFunction > Math.pow(2.0, n)) {
            throw new Exception("Max function number is too large!");
        }
        if (maxFunction > 20) {
            this.assalog.println("Max function number is over 20. Consider changing to smaller one!");
        }
        if (maxVariable > n) {
            throw new Exception("Max variable number is too large!");
        }
        if (maxVariable > 20) {
            this.assalog.println("Max variable number is over 20. Consider changing to smaller one!");
        }
        if (minFunction <= 0) {
            minFunction = 1;
            this.assalog.println("Minimum function number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        if (minVariable <= 0) {
            minVariable = 1;
            this.assalog.println("Minimum variable number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int diffVar = maxVariable - minVariable + 1;
        double[] distribution = new double[diffVar];
        File file = new File(distributionFile);
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(file));
        String tempString = null;
        int count = 0;
        tempString = reader.readLine();
        if (tempString != null) {
            StringTokenizer st = new StringTokenizer(tempString);
            while (st.hasMoreTokens()) {
                distribution[count] = Double.parseDouble(st.nextToken());
                if (count > 0) {
                    int n2 = count;
                    distribution[n2] = distribution[n2] + distribution[count - 1];
                }
                ++count;
            }
        }
        int i = 0;
        while (i < nf.length) {
            double random = rng.randomUnifDouble();
            count = 0;
            while (random > distribution[count]) {
                ++count;
            }
            nf[i] = count + minFunction;
            int j = 0;
            while (j < nf[i]) {
                random = rng.randomUnifDouble();
                count = 0;
                while (random > distribution[count]) {
                    ++count;
                }
                nv.add(count + minVariable);
                ++j;
            }
            ++i;
        }
        Model m = io.generateRandomModel(n, nf, nv, perturbation);
        BDDPBN pbn = m.convertToBDDPBN();
        this.assalog.println("The density of the generated PBN is " + pbn.density() + ".");
        return pbn;
    }

    public BitSetPBN generatePBN(int n, String fileName, double perturbation, int type, int maxFunctionNum, int maxVariableNum, int minFunctionNum, int minVariableNum) throws Exception {
        if (perturbation < 0.0) {
            perturbation = RandomProvider.getInstance().getRandom().nextDouble();
        }
        BitSetPBN pbn = this.defineBitSetPBN(n, perturbation, maxFunctionNum, minFunctionNum, maxVariableNum, minVariableNum);
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        if (fileName == null || fileName.equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
            fileName = "model/PBN_Node" + n + "_" + df.format(new Date());
        }
        switch (type) {
            case 0: {
                exp.exportPBN(pbn, fileName);
                break;
            }
            case 1: {
                exp.exportPBNtoMatlab(pbn, fileName);
                break;
            }
            case 2: {
                exp.exportPBN(pbn, String.valueOf(fileName) + ".txt");
                exp.exportPBNtoMatlab(pbn, String.valueOf(fileName) + ".m");
                break;
            }
            default: {
                this.assalog.println("The export type is not recognized!");
            }
        }
        return pbn;
    }

    public BitSetPBN generatePBNExpression(int n, String fileName, double perturbation, int type, int maxFunctionNum, int maxVariableNum, int minFunctionNum, int minVariableNum, String distributionFile) throws Exception {
        if (perturbation < 0.0) {
            perturbation = RandomProvider.getInstance().getRandom().nextDouble();
        }
        BitSetPBN pbn = distributionFile == null ? this.defineBitSetPBNFromExpression(n, perturbation, maxFunctionNum, minFunctionNum, maxVariableNum, minVariableNum) : this.defineBitSetPBNFromExpression(n, perturbation, maxFunctionNum, minFunctionNum, maxVariableNum, minVariableNum, distributionFile);
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        if (fileName == null || fileName.equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
            fileName = "model/PBN_Node" + n + "_" + df.format(new Date());
        }
        switch (type) {
            case 0: {
                exp.exportPBN(pbn, fileName);
                break;
            }
            case 1: {
                exp.exportPBNtoMatlab(pbn, fileName);
                break;
            }
            case 2: {
                exp.exportPBN(pbn, String.valueOf(fileName) + ".txt");
                exp.exportPBNtoMatlab(pbn, String.valueOf(fileName) + ".m");
                break;
            }
            default: {
                this.assalog.println("The export type is not recognized!");
            }
        }
        return pbn;
    }

    private BitSetPBN generateHighLevelPBN(int n, String fileName, double perturbation, int type, int maxFunctionNum, int maxVariableNum, int minFunctionNum, int minVariableNum, String distributionFile) throws Exception {
        if (perturbation < 0.0) {
            perturbation = RandomProvider.getInstance().getRandom().nextDouble();
        }
        BDDPBN pbn = (BDDPBN)this.defineHighLevelPBN(n, perturbation, maxFunctionNum, minFunctionNum, maxVariableNum, minVariableNum, distributionFile);
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        if (fileName == null || fileName.equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
            fileName = "model/PBN_Node" + n + "_" + df.format(new Date());
        }
        switch (type) {
            case 0: {
                exp.exportPBN(pbn, fileName);
                break;
            }
            case 1: {
                exp.exportPBNtoMatlab(pbn, fileName);
                break;
            }
            case 2: {
                exp.exportPBN(pbn, String.valueOf(fileName) + ".txt");
                exp.exportPBNtoMatlab(pbn, String.valueOf(fileName) + ".m");
                break;
            }
            case 3: {
                exp.exportHighlevelModel(pbn.getModel(), fileName, null);
                break;
            }
            default: {
                this.assalog.println("Using default export type!");
                exp.exportHighlevelModel(pbn.getModel(), fileName, null);
            }
        }
        return pbn;
    }

    public BitSetPBN generatePBNfromFile(String fromFile, int type, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.generatePBNFromFile(fromFile);
        switch (type) {
            case 0: {
                io.exportPBN(pbn, outputName);
                break;
            }
            case 1: {
                io.exportPBNtoMatlab(pbn, outputName);
                break;
            }
            case 2: {
                io.exportPBN(pbn, String.valueOf(outputName) + ".txt");
                io.exportPBNtoMatlab(pbn, String.valueOf(outputName) + ".m");
                break;
            }
        }
        return pbn;
    }

    public void runTwoStateBitSet(double precision, double confidence, String modelFileName, String property, String outputName, boolean globalAlias) throws Exception {
        TwoStateBitSet ts = new TwoStateBitSet(this.assalog, precision, confidence, Parameters.epsilon, 1);
        double average = 0.0;
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the two state Markov chain approach on the PBN from file " + modelFileName);
        if (outputName != null) {
            ts.setLogFile(outputName);
        } else {
            outputName = ts.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        StateBit initialState = new StateBit(0);
        int sampleSize = 0;
        double cpuTime = 0.0;
        if (!globalAlias) {
            ts.setDisableGlobalAlias(true);
        }
        ts.setExpressions(ParseProperty.getProperties(pbn, property));
        double[] result = ts.run((PBN)pbn, initialState);
        double time = result[3];
        this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + (sampleSize += (int)result[1]) + "\nProbability\t" + (average += result[0]) + "\nCPU time cost\t" + (cpuTime += result[2]) + " s\nTime cost\t" + time);
    }

    public void runTwoStateBitSetOpt(double precision, double confidence, String modelFileName, String property, String outputName, boolean globalAlias, int groupFunctionStoreType, int maxElementNum, int maxCredit) throws Exception {
        if (maxElementNum != 0) {
            Parameters.DEFAULT_SPARSE_NUMBER = maxElementNum;
            Parameters.DEFAULT_MTBDD_NUMBER = maxElementNum;
        }
        if (maxCredit != 0) {
            Parameters.MAX_CREDIT = maxCredit;
        }
        if (groupFunctionStoreType > 1 || groupFunctionStoreType == 1) {
            this.runTwoStateBitSetOptSingleChain(precision, confidence, modelFileName, property, outputName, globalAlias, groupFunctionStoreType);
        } else {
            String graphFileName = String.valueOf(modelFileName) + ".gra";
            double average = 0.0;
            this.assalog.printSeparator();
            BitSetPBNIO io = new BitSetPBNIO(this.assalog);
            BitSetPBN pbn = io.loadPBN(modelFileName);
            io.exportPBNtoGraph(pbn, graphFileName);
            OptimizePBN opt = new OptimizePBN(modelFileName, this.assalog);
            opt.setPropertyFile(property);
            opt.setGroupFunctionStore(groupFunctionStoreType);
            opt.run(graphFileName);
            GelmanFullStatePara ts = new GelmanFullStatePara(pbn, this.assalog, precision, confidence, 1);
            ts.setNumLeaves(opt.getNumLeaves());
            ts.setOptimizePBN(opt);
            this.assalog.printSeparator();
            property = opt.getPropertyFile();
            modelFileName = opt.getPBNFile();
            int tmplevel = Parameters.printlevel;
            Parameters.printlevel = 0;
            pbn = io.loadPBN(modelFileName);
            Parameters.printlevel = tmplevel;
            this.assalog.println("Performing " + ts.getInstanceName() + " on the PBN from file " + modelFileName);
            if (outputName != null) {
                ts.setLogFile(outputName);
            } else {
                outputName = ts.getLogFile();
            }
            this.assalog.println("Detailed information is stored in the file " + outputName + ".");
            int sampleSize = 0;
            double cpuTime = 0.0;
            if (!globalAlias) {
                ts.setDisableGlobalAlias(true);
            }
            ts.setExpressions(ParseProperty.getProperties(pbn, property));
            double[] result = ts.run(pbn);
            double time = result[3];
            this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + (sampleSize += (int)result[1]) + "\nProbability\t" + (average += result[0]) + "\nCPU time cost\t" + (cpuTime += result[2]) + " s\nTime cost\t" + time);
        }
    }

    public void runTwoStateBitSetReduce(double precision, double confidence, String modelFileName, String property, String outputName, boolean globalAlias) throws Exception {
        String graphFileName = String.valueOf(modelFileName) + ".gra";
        double average = 0.0;
        this.assalog.printSeparator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        io.exportPBNtoGraph(pbn, graphFileName);
        ReducePBN opt = new ReducePBN(modelFileName, this.assalog);
        opt.setPropertyFile(property);
        opt.run(graphFileName);
        GelmanFullStateReducedModel ts = new GelmanFullStateReducedModel(pbn, this.assalog, precision, confidence, 1);
        ts.setNumLeaves(opt.getNumLeaves());
        ts.setOptimizePBN(opt);
        this.assalog.printSeparator();
        property = opt.getPropertyFile();
        modelFileName = opt.getPBNFile();
        int tmplevel = Parameters.printlevel;
        Parameters.printlevel = 0;
        pbn = io.loadPBN(modelFileName);
        Parameters.printlevel = tmplevel;
        this.assalog.println("Performing " + ts.getInstanceName() + " on the PBN from file " + modelFileName);
        if (outputName != null) {
            ts.setLogFile(outputName);
        } else {
            outputName = ts.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double cpuTime = 0.0;
        if (!globalAlias) {
            ts.setDisableGlobalAlias(true);
        }
        ts.setExpressions(ParseProperty.getProperties(pbn, property));
        double[] result = ts.run(pbn);
        double time = result[3];
        this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + (sampleSize += (int)result[1]) + "\nProbability\t" + (average += result[0]) + "\nCPU time cost\t" + (cpuTime += result[2]) + " s\nTime cost\t" + time);
    }

    public void runGermanOpt(double precision, double confidence, String modelFileName, String property, String outputName, boolean globalAlias, int groupFunctionStoreType, int maxElementNum, int maxCredit) throws Exception {
        if (maxElementNum != 0) {
            Parameters.DEFAULT_SPARSE_NUMBER = maxElementNum;
            Parameters.DEFAULT_MTBDD_NUMBER = maxElementNum;
        }
        if (maxCredit != 0) {
            Parameters.MAX_CREDIT = maxCredit;
        }
        this.assalog.printSeparator();
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.assalog.println("number of processors: " + nThreads);
        if (Parameters.NUM_PARALLEL > nThreads) {
            Parameters.NUM_PARALLEL = nThreads;
            this.assalog.println("number of chains is set to " + Parameters.NUM_PARALLEL + ".");
        }
        String graphFileName = String.valueOf(modelFileName) + ".gra";
        double average = 0.0;
        this.assalog.printSeparator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        io.exportPBNtoGraph(pbn, graphFileName);
        OptimizePBN opt = new OptimizePBN(modelFileName, this.assalog);
        opt.setPropertyFile(property);
        opt.setGroupFunctionStore(groupFunctionStoreType);
        opt.run(graphFileName);
        GermanAndStructure ts = new GermanAndStructure(pbn, this.assalog, precision, confidence, 1);
        ts.setNumLeaves(opt.getNumLeaves());
        ts.setOptimizePBN(opt);
        property = opt.getPropertyFile();
        modelFileName = opt.getPBNFile();
        int tmplevel = Parameters.printlevel;
        Parameters.printlevel = 0;
        pbn = io.loadPBN(modelFileName);
        Parameters.printlevel = tmplevel;
        this.assalog.println("Performing " + ts.getInstanceName() + " on the PBN from file " + modelFileName);
        if (outputName != null) {
            ts.setLogFile(outputName);
        } else {
            outputName = ts.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double cpuTime = 0.0;
        if (!globalAlias) {
            ts.setDisableGlobalAlias(true);
        }
        ts.setExpressions(ParseProperty.getProperties(pbn, property));
        double[] result = ts.run(pbn);
        double time = result[3];
        this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + (sampleSize += (int)result[1]) + "\nProbability\t" + (average += result[0]) + "\nCPU time cost\t" + (cpuTime += result[2]) + " s\nTime cost\t" + time);
    }

    private void runGelmanOneCore(double precision, double confidence, String modelFileName, String property, String outputName, boolean globalAlias) throws Exception {
        double average = 0.0;
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        Gelman gelman = new Gelman(pbn, this.assalog);
        this.assalog.println("Performing the Gelman and Rubin approach on the PBN from file " + modelFileName);
        if (outputName != null) {
            gelman.setLogFile(outputName);
        } else {
            outputName = gelman.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        gelman.setParameters(precision, confidence);
        gelman.setExpressions(ParseProperty.getProperties(pbn, property));
        double[] result = gelman.run(pbn);
        int sampleSize = (int)result[1];
        double cpuTime = result[2];
        double time = result[3];
        this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + sampleSize + "\nProbability\t" + (average += result[0]) + "\nCPU time cost\t" + cpuTime + " s\nTime cost\t" + time);
    }

    private void runTwoStateBitSetOptSingleChain(double precision, double confidence, String modelFileName, String property, String outputName, boolean globalAlias, int groupFunctionStoreType) throws Exception {
        Parameters.NUM_PARALLEL = 1;
        if (groupFunctionStoreType == 2) {
            groupFunctionStoreType = 0;
        }
        TwoStateBitSetPara ts = null;
        switch (groupFunctionStoreType) {
            case 1: {
                ts = new TwoStateMTBDDPara(this.assalog, precision, confidence, Parameters.epsilon, 1);
                break;
            }
            case 0: {
                ts = new TwoStateBitSetPara(this.assalog, precision, confidence, Parameters.epsilon, 1);
            }
        }
        String graphFileName = String.valueOf(modelFileName) + ".gra";
        double average = 0.0;
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        io.exportPBNtoGraph(pbn, graphFileName);
        OptimizePBN opt = new OptimizePBN(modelFileName, this.assalog);
        opt.setPropertyFile(property);
        opt.setGroupFunctionStore(groupFunctionStoreType);
        opt.run(graphFileName);
        ts.setNumLeaves(opt.getNumLeaves());
        ts.setOptimizePBN(opt);
        property = opt.getPropertyFile();
        modelFileName = opt.getPBNFile();
        int tmplevel = Parameters.printlevel;
        Parameters.printlevel = 0;
        pbn = io.loadPBN(modelFileName);
        Parameters.printlevel = tmplevel;
        ts.setInstanceName();
        this.assalog.println("Performing " + ts.getInstanceName() + " on the PBN from file " + modelFileName);
        if (outputName != null) {
            ts.setLogFile(outputName);
        } else {
            outputName = ts.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double cpuTime = 0.0;
        if (!globalAlias) {
            ts.setDisableGlobalAlias(true);
        }
        ts.setExpressions(ParseProperty.getProperties(pbn, property));
        double[] result = ts.run(pbn);
        double time = result[3];
        this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + (sampleSize += (int)result[1]) + "\nProbability\t" + (average += result[0]) + "\nCPU time cost\t" + (cpuTime += result[2]) + " s\nTime cost\t" + time);
    }

    private void runTwoStateBitSetGPU(double precision, double confidence, String modelFileName, String property, String outputName, int block, int blockSize) {
        GermanGPU sm = new GermanGPU(this.assalog);
        BitSetPBN pbn = null;
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        try {
            pbn = io.loadPBN(modelFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((SimulationMethod)sm).setPBN(pbn);
        if (outputName != null) {
            ((SimulationMethod)sm).setLogFile(outputName);
        } else {
            outputName = ((SimulationMethod)sm).getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        try {
            ((SimulationMethod)sm).setExpressions(ParseProperty.getProperties(pbn, property));
            if (block != 0) {
                ((SimulationMethod)sm).setParameters(new double[]{precision, confidence, Parameters.epsilon, block, blockSize});
            } else {
                ((SimulationMethod)sm).setParameters(new double[]{precision, confidence});
            }
            double[] result = ((SimulationMethod)sm).run(pbn);
            this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + result[1] + "\nProbability\t" + result[0] + "\nTotal time cost\t" + result[2] + " s\nGPU Time\t" + result[3]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runTwostateParallelSingleProperty(String pbnName, String property, double precision, int m, int kstep, double confidence, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(pbnName);
        GelmanFullStateParallel gelman = new GelmanFullStateParallel(pbn, this.assalog);
        if (outputName != null) {
            gelman.setLogFile(outputName);
        } else {
            outputName = gelman.getLogFile();
        }
        this.assalog.println("Run the two-state approach in parallel for computing " + pbnName + " for property " + property + "...");
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.assalog.println("number of processors: " + nThreads);
        gelman.setExpressions(ParseProperty.getProperties(pbn, property));
        gelman.setParameters(precision, confidence);
        if (m > nThreads) {
            this.assalog.println("Required number of chains is " + m + ", the program sets it to " + nThreads + " (the number of processors in the computer).\n");
            m = nThreads;
        }
        gelman.setM(m);
        gelman.setKstep(kstep);
        long start = System.nanoTime();
        double[] re = gelman.computeSteadyState();
        start = System.nanoTime() - start;
        gelman.printStatistic();
        this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + re[1] + "\nProbability\t" + re[0] + "\nTotal time cost\t" + (double)start / 1.0E9 + " s");
    }

    public void runTwostateParallelSinglePropertyNoBurnIn(String pbnName, String property, double precision, int m, int kstep, double confidence, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(pbnName);
        GelmanFullStateNoInitial gelman = new GelmanFullStateNoInitial(pbn, this.assalog);
        if (outputName != null) {
            gelman.setLogFile(outputName);
        } else {
            outputName = gelman.getLogFile();
        }
        this.assalog.println("Run the two-state approach in parallel (No initial) for computing " + pbnName + " for property " + property + "...");
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.assalog.println("number of processors: " + nThreads);
        gelman.setExpressions(ParseProperty.getProperties(pbn, property));
        gelman.setParameters(precision, confidence);
        if (m > nThreads) {
            this.assalog.println("Required number of chains is " + m + ", the program sets it to " + nThreads + " (the number of processors in the computer).\n");
            m = nThreads;
        }
        gelman.setM(m);
        gelman.setKstep(kstep);
        long start = System.nanoTime();
        double[] re = gelman.computeSteadyState();
        start = System.nanoTime() - start;
        gelman.printStatistic();
        this.assalog.println("Precision\t" + precision + "\nConfidence Level\t" + confidence + "\nSample size\t" + re[1] + "\nProbability\t" + re[0] + "\nGerman report Time\t" + re[2] + " s" + "\nTotal time cost\t" + (double)start / 1.0E9 + " s");
    }

    public void runTwoStateParallelMultipleProperties(String pbnName, String property, double precision, int m, int kstep, double confidence, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(pbnName);
        TwostateMultiPropertyParallel tsmp = new TwostateMultiPropertyParallel(pbn, this.assalog);
        if (outputName != null) {
            tsmp.setLogFile(outputName);
        } else {
            outputName = tsmp.getLogFile();
        }
        this.assalog.println("Run the two-state method in parallel for computing " + pbnName + " for property " + property + "...");
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.assalog.println("number of processors: " + nThreads);
        tsmp.setExpressions(ParseProperty.getProperties(pbn, property));
        tsmp.setParameters(precision, confidence);
        if (m > nThreads) {
            this.assalog.println("Required number of chains is " + m + ", the program sets it to " + nThreads + " (the number of processors in the computer).\n");
            m = nThreads;
        }
        tsmp.setM(m);
        tsmp.setKstep(kstep);
        long start = System.nanoTime();
        double[][] re = tsmp.computeSteadyState();
        start = System.nanoTime() - start;
        tsmp.printStatistic();
        this.assalog.println("Total time cost: " + (double)start / 1.0E9);
        int i = 0;
        while (i < re[0].length) {
            this.assalog.println("Property " + i + ": ");
            this.assalog.println("\t probability\t" + re[0][i] + "\trequired sample size\t" + re[1][i] + "\tactual sample size\t" + re[2][i]);
            ++i;
        }
    }

    public void runStepPerfectSimulation(String modelFileName, String propertyFileName, double confidence, double precision, String outputName, boolean useAlias, boolean cost) throws Exception {
        StepPerfectSimulationWalkerBitSet ps = StepPerfectSimulationWalkerBitSet.getInstance();
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = exp.loadPBN(modelFileName);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        if (outputName == null) {
            outputName = "ps_" + df.format(new Date()) + ".txt";
        }
        ps.setIO(pbn, outputName);
        ps.setSampleSize(confidence, precision);
        ps.setUseAlias(useAlias);
        if (cost) {
            ps.setCost(true);
        }
        double average = 0.0;
        double sampleSize = 0.0;
        double simulationStep = 0.0;
        double couplingStep = 0.0;
        double cpu = 0.0;
        this.assalog.println("Performing the perfect simulation algorithm on the PBN from file " + modelFileName);
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        double[] result = ps.runWalker(propertyFileName, 1000, true);
        this.assalog.println("Avg. coupling steps\t" + (couplingStep += result[1]) + "\nSimulation steps\t" + (simulationStep += result[2]) + "\nNumber of samples\t" + (int)(sampleSize += result[3]) + "\nCPU time cost\t\t" + (cpu += result[4]) + "s\nProbability\t\t" + (average += result[0]));
    }

    public void runPBNIO(String PBNfile, String outputName, int type) throws Exception {
        BitSetPBNIO pbnIO = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = pbnIO.loadPBN(PBNfile);
        this.assalog.println("Start exporting model...");
        switch (type) {
            case 0: {
                pbnIO.exportPBN(pbn, outputName);
                break;
            }
            case 1: {
                pbnIO.exportPBNtoMatlab(pbn, outputName);
                break;
            }
            case 2: {
                pbnIO.exportPBN(pbn, String.valueOf(outputName) + ".txt");
                pbnIO.exportPBNtoMatlab(pbn, String.valueOf(outputName) + ".m");
                break;
            }
            case 3: {
                pbnIO.exportPBNtoGenYsis(pbn, String.valueOf(outputName) + ".net");
                break;
            }
            case 4: {
                pbnIO.exportPBNtoMCMAS(pbn, String.valueOf(outputName) + ".ispl");
                break;
            }
            case 5: {
                pbnIO.exportPBNtoMCMASWithOrder(pbn, String.valueOf(outputName) + "-withorder.ispl");
                break;
            }
            case 6: {
                pbnIO.exportPBNtoMCMASHeuristic1(pbn, String.valueOf(outputName) + "-heuristic1.ispl");
                break;
            }
            case 7: {
                pbnIO.exportPBNtoMCMASForceHeuristic(pbn, String.valueOf(outputName) + "-force.ispl");
                break;
            }
            case 8: {
                pbnIO.exportPBNtoMCMASWithOrder2(pbn, String.valueOf(outputName) + "-withorder2.ispl");
                break;
            }
            case 9: {
                pbnIO.exportPBNtoDot(pbn, String.valueOf(outputName) + ".dot");
                break;
            }
        }
    }

    public void simulate(String PBNfile, String outputName, long length) throws Exception {
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        exp.loadPBN(PBNfile);
        exp.simulate(length, null, true, outputName);
    }

    public void simulate(String modelFileName, long length, String property, int groupFunctionStoreType) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        io.simulate(modelFileName, property, groupFunctionStoreType, length, null);
    }

    public void BDDsimulate(String PBNfile, String outputName, long length) throws Exception {
        JDD.InitialiseCUDD(2048000L, 1.0E-15);
        Model m = new Model(this.assalog);
        m.loadModel(PBNfile);
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        PBN pbn = exp.loadPBN(m, 1);
        exp.simulate(length, null, true, outputName);
        if (pbn instanceof BDDPBN) {
            ((BDDPBN)pbn).closeJDD();
        }
        m.close();
        this.closeJDD();
    }

    public void runSkartPBN(double precision, double confidence, String modelFileName, String property, String outputName, boolean globalAlias) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the Skart method on the PBN from file " + modelFileName);
        SkartPBN skart = new SkartPBN(pbn, this.assalog);
        skart.setExpressions(ParseProperty.getProperties(pbn, property));
        skart.setAlpha(1.0 - confidence);
        skart.setPrecision(precision);
        if (!globalAlias) {
            skart.setDisableGlobalAlias(true);
        }
        if (outputName != null) {
            skart.setLogFile(outputName);
        } else {
            outputName = skart.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double halfLength = 0.0;
        double timeCost = 0.0;
        double average = 0.0;
        double[] estimate = skart.run();
        halfLength = estimate[2] - estimate[0];
        this.assalog.println("Sample size\t" + (sampleSize += (int)estimate[3]) + "\nProbability\t" + (average += estimate[2]) + "\nCI half-length\t" + halfLength + "\nCPU time cost\t" + (timeCost += estimate[4]) + "s");
    }

    public void runSkartPBNLarge(double precision, double confidence, String modelFileName, String property, String outputName, boolean globalAlias) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the full version Skart method on the PBN from file " + modelFileName + ".");
        SkartPBNLarge skart = new SkartPBNLarge(pbn, this.assalog);
        skart.setExpressions(ParseProperty.getProperties(pbn, property));
        skart.setAlpha(1.0 - confidence);
        skart.setPrecision(precision);
        if (!globalAlias) {
            skart.setDisableGlobalAlias(true);
        }
        if (outputName != null) {
            skart.setLogFile(outputName);
        } else {
            outputName = skart.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double halfLength = 0.0;
        double timeCost = 0.0;
        double average = 0.0;
        double[] estimate = skart.run();
        halfLength = estimate[2] - estimate[0];
        this.assalog.println("Sample size\t" + (sampleSize += (int)estimate[3]) + "\nProbability\t" + (average += estimate[2]) + "\nCI half-length\t" + halfLength + "\nCPU time cost\t" + (timeCost += estimate[4]) + "s");
    }

    public void runSkartParallel(String pbnName, String property, double precision, double confidence, int m, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(pbnName);
        this.assalog.println("Performing the Skart method (parallel version) to analyse " + property + " for model " + pbnName + "...");
        SkartPBNParallel skart = new SkartPBNParallel(pbn, this.assalog);
        if (outputName != null) {
            skart.setLogFile(outputName);
        } else {
            outputName = skart.getLogFile();
        }
        int nThreads = Runtime.getRuntime().availableProcessors();
        if (m > nThreads) {
            this.assalog.println("Required number of chains is " + m + ", the program sets it to " + nThreads + " (the number of processors in the computer).\n");
            m = nThreads;
        }
        skart.setM(m);
        skart.setExpressions(ParseProperty.getProperties(pbn, property));
        skart.setPrecision(precision);
        skart.setAlpha(1.0 - confidence);
        double[] re = skart.run();
        this.assalog.println("Precision=" + precision + ", confidence=" + confidence + ", number of chains=" + m);
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        this.assalog.println("the CI low value\t" + re[0]);
        this.assalog.println("the CI high value\t" + re[1]);
        this.assalog.println("the average value\t" + re[2]);
        this.assalog.println("the sample size\t\t" + re[3]);
        this.assalog.println("the time cost\t\t" + re[5]);
        this.assalog.println("extention step2\t\t" + re[6]);
        this.assalog.println("extention step5\t\t" + re[7]);
    }

    public void runParameterEstimation(String[] fileNames, String parameterFile, String propertyFile, double precision, double confidence, int simulationMethod, int m, boolean parallel, int evaluateMethod, int startPoint, int numberParticles, int numberIterations, double stopThreshold, boolean adaptive) {
        Estimate est = new Estimate(this.assalog);
        try {
            est.setStopThreshold(stopThreshold);
            est.run(fileNames, parameterFile, propertyFile, precision, confidence, simulationMethod, m, parallel, evaluateMethod, numberParticles, numberIterations, startPoint, adaptive);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void nodeInfluenceAnalysis(String fineName, int sourceNodeIndex, int targetNodeIndex, int simulationMethod, double precision, double confidence) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        double[] parameters = new double[]{precision, confidence};
        if (simulationMethod == 0 || simulationMethod == 1) {
            simulationMethod = 3;
        }
        SimulationMethod sm = this.smProvider(simulationMethod);
        sm.setParameters(parameters);
        try {
            BitSetPBN pbn = io.loadPBN(fineName);
            LongtermInfluence influence = new LongtermInfluence(pbn, sm, this.assalog);
            influence.computeInfluenceNode(sourceNodeIndex, targetNodeIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void functionInfluenceAnalysis(String fineName, int sourceNodeIndex, int targetNodeIndex, int targetFunctionIndex, int simulationMethod, double precision, double confidence) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        double[] parameters = new double[]{precision, confidence};
        SimulationMethod sm = this.smProvider(simulationMethod);
        sm.setParameters(parameters);
        try {
            BitSetPBN pbn = io.loadPBN(fineName);
            LongtermInfluence influence = new LongtermInfluence(pbn, sm, this.assalog);
            influence.computeInfluenceFunction(sourceNodeIndex, targetNodeIndex, targetFunctionIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void nodeSensitivityAnalysis(String fineName, int targetNodeIndex, int simulationMethod, double precision, double confidence) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        double[] parameters = new double[]{precision, confidence};
        SimulationMethod sm = this.smProvider(simulationMethod);
        sm.setParameters(parameters);
        try {
            BitSetPBN pbn = io.loadPBN(fineName);
            LongtermInfluence influence = new LongtermInfluence(pbn, sm, this.assalog);
            influence.computeSensitivityNode(targetNodeIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void functionSensitivityAnalysis(String fineName, int targetNodeIndex, int targetFunction, int simulationMethod, double precision, double confidence) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        double[] parameters = new double[]{precision, confidence};
        SimulationMethod sm = this.smProvider(simulationMethod);
        sm.setParameters(parameters);
        try {
            BitSetPBN pbn = io.loadPBN(fineName);
            LongtermInfluence influence = new LongtermInfluence(pbn, sm, this.assalog);
            influence.computeSensitivityFunction(targetNodeIndex, targetFunction);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void perturbeSensitivityAnalysis(String fineName1, String fineName2, List<Integer> nodeIndices, int simulationMethod, double precision, double confidence) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        double[] parameters = new double[]{precision, confidence};
        SimulationMethod sm = this.smProvider(simulationMethod);
        sm.setParameters(parameters);
        try {
            BitSetPBN pbn1 = io.loadPBN(fineName1);
            BitSetPBN pbn2 = io.loadPBN(fineName2);
            LongtermSensitivity sensitivity = new LongtermSensitivity(pbn1, pbn2, sm, this.assalog);
            sensitivity.computeSensitivity(nodeIndices);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SimulationMethod smProvider(int simulationMethod) {
        SimulationMethod sm;
        switch (simulationMethod) {
            case 0: {
                sm = new TwoStateBitSet(this.assalog);
                break;
            }
            case 1: {
                sm = new GelmanFullStateParallel(null, this.assalog);
                break;
            }
            case 2: {
                sm = new TwostateMultiPropertyParallel(null, this.assalog);
                break;
            }
            case 3: {
                sm = new TwoStateMultiProperty(this.assalog);
                break;
            }
            default: {
                sm = new TwoStateBitSet(this.assalog);
            }
        }
        return sm;
    }

    public void runChowLiu(String pbnName, String property, double precision, double confidence) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(pbnName);
        ChouLiu cl = new ChouLiu(this.assalog);
        cl.setPBN(pbn);
        cl.constructParent(precision, confidence);
        Property propertyPass = ParseProperty.getProperties(pbn, property).get(0);
        this.assalog.println("Run the ChouLiuTree method for computing " + pbnName + " for property " + property + "...");
        this.assalog.println("result = " + cl.computeSteadyState(propertyPass));
    }

    public void run(String[] args) throws Exception {
        boolean gee = false;
        boolean gef = false;
        boolean skart = false;
        boolean ts = false;
        boolean ge = false;
        boolean cost = false;
        boolean skartLarge = false;
        boolean help = false;
        boolean gauss = false;
        boolean jacobi = false;
        boolean ps = false;
        boolean io = false;
        boolean isMatlab = false;
        boolean globalAlias = true;
        double precision = 0.01;
        double confidence = 0.95;
        double perturbation = 0.01;
        int maxFunction = 0;
        int maxVariable = 0;
        int maxIteration = 0;
        String parameterFileName = "";
        String modelFileName = "";
        String propertyName = "";
        String outputName = null;
        String distributionFile = null;
        String console = null;
        int n = 0;
        int i = 0;
        int type = 7;
        int groupFunctionStoreType = 0;
        int m = 1;
        int kstep = 1;
        int minFunction = 0;
        int minVariable = 0;
        PrintWriter pw = null;
        if (args == null || args.length == 0) {
            help = true;
        } else if (args[0].equals("-gee")) {
            gee = true;
            n = Integer.parseInt(args[++i]);
            perturbation = Double.parseDouble(args[++i]);
            modelFileName = args.length > ++i ? args[i] : null;
            type = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                maxFunction = Integer.parseInt(args[i]);
                minFunction = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                maxVariable = Integer.parseInt(args[i]);
                minVariable = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                distributionFile = args[i];
            }
        } else if (args[0].equals("-ge")) {
            ge = true;
            n = Integer.parseInt(args[++i]);
            perturbation = Double.parseDouble(args[++i]);
            modelFileName = args.length > ++i ? args[i] : null;
            type = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                maxFunction = Integer.parseInt(args[i]);
                minFunction = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                maxVariable = Integer.parseInt(args[i]);
                minVariable = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-gef")) {
            gef = true;
            parameterFileName = args[++i];
            outputName = args[++i];
            type = Integer.parseInt(args[++i]);
        } else if (args[0].equals("-geh")) {
            n = Integer.parseInt(args[++i]);
            perturbation = Double.parseDouble(args[++i]);
            modelFileName = args.length > ++i ? args[i] : null;
            type = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                maxFunction = Integer.parseInt(args[i]);
                minFunction = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                maxVariable = Integer.parseInt(args[i]);
                minVariable = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                distributionFile = args[i];
            }
            this.generateHighLevelPBN(n, modelFileName, perturbation, type, maxFunction, maxVariable, minFunction, minVariable, distributionFile);
        } else if (args[0].equals("-gh")) {
            n = Integer.parseInt(args[++i]);
            perturbation = Double.parseDouble(args[++i]);
            modelFileName = args.length > ++i ? args[i] : null;
            while (args.length > ++i) {
                String str = args[i].toLowerCase();
                if (str.equals("-dis")) {
                    distributionFile = args[++i];
                    continue;
                }
                if (str.equals("-console")) {
                    console = args[++i];
                    pw = new PrintWriter(console);
                    this.assalog = new AssaFileLog(pw);
                    continue;
                }
                if (str.equals("-mfun")) {
                    maxFunction = Integer.parseInt(args[++i]);
                    minFunction = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-mvar")) {
                    maxVariable = Integer.parseInt(args[++i]);
                    minVariable = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-type")) {
                    type = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-leaves")) {
                    Parameters.leaves = Double.parseDouble(args[++i]);
                    continue;
                }
                throw new AssaException("Unknown parameters!");
            }
            if (args.length > ++i) {
                maxFunction = Integer.parseInt(args[i]);
                minFunction = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                maxVariable = Integer.parseInt(args[i]);
                minVariable = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                distributionFile = args[i];
            }
            this.generateHighLevelPBN(n, modelFileName, perturbation, type, maxFunction, maxVariable, minFunction, minVariable, distributionFile);
        } else if (args[0].equals("-io")) {
            io = true;
            modelFileName = args[++i];
            isMatlab = Boolean.parseBoolean(args[++i]);
            outputName = args[++i];
            type = Integer.parseInt(args[++i]);
        } else if (args[0].equals("-gauss")) {
            gauss = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            propertyName = args[++i].equals("-dis") ? null : args[i];
            if (args.length > ++i) {
                precision = Double.parseDouble(args[i]);
                maxIteration = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-jacobi")) {
            jacobi = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            propertyName = args[++i].equals("-dis") ? null : args[i];
            if (args.length > ++i) {
                precision = Double.parseDouble(args[i]);
                maxIteration = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-ps")) {
            ps = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-global")) {
                    globalAlias = Boolean.parseBoolean(args[++i]);
                } else {
                    cost = Boolean.parseBoolean(args[i]);
                }
            }
            if (args.length > ++i) {
                cost = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-ts")) {
            ts = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            while (args.length > ++i) {
                String str = args[i].toLowerCase();
                if (str.equals("-log")) {
                    outputName = args[++i];
                    continue;
                }
                if (str.equals("-console")) {
                    console = args[++i];
                    pw = new PrintWriter(console);
                    this.assalog = new AssaFileLog(pw);
                    continue;
                }
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-tsGPU")) {
            modelFileName = args[++i];
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            int block = 0;
            int blockSize = 0;
            while (args.length > ++i) {
                String str = args[i].toLowerCase();
                if (str.equals("-log")) {
                    outputName = args[++i];
                    continue;
                }
                if (str.equals("-console")) {
                    console = args[++i];
                    pw = new PrintWriter(console);
                    this.assalog = new AssaFileLog(pw);
                    continue;
                }
                if (str.equals("-block")) {
                    block = Integer.parseInt(args[++i]);
                    blockSize = Integer.parseInt(args[++i]);
                    continue;
                }
                globalAlias = Boolean.parseBoolean(args[i]);
            }
            this.runTwoStateBitSetGPU(precision, confidence, modelFileName, propertyName, outputName, block, blockSize);
        } else if (args[0].equalsIgnoreCase("-tsOpt")) {
            modelFileName = args[++i];
            int maxElementNum = 0;
            int maxCredit = 0;
            int sizeOne = 0;
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            while (args.length > ++i) {
                String str = args[i].toLowerCase();
                if (str.equals("-group")) {
                    groupFunctionStoreType = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-maxe")) {
                    maxElementNum = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-maxc")) {
                    maxCredit = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-sizeone")) {
                    Parameters.SIZE_ONE_FUNCTION_GROUP = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-m")) {
                    Parameters.NUM_PARALLEL = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-psize")) {
                    Parameters.P_GROUPSIZE = sizeOne = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-log")) {
                    outputName = args[++i];
                    continue;
                }
                if (str.equals("-console")) {
                    console = args[++i];
                    pw = new PrintWriter(console);
                    this.assalog = new AssaFileLog(pw);
                    continue;
                }
                if (str.equals("-2d")) {
                    this.assalog.print("Using 2d array to store combined functions.");
                    Parameters.size2D = Integer.parseInt(args[++i]);
                    this.assalog.println(" Array row size is " + Parameters.size2D);
                    Parameters.enable2D = true;
                    continue;
                }
                throw new AssaException("Unknown parameters!");
            }
            this.runTwoStateBitSetOpt(precision, confidence, modelFileName, propertyName, outputName, globalAlias, groupFunctionStoreType, maxElementNum, maxCredit);
        } else if (args[0].equalsIgnoreCase("-tsRed")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            while (args.length > ++i) {
                String str = args[i].toLowerCase();
                if (str.equals("-m")) {
                    Parameters.NUM_PARALLEL = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-log")) {
                    outputName = args[++i];
                    continue;
                }
                if (str.equals("-console")) {
                    console = args[++i];
                    pw = new PrintWriter(console);
                    this.assalog = new AssaFileLog(pw);
                    continue;
                }
                if (str.equals("-2d")) {
                    this.assalog.print("Using 2d array to store combined functions.");
                    Parameters.size2D = Integer.parseInt(args[++i]);
                    this.assalog.println(" Array row size is " + Parameters.size2D);
                    Parameters.enable2D = true;
                    continue;
                }
                throw new AssaException("Unknown parameters!");
            }
            this.runTwoStateBitSetReduce(precision, confidence, modelFileName, propertyName, outputName, globalAlias);
        } else if (args[0].equalsIgnoreCase("-germanOpt")) {
            modelFileName = args[++i];
            int maxElementNum = 0;
            int maxCredit = 0;
            int sizeOne = 0;
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            while (args.length > ++i) {
                String str = args[i].toLowerCase();
                if (str.equals("-group")) {
                    groupFunctionStoreType = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-maxe")) {
                    maxElementNum = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-maxc")) {
                    maxCredit = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-sizeone")) {
                    Parameters.SIZE_ONE_FUNCTION_GROUP = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-m")) {
                    Parameters.NUM_PARALLEL = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-psize")) {
                    Parameters.P_GROUPSIZE = sizeOne = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-log")) {
                    outputName = args[++i];
                    continue;
                }
                if (str.equals("-console")) {
                    console = args[++i];
                    pw = new PrintWriter(console);
                    this.assalog = new AssaFileLog(pw);
                    continue;
                }
                if (str.equals("-2d")) {
                    this.assalog.print("Using 2d array to store combined functions.");
                    Parameters.size2D = Integer.parseInt(args[++i]);
                    this.assalog.println(" Array row size is " + Parameters.size2D);
                    Parameters.enable2D = true;
                    continue;
                }
                throw new AssaException("Unknown parameters!");
            }
            this.runGermanOpt(precision, confidence, modelFileName, propertyName, outputName, globalAlias, groupFunctionStoreType, maxElementNum, maxCredit);
        } else if (args[0].equals("-gel")) {
            modelFileName = args[++i];
            boolean maxElementNum = false;
            boolean maxCredit = false;
            boolean sizeOne = false;
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            while (args.length > ++i) {
                String str = args[i].toLowerCase();
                if (str.equals("-log")) {
                    outputName = args[++i];
                    continue;
                }
                if (str.equals("-console")) {
                    console = args[++i];
                    pw = new PrintWriter(console);
                    this.assalog = new AssaFileLog(pw);
                    continue;
                }
                if (str.equals("-m")) {
                    Parameters.NUM_PARALLEL = Integer.parseInt(args[++i]);
                    continue;
                }
                throw new AssaException("Unknown parameters!");
            }
            this.runGelmanOneCore(precision, confidence, modelFileName, propertyName, outputName, globalAlias);
        } else if (args[0].equals("-skart")) {
            skart = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-skartfull")) {
            skartLarge = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equalsIgnoreCase("-skartPa")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            m = Integer.parseInt(args[++i]);
            this.runSkartParallel(modelFileName, propertyName, precision, confidence, m, outputName);
        } else if (args[0].equals("-h") || args[0].equals("-help") || args[0].equals("-H")) {
            help = true;
        } else if (args[0].equals("-v") || args[0].equals("-V")) {
            new Version().showVersion();
            System.exit(0);
        } else if (args[0].equalsIgnoreCase("-tsPa")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            m = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                kstep = Integer.parseInt(args[i]);
            }
            this.runTwostateParallelSingleProperty(modelFileName, propertyName, precision, m, kstep, confidence, outputName);
        } else if (args[0].equalsIgnoreCase("-tsPaNoBurnIn")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            m = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                kstep = Integer.parseInt(args[i]);
            }
            this.runTwostateParallelSinglePropertyNoBurnIn(modelFileName, propertyName, precision, m, kstep, confidence, outputName);
        } else if (args[0].equalsIgnoreCase("-tsPam")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            m = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                kstep = Integer.parseInt(args[i]);
            }
            this.runTwoStateParallelMultipleProperties(modelFileName, propertyName, precision, m, kstep, confidence, outputName);
        } else if (args[0].equalsIgnoreCase("-pe")) {
            String tmp;
            double stopThreshold = 0.0;
            boolean adaptive = false;
            int numPBNs = Integer.parseInt(args[++i]);
            int startPoint = 0;
            String[] fileNames = new String[numPBNs];
            boolean[] isMatlabs = new boolean[numPBNs];
            int j = 0;
            while (j < numPBNs) {
                fileNames[j] = args[++i];
                tmp = args[i + 1].toLowerCase();
                isMatlabs[j] = tmp.startsWith("true") || tmp.startsWith("false") ? Boolean.parseBoolean(args[++i]) : false;
                ++j;
            }
            parameterFileName = args[++i];
            propertyName = args[++i];
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            int simulationMethod = Integer.parseInt(args[++i]);
            tmp = args[i + 1].toLowerCase();
            boolean parallel = tmp.startsWith("true") || tmp.startsWith("false") ? Boolean.parseBoolean(args[++i]) : true;
            if (args[i + 1].startsWith("-m")) {
                ++i;
                m = Integer.parseInt(args[++i]);
            }
            int evaluateMethod = Integer.parseInt(args[++i]);
            if (args[i + 1].startsWith("-sp")) {
                ++i;
                startPoint = Integer.parseInt(args[++i]);
            }
            int numberParticles = Integer.parseInt(args[++i]);
            int numberIterations = Integer.parseInt(args[++i]);
            if (args.length > i + 1 && args[i + 1].startsWith("-stop")) {
                ++i;
                stopThreshold = Double.parseDouble(args[++i]);
            }
            if (args.length > i + 1 && args[i + 1].startsWith("-adaptive")) {
                ++i;
                adaptive = true;
            }
            this.runParameterEstimation(fileNames, parameterFileName, propertyName, precision, confidence, simulationMethod, m, parallel, evaluateMethod, startPoint, numberParticles, numberIterations, stopThreshold, adaptive);
        } else if (args[0].equalsIgnoreCase("-sim")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            outputName = args[++i];
            long length = Long.parseLong(args[++i]);
            this.simulate(modelFileName, outputName, length);
        } else if (args[0].equalsIgnoreCase("-simTest")) {
            modelFileName = args[++i];
            int maxElementNum = 0;
            int maxCredit = 0;
            int sizeOne = 0;
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            long length = 1000L;
            while (args.length > ++i) {
                String str = args[i].toLowerCase();
                if (str.equals("-group")) {
                    groupFunctionStoreType = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-maxe")) {
                    maxElementNum = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-maxc")) {
                    maxCredit = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-sizeone")) {
                    Parameters.SIZE_ONE_FUNCTION_GROUP = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-psize")) {
                    Parameters.P_GROUPSIZE = sizeOne = Integer.parseInt(args[++i]);
                    continue;
                }
                if (str.equals("-console")) {
                    console = args[++i];
                    pw = new PrintWriter(console);
                    this.assalog = new AssaFileLog(pw);
                    continue;
                }
                if (str.equals("-l")) {
                    length = Long.parseLong(args[++i]);
                    continue;
                }
                if (str.equals("-m")) {
                    Parameters.NUM_PARALLEL = Integer.parseInt(args[++i]);
                    continue;
                }
                throw new AssaException("Unknown parameters!");
            }
            this.simulate(modelFileName, length, propertyName, groupFunctionStoreType);
        } else if (args[0].equalsIgnoreCase("-BDDsim")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            outputName = args[++i];
            long length = Long.parseLong(args[++i]);
            this.BDDsimulate(modelFileName, outputName, length);
        } else if (args[0].equalsIgnoreCase("-infN")) {
            modelFileName = args[++i];
            int simulationMethod = 3;
            int sourceNodeIndex = Integer.parseInt(args[++i]);
            int targetNodeIndex = Integer.parseInt(args[++i]);
            precision = Parameters.DEFAULT_PRECISION;
            confidence = Parameters.DEFAULT_CONFIDENCE;
            if (args.length > i + 1 && args[i + 1].startsWith("-sm")) {
                ++i;
                simulationMethod = Integer.parseInt(args[++i]);
            }
            if (args.length > i + 1) {
                precision = Double.parseDouble(args[++i]);
                confidence = Double.parseDouble(args[++i]);
            }
            this.nodeInfluenceAnalysis(modelFileName, sourceNodeIndex, targetNodeIndex, simulationMethod, precision, confidence);
        } else if (args[0].equalsIgnoreCase("-infF")) {
            modelFileName = args[++i];
            int simulationMethod = 3;
            int sourceNodeIndex = Integer.parseInt(args[++i]);
            int targetNodeIndex = Integer.parseInt(args[++i]);
            int targetFunctionIndex = Integer.parseInt(args[++i]);
            precision = Parameters.DEFAULT_PRECISION;
            confidence = Parameters.DEFAULT_CONFIDENCE;
            if (args.length > i + 1 && args[i + 1].startsWith("-sm")) {
                ++i;
                simulationMethod = Integer.parseInt(args[++i]);
            }
            if (args.length > i + 1) {
                precision = Double.parseDouble(args[++i]);
                confidence = Double.parseDouble(args[++i]);
            }
            this.functionInfluenceAnalysis(modelFileName, sourceNodeIndex, targetNodeIndex, targetFunctionIndex, simulationMethod, precision, confidence);
        } else if (args[0].equalsIgnoreCase("-senN")) {
            modelFileName = args[++i];
            int simulationMethod = 3;
            int targetNodeIndex = Integer.parseInt(args[++i]);
            precision = Parameters.DEFAULT_PRECISION;
            confidence = Parameters.DEFAULT_CONFIDENCE;
            if (args.length > i + 1 && args[i + 1].startsWith("-sm")) {
                ++i;
                simulationMethod = Integer.parseInt(args[++i]);
            }
            if (args.length > i + 1) {
                precision = Double.parseDouble(args[++i]);
                confidence = Double.parseDouble(args[++i]);
            }
            this.nodeSensitivityAnalysis(modelFileName, targetNodeIndex, simulationMethod, precision, confidence);
        } else if (args[0].equalsIgnoreCase("-senF")) {
            modelFileName = args[++i];
            int simulationMethod = 3;
            int targetNodeIndex = Integer.parseInt(args[++i]);
            int targetFunctionIndex = Integer.parseInt(args[++i]);
            precision = Parameters.DEFAULT_PRECISION;
            confidence = Parameters.DEFAULT_CONFIDENCE;
            if (args.length > i + 1 && args[i + 1].startsWith("-sm")) {
                ++i;
                simulationMethod = Integer.parseInt(args[++i]);
            }
            if (args.length > i + 1) {
                precision = Double.parseDouble(args[++i]);
                confidence = Double.parseDouble(args[++i]);
            }
            this.functionSensitivityAnalysis(modelFileName, targetNodeIndex, targetFunctionIndex, simulationMethod, precision, confidence);
        } else if (args[0].equalsIgnoreCase("-senP")) {
            String modelFileName1 = args[++i];
            String modelFileName2 = args[++i];
            int simulationMethod = 3;
            precision = Parameters.DEFAULT_PRECISION;
            confidence = Parameters.DEFAULT_CONFIDENCE;
            if (args.length > i + 1 && args[i + 1].startsWith("-sm")) {
                ++i;
                simulationMethod = Integer.parseInt(args[++i]);
            }
            if (args.length > i + 1 && args[i + 1].startsWith("-p")) {
                ++i;
                precision = Double.parseDouble(args[++i]);
                confidence = Double.parseDouble(args[++i]);
            }
            ArrayList<Integer> nodeIndicies = new ArrayList<Integer>();
            while (args.length > i + 1) {
                nodeIndicies.add(Integer.parseInt(args[++i]));
            }
            this.perturbeSensitivityAnalysis(modelFileName1, modelFileName2, nodeIndicies, simulationMethod, precision, confidence);
        } else if (args[0].equalsIgnoreCase("-chow")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            this.runChowLiu(modelFileName, propertyName, precision, confidence);
        } else if (args[0].equalsIgnoreCase("-matrix")) {
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            BitSetPBNIO pbnio = new BitSetPBNIO(this.assalog);
            pbnio.loadPBN(modelFileName);
        } else {
            this.assalog.println("Wrong input parameters!");
            this.showhelp();
            System.exit(0);
        }
        try {
            if (ge) {
                this.generatePBN(n, modelFileName, perturbation, type, maxFunction, maxVariable, minFunction, minVariable);
            } else if (gee) {
                this.generatePBNExpression(n, modelFileName, perturbation, type, maxFunction, maxVariable, minFunction, minVariable, distributionFile);
            } else if (gef) {
                this.generatePBNfromFile(parameterFileName, type, outputName);
            } else if (io) {
                this.runPBNIO(modelFileName, outputName, type);
            } else if (gauss) {
                this.runGauss(modelFileName, propertyName, precision, maxIteration);
            } else if (jacobi) {
                this.runJacobi(modelFileName, propertyName, precision, maxIteration);
            } else if (ps) {
                this.runStepPerfectSimulation(modelFileName, propertyName, confidence, precision, outputName, true, cost);
            } else if (ts) {
                this.runTwoStateBitSet(precision, confidence, modelFileName, propertyName, outputName, globalAlias);
            } else if (skart) {
                this.runSkartPBN(precision, confidence, modelFileName, propertyName, outputName, globalAlias);
            } else if (skartLarge) {
                this.runSkartPBNLarge(precision, confidence, modelFileName, propertyName, outputName, globalAlias);
            } else if (help) {
                this.showhelp();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pw != null) {
            pw.close();
        }
    }

    public void closeJDD() {
        JDD.CloseDownCUDD();
    }

    public void runGauss(String modelFileName, String property, double precision, int maxIteration) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the Gauss-Seidel method on the PBN from file " + modelFileName);
        GaussSeidel gauss = new GaussSeidel(pbn, this.assalog);
        if (maxIteration > 0) {
            gauss.setPrecsion(precision);
            gauss.setMaxIteration(maxIteration);
        }
        gauss.setProperty(property);
        gauss.run();
    }

    public void runJacobi(String modelFileName, String property, double precision, int maxIteration) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the Jacobi method on the PBN from file " + modelFileName);
        Jacob jacob = new Jacob(pbn, this.assalog);
        if (maxIteration > 0) {
            jacob.setPrecsion(precision);
            jacob.setMaxIteration(maxIteration);
        }
        jacob.setProperty(property);
        jacob.run();
    }

    public void showhelp() {
        this.assalog.println("-ge <number of node> <perturbation rate> <export file name> <export type> [<max function number> <min function number><max parents node><min parents node>]");
        this.assalog.println("Generate a PBN and export to a file in ASSA format or Matlab format.\n");
        this.assalog.println("-gef <parameter file name> <export file name> <export type>");
        this.assalog.println("Generate a PBN with given parameters in a file.\n");
        this.assalog.println("-io <import file name> <isMatlab> <export file name> <export type> ");
        this.assalog.println("Load a PBN from a file and export to a file in ASSA format or Matlab format.\n");
        this.assalog.println("-gauss <model file name>  [isMatlab] <property file name> [<precision> <max iteration>]");
        this.assalog.println("Perform the Gauss-Seidel method\n");
        this.assalog.println("-jacobi <model file name> [isMatlab]  <property file name> [<precision> <max iteration>]");
        this.assalog.println("Perform the Jacobi method.\n");
        this.assalog.println("-ps <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>] [useCost]");
        this.assalog.println("Perform the perfect simulation approach. If the model file is exported from Matlab, please add true after the model file name.\n");
        this.assalog.println("-ts <model file name> [isMatlab] <precision> <confidence level> [-epsilon <epsilon>] <property file name> [-log <log file name>] [useGlobalAlias]");
        this.assalog.println("Perform the two-state Markov chain approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command\n");
        this.assalog.println("-tspa <model file name> [isMatlab] <precision> <confidence level> [-epsilon <epsilon>] <property file name> [-log <log file name>] <number of chains>");
        this.assalog.println("Perform the multi CPU cores parallel two-state Markov chain approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        this.assalog.println("-tspam <model file name> [isMatlab] <precision> <confidence level> [-epsilon <epsilon>] <property file name> [-log <log file name>] <number of chains>");
        this.assalog.println("Perform the multi CPU cores parallel two-state Markov chain approach for checking multiple properties at the same time. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        this.assalog.println("-tsOpt <model file name> <precision> <confidence level> [-epsilon <epsilon>] <property file name> [-log <log file name>] [-m <number of chains>] [-maxe <maximum # combined predictor function>] [-maxc <maximum # combined predictor function per group>] [-sizeone <maximum # of nodes in a group for nodes with only one Boolean function>] [-psize <maximum # nodes in a group for perturbations>]");
        this.assalog.println("-skart <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>] [useGlobalAlias]");
        this.assalog.println("Perform the fast version Skart approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        this.assalog.println("-skartfull <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>]  [useGlobalAlias]");
        this.assalog.println("Perform the full version Skart approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        this.assalog.println("-skartpa <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>] <number of chains>");
        this.assalog.println("Perform the multi CPU core parallel Skart approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        this.assalog.println("-v");
        this.assalog.println("Show version information.");
        this.assalog.println("-h");
        this.assalog.println("Show this help information.");
        this.assalog.println("Please visit http://satoss.uni.lu/software/ASSA-PBN/userguide.pdf for more help information.");
        this.assalog.println("");
        this.assalog.println("");
    }

    public static void main(String[] args) {
        final Assa assa = new Assa();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                assa.assalog.close();
            }
        });
        try {
            assa.run(args);
        }
        catch (Exception e) {
            assa.assalog.println("Incorrect parameters! Type -h to show help.");
            assa.assalog.println("Erorr information:\n" + e);
            assa.assalog.close();
            e.printStackTrace();
        }
    }
}

