/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import simulator.AliasMethod;

public class TestAliasMethod {
    int[] array;
    List<int[]> arrays;
    List<List> arraylist = new ArrayList<List>();

    public void testArrayAccess(int iteration, int arraysize1, int arraysize2) {
        int[] array1 = new int[arraysize1];
        int[] array2 = new int[arraysize2];
        ArrayList<int[]> array3 = new ArrayList<int[]>();
        int group = 100;
        int i = 0;
        while (i < group) {
            int[] tmp = new int[arraysize2 / group];
            array3.add(tmp);
            ++i;
        }
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < iteration) {
            array1[(int)(Math.random() * (double)arraysize1)] = i2++;
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
        start = System.currentTimeMillis();
        i2 = 0;
        while (i2 < iteration) {
            array2[(int)(Math.random() * (double)arraysize2)] = i2++;
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
        start = System.currentTimeMillis();
        arraysize2 /= group;
        int i3 = 0;
        while (i3 < iteration / 1000) {
            int index = (int)(Math.random() * (double)group);
            int[] tmp = (int[])array3.get(index);
            int j = 0;
            while (j < 1000) {
                int a = (int)(Math.random() * (double)arraysize2);
                tmp[a] = i3;
                ++j;
            }
            ++i3;
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
    }

    public void test() {
        int n;
        int j;
        ArrayList<AliasMethod> amList1 = new ArrayList<AliasMethod>();
        ArrayList<AliasMethod> amList2 = new ArrayList<AliasMethod>();
        int num = 100;
        int size1 = 10;
        int size2 = 1000;
        int i = 0;
        while (i < num) {
            double[] prob = new double[size1];
            int[] col = new int[size1];
            double sum = 0.0;
            int j2 = 0;
            while (j2 < size1) {
                col[j2] = j2;
                prob[j2] = Math.random();
                sum += prob[j2];
                ++j2;
            }
            j2 = 0;
            while (j2 < size1) {
                prob[j2] = prob[j2] / sum;
                ++j2;
            }
            AliasMethod am = new AliasMethod(prob, col);
            amList1.add(am);
            prob = new double[size2];
            col = new int[size2];
            sum = 0.0;
            j2 = 0;
            while (j2 < size2) {
                col[j2] = j2;
                prob[j2] = Math.random();
                sum += prob[j2];
                ++j2;
            }
            j2 = 0;
            while (j2 < size2) {
                prob[j2] = prob[j2] / sum;
                ++j2;
            }
            am = new AliasMethod(prob, col);
            amList2.add(am);
            ++i;
        }
        long start = System.currentTimeMillis();
        int steps = 1000000;
        long res = 0L;
        int i2 = 0;
        while (i2 < steps) {
            j = 0;
            while (j < num) {
                n = ((AliasMethod)amList1.get(j)).next();
                ++j;
            }
            ++i2;
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
        start = System.currentTimeMillis();
        i2 = 0;
        while (i2 < steps) {
            j = 0;
            while (j < num) {
                n = ((AliasMethod)amList2.get(j)).next();
                ++j;
            }
            ++i2;
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
        start = System.currentTimeMillis();
        i2 = 0;
        while (i2 < steps) {
            j = 0;
            while (j < num) {
                n = ((AliasMethod)amList1.get(j)).next();
                ++j;
            }
            ++i2;
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
        start = System.currentTimeMillis();
        int j3 = 0;
        while (j3 < num) {
            int i3 = 0;
            while (i3 < steps) {
                n = ((AliasMethod)amList2.get(j3)).next();
                ++i3;
            }
            ++j3;
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
    }

    public void testArrayList(int size, int num, int iteration, int iteration2) {
        this.arrays = new ArrayList<int[]>();
        int i = 0;
        while (i < num) {
            this.array = new int[size];
            this.arrays.add(this.array);
            ++i;
        }
        int a = 0;
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < iteration) {
            int index = (int)(Math.random() * (double)num);
            int j = 0;
            while (j < iteration2) {
                a = this.arrays.get(index)[(int)(Math.random() * (double)size)];
                ++j;
            }
            ++i2;
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
        this.array[0] = a;
        this.arraylist.add(this.arrays);
    }

    public void testList(int size, int num, int iteration, int iteration2) {
        ArrayList arrays = new ArrayList();
        List array = null;
        int i = 0;
        while (i < num) {
            array = new ArrayList<Integer>();
            int j = 0;
            while (j < size) {
                array.add(j);
                ++j;
            }
            arrays.add(array);
            ++i;
        }
        int a = 0;
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < iteration) {
            int index = (int)(Math.random() * (double)num);
            array = (List)arrays.get(index);
            int j = 0;
            while (j < iteration2) {
                index = (int)(Math.random() * (double)size);
                a = (Integer)array.get(index);
                ++j;
            }
            ++i2;
        }
        start = System.currentTimeMillis() - start;
        array.add(a);
        System.out.println(start);
        this.arraylist.add(arrays);
    }

    public void testDirectByteBuffer(int size, int num, int iteration, int iteration2) {
        int element = size * num;
        ByteBuffer buffer = ByteBuffer.allocateDirect(element * 4);
        int int_offset = 4;
        int pos = 0;
        int i = 0;
        while (i < element) {
            buffer.putInt(pos, i);
            pos += int_offset;
            ++i;
        }
        element = element * 4 - 3;
        int sum = 0;
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < iteration) {
            int j = 0;
            while (j < iteration2) {
                pos = (int)(Math.random() * (double)element);
                sum += buffer.getInt(pos);
                ++j;
            }
            ++i2;
        }
        start = System.currentTimeMillis() - start;
        System.out.println("Direct buffer access time:" + start);
        System.out.println("sum=" + sum);
    }

    public static void main(String[] args) {
        TestAliasMethod tt = new TestAliasMethod();
        int size = 10000;
        int num = 1000;
        int iteration = 10;
        int iteration2 = 1000000;
        tt.testList(size, num, iteration, iteration2);
        tt.testDirectByteBuffer(size, num, iteration, iteration2);
        tt.testList(size, num, iteration, iteration2);
        tt.testDirectByteBuffer(size, num, iteration, iteration2);
    }
}

