/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import analysis.influence.LongtermInfluence;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class FunctionLongRunController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private ChoiceBox<String> cbTarget;
    @FXML
    private ChoiceBox<String> cbTargetFunction;
    @FXML
    private ChoiceBox<String> cbParent;
    @FXML
    private ChoiceBox<String> cbMethod;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    private MainGUIController mainGUIController;
    private int target;
    private int targetFunction;
    private int parent;
    private String method;

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
        int i = 0;
        while (i < AssaGUI.getInstance(this.assalog).getBitSetPBN().getN()) {
            this.cbTarget.getItems().add((Object)("" + i));
            ++i;
        }
        this.cbMethod.getItems().add((Object)"Two State Multiple Properties");
        this.cbMethod.getSelectionModel().select(0);
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cbTarget.getSelectionModel().selectedIndexProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue arg0, Object arg1, Object arg2) {
                if (!arg2.equals(null)) {
                    FunctionLongRunController.this.cbParent.setDisable(true);
                    FunctionLongRunController.this.cbTargetFunction.setDisable(true);
                    FunctionLongRunController.this.cbMethod.setDisable(true);
                    try {
                        FunctionLongRunController.this.onlyValidParents(arg2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    FunctionLongRunController.this.cbParent.setDisable(false);
                    FunctionLongRunController.this.cbTargetFunction.setDisable(false);
                    FunctionLongRunController.this.cbMethod.setDisable(false);
                } else {
                    FunctionLongRunController.this.cbParent.setDisable(true);
                    FunctionLongRunController.this.cbTargetFunction.setDisable(true);
                    FunctionLongRunController.this.cbMethod.setDisable(true);
                }
            }
        });
    }

    @FXML
    protected void calculate(ActionEvent e) {
        try {
            this.target = Integer.parseInt((String)this.cbTarget.getSelectionModel().getSelectedItem());
            this.targetFunction = Integer.parseInt((String)this.cbTargetFunction.getSelectionModel().getSelectedItem());
            this.parent = Integer.parseInt((String)this.cbParent.getSelectionModel().getSelectedItem());
            this.method = (String)this.cbMethod.getSelectionModel().getSelectedItem();
            ((Node)e.getSource()).getScene().getWindow().hide();
            AssaGUI.getInstance().setTask(new Thread(new TS_Task(e, this.mainGUIController)));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (NumberFormatException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong input.");
            alert.setContentText("Please fill out all fields correctly");
            alert.showAndWait();
        }
    }

    public String getMethod() {
        return this.method;
    }

    public int getTarget() {
        return this.target;
    }

    public int getTargetFunction() {
        return this.targetFunction;
    }

    public int getParent() {
        return this.parent;
    }

    protected void onlyValidParents(Object arg2) throws Exception {
        boolean count = false;
        int i = Integer.parseInt(arg2.toString());
        this.cbParent.getItems().clear();
        this.cbTargetFunction.getItems().clear();
        int j = AssaGUI.getInstance(this.assalog).getBitSetPBN().buildCumNf()[i];
        while (j < AssaGUI.getInstance(this.assalog).getBitSetPBN().buildCumNf()[i] + AssaGUI.getInstance(this.assalog).getBitSetPBN().getNf()[i]) {
            int k = 0;
            while (k < AssaGUI.getInstance(this.assalog).getBitSetPBN().getVarF().get(j).size()) {
                if (AssaGUI.getInstance(this.assalog).getBitSetPBN().getVarF().get(j).get(k) && !this.cbParent.getItems().contains((Object)("" + k))) {
                    this.cbParent.getItems().add((Object)("" + k));
                }
                ++k;
            }
            ++j;
        }
        int numFunction = AssaGUI.getInstance(this.assalog).getBitSetPBN().getNf()[i];
        j = 0;
        while (j < numFunction) {
            this.cbTargetFunction.getItems().add((Object)("" + j));
            ++j;
        }
        Collections.sort(this.cbParent.getItems());
        Collections.sort(this.cbTargetFunction.getItems());
    }

    class TS_Task
    implements Runnable {
        private int number;
        private int nParents;
        private int pos_parent;
        ActionEvent e;
        private MainGUIController mainGUIController;
        private ArrayList<Integer> pos = new ArrayList();

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            int target = FunctionLongRunController.this.getTarget();
            int parent = FunctionLongRunController.this.getParent();
            int relativeTargetFunctionIndex = FunctionLongRunController.this.getTargetFunction();
            String method = FunctionLongRunController.this.getMethod();
            int simulationMethod = 3;
            double precision = Double.parseDouble(FunctionLongRunController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(FunctionLongRunController.this.txtConfidence.getText());
            double[] parameters = new double[]{precision, confidence};
            if (method.startsWith("Two State Single Property")) {
                simulationMethod = 0;
            } else if (method.contains("Two State Multiple Properties")) {
                simulationMethod = 3;
            }
            SimulationMethod sm = this.mainGUIController.smProvider(simulationMethod);
            try {
                sm.setParameters(parameters);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                LongtermInfluence influence = new LongtermInfluence(AssaGUI.getInstance(FunctionLongRunController.this.assalog).getBitSetPBN(), sm, FunctionLongRunController.this.assalog);
                influence.computeInfluenceFunction(parent, target, relativeTargetFunctionIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater(() -> {
                    this.mainGUIController.enableFunction();
                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                    this.mainGUIController.getStatus().setText(" Ready");
                    this.mainGUIController.btnCancel.setVisible(false);
                });
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

