/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import analysis.influence.LongtermInfluence;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;
import view.GUI.controller.FunctionLongRunController;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class FunctionLongRunPropertiesController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private ChoiceBox<String> cbTarget;
    @FXML
    private ChoiceBox<String> cbTargetFunction;
    @FXML
    private ChoiceBox<String> cbParent;
    @FXML
    private ChoiceBox<String> cbMethod;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    FunctionLongRunController longRun;
    private MainGUIController mainGUIController;

    public void initData(FunctionLongRunController longRun, MainGUIController mainGUIController) {
        this.longRun = longRun;
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    @FXML
    protected void calculate(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
        try {
            AssaGUI.getInstance().setTask(new Thread(new TS_Task(e, this.mainGUIController)));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    class TS_Task
    implements Runnable {
        private int number;
        private int nParents;
        private int pos_parent;
        ActionEvent e;
        private MainGUIController mainGUIController;
        private ArrayList<Integer> pos = new ArrayList();

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            int target = FunctionLongRunPropertiesController.this.longRun.getTarget();
            int parent = FunctionLongRunPropertiesController.this.longRun.getParent();
            int relativeTargetFunctionIndex = FunctionLongRunPropertiesController.this.longRun.getTargetFunction();
            String method = FunctionLongRunPropertiesController.this.longRun.getMethod();
            int simulationMethod = 3;
            double precision = Double.parseDouble(FunctionLongRunPropertiesController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(FunctionLongRunPropertiesController.this.txtConfidence.getText());
            double[] parameters = new double[]{precision, confidence};
            if (method.startsWith("Two State Single Property")) {
                simulationMethod = 0;
            } else if (method.contains("Two State Multiple Properties")) {
                simulationMethod = 3;
            }
            SimulationMethod sm = this.mainGUIController.smProvider(simulationMethod);
            try {
                sm.setParameters(parameters);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                LongtermInfluence influence = new LongtermInfluence(AssaGUI.getInstance(FunctionLongRunPropertiesController.this.assalog).getBitSetPBN(), sm, FunctionLongRunPropertiesController.this.assalog);
                influence.computeInfluenceFunction(parent, target, relativeTargetFunctionIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater(() -> {
                    this.mainGUIController.enableFunction();
                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                    this.mainGUIController.getStatus().setText(" Ready");
                    this.mainGUIController.btnCancel.setVisible(false);
                });
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

