/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import functionLib.AssaException;
import functionLib.ParametersGUI;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class GenerateGUIController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnLoadFromFile;
    @FXML
    private Button btnGenerate;
    @FXML
    private TextField txtNumNodes;
    @FXML
    private TextField txtpRate;
    @FXML
    private TextField txtMaxFunc;
    @FXML
    private TextField txtMinFunc;
    @FXML
    private TextField txtMaxParents;
    @FXML
    private TextField txtMinParents;
    @FXML
    private Label lblMaxFunc;
    @FXML
    private Label lblMinFunc;
    @FXML
    private Label lblMaxParents;
    @FXML
    private Label lblMinParents;
    @FXML
    private CheckBox cbMaxNumber;
    @FXML
    private CheckBox cbMinNumber;
    public MainGUIController mainGUIController;

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    @FXML
    protected void setMaxNumber(ActionEvent e) {
        if (this.cbMaxNumber.isSelected()) {
            this.lblMaxParents.setDisable(false);
            this.txtMaxParents.setVisible(true);
            this.lblMaxFunc.setDisable(false);
            this.txtMaxFunc.setVisible(true);
            this.cbMinNumber.setDisable(false);
        } else {
            this.lblMaxParents.setDisable(true);
            this.txtMaxParents.setVisible(false);
            this.lblMaxFunc.setDisable(true);
            this.txtMaxFunc.setVisible(false);
            this.cbMinNumber.setSelected(false);
            this.setMinNumber(null);
            this.cbMinNumber.setDisable(true);
        }
    }

    @FXML
    protected void setMinNumber(ActionEvent e) {
        if (this.cbMinNumber.isSelected()) {
            this.lblMinParents.setDisable(false);
            this.txtMinParents.setVisible(true);
            this.lblMinFunc.setDisable(false);
            this.txtMinFunc.setVisible(true);
        } else {
            this.lblMinParents.setDisable(true);
            this.txtMinParents.setVisible(false);
            this.lblMinFunc.setDisable(true);
            this.txtMinFunc.setVisible(false);
        }
    }

    @FXML
    protected void loadFromFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Resource File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                BitSetPBNIO io = new BitSetPBNIO(this.assalog);
                BitSetPBN pbn = io.generatePBNFromFile(selectedFile.getPath());
                AssaGUI.getInstance(this.assalog).setBitSetPBN(pbn);
                ((Node)e.getSource()).getScene().getWindow().hide();
            }
        }
        catch (Exception ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong file format.");
            alert.setContentText(ex.getMessage());
            alert.showAndWait();
        }
    }

    @FXML
    protected void generateModel(ActionEvent e) throws AssaException {
        block12: {
            String numberNodes = this.txtNumNodes.getText().replaceAll("\\s+", "");
            String pRate = this.txtpRate.getText().replaceAll("\\s+", "");
            String maxFunc = this.txtMaxFunc.getText().replaceAll("\\s+", "");
            String minFunc = this.txtMinFunc.getText().replaceAll("\\s+", "");
            String maxParents = this.txtMaxParents.getText().replaceAll("\\s+", "");
            String minParents = this.txtMinParents.getText().replaceAll("\\s+", "");
            try {
                if (Double.parseDouble(pRate) < 1.0 && Double.parseDouble(pRate) > 0.0) {
                    try {
                        int maxFunction;
                        double perturbation;
                        int n;
                        if (!this.cbMaxNumber.isSelected()) {
                            n = Integer.parseInt(numberNodes);
                            perturbation = Double.parseDouble(pRate);
                            AssaGUI.getInstance(this.assalog).setBitSetPBN(AssaGUI.getInstance(this.assalog).defineBitSetPBN(n, perturbation));
                        } else if (this.cbMaxNumber.isSelected() && !this.cbMinNumber.isSelected()) {
                            n = Integer.parseInt(numberNodes);
                            perturbation = Double.parseDouble(pRate);
                            maxFunction = Integer.parseInt(maxFunc);
                            int maxVariable = Integer.parseInt(maxParents);
                            AssaGUI.getInstance(this.assalog).setBitSetPBN(AssaGUI.getInstance(this.assalog).defineBitSetPBN(n, perturbation, maxFunction, maxVariable));
                        } else if (this.cbMaxNumber.isSelected() && this.cbMinNumber.isSelected()) {
                            n = Integer.parseInt(numberNodes);
                            perturbation = Double.parseDouble(pRate);
                            maxFunction = Integer.parseInt(maxFunc);
                            int minFunction = Integer.parseInt(minFunc);
                            int maxVariable = Integer.parseInt(maxParents);
                            int minVariable = Integer.parseInt(minParents);
                            AssaGUI.getInstance(this.assalog).setBitSetPBN(AssaGUI.getInstance(this.assalog).defineBitSetPBN(n, perturbation, maxFunction, minFunction, maxVariable, minVariable));
                        }
                        AssaGUI.getInstance(this.assalog).setModelFullName("newGenerated_" + System.currentTimeMillis() + ".pbn");
                        ((Node)e.getSource()).getScene().getWindow().hide();
                    }
                    catch (NumberFormatException e1) {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error. Wrong data format.");
                        alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                        alert.showAndWait();
                    }
                    catch (Exception e2) {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error.");
                        alert.setContentText(e2.getMessage());
                        alert.showAndWait();
                    }
                    this.mainGUIController.getRoot().getChildren().clear();
                    this.mainGUIController.getTableView().getColumns().clear();
                    this.mainGUIController.getTableView().getItems().clear();
                    this.mainGUIController.getTableView().getColumns().add((Object)new TableColumn("Int"));
                    int j = 0;
                    while (j < AssaGUI.getInstance(this.assalog).getBitSetPBN().getN()) {
                        this.mainGUIController.getTableView().getColumns().add((Object)new TableColumn("N" + j));
                        ++j;
                    }
                    this.mainGUIController.getTableView().getColumns().add((Object)new TableColumn("Value"));
                    this.mainGUIController.loadOverview();
                    break block12;
                }
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("Number Error");
                alert.setHeaderText("pRate Error.");
                alert.setContentText("Please select a value 0 < p < 1.");
                alert.showAndWait();
            }
            catch (NumberFormatException e1) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Data Error");
                alert.setHeaderText("Error. Wrong data format.");
                alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                alert.showAndWait();
            }
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.txtNumNodes.requestFocus();
        this.assalog = mainGUIController.getAssaLog();
    }
}

