/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.PBN;
import PBN.StateBit;
import analysis.influence.LongtermInfluence;
import functionLib.AssaException;
import functionLib.Parameters;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import parser.Model;
import simulationMethod.SimulationMethod;
import simulationMethod.SkartPBN;
import simulationMethod.TwoStateBitSet;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class LongRunController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private ChoiceBox<String> cbTarget;
    @FXML
    private ChoiceBox<String> cbParent;
    @FXML
    private ChoiceBox<String> cbMethod;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    private MainGUIController mainGUIController;
    private int target;
    private int parent;
    private String method;

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
        BitSetPBN pbn = AssaGUI.getInstance().getBitSetPBN();
        Model model = null;
        if (pbn instanceof BDDPBN) {
            model = ((BDDPBN)pbn).getModel();
            List<String> names = model.getNames();
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                this.cbTarget.getItems().add((Object)names.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                this.cbTarget.getItems().add((Object)("" + i));
                ++i;
            }
        }
        this.cbMethod.getItems().add((Object)"Two State Multiple Properties");
        this.cbMethod.getSelectionModel().select(0);
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cbTarget.getSelectionModel().selectedIndexProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue arg0, Object arg1, Object arg2) {
                if (!arg2.equals(null)) {
                    LongRunController.this.cbParent.setDisable(true);
                    LongRunController.this.cbMethod.setDisable(true);
                    try {
                        LongRunController.this.onlyValidParents(arg2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    LongRunController.this.cbParent.setDisable(false);
                    LongRunController.this.cbMethod.setDisable(false);
                } else {
                    LongRunController.this.cbParent.setDisable(true);
                    LongRunController.this.cbMethod.setDisable(true);
                }
            }
        });
    }

    @FXML
    protected void calculate(ActionEvent e) throws AssaException {
        try {
            BitSetPBN pbn = AssaGUI.getInstance(this.assalog).getBitSetPBN();
            if (pbn instanceof BDDPBN) {
                Model model = ((BDDPBN)pbn).getModel();
                this.target = model.getNodeID((String)this.cbTarget.getSelectionModel().getSelectedItem());
                this.parent = model.getNodeID((String)this.cbParent.getSelectionModel().getSelectedItem());
            } else {
                this.target = Integer.parseInt((String)this.cbTarget.getSelectionModel().getSelectedItem());
                this.parent = Integer.parseInt((String)this.cbParent.getSelectionModel().getSelectedItem());
            }
            this.method = (String)this.cbMethod.getSelectionModel().getSelectedItem();
            ((Node)e.getSource()).getScene().getWindow().hide();
            AssaGUI.getInstance().setTask(new Thread(new TS_Task(e, this.mainGUIController)));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (NumberFormatException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong input.");
            alert.setContentText("Please fill out all fields correctly");
            alert.showAndWait();
        }
    }

    public String getMethod() {
        return this.method;
    }

    public int getTarget() {
        return this.target;
    }

    public int getParent() {
        return this.parent;
    }

    protected void onlyValidParents(Object arg2) throws Exception {
        int i = Integer.parseInt(arg2.toString());
        this.cbParent.getItems().clear();
        BitSetPBN pbn = AssaGUI.getInstance().getBitSetPBN();
        Model model = null;
        int j = AssaGUI.getInstance(this.assalog).getBitSetPBN().buildCumNf()[i];
        while (j < AssaGUI.getInstance(this.assalog).getBitSetPBN().buildCumNf()[i] + AssaGUI.getInstance(this.assalog).getBitSetPBN().getNf()[i]) {
            int k = 0;
            while (k < AssaGUI.getInstance(this.assalog).getBitSetPBN().getVarF().get(j).size()) {
                if (AssaGUI.getInstance(this.assalog).getBitSetPBN().getVarF().get(j).get(k)) {
                    if (pbn instanceof BDDPBN) {
                        model = ((BDDPBN)pbn).getModel();
                        List<String> names = model.getNames();
                        if (!this.cbParent.getItems().contains((Object)names.get(k))) {
                            this.cbParent.getItems().add((Object)names.get(k));
                        }
                    } else if (!this.cbParent.getItems().contains((Object)("" + k))) {
                        this.cbParent.getItems().add((Object)("" + k));
                    }
                }
                ++k;
            }
            ++j;
        }
        Collections.sort(this.cbParent.getItems());
    }

    class TS_Task
    implements Runnable {
        private int number;
        private int nParents;
        private int pos_parent;
        ActionEvent e;
        private MainGUIController mainGUIController;
        private ArrayList<Integer> pos = new ArrayList();

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        private double call_ts(int k, int nParentNodes, int indexOf) {
            double average;
            block12: {
                this.number = k;
                this.nParents = nParentNodes;
                this.pos_parent = indexOf;
                average = 0.0;
                try {
                    double precision = Double.parseDouble(LongRunController.this.txtPrecision.getText());
                    double confidence = Double.parseDouble(LongRunController.this.txtConfidence.getText());
                    if (precision < 1.0 && precision > 0.0 && confidence > 0.0 && confidence < 1.0) {
                        MainGUIController.setTs(new TwoStateBitSet(LongRunController.this.assalog, precision, confidence, Parameters.epsilon, 1));
                        StateBit initialState = new StateBit(0);
                        MainGUIController.getTs().setDisableGlobalAlias(false);
                        MainGUIController.getTs().initIndices();
                        byte b = (byte)this.number;
                        int i = 0;
                        while (i < this.nParents) {
                            if (this.pos_parent != i) {
                                String value1 = "" + (b >> this.nParents - i - 1 & 1);
                                if (value1.equals("1")) {
                                    MainGUIController.getTs().addPositiveIndex(this.pos.get(i));
                                } else if (value1.equals("0")) {
                                    MainGUIController.getTs().addNegativeIndex(this.pos.get(i));
                                }
                            }
                            ++i;
                        }
                        try {
                            try {
                                double[] result = MainGUIController.getTs().run((PBN)AssaGUI.getInstance(LongRunController.this.assalog).getBitSetPBN(), initialState);
                                average = result[0];
                                break block12;
                            }
                            catch (Exception e1) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Simulation Error");
                                    alert.setHeaderText("Error. Simulation not performed.");
                                    alert.setContentText(e1.getMessage());
                                    alert.showAndWait();
                                });
                                Platform.runLater(() -> {
                                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                                    this.mainGUIController.getStatus().setText(" Ready");
                                    this.mainGUIController.btnCancel.setVisible(false);
                                });
                            }
                        }
                        catch (Exception e1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Format Error");
                                alert.setHeaderText("Error. Wrong property file format.");
                                alert.setContentText(e1.getMessage());
                                alert.showAndWait();
                            });
                            Platform.runLater(() -> {
                                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                                this.mainGUIController.getStatus().setText(" Ready");
                                this.mainGUIController.btnCancel.setVisible(false);
                            });
                        }
                        break block12;
                    }
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Number Error");
                        alert.setHeaderText("Precision/Confidence Error.");
                        alert.setContentText("Precision p and Confidence c have to be 0 < p and c < 1.");
                        alert.showAndWait();
                    });
                    Platform.runLater(() -> {
                        this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        this.mainGUIController.getStatus().setText(" Ready");
                        this.mainGUIController.btnCancel.setVisible(false);
                    });
                }
                catch (NumberFormatException e1) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error. Wrong data format.");
                        alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                        alert.showAndWait();
                    });
                    Platform.runLater(() -> {
                        this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        this.mainGUIController.getStatus().setText(" Ready");
                        this.mainGUIController.btnCancel.setVisible(false);
                    });
                }
            }
            return average;
        }

        private double call_skart(int k, int nParentNodes, int indexOf) {
            double average;
            block12: {
                this.number = k;
                this.nParents = nParentNodes;
                this.pos_parent = indexOf;
                average = 0.0;
                try {
                    double precision = Double.parseDouble(LongRunController.this.txtPrecision.getText());
                    double confidence = Double.parseDouble(LongRunController.this.txtConfidence.getText());
                    if (precision < 1.0 && precision > 0.0 && confidence > 0.0 && confidence < 1.0) {
                        MainGUIController.setSkart(new SkartPBN(AssaGUI.getInstance(LongRunController.this.assalog).getBitSetPBN(), LongRunController.this.assalog));
                        MainGUIController.getSkart().setAlpha(1.0 - confidence);
                        MainGUIController.getSkart().setPrecision(precision);
                        StateBit initialState = new StateBit(0);
                        MainGUIController.getSkart().setDisableGlobalAlias(false);
                        MainGUIController.getSkart().initIndices();
                        byte b = (byte)this.number;
                        int i = 0;
                        while (i < this.nParents) {
                            if (this.pos_parent != i) {
                                String value1 = "" + (b >> this.nParents - i - 1 & 1);
                                if (value1.equals("1")) {
                                    MainGUIController.getSkart().addPositiveIndex(this.pos.get(i));
                                } else if (value1.equals("0")) {
                                    MainGUIController.getSkart().addNegativeIndex(this.pos.get(i));
                                }
                            }
                            ++i;
                        }
                        try {
                            try {
                                double[] result = MainGUIController.getSkart().run();
                                average = result[2];
                                break block12;
                            }
                            catch (Exception e1) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Simulation Error");
                                    alert.setHeaderText("Error. Simulation not performed.");
                                    alert.setContentText(e1.getMessage());
                                    alert.showAndWait();
                                });
                                Platform.runLater(() -> {
                                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                                    this.mainGUIController.getStatus().setText(" Ready");
                                    this.mainGUIController.btnCancel.setVisible(false);
                                });
                            }
                        }
                        catch (Exception e1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Format Error");
                                alert.setHeaderText("Error. Wrong property file format.");
                                alert.setContentText(e1.getMessage());
                                alert.showAndWait();
                            });
                            Platform.runLater(() -> {
                                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                                this.mainGUIController.getStatus().setText(" Ready");
                                this.mainGUIController.btnCancel.setVisible(false);
                            });
                        }
                        break block12;
                    }
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Number Error");
                        alert.setHeaderText("Precision/Confidence Error.");
                        alert.setContentText("Precision p and Confidence c have to be 0 < p and c < 1.");
                        alert.showAndWait();
                    });
                    Platform.runLater(() -> {
                        this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        this.mainGUIController.getStatus().setText(" Ready");
                        this.mainGUIController.btnCancel.setVisible(false);
                    });
                }
                catch (NumberFormatException e1) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error. Wrong data format.");
                        alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                        alert.showAndWait();
                    });
                    Platform.runLater(() -> {
                        this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        this.mainGUIController.getStatus().setText(" Ready");
                        this.mainGUIController.btnCancel.setVisible(false);
                    });
                }
            }
            return average;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            int target = LongRunController.this.getTarget();
            int parent = LongRunController.this.getParent();
            String method = LongRunController.this.getMethod();
            int simulationMethod = 3;
            double precision = Double.parseDouble(LongRunController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(LongRunController.this.txtConfidence.getText());
            double[] parameters = new double[]{precision, confidence};
            if (method.startsWith("Two State Single Property")) {
                simulationMethod = 0;
            } else if (method.contains("Two State Multiple Properties")) {
                simulationMethod = 3;
            }
            SimulationMethod sm = this.mainGUIController.smProvider(simulationMethod);
            try {
                sm.setParameters(parameters);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                LongtermInfluence influence = new LongtermInfluence(AssaGUI.getInstance(LongRunController.this.assalog).getBitSetPBN(), sm, LongRunController.this.assalog);
                influence.computeInfluenceNode(parent, target);
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater(() -> {
                    this.mainGUIController.enableFunction();
                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                    this.mainGUIController.getStatus().setText(" Ready");
                    this.mainGUIController.btnCancel.setVisible(false);
                });
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

