/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.PBN;
import PBN.StateBit;
import analysis.influence.LongtermInfluence;
import functionLib.Parameters;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import simulationMethod.SimulationMethod;
import simulationMethod.SkartPBN;
import simulationMethod.TwoStateBitSet;
import userInterface.AssaLog;
import view.GUI.controller.LongRunController;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class LongRunPropertiesController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private ChoiceBox<String> cbTarget;
    @FXML
    private ChoiceBox<String> cbParent;
    @FXML
    private ChoiceBox<String> cbMethod;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    LongRunController longRun;
    private MainGUIController mainGUIController;

    public void initData(LongRunController longRun, MainGUIController mainGUIController) {
        this.longRun = longRun;
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    @FXML
    protected void calculate(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
        AssaGUI.getInstance().setTask(new Thread(new TS_Task(e, this.mainGUIController)));
        this.mainGUIController.btnCancel.setVisible(true);
        AssaGUI.getInstance().getTask().setDaemon(true);
        AssaGUI.getInstance().getTask().start();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    class TS_Task
    implements Runnable {
        private int number;
        private int nParents;
        private int pos_parent;
        ActionEvent e;
        private MainGUIController mainGUIController;
        private ArrayList<Integer> pos = new ArrayList();

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        private double call_ts(int k, int nParentNodes, int indexOf) {
            double average;
            block12: {
                this.number = k;
                this.nParents = nParentNodes;
                this.pos_parent = indexOf;
                average = 0.0;
                try {
                    double precision = Double.parseDouble(LongRunPropertiesController.this.txtPrecision.getText());
                    double confidence = Double.parseDouble(LongRunPropertiesController.this.txtConfidence.getText());
                    if (precision < 1.0 && precision > 0.0 && confidence > 0.0 && confidence < 1.0) {
                        MainGUIController.setTs(new TwoStateBitSet(LongRunPropertiesController.this.assalog, precision, confidence, Parameters.epsilon, 1));
                        StateBit initialState = new StateBit(0);
                        MainGUIController.getTs().setDisableGlobalAlias(false);
                        MainGUIController.getTs().initIndices();
                        byte b = (byte)this.number;
                        int i = 0;
                        while (i < this.nParents) {
                            if (this.pos_parent != i) {
                                String value1 = "" + (b >> this.nParents - i - 1 & 1);
                                if (value1.equals("1")) {
                                    MainGUIController.getTs().addPositiveIndex(this.pos.get(i));
                                } else if (value1.equals("0")) {
                                    MainGUIController.getTs().addNegativeIndex(this.pos.get(i));
                                }
                            }
                            ++i;
                        }
                        try {
                            try {
                                double[] result = MainGUIController.getTs().run((PBN)AssaGUI.getInstance(LongRunPropertiesController.this.assalog).getBitSetPBN(), initialState);
                                average = result[0];
                                break block12;
                            }
                            catch (Exception e1) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Simulation Error");
                                    alert.setHeaderText("Error. Simulation not performed.");
                                    alert.setContentText(e1.getMessage());
                                    alert.showAndWait();
                                });
                                Platform.runLater(() -> {
                                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                                    this.mainGUIController.getStatus().setText(" Ready");
                                    this.mainGUIController.btnCancel.setVisible(false);
                                });
                            }
                        }
                        catch (Exception e1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Format Error");
                                alert.setHeaderText("Error. Wrong property file format.");
                                alert.setContentText(e1.getMessage());
                                alert.showAndWait();
                            });
                            Platform.runLater(() -> {
                                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                                this.mainGUIController.getStatus().setText(" Ready");
                                this.mainGUIController.btnCancel.setVisible(false);
                            });
                        }
                        break block12;
                    }
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Number Error");
                        alert.setHeaderText("Precision/Confidence Error.");
                        alert.setContentText("Precision p and Confidence c have to be 0 < p and c < 1.");
                        alert.showAndWait();
                    });
                    Platform.runLater(() -> {
                        this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        this.mainGUIController.getStatus().setText(" Ready");
                        this.mainGUIController.btnCancel.setVisible(false);
                    });
                }
                catch (NumberFormatException e1) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error. Wrong data format.");
                        alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                        alert.showAndWait();
                    });
                    Platform.runLater(() -> {
                        this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        this.mainGUIController.getStatus().setText(" Ready");
                        this.mainGUIController.btnCancel.setVisible(false);
                    });
                }
            }
            return average;
        }

        private double call_skart(int k, int nParentNodes, int indexOf) {
            double average;
            block12: {
                this.number = k;
                this.nParents = nParentNodes;
                this.pos_parent = indexOf;
                average = 0.0;
                try {
                    double precision = Double.parseDouble(LongRunPropertiesController.this.txtPrecision.getText());
                    double confidence = Double.parseDouble(LongRunPropertiesController.this.txtConfidence.getText());
                    if (precision < 1.0 && precision > 0.0 && confidence > 0.0 && confidence < 1.0) {
                        MainGUIController.setSkart(new SkartPBN(AssaGUI.getInstance(LongRunPropertiesController.this.assalog).getBitSetPBN(), LongRunPropertiesController.this.assalog));
                        MainGUIController.getSkart().setAlpha(1.0 - confidence);
                        MainGUIController.getSkart().setPrecision(precision);
                        StateBit initialState = new StateBit(0);
                        MainGUIController.getSkart().setDisableGlobalAlias(false);
                        MainGUIController.getSkart().initIndices();
                        byte b = (byte)this.number;
                        int i = 0;
                        while (i < this.nParents) {
                            if (this.pos_parent != i) {
                                String value1 = "" + (b >> this.nParents - i - 1 & 1);
                                if (value1.equals("1")) {
                                    MainGUIController.getSkart().addPositiveIndex(this.pos.get(i));
                                } else if (value1.equals("0")) {
                                    MainGUIController.getSkart().addNegativeIndex(this.pos.get(i));
                                }
                            }
                            ++i;
                        }
                        try {
                            try {
                                double[] result = MainGUIController.getSkart().run();
                                average = result[2];
                                break block12;
                            }
                            catch (Exception e1) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Simulation Error");
                                    alert.setHeaderText("Error. Simulation not performed.");
                                    alert.setContentText(e1.getMessage());
                                    alert.showAndWait();
                                });
                                Platform.runLater(() -> {
                                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                                    this.mainGUIController.getStatus().setText(" Ready");
                                    this.mainGUIController.btnCancel.setVisible(false);
                                });
                            }
                        }
                        catch (Exception e1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Format Error");
                                alert.setHeaderText("Error. Wrong property file format.");
                                alert.setContentText(e1.getMessage());
                                alert.showAndWait();
                            });
                            Platform.runLater(() -> {
                                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                                this.mainGUIController.getStatus().setText(" Ready");
                                this.mainGUIController.btnCancel.setVisible(false);
                            });
                        }
                        break block12;
                    }
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Number Error");
                        alert.setHeaderText("Precision/Confidence Error.");
                        alert.setContentText("Precision p and Confidence c have to be 0 < p and c < 1.");
                        alert.showAndWait();
                    });
                    Platform.runLater(() -> {
                        this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        this.mainGUIController.getStatus().setText(" Ready");
                        this.mainGUIController.btnCancel.setVisible(false);
                    });
                }
                catch (NumberFormatException e1) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error. Wrong data format.");
                        alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                        alert.showAndWait();
                    });
                    Platform.runLater(() -> {
                        this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        this.mainGUIController.getStatus().setText(" Ready");
                        this.mainGUIController.btnCancel.setVisible(false);
                    });
                }
            }
            return average;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            int target = LongRunPropertiesController.this.longRun.getTarget();
            int parent = LongRunPropertiesController.this.longRun.getParent();
            String method = LongRunPropertiesController.this.longRun.getMethod();
            int simulationMethod = 3;
            double precision = Double.parseDouble(LongRunPropertiesController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(LongRunPropertiesController.this.txtConfidence.getText());
            double[] parameters = new double[]{precision, confidence};
            if (method.startsWith("Two State Single Property")) {
                simulationMethod = 0;
            } else if (method.contains("Two State Multiple Properties")) {
                simulationMethod = 3;
            }
            SimulationMethod sm = this.mainGUIController.smProvider(simulationMethod);
            try {
                sm.setParameters(parameters);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                LongtermInfluence influence = new LongtermInfluence(AssaGUI.getInstance(LongRunPropertiesController.this.assalog).getBitSetPBN(), sm, LongRunPropertiesController.this.assalog);
                influence.computeInfluenceNode(parent, target);
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater(() -> {
                    this.mainGUIController.enableFunction();
                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                    this.mainGUIController.getStatus().setText(" Ready");
                    this.mainGUIController.btnCancel.setVisible(false);
                });
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

