/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.PBN;
import analysis.influence.LongtermSensitivity;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import parser.Model;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class LongRunSensitivityFunctionPerturbationController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private TextField nodeIndices;
    @FXML
    private TextField PBNPath;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    @FXML
    private ChoiceBox<String> cbMethod;
    @FXML
    private ChoiceBox<String> cbFunction;
    @FXML
    private ChoiceBox<String> cbNode;
    @FXML
    private TableView<Map> tblFunction;
    private MainGUIController mainGUIController;
    private String method;
    private TS_Task ts_task;
    protected TreeItem<?> newValue;
    private boolean function_changes = false;
    private BitSetPBN pbnTemp;

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
        this.pbnTemp = (BitSetPBN)AssaGUI.getInstance().getBitSetPBN().copy();
        this.cbMethod.getItems().add((Object)"Two State Multiple Properties");
        this.cbMethod.getSelectionModel().select(0);
        BitSetPBN pbn = AssaGUI.getInstance().getBitSetPBN();
        if (pbn instanceof BDDPBN) {
            Model model = ((BDDPBN)pbn).getModel();
            List<String> names = model.getNames();
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                this.cbNode.getItems().add((Object)names.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                this.cbNode.getItems().add((Object)("" + i));
                ++i;
            }
        }
        this.cbNode.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number new_value) {
                LongRunSensitivityFunctionPerturbationController.this.nodeChanged(new_value);
                LongRunSensitivityFunctionPerturbationController.this.cbFunction.getSelectionModel().select(0);
            }
        });
        this.cbFunction.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number new_value) {
                if (new_value != null) {
                    LongRunSensitivityFunctionPerturbationController.this.tableAction(new_value);
                    if (LongRunSensitivityFunctionPerturbationController.this.function_changes) {
                        LongRunSensitivityFunctionPerturbationController.this.pbnTemp = (BitSetPBN)AssaGUI.getInstance().getBitSetPBN().copy();
                        Alert alert = new Alert(Alert.AlertType.WARNING);
                        alert.setTitle("Warning");
                        alert.setHeaderText("Predictor Functions have been reset.");
                        alert.setContentText("You can only change one function.");
                        alert.showAndWait();
                        LongRunSensitivityFunctionPerturbationController.this.function_changes = false;
                    }
                }
            }
        });
    }

    @FXML
    protected void nodeChanged(Number new_value) {
        this.cbFunction.getItems().clear();
        if (new_value != null) {
            int i = 0;
            while (i < AssaGUI.getInstance().getBitSetPBN().getNf()[(Integer)new_value]) {
                this.cbFunction.getItems().add((Object)("" + i));
                ++i;
            }
            if (this.function_changes) {
                this.pbnTemp = (BitSetPBN)AssaGUI.getInstance().getBitSetPBN().copy();
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("Warning");
                alert.setHeaderText("Predictor Functions have been reset.");
                alert.setContentText("You can only change one function.");
                alert.showAndWait();
                this.function_changes = false;
            }
        }
    }

    @FXML
    protected void tableAction(final Number new_value) {
        if ((Integer)new_value != -1) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Platform.runLater(() -> {
                        Callback<TableColumn<Map, String>, TableCell<Map, String>> cellFactoryForMap = new Callback<TableColumn<Map, String>, TableCell<Map, String>>(){

                            public TableCell<Map, String> call(TableColumn p) {
                                return new TextFieldTableCell((StringConverter)new StringConverter<Object>(){

                                    public Object fromString(String string) {
                                        return string;
                                    }

                                    public String toString(Object t) {
                                        if (t != null) {
                                            return t.toString();
                                        }
                                        return "";
                                    }
                                });
                            }
                        };
                        BitSetPBN pbn = AssaGUI.getInstance(LongRunSensitivityFunctionPerturbationController.this.assalog).getBitSetPBN();
                        int nId = 0;
                        if (pbn instanceof BDDPBN) {
                            Model model = ((BDDPBN)pbn).getModel();
                            try {
                                nId = model.getNodeID((String)LongRunSensitivityFunctionPerturbationController.this.cbNode.getSelectionModel().getSelectedItem());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            nId = Integer.parseInt((String)LongRunSensitivityFunctionPerturbationController.this.cbNode.getSelectionModel().getSelectedItem());
                        }
                        try {
                            LongRunSensitivityFunctionPerturbationController.this.tblFunction.getColumns().clear();
                        }
                        catch (Exception model) {
                            // empty catch block
                        }
                        int count = 0;
                        int i = 0;
                        while (i < nId) {
                            count += AssaGUI.getInstance(LongRunSensitivityFunctionPerturbationController.this.assalog).getBitSetPBN().getNf()[i];
                            ++i;
                        }
                        int fId = (Integer)new_value;
                        int nParentNodes = AssaGUI.getInstance(LongRunSensitivityFunctionPerturbationController.this.assalog).getBitSetPBN().getNv().get(fId += count);
                        ArrayList<Integer> parentList = new ArrayList<Integer>();
                        int i22 = 0;
                        while (i22 < AssaGUI.getInstance(LongRunSensitivityFunctionPerturbationController.this.assalog).getBitSetPBN().getVarF().get(fId).size()) {
                            if (AssaGUI.getInstance(LongRunSensitivityFunctionPerturbationController.this.assalog).getBitSetPBN().getVarF().get(fId).get(i22)) {
                                parentList.add(i22);
                            }
                            ++i22;
                        }
                        try {
                            LongRunSensitivityFunctionPerturbationController.this.tblFunction.getItems().clear();
                        }
                        catch (Exception i22) {
                            // empty catch block
                        }
                        TableColumn temp = new TableColumn("Number");
                        temp.setStyle("-fx-border-width: 0 2.5 0 0;-fx-table-cell-border-color: #000000;");
                        temp.setCellValueFactory((Callback)new MapValueFactory((Object)"Number"));
                        temp.setCellFactory((Callback)cellFactoryForMap);
                        LongRunSensitivityFunctionPerturbationController.this.tblFunction.getColumns().add((Object)temp);
                        if (pbn instanceof BDDPBN) {
                            Model model = ((BDDPBN)pbn).getModel();
                            List<String> names = model.getNames();
                            int myi = parentList.size() - 1;
                            while (myi >= 0) {
                                int k = (Integer)parentList.get(myi);
                                if (AssaGUI.getInstance(LongRunSensitivityFunctionPerturbationController.this.assalog).getBitSetPBN().getVarF().get(fId).get(k)) {
                                    temp = new TableColumn(names.get(k));
                                    temp.setCellValueFactory((Callback)new MapValueFactory((Object)("" + k)));
                                    temp.setCellFactory((Callback)cellFactoryForMap);
                                    LongRunSensitivityFunctionPerturbationController.this.tblFunction.getColumns().add((Object)temp);
                                }
                                --myi;
                            }
                        } else {
                            int myi = parentList.size() - 1;
                            while (myi >= 0) {
                                int k = (Integer)parentList.get(myi);
                                if (AssaGUI.getInstance(LongRunSensitivityFunctionPerturbationController.this.assalog).getBitSetPBN().getVarF().get(fId).get(k)) {
                                    temp = new TableColumn("N" + k);
                                    temp.setCellValueFactory((Callback)new MapValueFactory((Object)("" + k)));
                                    temp.setCellFactory((Callback)cellFactoryForMap);
                                    LongRunSensitivityFunctionPerturbationController.this.tblFunction.getColumns().add((Object)temp);
                                }
                                --myi;
                            }
                        }
                        temp.setStyle("-fx-border-width: 0 2.5 0 0;-fx-table-cell-border-color: #000000;");
                        temp = new TableColumn("Value");
                        temp.setStyle("-fx-cursor: hand;");
                        temp.setCellValueFactory((Callback)new MapValueFactory((Object)"Value"));
                        temp.setCellFactory((Callback)cellFactoryForMap);
                        LongRunSensitivityFunctionPerturbationController.this.tblFunction.getColumns().add((Object)temp);
                        LongRunSensitivityFunctionPerturbationController.this.tblFunction.getItems().addAll(this.generateDataInMap(fId, nParentNodes, parentList));
                        LongRunSensitivityFunctionPerturbationController.this.tblFunction.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                if (event.isPrimaryButtonDown() && event.getClickCount() == 2) {
                                    String temp;
                                    Parent node;
                                    TableRow row;
                                    if (LongRunSensitivityFunctionPerturbationController.this.function_changes) {
                                        LongRunSensitivityFunctionPerturbationController.this.pbnTemp = (BitSetPBN)AssaGUI.getInstance().getBitSetPBN().copy();
                                        Alert alert = new Alert(Alert.AlertType.WARNING);
                                        alert.setTitle("Warning");
                                        alert.setHeaderText("New value set and all other predictor functions have been reset.");
                                        alert.setContentText("You can only change one function.");
                                        alert.showAndWait();
                                        LongRunSensitivityFunctionPerturbationController.this.function_changes = false;
                                        LongRunSensitivityFunctionPerturbationController.this.tableAction(Integer.parseInt((String)LongRunSensitivityFunctionPerturbationController.this.cbFunction.getSelectionModel().getSelectedItem()));
                                    }
                                    if ("false".equals(((Map)(row = (node = ((Node)event.getTarget()).getParent()) instanceof TableRow ? (TableRow)node : (TableRow)node.getParent()).getItem()).get("Value"))) {
                                        temp = "true";
                                        ((LongRunSensitivityFunctionPerturbationController)(this).LongRunSensitivityFunctionPerturbationController.this).pbnTemp.getF().get((int)Integer.parseInt((String)((String)((Map)row.getItem()).get((Object)"fId"))))[Integer.parseInt((String)((String)((Map)row.getItem()).get((Object)"fValueId")))] = true;
                                    } else {
                                        temp = "false";
                                        ((LongRunSensitivityFunctionPerturbationController)(this).LongRunSensitivityFunctionPerturbationController.this).pbnTemp.getF().get((int)Integer.parseInt((String)((String)((Map)row.getItem()).get((Object)"fId"))))[Integer.parseInt((String)((String)((Map)row.getItem()).get((Object)"fValueId")))] = false;
                                    }
                                    ((Map)row.getItem()).replace("Value", temp);
                                    ((TableColumn)LongRunSensitivityFunctionPerturbationController.this.tblFunction.getColumns().get(0)).setVisible(false);
                                    ((TableColumn)LongRunSensitivityFunctionPerturbationController.this.tblFunction.getColumns().get(0)).setVisible(true);
                                    LongRunSensitivityFunctionPerturbationController.this.function_changes = true;
                                }
                            }
                        });
                    });
                }

                private ObservableList<Map> generateDataInMap(int func, int nParentNodes, ArrayList<Integer> parentList) {
                    int max = (int)Math.pow(2.0, nParentNodes);
                    ObservableList allData = FXCollections.observableArrayList();
                    int i = 0;
                    while (i < max) {
                        HashMap<String, String> dataRow = new HashMap<String, String>();
                        dataRow.put("Number", "" + i);
                        int count = 0;
                        for (int j : parentList) {
                            byte b = (byte)i;
                            String value1 = "" + (b >> count & 1);
                            ++count;
                            dataRow.put("" + j, value1);
                        }
                        dataRow.put("Value", "" + LongRunSensitivityFunctionPerturbationController.this.pbnTemp.getF().get(func)[i]);
                        dataRow.put("fId", "" + func);
                        dataRow.put("fValueId", "" + i);
                        allData.add(dataRow);
                        ++i;
                    }
                    return allData;
                }
            });
        }
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void calculate(ActionEvent e) {
        try {
            ((Node)e.getSource()).getScene().getWindow().hide();
            if (this.ts_task == null) {
                this.ts_task = new TS_Task(e, this.mainGUIController);
            } else {
                this.ts_task.setE(e);
            }
            AssaGUI.getInstance().setTask(new Thread(this.ts_task));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (NumberFormatException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong input.");
            alert.setContentText("Please fill out all fields correctly");
            alert.showAndWait();
        }
    }

    @FXML
    protected void loadPBNFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Perturbed PBN File");
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                this.PBNPath.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getMethod() {
        return this.method;
    }

    class TS_Task
    implements Runnable {
        ActionEvent e;
        private MainGUIController mainGUIController;

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        public void setE(ActionEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            String nodeIndicesStr = LongRunSensitivityFunctionPerturbationController.this.nodeIndices.getText();
            ArrayList<Integer> nodeIndiciesList = new ArrayList<Integer>();
            StringTokenizer st = new StringTokenizer(nodeIndicesStr);
            BitSetPBNIO io = new BitSetPBNIO(LongRunSensitivityFunctionPerturbationController.this.assalog);
            double precision = Double.parseDouble(LongRunSensitivityFunctionPerturbationController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(LongRunSensitivityFunctionPerturbationController.this.txtConfidence.getText());
            double[] parameters = new double[]{precision, confidence};
            int simulationMethod = 3;
            LongRunSensitivityFunctionPerturbationController.this.method = (String)LongRunSensitivityFunctionPerturbationController.this.cbMethod.getSelectionModel().getSelectedItem();
            if (LongRunSensitivityFunctionPerturbationController.this.method.startsWith("Two State Single Property")) {
                simulationMethod = 0;
            } else if (LongRunSensitivityFunctionPerturbationController.this.method.contains("Two State Multiple Properties")) {
                simulationMethod = 3;
            }
            SimulationMethod sm = this.mainGUIController.smProvider(simulationMethod);
            try {
                sm.setParameters(parameters);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                while (st.hasMoreTokens()) {
                    nodeIndiciesList.add(Integer.parseInt(st.nextToken()));
                }
                BitSetPBN pbn1 = LongRunSensitivityFunctionPerturbationController.this.pbnTemp;
                LongtermSensitivity sensitivity = new LongtermSensitivity(AssaGUI.getInstance(LongRunSensitivityFunctionPerturbationController.this.assalog).getBitSetPBN(), pbn1, sm, LongRunSensitivityFunctionPerturbationController.this.assalog);
                sensitivity.computeSensitivity(nodeIndiciesList);
            }
            catch (Exception e) {
                LongRunSensitivityFunctionPerturbationController.this.assalog.println(e.getMessage());
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

