/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.PBN;
import analysis.influence.LongtermInfluence;
import functionLib.AssaException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import parser.Model;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class LongRunSensitivityNodeController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private ChoiceBox<String> cbTarget;
    @FXML
    private ChoiceBox<String> cbTargetFunction;
    @FXML
    private ChoiceBox<String> cbMethod;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    private MainGUIController mainGUIController;
    private int target;
    private int targetFunction;
    private String method;
    private TS_Task ts_task;

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
        BitSetPBN pbn = AssaGUI.getInstance().getBitSetPBN();
        Model model = null;
        if (pbn instanceof BDDPBN) {
            model = ((BDDPBN)pbn).getModel();
            List<String> names = model.getNames();
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                this.cbTarget.getItems().add((Object)names.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                this.cbTarget.getItems().add((Object)("" + i));
                ++i;
            }
        }
        this.cbMethod.getItems().add((Object)"Two State Multiple Properties");
        this.cbMethod.getSelectionModel().select(0);
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cbTarget.getSelectionModel().selectedIndexProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue arg0, Object arg1, Object arg2) {
                if (!arg2.equals(null)) {
                    LongRunSensitivityNodeController.this.cbTargetFunction.setDisable(true);
                    LongRunSensitivityNodeController.this.cbMethod.setDisable(true);
                    try {
                        LongRunSensitivityNodeController.this.onlyValidParents(arg2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    LongRunSensitivityNodeController.this.cbTargetFunction.setDisable(false);
                    LongRunSensitivityNodeController.this.cbMethod.setDisable(false);
                } else {
                    LongRunSensitivityNodeController.this.cbTargetFunction.setDisable(true);
                    LongRunSensitivityNodeController.this.cbMethod.setDisable(true);
                }
            }
        });
    }

    @FXML
    protected void calculate(ActionEvent e) throws AssaException {
        try {
            BitSetPBN pbn = AssaGUI.getInstance(this.assalog).getBitSetPBN();
            if (pbn instanceof BDDPBN) {
                Model model = ((BDDPBN)pbn).getModel();
                this.target = model.getNodeID((String)this.cbTarget.getSelectionModel().getSelectedItem());
            } else {
                this.target = Integer.parseInt((String)this.cbTarget.getSelectionModel().getSelectedItem());
            }
            this.targetFunction = ((String)this.cbTargetFunction.getSelectionModel().getSelectedItem()).startsWith("All") ? -1 : Integer.parseInt((String)this.cbTargetFunction.getSelectionModel().getSelectedItem());
            this.method = (String)this.cbMethod.getSelectionModel().getSelectedItem();
            ((Node)e.getSource()).getScene().getWindow().hide();
            if (this.ts_task == null) {
                this.ts_task = new TS_Task(e, this.mainGUIController);
            } else {
                this.ts_task.setE(e);
            }
            AssaGUI.getInstance().setTask(new Thread(this.ts_task));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (NumberFormatException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong input.");
            alert.setContentText("Please fill out all fields correctly");
            alert.showAndWait();
        }
    }

    public String getMethod() {
        return this.method;
    }

    public int getTarget() {
        return this.target;
    }

    public int getTargetFunction() {
        return this.targetFunction;
    }

    protected void onlyValidParents(Object arg2) throws Exception {
        int i = Integer.parseInt(arg2.toString());
        this.cbTargetFunction.getItems().clear();
        this.cbTargetFunction.getItems().add((Object)"All (Node sensitivity)");
        this.cbTargetFunction.getSelectionModel().select((Object)"All (Node sensitivity)");
        int j = AssaGUI.getInstance(this.assalog).getBitSetPBN().getNf()[i];
        int k = 0;
        while (k < j) {
            this.cbTargetFunction.getItems().add((Object)("" + k));
            ++k;
        }
    }

    class TS_Task
    implements Runnable {
        ActionEvent e;
        private MainGUIController mainGUIController;

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        public void setE(ActionEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            int simulationMethod = 3;
            double precision = Double.parseDouble(LongRunSensitivityNodeController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(LongRunSensitivityNodeController.this.txtConfidence.getText());
            double[] parameters = new double[]{precision, confidence};
            if (LongRunSensitivityNodeController.this.method.startsWith("Two State Single Property")) {
                simulationMethod = 0;
            } else if (LongRunSensitivityNodeController.this.method.contains("Two State Multiple Properties")) {
                simulationMethod = 3;
            }
            SimulationMethod sm = this.mainGUIController.smProvider(simulationMethod);
            try {
                sm.setParameters(parameters);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                LongtermInfluence influence = new LongtermInfluence(AssaGUI.getInstance(LongRunSensitivityNodeController.this.assalog).getBitSetPBN(), sm, LongRunSensitivityNodeController.this.assalog);
                if (LongRunSensitivityNodeController.this.targetFunction == -1) {
                    influence.computeSensitivityNode(LongRunSensitivityNodeController.this.target);
                } else {
                    influence.computeSensitivityFunction(LongRunSensitivityNodeController.this.target, LongRunSensitivityNodeController.this.targetFunction);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater(() -> {
                    this.mainGUIController.enableFunction();
                    this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                    this.mainGUIController.getStatus().setText(" Ready");
                    this.mainGUIController.btnCancel.setVisible(false);
                });
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

