/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import analysis.influence.LongtermSensitivity;
import functionLib.ParametersGUI;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class LongRunSensitivityPerturbationController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private TextField nodeIndices;
    @FXML
    private TextField PBNPath;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    @FXML
    private ChoiceBox<String> cbMethod;
    private MainGUIController mainGUIController;
    private String method;
    private TS_Task ts_task;

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
        this.cbMethod.getItems().add((Object)"Two State Multiple Properties");
        this.cbMethod.getSelectionModel().select(0);
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void calculate(ActionEvent e) {
        try {
            ((Node)e.getSource()).getScene().getWindow().hide();
            if (this.ts_task == null) {
                this.ts_task = new TS_Task(e, this.mainGUIController);
            } else {
                this.ts_task.setE(e);
            }
            AssaGUI.getInstance().setTask(new Thread(this.ts_task));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (NumberFormatException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong input.");
            alert.setContentText("Please fill out all fields correctly");
            alert.showAndWait();
        }
    }

    @FXML
    protected void loadPBNFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Perturbed PBN File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                this.PBNPath.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getMethod() {
        return this.method;
    }

    class TS_Task
    implements Runnable {
        ActionEvent e;
        private MainGUIController mainGUIController;

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        public void setE(ActionEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            String nodeIndicesStr = LongRunSensitivityPerturbationController.this.nodeIndices.getText();
            ArrayList<Integer> nodeIndiciesList = new ArrayList<Integer>();
            StringTokenizer st = new StringTokenizer(nodeIndicesStr);
            BitSetPBNIO io = new BitSetPBNIO(LongRunSensitivityPerturbationController.this.assalog);
            double precision = Double.parseDouble(LongRunSensitivityPerturbationController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(LongRunSensitivityPerturbationController.this.txtConfidence.getText());
            double[] parameters = new double[]{precision, confidence};
            int simulationMethod = 3;
            LongRunSensitivityPerturbationController.this.method = (String)LongRunSensitivityPerturbationController.this.cbMethod.getSelectionModel().getSelectedItem();
            if (LongRunSensitivityPerturbationController.this.method.startsWith("Two State Single Property")) {
                simulationMethod = 0;
            } else if (LongRunSensitivityPerturbationController.this.method.contains("Two State Multiple Properties")) {
                simulationMethod = 3;
            }
            SimulationMethod sm = this.mainGUIController.smProvider(simulationMethod);
            try {
                sm.setParameters(parameters);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                while (st.hasMoreTokens()) {
                    nodeIndiciesList.add(Integer.parseInt(st.nextToken()));
                }
                BitSetPBN pbn1 = io.loadPBN(LongRunSensitivityPerturbationController.this.PBNPath.getText());
                LongtermSensitivity sensitivity = new LongtermSensitivity(AssaGUI.getInstance(LongRunSensitivityPerturbationController.this.assalog).getBitSetPBN(), pbn1, sm, LongRunSensitivityPerturbationController.this.assalog);
                sensitivity.computeSensitivity(nodeIndiciesList);
            }
            catch (Exception e) {
                LongRunSensitivityPerturbationController.this.assalog.println(e.getMessage());
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

