/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.PBN;
import analysis.influence.LongtermSensitivity;
import functionLib.AssaException;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import parser.Model;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class LongRunSensitivityProbabilityPerturbationController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private TextField nodeIndices;
    @FXML
    private TextField PBNPath;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    @FXML
    private ChoiceBox<String> cbMethod;
    @FXML
    private ChoiceBox<String> cbFunction;
    @FXML
    private ChoiceBox<String> cbNode;
    @FXML
    private TableView<Map> tblFunction;
    private MainGUIController mainGUIController;
    private String method;
    private TS_Task ts_task;
    protected TreeItem<?> newValue;
    private boolean function_changes = false;
    private BitSetPBN pbnTemp;
    private boolean work = false;

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
        this.pbnTemp = (BitSetPBN)AssaGUI.getInstance().getBitSetPBN().copy();
        this.cbMethod.getItems().add((Object)"Two State Multiple Properties");
        this.cbMethod.getSelectionModel().select(0);
        BitSetPBN pbn = AssaGUI.getInstance().getBitSetPBN();
        Model model = null;
        if (pbn instanceof BDDPBN) {
            model = ((BDDPBN)pbn).getModel();
            List<String> names = model.getNames();
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                this.cbNode.getItems().add((Object)names.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                this.cbNode.getItems().add((Object)("" + i));
                ++i;
            }
        }
        this.cbNode.getSelectionModel().select(0);
        this.cbNode.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number new_value) {
                LongRunSensitivityProbabilityPerturbationController.this.nodeChanged(new_value);
            }
        });
        if (model != null) {
            try {
                this.tableAction(model.getNodeID((String)this.cbNode.getSelectionModel().getSelectedItem()));
            }
            catch (AssaException e) {
                e.printStackTrace();
            }
        } else {
            this.tableAction(Integer.parseInt((String)this.cbNode.getSelectionModel().getSelectedItem()));
        }
    }

    @FXML
    protected void nodeChanged(Number new_value) {
        if (new_value != null) {
            this.tableAction(new_value);
            this.pbnTemp = (BitSetPBN)AssaGUI.getInstance().getBitSetPBN().copy();
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("Warning");
            alert.setHeaderText("Predictor Functions have been reset.");
            alert.setContentText("You can only change one function.");
            alert.showAndWait();
            this.function_changes = false;
        }
    }

    @FXML
    protected void tableAction(final Number new_value) {
        if ((Integer)new_value != -1) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Platform.runLater(() -> {
                        Callback<TableColumn<Map, String>, TableCell<Map, String>> cellFactoryForMap = new Callback<TableColumn<Map, String>, TableCell<Map, String>>(){

                            public TableCell<Map, String> call(TableColumn p) {
                                return new TextFieldTableCell((StringConverter)new StringConverter<Object>(){

                                    public Object fromString(String string) {
                                        return string;
                                    }

                                    public String toString(Object t) {
                                        if (t != null) {
                                            return t.toString();
                                        }
                                        return "";
                                    }
                                });
                            }
                        };
                        LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getColumns().clear();
                        LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().clear();
                        int max_functions = AssaGUI.getInstance(LongRunSensitivityProbabilityPerturbationController.this.assalog).getBitSetPBN().getNf()[(Integer)new_value];
                        LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getSelectionModel().setCellSelectionEnabled(true);
                        int f_id = 0;
                        while (f_id < max_functions) {
                            TableColumn temp = new TableColumn("f" + f_id);
                            temp.setStyle("-fx-border-width: 0 2.5 0 0;-fx-table-cell-border-color: #000000;");
                            temp.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Map, String>>(){

                                public void handle(TableColumn.CellEditEvent<Map, String> t) {
                                    if (!LongRunSensitivityProbabilityPerturbationController.this.work) {
                                        LongRunSensitivityProbabilityPerturbationController.this.work = true;
                                        int place = t.getTablePosition().getColumn();
                                        double old_value = Double.parseDouble((String)t.getOldValue());
                                        double new_value = Double.parseDouble((String)t.getNewValue());
                                        double diff = 0.0;
                                        diff = old_value > new_value ? new_value - old_value : old_value - new_value;
                                        int t_row = t.getTablePosition().getRow();
                                        System.out.println("row:" + t_row + "col:" + place);
                                        ((Map)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().get(t_row)).replace("f" + place, "" + new_value);
                                        double sum = 0.0;
                                        int i = 0;
                                        while (i < ((Map)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().get(0)).size()) {
                                            if (i != t.getTablePosition().getColumn()) {
                                                sum += Double.parseDouble("" + ((Map)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().get(0)).get("f" + i));
                                            }
                                            ++i;
                                        }
                                        System.out.println(sum);
                                        System.out.println(old_value);
                                        System.out.println(new_value);
                                        System.out.println("size:" + ((Map)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().get(0)).size());
                                        double sum_all = 0.0;
                                        int i2 = 0;
                                        while (i2 < ((Map)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().get(0)).size()) {
                                            if (i2 != place) {
                                                double n = Double.parseDouble("" + ((Map)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().get(0)).get("f" + i2));
                                                ((Map)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().get(0)).replace("f" + i2, "" + (double)Math.round((n + n * diff / sum) * 1000.0) / 1000.0);
                                            }
                                            sum_all += Double.parseDouble("" + ((Map)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().get(0)).get("f" + i2));
                                            ++i2;
                                        }
                                        ((TableColumn)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getColumns().get(0)).setVisible(false);
                                        ((TableColumn)LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getColumns().get(0)).setVisible(true);
                                        LongRunSensitivityProbabilityPerturbationController.this.work = false;
                                    }
                                }
                            });
                            temp.setCellValueFactory((Callback)new MapValueFactory((Object)("f" + f_id)));
                            temp.setCellFactory((Callback)cellFactoryForMap);
                            LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getColumns().add((Object)temp);
                            ++f_id;
                        }
                        LongRunSensitivityProbabilityPerturbationController.this.tblFunction.getItems().addAll(this.generateDataInMap());
                        LongRunSensitivityProbabilityPerturbationController.this.tblFunction.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                            }
                        });
                    });
                }

                private ObservableList<Map> generateDataInMap() {
                    ObservableList allData = FXCollections.observableArrayList();
                    HashMap<String, String> dataRow = new HashMap<String, String>();
                    int count = 0;
                    int j = 0;
                    while (j < AssaGUI.getInstance(LongRunSensitivityProbabilityPerturbationController.this.assalog).getBitSetPBN().getNf()[(Integer)new_value]) {
                        String value1 = new DecimalFormat("#.###").format(AssaGUI.getInstance(LongRunSensitivityProbabilityPerturbationController.this.assalog).getBitSetPBN().getCij().get((Integer)new_value)[j - count]);
                        dataRow.put("f" + j, value1);
                        ++j;
                    }
                    allData.add(dataRow);
                    return allData;
                }
            });
        }
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void calculate(ActionEvent e) throws AssaException {
        try {
            ((Node)e.getSource()).getScene().getWindow().hide();
            List<double[]> dt = this.pbnTemp.getCij();
            BitSetPBN pbn = AssaGUI.getInstance().getBitSetPBN();
            int value = 0;
            if (pbn instanceof BDDPBN) {
                Model model = ((BDDPBN)pbn).getModel();
                value = model.getNodeID((String)this.cbNode.getSelectionModel().getSelectedItem());
            } else {
                value = Integer.parseInt((String)this.cbNode.getSelectionModel().getSelectedItem());
            }
            double[] de = new double[AssaGUI.getInstance().getBitSetPBN().getNf()[value]];
            int j = 0;
            while (j < AssaGUI.getInstance().getBitSetPBN().getNf()[value]) {
                dt.get((int)value)[j] = Double.parseDouble((String)((Map)this.tblFunction.getItems().get(0)).get("f" + j));
                ++j;
            }
            this.pbnTemp.setCij(dt);
            if (this.ts_task == null) {
                this.ts_task = new TS_Task(e, this.mainGUIController);
            } else {
                this.ts_task.setE(e);
            }
            AssaGUI.getInstance().setTask(new Thread(this.ts_task));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (NumberFormatException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong input.");
            alert.setContentText("Please fill out all fields correctly");
            alert.showAndWait();
        }
    }

    @FXML
    protected void loadPBNFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Perturbed PBN File");
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                this.PBNPath.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getMethod() {
        return this.method;
    }

    class TS_Task
    implements Runnable {
        ActionEvent e;
        private MainGUIController mainGUIController;

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        public void setE(ActionEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            String nodeIndicesStr = LongRunSensitivityProbabilityPerturbationController.this.nodeIndices.getText();
            ArrayList<Integer> nodeIndiciesList = new ArrayList<Integer>();
            StringTokenizer st = new StringTokenizer(nodeIndicesStr);
            double precision = Double.parseDouble(LongRunSensitivityProbabilityPerturbationController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(LongRunSensitivityProbabilityPerturbationController.this.txtConfidence.getText());
            double[] parameters = new double[]{precision, confidence};
            int simulationMethod = 3;
            LongRunSensitivityProbabilityPerturbationController.this.method = (String)LongRunSensitivityProbabilityPerturbationController.this.cbMethod.getSelectionModel().getSelectedItem();
            if (LongRunSensitivityProbabilityPerturbationController.this.method.startsWith("Two State Single Property")) {
                simulationMethod = 0;
            } else if (LongRunSensitivityProbabilityPerturbationController.this.method.contains("Two State Multiple Properties")) {
                simulationMethod = 3;
            }
            SimulationMethod sm = this.mainGUIController.smProvider(simulationMethod);
            try {
                sm.setParameters(parameters);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                while (st.hasMoreTokens()) {
                    nodeIndiciesList.add(Integer.parseInt(st.nextToken()));
                }
                BitSetPBN pbn1 = LongRunSensitivityProbabilityPerturbationController.this.pbnTemp;
                LongtermSensitivity sensitivity = new LongtermSensitivity(AssaGUI.getInstance(LongRunSensitivityProbabilityPerturbationController.this.assalog).getBitSetPBN(), pbn1, sm, LongRunSensitivityProbabilityPerturbationController.this.assalog);
                sensitivity.computeSensitivity(nodeIndiciesList);
            }
            catch (Exception e) {
                LongRunSensitivityProbabilityPerturbationController.this.assalog.println(e.getMessage());
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

