/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BDDPBN;
import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.PBN;
import functionLib.AssaException;
import functionLib.ParametersGUI;
import java.awt.Desktop;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import parser.Model;
import simulationMethod.GaussSeidelGUI;
import simulationMethod.GelmanFullStatePara;
import simulationMethod.GelmanFullStateParallel;
import simulationMethod.GermanGPU;
import simulationMethod.JacobGUI;
import simulationMethod.SimulationMethod;
import simulationMethod.SkartPBN;
import simulationMethod.SkartPBNLarge;
import simulationMethod.SkartPBNParallel;
import simulationMethod.TwoStateBitSet;
import simulationMethod.TwoStateMultiProperty;
import simulationMethod.TwostateMultiPropertyParallel;
import userInterface.AssaLog;
import userInterface.Version;
import view.GUI.MainGUI;
import view.GUI.controller.AssaGUILog;
import view.GUI.controller.FunctionLongRunController;
import view.GUI.controller.GenerateGUIController;
import view.GUI.controller.LongRunController;
import view.GUI.controller.LongRunSensitivityFunctionPerturbationController;
import view.GUI.controller.LongRunSensitivityNodeController;
import view.GUI.controller.LongRunSensitivityPerturbationController;
import view.GUI.controller.LongRunSensitivityProbabilityPerturbationController;
import view.GUI.controller.ParameterEstimationController;
import view.GUI.controller.SimulateGaussGUIController;
import view.GUI.controller.SimulateJacobiGUIController;
import view.GUI.controller.SimulateModelGUIController;
import view.GUI.controller.SimulatePerfectGUIController;
import view.GUI.controller.SimulateSkartGUIController;
import view.GUI.controller.SimulateTwoStateGUIController;
import view.GUI.etc.AssaGUI;

public class MainGUIController
implements Initializable {
    AssaLog assalog;
    private String currentModelPath;
    private boolean disableFunction = false;
    private static GaussSeidelGUI gauss;
    private static JacobGUI jacobi;
    private static SkartPBN sk;
    private static SkartPBNLarge skL;
    private static TwoStateBitSet ts;
    @FXML
    private Label lblStatus;
    @FXML
    private URL location;
    @FXML
    public Button btnCancel;
    @FXML
    private MenuItem mmLoad;
    @FXML
    private MenuItem mmGenerate;
    @FXML
    private MenuItem mmExport;
    @FXML
    private MenuItem mmShowGraph;
    @FXML
    private MenuItem mmSimulate;
    @FXML
    private MenuItem mmSimulateGauss;
    @FXML
    private MenuItem mmSimulateJacobi;
    @FXML
    private MenuItem mmSimulatePerfect;
    @FXML
    private MenuItem mmSimulateSkart;
    @FXML
    private MenuItem mmLongRun;
    @FXML
    private MenuItem mmLongRunFunction;
    @FXML
    private MenuItem mmSimulateTwoState;
    @FXML
    private MenuItem mmLongRunSensitivityNode;
    @FXML
    private MenuItem mmLongRunSensitivityPerturbation;
    @FXML
    private MenuItem mmPE;
    @FXML
    private TreeView<String> modelTree;
    @FXML
    private ResourceBundle resources;
    @FXML
    private TabPane rightTab;
    private TreeItem<String> root;
    @FXML
    private Circle statusCircle;
    @FXML
    private TableView<Map> tblFunction;
    @FXML
    private TextArea txtAreaAnalysis;
    @FXML
    private TextArea txtAreaFile;
    @FXML
    private TextArea txtAreaLog;
    @FXML
    private TextArea txtAreaOverview;

    public static GaussSeidelGUI getGauss() {
        return gauss;
    }

    public static JacobGUI getJacobi() {
        return jacobi;
    }

    public static SkartPBN getSkart() {
        return sk;
    }

    public static SkartPBNLarge getSkartL() {
        return skL;
    }

    public static TwoStateBitSet getTs() {
        return ts;
    }

    public static void setGauss(GaussSeidelGUI gauss) {
        MainGUIController.gauss = gauss;
    }

    public static void setJacobi(JacobGUI jacobi) {
        MainGUIController.jacobi = jacobi;
    }

    public static void setSkart(SkartPBN skartPBN) {
        sk = skartPBN;
    }

    public static void setSkartL(SkartPBNLarge skartPBNL) {
        skL = skartPBNL;
    }

    public static void setTs(TwoStateBitSet ts) {
        MainGUIController.ts = ts;
    }

    public SimulationMethod smProvider(int simulationMethod) {
        SimulationMethod sm;
        switch (simulationMethod) {
            case 0: {
                sm = new TwoStateBitSet(this.assalog);
                break;
            }
            case 1: {
                sm = new GelmanFullStateParallel(null, this.assalog);
                break;
            }
            case 2: {
                sm = new TwostateMultiPropertyParallel(null, this.assalog);
                break;
            }
            case 3: {
                sm = new TwoStateMultiProperty(this.assalog);
                break;
            }
            case 4: {
                sm = new SkartPBN(null, this.assalog);
                break;
            }
            case 6: {
                sm = new SkartPBNParallel(null, this.assalog);
                break;
            }
            case 5: {
                sm = new SkartPBNLarge(null, this.assalog);
                break;
            }
            case 7: {
                sm = new GermanGPU(this.assalog);
                sm.setPBN(AssaGUI.getInstance().getBitSetPBN());
                break;
            }
            case 8: {
                sm = new GelmanFullStatePara(this.assalog);
                break;
            }
            default: {
                sm = new TwoStateBitSet(this.assalog);
            }
        }
        return sm;
    }

    @FXML
    protected void checkStatus() {
        if (this.disableFunction) {
            this.mmLoad.setDisable(true);
            this.mmGenerate.setDisable(true);
            this.mmExport.setDisable(true);
            this.mmPE.setDisable(true);
        }
        if (this.disableFunction || AssaGUI.getInstance(this.assalog).getBitSetPBN() == null) {
            this.mmSimulateGauss.setDisable(true);
            this.mmSimulateJacobi.setDisable(true);
            this.mmSimulateSkart.setDisable(true);
            this.mmSimulatePerfect.setDisable(true);
            this.mmSimulate.setDisable(true);
            this.mmLongRun.setDisable(true);
            this.mmLongRunFunction.setDisable(true);
            this.mmLongRunSensitivityPerturbation.setDisable(true);
            this.mmLongRunSensitivityNode.setDisable(true);
        } else {
            this.mmLoad.setDisable(false);
            this.mmGenerate.setDisable(false);
            this.mmExport.setDisable(false);
            this.mmPE.setDisable(false);
            this.mmSimulateGauss.setDisable(false);
            this.mmSimulateJacobi.setDisable(false);
            this.mmSimulateTwoState.setDisable(false);
            this.mmSimulateSkart.setDisable(false);
            this.mmSimulatePerfect.setDisable(false);
            this.mmSimulate.setDisable(false);
            this.mmLongRun.setDisable(false);
            this.mmLongRunFunction.setDisable(false);
            this.mmLongRunSensitivityPerturbation.setDisable(false);
            this.mmLongRunSensitivityNode.setDisable(false);
        }
    }

    public void disableFunction() {
        this.disableFunction = true;
    }

    public void enableFunction() {
        this.disableFunction = false;
    }

    @FXML
    protected void clearTab() {
        System.out.println(this.rightTab.getSelectionModel().getSelectedIndex());
        if (this.rightTab.getSelectionModel().getSelectedIndex() == 0) {
            this.txtAreaAnalysis.setText("");
        } else if (this.rightTab.getSelectionModel().getSelectedIndex() == 1) {
            this.txtAreaFile.setText("");
        }
    }

    @FXML
    protected void closeAction(ActionEvent e) {
        System.exit(0);
    }

    @FXML
    protected void exportModel(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Model");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        FileChooser.ExtensionFilter filter1 = new FileChooser.ExtensionFilter("ASSA PBN(*.pbn)", new String[]{"*.pbn"});
        fileChooser.getExtensionFilters().add((Object)filter1);
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Matlab(*.m)", new String[]{"*.m"}));
        File file = fileChooser.showSaveDialog(null);
        if (file != null) {
            try {
                ParametersGUI.lastDirectory = file.getParent();
                BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
                if (fileChooser.getSelectedExtensionFilter() == filter1) {
                    exp.exportPBN(AssaGUI.getInstance(this.assalog).getBitSetPBN(), "" + file);
                } else {
                    exp.exportPBNtoMatlab(AssaGUI.getInstance(this.assalog).getBitSetPBN(), "" + file);
                }
                AssaGUI.getInstance(this.assalog).setModelFullName(this.currentModelPath);
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    @FXML
    protected void generateModel(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/GenerateGUI.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Generate Model");
            stage.setScene(new Scene(root1));
            GenerateGUIController controller = (GenerateGUIController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void computeLongRunInfluence(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/LongRunInfluence.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Compute Long Run Influence (Gene Level)");
            stage.setScene(new Scene(root1));
            LongRunController controller = (LongRunController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void computeLongRunFunctionInfluence(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/FunctionLongRunInfluence.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Compute Long Run Influence (Function Level)");
            stage.setScene(new Scene(root1));
            FunctionLongRunController controller = (FunctionLongRunController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void computeLongRunSensitivityNode(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/LongRunSensitivityNode.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Compute Long Run Sensitivity");
            stage.setScene(new Scene(root1));
            LongRunSensitivityNodeController controller = (LongRunSensitivityNodeController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void computeLongRunSensitivityPerturbation(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/LongRunSensitivityPerturbation.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Compute Long Run Sensitivity");
            stage.setScene(new Scene(root1));
            LongRunSensitivityPerturbationController controller = (LongRunSensitivityPerturbationController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void computeLongRunSensitivityFunctionPerturbation(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/LongRunSensitivityFunctionPerturbation.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Compute Long Run Sensitivity");
            stage.setScene(new Scene(root1));
            LongRunSensitivityFunctionPerturbationController controller = (LongRunSensitivityFunctionPerturbationController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void computeLongRunSensitivityProbabilityPerturbation(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/LongRunSensitivityProbabilityPerturbation.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Compute Long Run Sensitivity");
            stage.setScene(new Scene(root1));
            LongRunSensitivityProbabilityPerturbationController controller = (LongRunSensitivityProbabilityPerturbationController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void cancelComputation() {
        this.btnCancel.setVisible(false);
        AssaGUI.getInstance().getTask().stop();
        this.disableFunction = false;
        Platform.runLater(() -> {
            this.enableFunction();
            this.getCircle().setFill((Paint)Color.GREENYELLOW);
            this.getStatus().setText(" Ready");
        });
    }

    public Circle getCircle() {
        return this.statusCircle;
    }

    public TreeItem<String> getRoot() {
        return this.root;
    }

    public Label getStatus() {
        return this.lblStatus;
    }

    public TableView<Map> getTableView() {
        return this.tblFunction;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.tblFunction.setPlaceholder((Node)new Label("Choose predictor function.."));
        this.assalog = new AssaGUILog(this.txtAreaAnalysis);
        this.setLog(this.assalog);
        Thread t = new Thread(new Task());
        t.setDaemon(true);
        t.start();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MainGUIController.this.root = new TreeItem((Object)"Model");
                MainGUIController.this.root.setValue((Object)"Model");
                MainGUIController.this.root.getChildren().add((Object)new TreeItem((Object)"<empty>"));
                MainGUIController.this.root.setExpanded(true);
                MainGUIController.this.modelTree.setRoot(MainGUIController.this.root);
                MainGUIController.this.modelTree.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
                MainGUIController.this.txtAreaAnalysis.setWrapText(false);
                MainGUIController.this.modelTree.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

                    public void changed(ObservableValue<?> observable, Object oldValue, Object newValue) {
                        if (newValue != null) {
                            Platform.runLater(() -> {
                                Callback<TableColumn<Map, String>, TableCell<Map, String>> cellFactoryForMap = new Callback<TableColumn<Map, String>, TableCell<Map, String>>(){

                                    public TableCell<Map, String> call(TableColumn p) {
                                        return new TextFieldTableCell((StringConverter)new StringConverter<Object>(){

                                            public Object fromString(String string) {
                                                return string;
                                            }

                                            public String toString(Object t) {
                                                if (t != null) {
                                                    return t.toString();
                                                }
                                                return "";
                                            }
                                        });
                                    }
                                };
                                BitSetPBN pbn = AssaGUI.getInstance((this).MainGUIController.this.assalog).getBitSetPBN();
                                int nId = 0;
                                TreeItem treeItem = (TreeItem)newValue;
                                if (treeItem.getValue().toString().contains("Function") && treeItem.getValue().toString().contains("c(i,j)")) {
                                    MainGUIController.this.tblFunction.getColumns().clear();
                                    int i = 0;
                                    while (i < treeItem.getParent().getParent().getChildren().size()) {
                                        if (treeItem.getParent().getParent().getChildren().get(i) == treeItem.getParent()) {
                                            nId = i;
                                        }
                                        ++i;
                                    }
                                    int count = 0;
                                    try {
                                        count = ((PBN)pbn).buildCumNf()[nId];
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    int fId = 0;
                                    int i2 = 0;
                                    while (i2 < treeItem.getParent().getChildren().size()) {
                                        if (treeItem.getParent().getChildren().get(i2) == treeItem) {
                                            fId = i2;
                                        }
                                        ++i2;
                                    }
                                    int nParentNodes = AssaGUI.getInstance((this).MainGUIController.this.assalog).getBitSetPBN().getNv().get(fId += count);
                                    ArrayList<Integer> parentList = new ArrayList<Integer>();
                                    int i3 = 0;
                                    while (i3 < AssaGUI.getInstance((this).MainGUIController.this.assalog).getBitSetPBN().getVarF().get(fId).size()) {
                                        if (AssaGUI.getInstance((this).MainGUIController.this.assalog).getBitSetPBN().getVarF().get(fId).get(i3)) {
                                            parentList.add(i3);
                                        }
                                        ++i3;
                                    }
                                    MainGUIController.this.tblFunction.getItems().clear();
                                    TableColumn temp = new TableColumn("Number");
                                    temp.setStyle("-fx-border-width: 0 2.5 0 0;-fx-table-cell-border-color: #000000;");
                                    temp.setCellValueFactory((Callback)new MapValueFactory((Object)"Number"));
                                    temp.setCellFactory((Callback)cellFactoryForMap);
                                    MainGUIController.this.tblFunction.getColumns().add((Object)temp);
                                    if (pbn instanceof BDDPBN) {
                                        Model model = ((BDDPBN)pbn).getModel();
                                        List<String> names = model.getNames();
                                        int myi = parentList.size() - 1;
                                        while (myi >= 0) {
                                            int k = (Integer)parentList.get(myi);
                                            if (AssaGUI.getInstance((this).MainGUIController.this.assalog).getBitSetPBN().getVarF().get(fId).get(k)) {
                                                temp = new TableColumn(names.get(k));
                                                temp.setCellValueFactory((Callback)new MapValueFactory((Object)("" + k)));
                                                temp.setCellFactory((Callback)cellFactoryForMap);
                                                MainGUIController.this.tblFunction.getColumns().add((Object)temp);
                                            }
                                            --myi;
                                        }
                                    } else {
                                        int myi = parentList.size() - 1;
                                        while (myi >= 0) {
                                            int k = (Integer)parentList.get(myi);
                                            if (AssaGUI.getInstance((this).MainGUIController.this.assalog).getBitSetPBN().getVarF().get(fId).get(k)) {
                                                temp = new TableColumn("N" + k);
                                                temp.setCellValueFactory((Callback)new MapValueFactory((Object)("" + k)));
                                                temp.setCellFactory((Callback)cellFactoryForMap);
                                                MainGUIController.this.tblFunction.getColumns().add((Object)temp);
                                            }
                                            --myi;
                                        }
                                    }
                                    temp.setStyle("-fx-border-width: 0 2.5 0 0;-fx-table-cell-border-color: #000000;");
                                    temp = new TableColumn("Value");
                                    temp.setStyle("-fx-cursor: hand;");
                                    temp.setCellValueFactory((Callback)new MapValueFactory((Object)"Value"));
                                    temp.setCellFactory((Callback)cellFactoryForMap);
                                    MainGUIController.this.tblFunction.getColumns().add((Object)temp);
                                    MainGUIController.this.tblFunction.getItems().addAll(this.generateDataInMap(fId, nParentNodes, parentList));
                                }
                                MainGUIController.this.tblFunction.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                                    public void handle(MouseEvent event) {
                                        if (event.isPrimaryButtonDown() && event.getClickCount() == 2) {
                                            String temp;
                                            Parent node = ((Node)event.getTarget()).getParent();
                                            TableRow row = node instanceof TableRow ? (TableRow)node : (TableRow)node.getParent();
                                            if ("false".equals(((Map)row.getItem()).get("Value"))) {
                                                temp = "true";
                                                AssaGUI.getInstance((AssaLog)((this).this).MainGUIController.this.assalog).getBitSetPBN().getF().get((int)Integer.parseInt((String)((String)((Map)row.getItem()).get((Object)"fId"))))[Integer.parseInt((String)((String)((Map)row.getItem()).get((Object)"fValueId")))] = true;
                                            } else {
                                                temp = "false";
                                                AssaGUI.getInstance((AssaLog)((this).this).MainGUIController.this.assalog).getBitSetPBN().getF().get((int)Integer.parseInt((String)((String)((Map)row.getItem()).get((Object)"fId"))))[Integer.parseInt((String)((String)((Map)row.getItem()).get((Object)"fValueId")))] = false;
                                            }
                                            ((Map)row.getItem()).replace("Value", temp);
                                            System.out.println(row.getItem());
                                            ((TableColumn)MainGUIController.this.tblFunction.getColumns().get(0)).setVisible(false);
                                            ((TableColumn)MainGUIController.this.tblFunction.getColumns().get(0)).setVisible(true);
                                        }
                                    }
                                });
                            });
                        }
                    }

                    private ObservableList<Map> generateDataInMap(int func, int nParentNodes, ArrayList<Integer> parentList) {
                        int max = (int)Math.pow(2.0, nParentNodes);
                        ObservableList allData = FXCollections.observableArrayList();
                        int i = 0;
                        while (i < max) {
                            HashMap<String, String> dataRow = new HashMap<String, String>();
                            dataRow.put("Number", "" + i);
                            int count = 0;
                            for (int j : parentList) {
                                byte b = (byte)i;
                                String value1 = "" + (b >> count & 1);
                                ++count;
                                dataRow.put("" + j, value1);
                            }
                            dataRow.put("Value", "" + AssaGUI.getInstance((this).MainGUIController.this.assalog).getBitSetPBN().getF().get(func)[i]);
                            dataRow.put("fId", "" + func);
                            dataRow.put("fValueId", "" + i);
                            allData.add(dataRow);
                            ++i;
                        }
                        return allData;
                    }
                });
            }
        });
    }

    @FXML
    protected void loadFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Model File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Text(*.txt)", new String[]{"*.txt"}));
        File selectedFile = fileChooser.showOpenDialog(null);
        if (selectedFile != null) {
            try {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                DataInputStream dis = new DataInputStream(new FileInputStream(selectedFile));
                byte[] datainBytes = new byte[dis.available()];
                dis.readFully(datainBytes);
                dis.close();
                String s = new String(datainBytes, 0, datainBytes.length);
                this.txtAreaFile.setText("");
                this.txtAreaFile.setText(s);
                SingleSelectionModel selectionModel = this.rightTab.getSelectionModel();
                selectionModel.select(1);
                this.rightTab.setSelectionModel(selectionModel);
            }
            catch (Exception e1) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Format Error");
                alert.setHeaderText("Error. Wrong file format.");
                alert.setContentText(e1.getMessage());
                alert.showAndWait();
            }
        }
    }

    @FXML
    protected void loadModel(ActionEvent e) {
        BitSetPBNIO pbnIO = new BitSetPBNIO(this.assalog);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        fileChooser.setTitle("Load Model File");
        File selectedFile = fileChooser.showOpenDialog(null);
        if (selectedFile != null) {
            try {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                AssaGUI.getInstance(this.assalog).setBitSetPBN(pbnIO.loadPBN(selectedFile.getAbsolutePath()));
                this.currentModelPath = selectedFile.getAbsolutePath();
                AssaGUI.getInstance(this.assalog).setModelFullName(this.currentModelPath);
                this.loadOverview();
            }
            catch (Exception e1) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Format Error");
                alert.setHeaderText("Error. Wrong file format.");
                alert.setContentText(e1.getMessage());
                alert.showAndWait();
            }
        }
    }

    public void loadOverview() throws AssaException {
        this.getRoot().getChildren().clear();
        TreeItem temp = new TreeItem((Object)"Number of nodes");
        temp.getChildren().add((Object)new TreeItem((Object)("" + AssaGUI.getInstance(this.assalog).getBitSetPBN().getN())));
        temp.setExpanded(true);
        this.root.getChildren().add((Object)temp);
        temp = new TreeItem((Object)"Network density");
        try {
            temp.getChildren().add((Object)new TreeItem((Object)("" + AssaGUI.getInstance(this.assalog).getBitSetPBN().density())));
        }
        catch (Exception e) {
            temp.getChildren().add((Object)new TreeItem((Object)("" + null)));
        }
        temp.setExpanded(true);
        this.root.getChildren().add((Object)temp);
        temp = new TreeItem((Object)"Perturbation rate");
        temp.getChildren().add((Object)new TreeItem((Object)("" + AssaGUI.getInstance(this.assalog).getBitSetPBN().getPerturbation())));
        temp.setExpanded(true);
        this.root.getChildren().add((Object)temp);
        temp = new TreeItem((Object)"Function details");
        int count = 0;
        BitSetPBN pbn = AssaGUI.getInstance(this.assalog).getBitSetPBN();
        List<String> names = null;
        if (pbn instanceof BDDPBN) {
            Model model = ((BDDPBN)pbn).getModel();
            names = model.getNames();
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                TreeItem t = new TreeItem((Object)("Node " + names.get(i) + " (num. of predictor functions " + ((PBN)pbn).getNf()[i] + ")"));
                int j = count;
                while (j < count + ((PBN)pbn).getNf()[i]) {
                    TreeItem t1 = new TreeItem((Object)("Function " + (j - count) + ": " + model.getFunction(names.get(i), j - count).toString() + ", c(i,j)=" + new DecimalFormat("#.###").format(pbn.getCij().get(i)[j - count]) + "."));
                    int k = 0;
                    while (k < ((PBN)pbn).getVarF().get(j).size()) {
                        if (((PBN)pbn).getVarF().get(j).get(k)) {
                            t1.getChildren().add((Object)new TreeItem((Object)("Parent node index <" + names.get(k) + ">")));
                        }
                        ++k;
                    }
                    t.getChildren().add((Object)t1);
                    ++j;
                }
                temp.getChildren().add((Object)t);
                count += ((PBN)pbn).getNf()[i];
                ++i;
            }
            this.root.getChildren().add((Object)temp);
        } else {
            int i = 0;
            while (i < ((PBN)pbn).getN()) {
                TreeItem t = new TreeItem((Object)("Node " + i + " (num. of predictor functions " + ((PBN)pbn).getNf()[i] + ")"));
                int j = count;
                while (j < count + ((PBN)pbn).getNf()[i]) {
                    TreeItem t1 = new TreeItem((Object)("Function " + (j - count) + " (num. of parent nodes " + ((PBN)pbn).getNv().get(j) + ", c(i,j) " + new DecimalFormat("#.###").format(pbn.getCij().get(i)[j - count]) + ")"));
                    int k = 0;
                    while (k < ((PBN)pbn).getVarF().get(j).size()) {
                        if (((PBN)pbn).getVarF().get(j).get(k)) {
                            t1.getChildren().add((Object)new TreeItem((Object)("Parent node index <" + k + ">")));
                        }
                        ++k;
                    }
                    t.getChildren().add((Object)t1);
                    ++j;
                }
                temp.getChildren().add((Object)t);
                count += ((PBN)pbn).getNf()[i];
                ++i;
            }
            this.root.getChildren().add((Object)temp);
        }
        if (pbn.npNode().size() > 1) {
            TreeItem t;
            temp = new TreeItem((Object)"Nodes without perturbation");
            if (names != null) {
                int i = 0;
                while (i < pbn.npNode().size() - 1) {
                    t = new TreeItem((Object)names.get(pbn.npNode().get(i)));
                    temp.getChildren().add((Object)t);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < pbn.npNode().size() - 1) {
                    t = new TreeItem((Object)("" + pbn.npNode().get(i)));
                    temp.getChildren().add((Object)t);
                    ++i;
                }
            }
            this.root.getChildren().add((Object)temp);
        }
    }

    public void setAnalyseTextFieldStart(String s, boolean reset) {
        if (reset) {
            this.txtAreaAnalysis.setText("");
        } else {
            this.assalog.print(s);
        }
    }

    public void setAnalyseTextField(String s, boolean reset) {
        if (reset) {
            this.txtAreaAnalysis.setText("");
        } else {
            this.assalog.print(s);
        }
    }

    public void setFileTextField(String s, boolean reset) {
        if (reset) {
            this.txtAreaFile.setText("");
        } else {
            this.txtAreaFile.setText(String.valueOf(this.txtAreaFile.getText()) + s);
        }
    }

    public void setRoot(TreeItem<String> root) {
        this.root = root;
    }

    @FXML
    protected void simulate(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/SimulateModel.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Simulate Model");
            stage.setScene(new Scene(root1));
            SimulateModelGUIController controller = (SimulateModelGUIController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void parameterEstimation(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/ParameterEstimation.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Paramter Estimation");
            stage.setScene(new Scene(root1));
            ParameterEstimationController controller = (ParameterEstimationController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void simulateGauss(ActionEvent e) {
        try {
            if (AssaGUI.getInstance(this.assalog).getBitSetPBN() != null) {
                gauss = new GaussSeidelGUI(AssaGUI.getInstance(this.assalog).getBitSetPBN(), this.assalog);
                try {
                    FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/SimulateGauss.fxml"));
                    Parent root1 = (Parent)fxmlLoader.load();
                    Stage stage = new Stage();
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
                    stage.setTitle("Compute steady-state probability(Gauss)");
                    stage.setScene(new Scene(root1));
                    SimulateGaussGUIController controller = (SimulateGaussGUIController)fxmlLoader.getController();
                    controller.initData(this);
                    stage.show();
                }
                catch (IOException e1) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Format Error");
                    alert.setHeaderText("Error. Wrong file format.");
                    alert.setContentText(e1.getMessage());
                    alert.showAndWait();
                }
            } else {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("NO MODEL");
                alert.setHeaderText("Error. Generate a model first.");
                alert.setContentText("No model was found during execution.");
                alert.showAndWait();
            }
        }
        catch (OutOfMemoryError e1) {
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Simulation Error");
                alert.setHeaderText("Error. Simulation not performed.");
                alert.setContentText("Out of memory. Model too big, please try statistical method or raise memory limit.");
                alert.showAndWait();
            });
        }
    }

    @FXML
    protected void simulateJacobi(ActionEvent e) {
        try {
            if (AssaGUI.getInstance(this.assalog).getBitSetPBN() != null) {
                gauss = null;
                jacobi = new JacobGUI(AssaGUI.getInstance(this.assalog).getBitSetPBN(), this.assalog);
                try {
                    FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/SimulateJacobi.fxml"));
                    Parent root1 = (Parent)fxmlLoader.load();
                    Stage stage = new Stage();
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
                    stage.setTitle("Compute steady-state probability(Jacobi)");
                    stage.setScene(new Scene(root1));
                    SimulateJacobiGUIController controller = (SimulateJacobiGUIController)fxmlLoader.getController();
                    controller.initData(this);
                    stage.show();
                }
                catch (IOException e1) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Format Error");
                    alert.setHeaderText("Error. Wrongg file format.");
                    alert.setContentText(e1.getMessage());
                    alert.showAndWait();
                }
            } else {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("NO MODEL");
                alert.setHeaderText("Error. Generate a model first.");
                alert.setContentText("No model was found during execution.");
                alert.showAndWait();
            }
        }
        catch (OutOfMemoryError e1) {
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Simulation Error");
                alert.setHeaderText("Error. Simulation not performed.");
                alert.setContentText("Out of memory. Model too big, please try statistical method or raise memory limit.");
                alert.showAndWait();
            });
        }
    }

    @FXML
    protected void simulatePerfect(ActionEvent e) {
        if (AssaGUI.getInstance(this.assalog).getBitSetPBN() != null) {
            try {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/SimulatePerfect.fxml"));
                Parent root1 = (Parent)fxmlLoader.load();
                Stage stage = new Stage();
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Perfect Simulation");
                stage.setScene(new Scene(root1));
                stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
                SimulatePerfectGUIController controller = (SimulatePerfectGUIController)fxmlLoader.getController();
                controller.initData(this);
                stage.show();
            }
            catch (IOException e1) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Format Error");
                alert.setHeaderText("Error. Wrong file format.");
                alert.setContentText(e1.getMessage());
                alert.showAndWait();
            }
        } else {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("NO MODEL");
            alert.setHeaderText("Error. Generate a model first.");
            alert.setContentText("No model was found during execution.");
            alert.showAndWait();
        }
    }

    @FXML
    protected void simulateSkart(ActionEvent e) {
        if (AssaGUI.getInstance(this.assalog).getBitSetPBN() != null) {
            try {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/SimulateSkart.fxml"));
                Parent root1 = (Parent)fxmlLoader.load();
                Stage stage = new Stage();
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Skart");
                stage.setScene(new Scene(root1));
                stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
                SimulateSkartGUIController controller = (SimulateSkartGUIController)fxmlLoader.getController();
                controller.initData(this);
                stage.show();
            }
            catch (IOException e1) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Format Error");
                alert.setHeaderText("Error. Wrong file format.");
                alert.setContentText(e1.getMessage());
                alert.showAndWait();
            }
        } else {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("NO MODEL");
            alert.setHeaderText("Error. Generate a model first.");
            alert.setContentText("No model was found during execution.");
            alert.showAndWait();
        }
    }

    @FXML
    protected void simulateTwoState(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/SimulateTwoState.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Two State Markov Chain");
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.setScene(new Scene(root1));
            SimulateTwoStateGUIController controller = (SimulateTwoStateGUIController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong file format.");
            alert.setContentText(e1.getMessage());
            alert.showAndWait();
        }
    }

    @FXML
    protected void about(ActionEvent e) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("About ASSA-PBN.");
        alert.setHeaderText(new Version().getVersion());
        alert.showAndWait();
    }

    @FXML
    protected void userGuide(ActionEvent e) {
        try {
            Desktop.getDesktop().browse(new URI("http://satoss.uni.lu/software/ASSA-PBN/userguide.pdf"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    public void setLog(AssaLog assalog) {
        this.assalog = assalog;
    }

    public AssaLog getAssaLog() {
        return this.assalog;
    }

    class Task
    implements Runnable {
        Task() {
        }

        @Override
        public void run() {
        }
    }
}

