/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import functionLib.ParametersGUI;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import parameterEstimation.particleSwarm.estiPBN.Estimate;
import userInterface.AssaLog;
import view.GUI.controller.MainGUIController;
import view.GUI.controller.PBNFile;
import view.GUI.etc.AssaGUI;

public class ParameterEstimationController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private TextField nodeIndices;
    @FXML
    private TextField parameters;
    @FXML
    private TextField property;
    @FXML
    private TextField txtNumberCores;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtConfidence;
    @FXML
    private TextField txtIterations;
    @FXML
    private TextField txtParticles;
    @FXML
    private TableView<PBNFile> PBNFiles;
    @FXML
    private ChoiceBox<String> cbMethod;
    @FXML
    private CheckBox cbParallel;
    @FXML
    private CheckBox cbStartPolicy;
    @FXML
    private CheckBox cbAdaptiveUpdate;
    private MainGUIController mainGUIController;
    private TS_Task ts_task;

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
        this.cbMethod.getItems().add((Object)"Particle Swarm");
        this.cbMethod.getSelectionModel().select(0);
    }

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void calculate(ActionEvent e) {
        try {
            ((Node)e.getSource()).getScene().getWindow().hide();
            if (this.ts_task == null) {
                this.ts_task = new TS_Task(e, this.mainGUIController);
            } else {
                this.ts_task.setE(e);
            }
            AssaGUI.getInstance().setTask(new Thread(this.ts_task));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (NumberFormatException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong input.");
            alert.setContentText("Please fill out all fields correctly");
            alert.showAndWait();
        }
    }

    @FXML
    protected void loadPBNFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Perturbed PBN File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        ObservableList data = this.PBNFiles.getItems();
        List selectedFile = fileChooser.showOpenMultipleDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = ((File)selectedFile.get(selectedFile.size() - 1)).getParent();
                for (File f : selectedFile) {
                    data.add((Object)new PBNFile(f.getAbsolutePath(), f.getName()));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    protected void removePBNFile(ActionEvent e) {
        TableView.TableViewSelectionModel selectionModel = this.PBNFiles.getSelectionModel();
        ObservableList selectedCells = selectionModel.getSelectedCells();
        ObservableList data = this.PBNFiles.getItems();
        if (selectedCells != null) {
            int i = 0;
            while (i < selectedCells.size()) {
                TablePosition tablePosition = (TablePosition)selectedCells.get(i);
                data.remove(tablePosition.getRow());
                ++i;
            }
        }
    }

    @FXML
    protected void loadParameterFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Parameter File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                this.parameters.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    protected void loadPropertyFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Property File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                this.property.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    protected void setParallel(ActionEvent e) {
        if (this.cbParallel.isSelected()) {
            this.txtNumberCores.setDisable(false);
            int cores = Runtime.getRuntime().availableProcessors();
            this.txtNumberCores.setText(String.valueOf(cores));
        } else {
            this.txtNumberCores.setDisable(true);
        }
    }

    class TS_Task
    implements Runnable {
        ActionEvent e;
        private MainGUIController mainGUIController;

        public TS_Task(ActionEvent e, MainGUIController mainGUIController) {
            this.e = e;
            this.mainGUIController = mainGUIController;
        }

        public void setE(ActionEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                this.mainGUIController.disableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                this.mainGUIController.getStatus().setText(" Running..");
            });
            Estimate est = new Estimate(ParameterEstimationController.this.assalog);
            String[] fileNames = null;
            int simulationMethod = 3;
            int m = 0;
            boolean parallel = false;
            boolean adaptive = false;
            int evaluateMethod = 0;
            int startPoint = 1;
            ObservableList data = ParameterEstimationController.this.PBNFiles.getItems();
            if (data != null) {
                fileNames = new String[data.size()];
                int i = 0;
                while (i < data.size()) {
                    fileNames[i] = ((PBNFile)data.get(i)).getFilePath();
                    ++i;
                }
            }
            String parameterFile = ParameterEstimationController.this.parameters.getText();
            String propertyFile = ParameterEstimationController.this.property.getText();
            double precision = Double.parseDouble(ParameterEstimationController.this.txtPrecision.getText());
            double confidence = Double.parseDouble(ParameterEstimationController.this.txtConfidence.getText());
            int numberIterations = Integer.parseInt(ParameterEstimationController.this.txtIterations.getText());
            int numberParticles = Integer.parseInt(ParameterEstimationController.this.txtParticles.getText());
            if (ParameterEstimationController.this.cbParallel.isSelected()) {
                parallel = true;
                m = Integer.parseInt(ParameterEstimationController.this.txtNumberCores.getText());
            }
            if (ParameterEstimationController.this.cbStartPolicy.isSelected()) {
                startPoint = 0;
            }
            if (ParameterEstimationController.this.cbAdaptiveUpdate.isSelected()) {
                adaptive = true;
            }
            try {
                est.run(fileNames, parameterFile, propertyFile, precision, confidence, simulationMethod, m, parallel, evaluateMethod, numberParticles, numberIterations, startPoint, adaptive);
            }
            catch (Exception e) {
                ParameterEstimationController.this.assalog.println("\n*******************An error occured. Please verify your assigned PBN files or experiment data file!\n*******************");
            }
            Platform.runLater(() -> {
                this.mainGUIController.enableFunction();
                this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                this.mainGUIController.getStatus().setText(" Ready");
                this.mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

