/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import functionLib.ParametersGUI;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import view.GUI.MainGUI;
import view.GUI.controller.CreatePropertiesGUIController;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class SimulateGaussGUIController
implements Initializable {
    @FXML
    private Button btnGenerate;
    @FXML
    private URL location;
    private MainGUIController mainGUIController;
    @FXML
    private ResourceBundle resources;
    @FXML
    private TextField txtMaxIterations;
    @FXML
    private TextField txtPath;
    @FXML
    private TextField txtPrecision;

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void loadPropertyFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Property File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                this.txtPath.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPath(String s) {
        this.txtPath.setText(s);
    }

    @FXML
    protected void setProprities(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/CreateProperties.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Create property file");
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.setScene(new Scene(root1));
            CreatePropertiesGUIController controller = (CreatePropertiesGUIController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void simulateGauss(ActionEvent e) {
        try {
            AssaGUI.getInstance().setTask(new Thread(new Task(this, e)));
            this.mainGUIController.btnCancel.setVisible(true);
            AssaGUI.getInstance().getTask().setDaemon(true);
            AssaGUI.getInstance().getTask().start();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    class Task
    implements Runnable {
        ActionEvent e;
        SimulateGaussGUIController sm;

        public Task(SimulateGaussGUIController sm, ActionEvent e) {
            this.sm = sm;
            this.e = e;
        }

        @Override
        public void run() {
            block10: {
                Platform.runLater(() -> {
                    SimulateGaussGUIController.this.mainGUIController.disableFunction();
                    SimulateGaussGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                    SimulateGaussGUIController.this.mainGUIController.getStatus().setText(" Running..");
                });
                try {
                    if (Double.parseDouble(SimulateGaussGUIController.this.txtPrecision.getText()) > 0.0 && Double.parseDouble(SimulateGaussGUIController.this.txtPrecision.getText()) < 1.0) {
                        if (Long.parseLong(SimulateGaussGUIController.this.txtMaxIterations.getText()) > 0L) {
                            MainGUIController.getGauss().setPrecsion(Double.parseDouble(SimulateGaussGUIController.this.txtPrecision.getText()));
                            MainGUIController.getGauss().setMaxIteration(Long.parseLong(SimulateGaussGUIController.this.txtMaxIterations.getText()));
                            try {
                                MainGUIController.getGauss().setProperty(SimulateGaussGUIController.this.txtPath.getText());
                            }
                            catch (IOException e1) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Format Error");
                                    alert.setHeaderText("Error. Wrong property file format.");
                                    alert.setContentText(e1.getMessage());
                                    alert.showAndWait();
                                });
                            }
                            try {
                                MainGUIController.getGauss().setGUI(SimulateGaussGUIController.this.mainGUIController);
                                Platform.runLater(() -> ((Node)this.e.getSource()).getScene().getWindow().hide());
                                try {
                                    MainGUIController.getGauss().run();
                                    break block10;
                                }
                                catch (OutOfMemoryError e) {
                                    Platform.runLater(() -> {
                                        Alert alert = new Alert(Alert.AlertType.ERROR);
                                        alert.setTitle("Simulation Error");
                                        alert.setHeaderText("Error. Simulation not performed.");
                                        alert.setContentText("Out of memory. Model too big, please try statistical method or raise memory limit.");
                                        alert.showAndWait();
                                    });
                                }
                            }
                            catch (Exception e1) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Simulation Error");
                                    alert.setHeaderText("Error. Simulation not performed.");
                                    alert.setContentText(e1.getMessage());
                                    alert.showAndWait();
                                });
                            }
                            break block10;
                        }
                        Platform.runLater(() -> {
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle("Number Error");
                            alert.setHeaderText("MaxIterations Error.");
                            alert.setContentText("Max Iterations has to be bigger than 1.");
                            alert.showAndWait();
                        });
                        break block10;
                    }
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Number Error");
                        alert.setHeaderText("Precision Error.");
                        alert.setContentText("Precision p hast to be 0 < p < 1.");
                        alert.showAndWait();
                    });
                }
                catch (NumberFormatException ex) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Format Error");
                        alert.setHeaderText("Error. Wrong number Format.");
                        alert.setContentText(ex.getMessage());
                        alert.showAndWait();
                    });
                }
            }
            Platform.runLater(() -> {
                SimulateGaussGUIController.this.mainGUIController.enableFunction();
                SimulateGaussGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                SimulateGaussGUIController.this.mainGUIController.getStatus().setText(" Ready");
                ((SimulateGaussGUIController)SimulateGaussGUIController.this).mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

