/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BitSetPBNIO;
import PBN.StateBit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import simulationMethod.BitSetPBNSimulationEngine;
import userInterface.AssaLog;
import view.GUI.MainGUI;
import view.GUI.controller.MainGUIController;
import view.GUI.controller.SimulateModelGraphGUIController;
import view.GUI.etc.AssaGUI;

public class SimulateModelGUIController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private CheckBox showGraph;
    private int length1;
    @FXML
    private URL location;
    private MainGUIController mainGUIController;
    @FXML
    private ResourceBundle resources;
    private ArrayList<StateBit> sb;
    @FXML
    private TextField txtInitial;
    @FXML
    private TextField txtLength;

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public int getLength() {
        return this.length1;
    }

    public ArrayList<StateBit> getSb() {
        return this.sb;
    }

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void simulateModel(ActionEvent e) {
        Platform.runLater((Runnable)new Task(this, e));
    }

    class Task
    implements Runnable {
        ActionEvent e;
        SimulateModelGUIController sm;

        public Task(SimulateModelGUIController sm, ActionEvent e) {
            this.sm = sm;
            this.e = e;
        }

        @Override
        public void run() {
            Platform.runLater(() -> {
                SimulateModelGUIController.this.mainGUIController.disableFunction();
                SimulateModelGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                SimulateModelGUIController.this.mainGUIController.getStatus().setText(" Running..");
            });
            String s = "";
            int length = 0;
            try {
                length = Integer.parseInt(SimulateModelGUIController.this.txtLength.getText());
                if (length < 1) {
                    throw new NumberFormatException("Enter a valid length.");
                }
            }
            catch (Exception e1) {
                Platform.runLater(() -> {
                    SimulateModelGUIController.this.mainGUIController.enableFunction();
                    SimulateModelGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                    SimulateModelGUIController.this.mainGUIController.getStatus().setText(" Ready");
                    ((SimulateModelGUIController)SimulateModelGUIController.this).mainGUIController.btnCancel.setVisible(false);
                });
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Simulation Error");
                alert.setHeaderText("Error. Simulation not performed.");
                alert.setContentText("Enter a valid length.");
                alert.showAndWait();
            }
            char[] bits = SimulateModelGUIController.this.txtInitial.getText().toCharArray();
            BitSetPBNSimulationEngine en = new BitSetPBNSimulationEngine(AssaGUI.getInstance(SimulateModelGUIController.this.assalog).getBitSetPBN(), null);
            StateBit initialState = new StateBit(AssaGUI.getInstance(SimulateModelGUIController.this.assalog).getBitSetPBN().getN());
            if (bits.length == AssaGUI.getInstance(SimulateModelGUIController.this.assalog).getBitSetPBN().getN() || bits.length == 0) {
                if (bits.length > 0) {
                    initialState.clear();
                    int i = 0;
                    while (i < bits.length) {
                        if (bits[i] == '1') {
                            initialState.set(i, true);
                        }
                        ++i;
                    }
                } else {
                    initialState.clear();
                    Random r = new Random(System.currentTimeMillis());
                    int i = 0;
                    while (i < AssaGUI.getInstance(SimulateModelGUIController.this.assalog).getBitSetPBN().getN()) {
                        if (r.nextBoolean()) {
                            initialState.set(i, true);
                        }
                        ++i;
                    }
                }
            }
            if (SimulateModelGUIController.this.showGraph.isSelected()) {
                if (length >= 1) {
                    SimulateModelGUIController.this.length1 = length;
                    try {
                        s = String.valueOf(s) + "Starting Model Simulation..\n\n";
                        int i = 0;
                        while (i < AssaGUI.getInstance(SimulateModelGUIController.this.assalog).getBitSetPBN().getN()) {
                            s = String.valueOf(s) + "N" + i + "\t";
                            ++i;
                        }
                        s = String.valueOf(s) + "STEP\n";
                        SimulateModelGUIController.this.sb = en.simulateGUI(length, initialState);
                        i = 0;
                        while (i < SimulateModelGUIController.this.sb.size()) {
                            int j = 0;
                            while (j < AssaGUI.getInstance(SimulateModelGUIController.this.assalog).getBitSetPBN().getN()) {
                                s = String.valueOf(s) + (!((StateBit)SimulateModelGUIController.this.sb.get(i)).get(j) ? " 0\t" : " 1\t");
                                ++j;
                            }
                            s = String.valueOf(s) + "   " + i + "\n";
                            ++i;
                        }
                        s = String.valueOf(s) + "\nSimulation performed.\n-------------------------\n";
                        ((Node)this.e.getSource()).getScene().getWindow().hide();
                        SimulateModelGUIController.this.mainGUIController.setAnalyseTextField(s, false);
                        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/SimulateModelGraph.fxml"));
                        Parent root1 = (Parent)fxmlLoader.load();
                        Stage stage = new Stage();
                        stage.initModality(Modality.APPLICATION_MODAL);
                        stage.setTitle("Simulate Graph");
                        stage.setScene(new Scene(root1));
                        stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
                        SimulateModelGraphGUIController controller = (SimulateModelGraphGUIController)fxmlLoader.getController();
                        controller.initData(this.sm, s);
                        stage.initModality(Modality.NONE);
                        stage.show();
                    }
                    catch (Exception e1) {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Simulation Error");
                        alert.setHeaderText("Error. Simulation not performed.");
                        alert.setContentText(e1.getMessage());
                        alert.showAndWait();
                    }
                } else {
                    Platform.runLater(() -> {
                        SimulateModelGUIController.this.mainGUIController.enableFunction();
                        SimulateModelGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        SimulateModelGUIController.this.mainGUIController.getStatus().setText(" Ready");
                        ((SimulateModelGUIController)SimulateModelGUIController.this).mainGUIController.btnCancel.setVisible(false);
                    });
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Initial State Error");
                    alert.setHeaderText("Error. Simulation not performed.");
                    alert.setContentText("Please set a value for every node.");
                    alert.showAndWait();
                }
            } else {
                ((Node)this.e.getSource()).getScene().getWindow().hide();
                BitSetPBNIO io = new BitSetPBNIO(AssaGUI.getInstance(SimulateModelGUIController.this.assalog).getBitSetPBN(), SimulateModelGUIController.this.assalog);
                try {
                    io.simulate(length, initialState, false, null);
                }
                catch (Exception e) {
                    Platform.runLater(() -> {
                        SimulateModelGUIController.this.mainGUIController.enableFunction();
                        SimulateModelGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                        SimulateModelGUIController.this.mainGUIController.getStatus().setText(" Ready");
                        ((SimulateModelGUIController)SimulateModelGUIController.this).mainGUIController.btnCancel.setVisible(false);
                    });
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Simulation Error");
                    alert.setHeaderText("Error. Simulation not performed.");
                    alert.setContentText(e.getMessage());
                    alert.showAndWait();
                }
            }
            Platform.runLater(() -> {
                SimulateModelGUIController.this.mainGUIController.enableFunction();
                SimulateModelGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                SimulateModelGUIController.this.mainGUIController.getStatus().setText(" Ready");
                ((SimulateModelGUIController)SimulateModelGUIController.this).mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

