/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import functionLib.ParametersGUI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import view.GUI.controller.SimulateModelGUIController;
import view.GUI.etc.AssaGUI;

public class SimulateModelGraphGUIController
implements Initializable {
    @FXML
    private Button hideAll;
    @FXML
    private LineChart<Integer, Integer> linechart;
    @FXML
    private URL location;
    @FXML
    private MenuButton mShow;
    private HashMap<String, XYChart.Series<Integer, Integer>> original = new HashMap();
    @FXML
    private ResourceBundle resources;
    @FXML
    private Button showAll;
    private SimulateModelGUIController simulateModelGUIController;
    private HashMap<String, XYChart.Series<Integer, Integer>> temp = new HashMap();
    @FXML
    private TextField txtMin;
    @FXML
    private TextField txtMax;
    @FXML
    private NumberAxis xAxis;
    @FXML
    private MenuItem saveData;
    private String data;

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    @FXML
    protected void saveData() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Model");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        FileChooser.ExtensionFilter filter1 = new FileChooser.ExtensionFilter("Text file(*.txt)", new String[]{"*.txt"});
        fileChooser.getExtensionFilters().add((Object)filter1);
        File file = fileChooser.showSaveDialog(null);
        if (file != null) {
            try {
                ParametersGUI.lastDirectory = file.getParent();
                this.data.replaceAll("\n", System.lineSeparator());
                FileWriter fw = new FileWriter("" + file);
                fw.write(this.data);
                fw.close();
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    @FXML
    protected void hideAll(ActionEvent e) {
        for (MenuItem mi : this.mShow.getItems()) {
            ((CheckMenuItem)mi).setSelected(false);
        }
        this.linechart.getData().clear();
        this.temp.clear();
    }

    public void initData(SimulateModelGUIController simulateModelGUIController, String s) {
        this.data = s;
        this.simulateModelGUIController = simulateModelGUIController;
        this.linechart.setCreateSymbols(false);
        this.xAxis.setUpperBound((double)simulateModelGUIController.getSb().size());
        this.txtMin.setText("0");
        this.txtMax.setText("" + simulateModelGUIController.getLength());
        this.linechart.setTitle("Simulation of " + simulateModelGUIController.getLength() + " steps");
        int i = 0;
        while (i < AssaGUI.getInstance().getBitSetPBN().getN()) {
            XYChart.Series series1 = new XYChart.Series();
            series1.setName("Node " + i);
            final CheckMenuItem mi = new CheckMenuItem("" + i);
            mi.setSelected(true);
            mi.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    if (!mi.isSelected()) {
                        SimulateModelGraphGUIController.this.linechart.getData().clear();
                        SimulateModelGraphGUIController.this.temp.remove(mi.getText());
                        for (String i : SimulateModelGraphGUIController.this.temp.keySet()) {
                            SimulateModelGraphGUIController.this.linechart.getData().add((Object)((XYChart.Series)SimulateModelGraphGUIController.this.temp.get(i)));
                        }
                    } else {
                        SimulateModelGraphGUIController.this.linechart.getData().clear();
                        SimulateModelGraphGUIController.this.temp.put(mi.getText(), (XYChart.Series)SimulateModelGraphGUIController.this.original.get(mi.getText()));
                        for (String i : SimulateModelGraphGUIController.this.temp.keySet()) {
                            SimulateModelGraphGUIController.this.linechart.getData().add((Object)((XYChart.Series)SimulateModelGraphGUIController.this.temp.get(i)));
                        }
                    }
                }
            });
            this.mShow.getItems().add((Object)mi);
            int j = 0;
            while (j < simulateModelGUIController.getSb().size()) {
                series1.getData().add((Object)new XYChart.Data((Object)j, (Object)(simulateModelGUIController.getSb().get(j).get(i) ? 1 : 0)));
                series1.getData().add((Object)new XYChart.Data((Object)(j + 1), (Object)(simulateModelGUIController.getSb().get(j).get(i) ? 1 : 0)));
                ++j;
            }
            this.linechart.getData().add((Object)series1);
            this.original.put("" + i, (XYChart.Series<Integer, Integer>)series1);
            ++i;
        }
        for (String i2 : this.original.keySet()) {
            this.temp.put(i2, this.original.get(i2));
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void intervalChanged(ActionEvent e) {
        try {
            int min = Integer.parseInt(this.txtMin.getText());
            int max = Integer.parseInt(this.txtMax.getText());
            this.xAxis.setUpperBound((double)max);
            this.xAxis.setLowerBound((double)min);
        }
        catch (NumberFormatException e1) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Format Error");
            alert.setHeaderText("Error. Wrong number Format.");
            alert.setContentText(e1.getMessage());
            alert.showAndWait();
        }
    }

    @FXML
    protected void showAll(ActionEvent e) {
        this.linechart.getData().clear();
        this.temp.clear();
        for (String i : this.original.keySet()) {
            this.temp.put(i, this.original.get(i));
        }
        for (String i : this.temp.keySet()) {
            this.linechart.getData().add(this.temp.get(i));
        }
    }
}

