/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import functionLib.ParametersGUI;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import simulationMethod.StepPerfectSimulationWalkerBitSet;
import view.GUI.MainGUI;
import view.GUI.controller.CreatePropertiesGUIController;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class SimulatePerfectGUIController
implements Initializable {
    @FXML
    private Button btnGenerate;
    @FXML
    private CheckBox cbGlobalAlias;
    @FXML
    private URL location;
    private MainGUIController mainGUIController;
    @FXML
    private ResourceBundle resources;
    @FXML
    private TextField txtConfidence;
    @FXML
    private TextField txtPath;
    @FXML
    private TextField txtPrecision;

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void loadPropertyFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Property File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                this.txtPath.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPath(String s) {
        this.txtPath.setText(s);
    }

    @FXML
    protected void setProprities(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/CreateProperties.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Create property file");
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.setScene(new Scene(root1));
            CreatePropertiesGUIController controller = (CreatePropertiesGUIController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void simulatePerfect(ActionEvent e) {
        AssaGUI.getInstance().setTask(new Thread(new Task(this, e)));
        this.mainGUIController.btnCancel.setVisible(true);
        AssaGUI.getInstance().getTask().setDaemon(true);
        AssaGUI.getInstance().getTask().start();
    }

    class Task
    implements Runnable {
        ActionEvent e;
        SimulatePerfectGUIController sm;

        public Task(SimulatePerfectGUIController sm, ActionEvent e) {
            this.sm = sm;
            this.e = e;
        }

        @Override
        public void run() {
            block8: {
                Platform.runLater(() -> {
                    SimulatePerfectGUIController.this.mainGUIController.disableFunction();
                    SimulatePerfectGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                    SimulatePerfectGUIController.this.mainGUIController.getStatus().setText(" Running..");
                });
                try {
                    double precision = Double.parseDouble(SimulatePerfectGUIController.this.txtPrecision.getText());
                    double confidence = Double.parseDouble(SimulatePerfectGUIController.this.txtConfidence.getText());
                    if (precision < 1.0 && precision > 0.0 && confidence > 0.0 && confidence < 1.0) {
                        boolean globalAlias = SimulatePerfectGUIController.this.cbGlobalAlias.isSelected();
                        StepPerfectSimulationWalkerBitSet ps = StepPerfectSimulationWalkerBitSet.getInstance();
                        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
                        ps.setSampleSize(confidence, precision);
                        ps.setUseAlias(globalAlias);
                        ps.setCost(true);
                        String outputName = null;
                        if (outputName == null) {
                            outputName = "ps_" + df.format(new Date()) + ".txt";
                        }
                        try {
                            ps.setIO(AssaGUI.getInstance().getBitSetPBN(), outputName);
                        }
                        catch (FileNotFoundException e2) {
                            e2.printStackTrace();
                        }
                        double average = 0.0;
                        double sampleSize = 0.0;
                        double simulationStep = 0.0;
                        double couplingStep = 0.0;
                        double cpu = 0.0;
                        Platform.runLater(() -> SimulatePerfectGUIController.this.mainGUIController.setAnalyseTextField("Performing the perfect simulation.. \n", false));
                        String tmp = outputName;
                        Platform.runLater(() -> SimulatePerfectGUIController.this.mainGUIController.setAnalyseTextField("Detailed information is stored in the file: " + tmp + "\n", false));
                        try {
                            Platform.runLater(() -> ((Node)this.e.getSource()).getScene().getWindow().hide());
                            double[] result = ps.runWalker(SimulatePerfectGUIController.this.txtPath.getText(), 1000, false);
                            double couplingStep_tmp = couplingStep += result[1];
                            double simulationStep_tmp = simulationStep += result[2];
                            double sampleSize_tmp = sampleSize += result[3];
                            double cpu_tmp = cpu += result[4];
                            double average_tmp = average += result[0];
                            Platform.runLater(() -> SimulatePerfectGUIController.this.mainGUIController.setAnalyseTextField("Avg. coupling steps\t" + couplingStep_tmp + "\nSimulation steps\t" + simulationStep_tmp + "\nNumber of samples\t" + sampleSize_tmp + "\nCPU time cost\t\t" + cpu_tmp + "s\nProbability\t\t" + average_tmp + "\n----------------\n", false));
                            SimulatePerfectGUIController.this.mainGUIController.setFileTextField("", true);
                            DataInputStream dis = new DataInputStream(new FileInputStream(outputName));
                            byte[] datainBytes = new byte[dis.available()];
                            dis.readFully(datainBytes);
                            dis.close();
                            String s = new String(datainBytes, 0, datainBytes.length);
                            Platform.runLater(() -> SimulatePerfectGUIController.this.mainGUIController.setFileTextField(s, false));
                        }
                        catch (Exception e1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Simulation Error");
                                alert.setHeaderText("Error. Simulation not performded.");
                                alert.setContentText(e1.getMessage());
                                alert.showAndWait();
                            });
                        }
                        break block8;
                    }
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Number Error");
                        alert.setHeaderText("Precision/Confidence Error.");
                        alert.setContentText("Precision p and Confidence c have to be 0 < p and c < 1.");
                        alert.showAndWait();
                    });
                }
                catch (NumberFormatException e1) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error. Wrong data format.");
                        alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                        alert.showAndWait();
                    });
                }
            }
            Platform.runLater(() -> {
                SimulatePerfectGUIController.this.mainGUIController.enableFunction();
                SimulatePerfectGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                SimulatePerfectGUIController.this.mainGUIController.getStatus().setText(" Ready");
                ((SimulatePerfectGUIController)SimulatePerfectGUIController.this).mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

