/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.ParseProperty;
import functionLib.ParametersGUI;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;
import view.GUI.MainGUI;
import view.GUI.controller.CreatePropertiesGUIController;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class SimulateSkartGUIController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private Button btnGenerate;
    @FXML
    private CheckBox cbGlobalAlias;
    @FXML
    private CheckBox cbSkartFull;
    @FXML
    private URL location;
    private MainGUIController mainGUIController;
    @FXML
    private ResourceBundle resources;
    @FXML
    private TextField txtConfidence;
    @FXML
    private TextField txtPath;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtCores;
    @FXML
    private CheckBox cbParallel;
    @FXML
    private Label lbCores;
    private boolean parallel = false;

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = mainGUIController.getAssaLog();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void loadPropertyFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Property File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                this.txtPath.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPath(String s) {
        this.txtPath.setText(s);
    }

    @FXML
    protected void setProprities(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/CreateProperties.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Create property file");
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.setScene(new Scene(root1));
            CreatePropertiesGUIController controller = (CreatePropertiesGUIController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void simulateSkart(ActionEvent e) {
        AssaGUI.getInstance().setTask(new Thread(new Task(this, e)));
        this.mainGUIController.btnCancel.setVisible(true);
        AssaGUI.getInstance().getTask().setDaemon(true);
        AssaGUI.getInstance().getTask().start();
    }

    @FXML
    protected void allowParallel(ActionEvent e) {
        if (this.cbParallel.isSelected()) {
            this.lbCores.setDisable(false);
            this.txtCores.setDisable(false);
            int cores = Runtime.getRuntime().availableProcessors();
            this.txtCores.setText(String.valueOf(cores));
            this.parallel = true;
            this.cbSkartFull.setSelected(false);
            this.cbSkartFull.setDisable(true);
        } else {
            this.lbCores.setDisable(true);
            this.txtCores.setDisable(true);
            this.parallel = false;
            this.cbSkartFull.setDisable(false);
        }
    }

    @FXML
    protected void skartFull(ActionEvent e) {
        if (this.cbSkartFull.isSelected()) {
            this.lbCores.setDisable(true);
            this.txtCores.setDisable(true);
            this.parallel = false;
            this.cbParallel.setDisable(true);
        } else {
            this.cbParallel.setDisable(false);
            this.parallel = false;
        }
    }

    class Task
    implements Runnable {
        ActionEvent e;
        SimulationMethod simulationMethod;
        SimulateSkartGUIController sm;

        public Task(SimulateSkartGUIController sm, ActionEvent e) {
            this.sm = sm;
            this.e = e;
        }

        @Override
        public void run() {
            block13: {
                Platform.runLater(() -> {
                    SimulateSkartGUIController.this.mainGUIController.disableFunction();
                    SimulateSkartGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                    SimulateSkartGUIController.this.mainGUIController.getStatus().setText(" Running..");
                });
                try {
                    double precision = Double.parseDouble(SimulateSkartGUIController.this.txtPrecision.getText());
                    double confidence = Double.parseDouble(SimulateSkartGUIController.this.txtConfidence.getText());
                    if (precision < 1.0 && precision > 0.0 && confidence > 0.0 && confidence < 1.0) {
                        boolean globalAlias = SimulateSkartGUIController.this.cbGlobalAlias.isSelected();
                        if (SimulateSkartGUIController.this.parallel) {
                            this.simulationMethod = SimulateSkartGUIController.this.mainGUIController.smProvider(6);
                            this.simulationMethod.setParameters(new double[]{precision, confidence, Double.parseDouble(SimulateSkartGUIController.this.txtCores.getText())});
                        } else if (SimulateSkartGUIController.this.cbSkartFull.isSelected()) {
                            this.simulationMethod = SimulateSkartGUIController.this.mainGUIController.smProvider(5);
                            this.simulationMethod.setParameters(new double[]{precision, confidence});
                        } else {
                            this.simulationMethod = SimulateSkartGUIController.this.mainGUIController.smProvider(4);
                            this.simulationMethod.setParameters(new double[]{precision, confidence});
                        }
                        if (!globalAlias) {
                            this.simulationMethod.setDisableGlobalAlias(true);
                        }
                        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
                        String outputName = null;
                        try {
                            this.simulationMethod.setExpressions(ParseProperty.getProperties(AssaGUI.getInstance().getBitSetPBN(), SimulateSkartGUIController.this.txtPath.getText()));
                            try {
                                Platform.runLater(() -> SimulateSkartGUIController.this.mainGUIController.setAnalyseTextField("Performing the " + this.simulationMethod.getInstanceName() + " approach ...\n", false));
                                String outputName_tmp = outputName;
                                Platform.runLater(() -> ((Node)this.e.getSource()).getScene().getWindow().hide());
                                double[] estimate = this.simulationMethod.run(AssaGUI.getInstance().getBitSetPBN());
                                outputName = this.simulationMethod.getLogFile();
                                Platform.runLater(() -> SimulateSkartGUIController.this.mainGUIController.setFileTextField("", true));
                                DataInputStream dis = new DataInputStream(new FileInputStream(outputName));
                                byte[] datainBytes = new byte[dis.available()];
                                dis.readFully(datainBytes);
                                dis.close();
                                String s = new String(datainBytes, 0, datainBytes.length);
                                Platform.runLater(() -> SimulateSkartGUIController.this.mainGUIController.setFileTextField(s, false));
                                double halfLength = estimate[2] - estimate[0];
                                int sampleSize = (int)estimate[3];
                                double timeCost = estimate[4];
                                double average = estimate[2];
                                Platform.runLater(() -> SimulateSkartGUIController.this.mainGUIController.setAnalyseTextField("Sample size\t" + sampleSize + "\nProbability\t" + average + "\nCI half-length\t" + halfLength + "\nCPU time cost\t" + timeCost + "s\n----------------\n", false));
                                break block13;
                            }
                            catch (Exception e1) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Simulation Error");
                                    alert.setHeaderText("Error. Simulation not performed.");
                                    alert.setContentText(e1.getMessage());
                                    alert.showAndWait();
                                });
                            }
                        }
                        catch (Exception e1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Format Error");
                                alert.setHeaderText("Error. Wrong property file format.");
                                alert.setContentText(e1.getMessage());
                                alert.showAndWait();
                            });
                        }
                        break block13;
                    }
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Number Error");
                        alert.setHeaderText("Precision/Confidence Error.");
                        alert.setContentText("Precision p and Confidence c have to be 0 < p and c < 1.");
                        alert.showAndWait();
                    });
                }
                catch (NumberFormatException e1) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error. Wrong data format.");
                        alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                        alert.showAndWait();
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Platform.runLater(() -> {
                SimulateSkartGUIController.this.mainGUIController.enableFunction();
                SimulateSkartGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                SimulateSkartGUIController.this.mainGUIController.getStatus().setText(" Ready");
                ((SimulateSkartGUIController)SimulateSkartGUIController.this).mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

