/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.controller;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.OptimizePBN;
import PBN.ParseProperty;
import functionLib.Parameters;
import functionLib.ParametersGUI;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import simulationMethod.GelmanFullStatePara;
import simulationMethod.SimulationMethod;
import userInterface.AssaLog;
import view.GUI.MainGUI;
import view.GUI.controller.CreatePropertiesGUIController;
import view.GUI.controller.MainGUIController;
import view.GUI.etc.AssaGUI;

public class SimulateTwoStateGUIController
implements Initializable {
    private AssaLog assalog;
    @FXML
    private Button btnGenerate;
    @FXML
    private CheckBox cbGlobalAlias;
    @FXML
    private URL location;
    private MainGUIController mainGUIController;
    @FXML
    private ResourceBundle resources;
    @FXML
    private TextField txtConfidence;
    @FXML
    private TextField txtPath;
    @FXML
    private TextField txtPrecision;
    @FXML
    private TextField txtCores;
    @FXML
    private CheckBox cbParallel;
    @FXML
    private RadioButton rbParallelCPU;
    @FXML
    private RadioButton rbSequential;
    @FXML
    private RadioButton rbParallelGPU;
    @FXML
    private RadioButton rbParallelStr;
    @FXML
    private Label lbCores;
    private int parallel = 0;

    @FXML
    protected void cancelAction(ActionEvent e) {
        ((Node)e.getSource()).getScene().getWindow().hide();
    }

    public void initData(MainGUIController mainGUIController) {
        this.mainGUIController = mainGUIController;
        this.assalog = this.mainGUIController.getAssaLog();
        this.txtPrecision.setText(String.valueOf(Parameters.DEFAULT_PRECISION));
        this.txtConfidence.setText(String.valueOf(Parameters.DEFAULT_CONFIDENCE));
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    protected void loadPropertyFile(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Property File");
        fileChooser.setInitialDirectory(new File(ParametersGUI.lastDirectory));
        File selectedFile = fileChooser.showOpenDialog(((Node)e.getSource()).getScene().getWindow());
        try {
            if (selectedFile != null) {
                ParametersGUI.lastDirectory = selectedFile.getParent();
                this.txtPath.setText(selectedFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    protected void allowParallel(ActionEvent e) {
        if (this.rbParallelCPU.isSelected()) {
            this.lbCores.setDisable(false);
            this.txtCores.setDisable(false);
            int cores = Runtime.getRuntime().availableProcessors();
            this.txtCores.setText(String.valueOf(cores));
            this.parallel = 1;
        } else if (this.rbParallelGPU.isSelected()) {
            this.lbCores.setDisable(true);
            this.txtCores.setDisable(true);
            this.parallel = 7;
            File f = new File(System.getProperty("java.library.path"));
            boolean nolib = true;
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (files[i].getName().startsWith("libgpu")) {
                        nolib = false;
                        break;
                    }
                    ++i;
                }
            }
            if (nolib) {
                this.lbCores.setDisable(true);
                this.txtCores.setDisable(true);
                this.parallel = 0;
                this.rbParallelGPU.setSelected(false);
                this.rbSequential.setSelected(true);
                Platform.runLater(() -> {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("GPU lib error.");
                    alert.setHeaderText("Error. GPU lib does not exist.");
                    alert.setContentText("GPU lib does not exist. Please recompile it!");
                    alert.showAndWait();
                });
            }
        } else if (this.rbParallelStr.isSelected()) {
            this.lbCores.setDisable(true);
            this.txtCores.setDisable(true);
            this.parallel = 8;
        } else {
            this.lbCores.setDisable(true);
            this.txtCores.setDisable(true);
            this.parallel = 0;
        }
    }

    public void setPath(String s) {
        this.txtPath.setText(s);
    }

    @FXML
    protected void setProprities(ActionEvent e) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/view/GUI/CreateProperties.fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setTitle("Create property file");
            stage.getIcons().add((Object)new Image(MainGUI.class.getResource("/resources/logo.png").toExternalForm()));
            stage.setScene(new Scene(root1));
            CreatePropertiesGUIController controller = (CreatePropertiesGUIController)fxmlLoader.getController();
            controller.initData(this);
            stage.show();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    protected void simulateTwoState(ActionEvent e) {
        AssaGUI.getInstance().setTask(new Thread(new Task(this, e)));
        this.mainGUIController.btnCancel.setVisible(true);
        AssaGUI.getInstance().getTask().setDaemon(true);
        AssaGUI.getInstance().getTask().start();
    }

    class Task
    implements Runnable {
        ActionEvent e;
        SimulateTwoStateGUIController sm;
        SimulationMethod simulationMethod;

        public Task(SimulateTwoStateGUIController sm, ActionEvent e) {
            this.sm = sm;
            this.e = e;
        }

        @Override
        public void run() {
            block16: {
                Platform.runLater(() -> {
                    SimulateTwoStateGUIController.this.mainGUIController.disableFunction();
                    SimulateTwoStateGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.RED);
                    SimulateTwoStateGUIController.this.mainGUIController.getStatus().setText(" Running..");
                });
                try {
                    double precision = Double.parseDouble(SimulateTwoStateGUIController.this.txtPrecision.getText());
                    double confidence = Double.parseDouble(SimulateTwoStateGUIController.this.txtConfidence.getText());
                    String property = SimulateTwoStateGUIController.this.txtPath.getText();
                    BitSetPBN pbn = AssaGUI.getInstance().getBitSetPBN();
                    Platform.runLater(() -> ((Node)this.e.getSource()).getScene().getWindow().hide());
                    if (precision < 1.0 && precision > 0.0 && confidence > 0.0 && confidence < 1.0) {
                        boolean globalAlias = SimulateTwoStateGUIController.this.cbGlobalAlias.isSelected();
                        this.simulationMethod = SimulateTwoStateGUIController.this.mainGUIController.smProvider(SimulateTwoStateGUIController.this.parallel);
                        switch (SimulateTwoStateGUIController.this.parallel) {
                            case 1: {
                                this.simulationMethod.setParameters(new double[]{precision, confidence, Double.parseDouble(SimulateTwoStateGUIController.this.txtCores.getText())});
                                break;
                            }
                            case 0: {
                                this.simulationMethod.setParameters(new double[]{precision, confidence});
                                break;
                            }
                            case 8: {
                                BitSetPBN pbnCopy = (BitSetPBN)pbn.copy();
                                Parameters.printlevel = 3;
                                BitSetPBNIO io = new BitSetPBNIO(SimulateTwoStateGUIController.this.assalog);
                                String graphFileName = String.valueOf(AssaGUI.getInstance().getModelFullName()) + Math.random() + ".gra";
                                io.exportPBNtoGraph(AssaGUI.getInstance().getBitSetPBN(), graphFileName);
                                OptimizePBN opt = new OptimizePBN(AssaGUI.getInstance().getBitSetPBN(), AssaGUI.getInstance().getModelFullName(), SimulateTwoStateGUIController.this.assalog);
                                opt.setPropertyFile(SimulateTwoStateGUIController.this.txtPath.getText());
                                opt.setGroupFunctionStore(0);
                                opt.run(graphFileName);
                                io.delete(graphFileName);
                                ((GelmanFullStatePara)this.simulationMethod).setNumLeaves(opt.getNumLeaves());
                                ((GelmanFullStatePara)this.simulationMethod).setOptimizePBN(opt);
                                property = opt.getPropertyFile();
                                String modelFileName = opt.getPBNFile();
                                Parameters.printlevel = 1;
                                SimulateTwoStateGUIController.this.assalog.println("Reloading optimized PBN.");
                                pbn = io.loadPBN(modelFileName);
                                io.delete(modelFileName);
                                this.simulationMethod.setPBN(pbn);
                                Parameters.printlevel = 1;
                                AssaGUI.getInstance().setBitSetPBN(pbnCopy);
                                break;
                            }
                            default: {
                                this.simulationMethod.setParameters(new double[]{precision, confidence});
                            }
                        }
                        if (!globalAlias) {
                            this.simulationMethod.setDisableGlobalAlias(true);
                        }
                        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                        String outputName = null;
                        if (outputName == null) {
                            outputName = "ts_" + df.format(new Date()) + ".txt";
                        }
                        try {
                            this.simulationMethod.setExpressions(ParseProperty.getProperties(pbn, property));
                            if (!property.equals(SimulateTwoStateGUIController.this.txtPath.getText())) {
                                new BitSetPBNIO(SimulateTwoStateGUIController.this.assalog).delete(property);
                            }
                            try {
                                Platform.runLater(() -> SimulateTwoStateGUIController.this.mainGUIController.setAnalyseTextField("Performing the " + this.simulationMethod.getInstanceName() + "...\n", false));
                                String outputName_tmp = outputName;
                                Platform.runLater(() -> SimulateTwoStateGUIController.this.mainGUIController.setAnalyseTextField("Detailed information is stored in the file: " + outputName_tmp + "\n", false));
                                this.simulationMethod.setLogFile(outputName);
                                double[] result = this.simulationMethod.run(pbn);
                                Platform.runLater(() -> SimulateTwoStateGUIController.this.mainGUIController.setFileTextField("", true));
                                DataInputStream dis = new DataInputStream(new FileInputStream(outputName));
                                byte[] datainBytes = new byte[dis.available()];
                                dis.readFully(datainBytes);
                                dis.close();
                                String s = new String(datainBytes, 0, datainBytes.length);
                                Platform.runLater(() -> SimulateTwoStateGUIController.this.mainGUIController.setFileTextField(s, false));
                                double average = result[0];
                                int sampleSize = (int)result[1];
                                double cpuTime = result[2];
                                Platform.runLater(() -> SimulateTwoStateGUIController.this.mainGUIController.setAnalyseTextField("Sample size\t" + sampleSize + "\nProbability\t" + average + "\nCpu time cost\t" + cpuTime + "s\n----------------\n", false));
                                break block16;
                            }
                            catch (Exception e1) {
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR);
                                    alert.setTitle("Simulation Error");
                                    alert.setHeaderText("Error. Simulation not performed.");
                                    alert.setContentText(e1.getMessage());
                                    alert.showAndWait();
                                });
                            }
                        }
                        catch (Exception e1) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.setTitle("Format Error");
                                alert.setHeaderText("Error. Wrong property file format.");
                                alert.setContentText(e1.getMessage());
                                alert.showAndWait();
                            });
                        }
                        break block16;
                    }
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Number Error");
                        alert.setHeaderText("Precision/Confidence Error.");
                        alert.setContentText("Precision p and Confidence c have to be 0 < p and c < 1.");
                        alert.showAndWait();
                    });
                }
                catch (NumberFormatException e1) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Data Error");
                        alert.setHeaderText("Error. Wrong data format.");
                        alert.setContentText("Make sure to enter valid data and fill out all required fields.");
                        alert.showAndWait();
                    });
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            Platform.runLater(() -> {
                SimulateTwoStateGUIController.this.mainGUIController.enableFunction();
                SimulateTwoStateGUIController.this.mainGUIController.getCircle().setFill((Paint)Color.GREENYELLOW);
                SimulateTwoStateGUIController.this.mainGUIController.getStatus().setText(" Ready");
                ((SimulateTwoStateGUIController)SimulateTwoStateGUIController.this).mainGUIController.btnCancel.setVisible(false);
            });
        }
    }
}

