/*
 * Decompiled with CFR 0.152.
 */
package view.GUI.etc;

import PBN.BitSetPBN;
import PBN.BitSetPBNIO;
import PBN.PBN;
import PBN.ParseProperty;
import PBN.StateBit;
import functionLib.Parameters;
import functionLib.RandomProvider;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import simulationMethod.GaussSeidel;
import simulationMethod.Jacob;
import simulationMethod.JacobGUI;
import simulationMethod.SkartPBN;
import simulationMethod.SkartPBNLarge;
import simulationMethod.StepPerfectSimulationWalkerBitSet;
import simulationMethod.TwoStateBitSet;
import simulator.RandomNumberGenerator;
import userInterface.AssaLog;
import userInterface.Version;

public class AssaGUI {
    AssaLog assalog = null;
    private Thread task;
    private static AssaGUI instance = null;
    private BitSetPBN pbn;
    private String log;
    private String currentModelFullName = null;

    public void setTask(Thread r) {
        this.task = r;
    }

    private AssaGUI(AssaLog assalog) {
        this.assalog = assalog;
    }

    private AssaGUI() {
    }

    public static AssaGUI getInstance(AssaLog assalog) {
        if (instance == null) {
            instance = new AssaGUI(assalog);
        }
        return instance;
    }

    public static AssaGUI getInstance() {
        if (instance == null) {
            instance = new AssaGUI();
        }
        return instance;
    }

    public BitSetPBN getBitSetPBN() {
        return this.pbn;
    }

    public void setBitSetPBN(BitSetPBN pbn) {
        this.pbn = pbn;
    }

    public String getLog() {
        return this.log;
    }

    public Thread getTask() {
        return this.task;
    }

    public String getModelFullName() {
        return this.currentModelFullName;
    }

    public void setModelFullName(String currentModelPath) {
        this.currentModelFullName = currentModelPath;
    }

    public void setLog(String s) {
        this.log = String.valueOf(this.log) + s + "\n---------------\n";
    }

    public BitSetPBN defineBitSetPBN(int n, double perturbation) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = n >= 20 ? 20 : n;
        this.assalog.println("Max number of functions and max number of parent nodes are set to " + maxVariableNum);
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBN(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, double perturbation, int maxFunction, int maxVariable) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBN(n, perturbation);
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxFunction) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariable) + 1);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBN(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, boolean maxVariableNumLimit) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int maxVariableNum = maxVariableNumLimit && n >= 20 ? 20 : n;
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int i = 0;
        while (i < nf.length) {
            nf[i] = rng.randomUnifInt(maxVariableNum) + 1;
            int j = 0;
            while (j < nf[i]) {
                nv.add(rng.randomUnifInt(maxVariableNum) + 1);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBN(n, nf, nv);
        pbn.setPerturbation(0.1);
        return pbn;
    }

    public BitSetPBN defineBitSetPBN(int n, double perturbation, int maxFunction, int minFunction, int maxVariable, int minVariable) throws Exception {
        if (maxFunction == 0 || maxVariable == 0) {
            return this.defineBitSetPBN(n, perturbation);
        }
        if ((double)maxFunction > Math.pow(2.0, n)) {
            throw new Exception("Max function number is too large!");
        }
        if (maxFunction > 20) {
            this.assalog.println("Max function number is over 20. Consider changing to smaller one!");
        }
        if (maxVariable > n) {
            throw new Exception("Max variable number is too large!");
        }
        if (maxVariable > 20) {
            this.assalog.println("Max variable number is over 20. Consider changing to smaller one!");
        }
        if (minFunction <= 0) {
            minFunction = 1;
            this.assalog.println("Minimum function number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        if (minVariable <= 0) {
            minVariable = 1;
            this.assalog.println("Minimum variable number cannot be smaller than 1. ASSAPBN changed it to 1 for you!");
        }
        RandomNumberGenerator rng = new RandomNumberGenerator();
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        int[] nf = new int[n];
        ArrayList<Integer> nv = new ArrayList<Integer>();
        int diffFun = maxFunction - minFunction + 1;
        int diffVar = maxVariable - minVariable + 1;
        int i = 0;
        while (i < nf.length) {
            nf[i] = (int)(rng.randomUnifDouble() * (double)diffFun) + minFunction;
            int j = 0;
            while (j < nf[i]) {
                nv.add((int)(rng.randomUnifDouble() * (double)diffVar) + minVariable);
                ++j;
            }
            ++i;
        }
        BitSetPBN pbn = io.generateRandomPBN(n, nf, nv);
        pbn.setPerturbation(perturbation);
        return pbn;
    }

    public BitSetPBN generatePBN(int n, String fileName, double perturbation, int type, int maxFunctionNum, int maxVariableNum, int minFunctionNum, int minVariableNum) throws Exception {
        if (perturbation < 0.0) {
            perturbation = RandomProvider.getInstance().getRandom().nextDouble();
        }
        BitSetPBN pbn = this.defineBitSetPBN(n, perturbation, maxFunctionNum, minFunctionNum, maxVariableNum, minVariableNum);
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        if (fileName == null || fileName.equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
            fileName = "model/PBN_Node" + n + "_" + df.format(new Date());
        }
        switch (type) {
            case 0: {
                exp.exportPBN(pbn, fileName);
                break;
            }
            case 1: {
                exp.exportPBNtoMatlab(pbn, fileName);
                break;
            }
            case 2: {
                exp.exportPBN(pbn, String.valueOf(fileName) + ".txt");
                exp.exportPBNtoMatlab(pbn, String.valueOf(fileName) + ".m");
                break;
            }
            default: {
                this.assalog.println("The export type is not recognized!");
            }
        }
        return pbn;
    }

    public BitSetPBN generatePBNfromFile(String fromFile, int type, String outputName) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.generatePBNFromFile(fromFile);
        switch (type) {
            case 0: {
                io.exportPBN(pbn, outputName);
                break;
            }
            case 1: {
                io.exportPBNtoMatlab(pbn, outputName);
                break;
            }
            case 2: {
                io.exportPBN(pbn, String.valueOf(outputName) + ".txt");
                io.exportPBNtoMatlab(pbn, String.valueOf(outputName) + ".m");
                break;
            }
        }
        return pbn;
    }

    public void runTwoStateBitSet(double precision, double confidence, String modelFileName, String property, boolean isMatlab, String outputName, boolean globalAlias) throws Exception {
        TwoStateBitSet ts = new TwoStateBitSet(this.assalog, precision, confidence, Parameters.epsilon, 1);
        double average = 0.0;
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the two state Markov chain approach on the PBN from file " + modelFileName);
        if (outputName != null) {
            ts.setLogFile(outputName);
        } else {
            outputName = ts.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        StateBit initialState = new StateBit(0);
        int sampleSize = 0;
        double cpuTime = 0.0;
        if (!globalAlias) {
            ts.setDisableGlobalAlias(true);
        }
        ts.setExpressions(ParseProperty.getProperties(pbn, property));
        double[] result = ts.run((PBN)pbn, initialState);
        this.assalog.println("Sample size\t" + (sampleSize += (int)result[1]) + "\nProbability\t" + (average += result[0]) + "\nCpu time cost\t" + (cpuTime += result[2]) + "s");
    }

    public void runStepPerfectSimulation(String modelFileName, boolean isMatlab, String propertyFileName, double confidence, double precision, String outputName, boolean useAlias, boolean cost) throws Exception {
        StepPerfectSimulationWalkerBitSet ps = StepPerfectSimulationWalkerBitSet.getInstance();
        BitSetPBNIO exp = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = exp.loadPBN(modelFileName);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        if (outputName == null) {
            outputName = "ps_" + df.format(new Date()) + ".txt";
        }
        ps.setIO(pbn, outputName);
        ps.setSampleSize(confidence, precision);
        ps.setUseAlias(useAlias);
        if (cost) {
            ps.setCost(true);
        }
        double average = 0.0;
        double sampleSize = 0.0;
        double simulationStep = 0.0;
        double couplingStep = 0.0;
        double cpu = 0.0;
        this.assalog.println("Performing the perfect simulation algorithm on the PBN from file " + modelFileName);
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        double[] result = ps.runWalker(propertyFileName, 1000, true);
        this.assalog.println("Avg. coupling steps\t" + (couplingStep += result[1]) + "\nSimulation steps\t" + (simulationStep += result[2]) + "\nNumber of samples\t" + (sampleSize += result[3]) + "\nCPU time cost\t\t" + (cpu += result[4]) + "s\nProbability\t\t" + (average += result[0]));
    }

    public void runPBNIO(String PBNfile, boolean isFromMatlab, String outputName, int type) throws Exception {
        BitSetPBNIO pbnIO = new BitSetPBNIO(this.assalog);
        this.assalog.println("Start loading model from file " + PBNfile + "...");
        BitSetPBN pbn = pbnIO.loadPBN(PBNfile);
        this.assalog.println("Start exporting model...");
        switch (type) {
            case 0: {
                pbnIO.exportPBN(pbn, outputName);
                break;
            }
            case 1: {
                pbnIO.exportPBNtoMatlab(pbn, outputName);
                break;
            }
            case 2: {
                pbnIO.exportPBN(pbn, String.valueOf(outputName) + ".txt");
                pbnIO.exportPBNtoMatlab(pbn, String.valueOf(outputName) + ".m");
                break;
            }
        }
    }

    public void runSkartPBN(double precision, double confidence, String modelFileName, String property, boolean isMatlab, String outputName, boolean globalAlias) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the Skart method on the PBN from file " + modelFileName);
        SkartPBN skart = new SkartPBN(pbn, this.assalog);
        skart.setExpressions(ParseProperty.getProperties(pbn, property));
        skart.setAlpha(1.0 - confidence);
        skart.setPrecision(precision);
        if (!globalAlias) {
            skart.setDisableGlobalAlias(true);
        }
        if (outputName != null) {
            skart.setLogFile(outputName);
        } else {
            outputName = skart.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double halfLength = 0.0;
        double timeCost = 0.0;
        double average = 0.0;
        double[] estimate = skart.run();
        halfLength = estimate[2] - estimate[0];
        this.assalog.println("Sample size\t" + (sampleSize += (int)estimate[3]) + "\nProbability\t" + (average += estimate[2]) + "\nCI half-length\t" + halfLength + "\nCPU time cost\t" + (timeCost += estimate[4]) + "s");
    }

    public void runSkartPBNLarge(double precision, double confidence, String modelFileName, String property, boolean isMatlab, String outputName, boolean globalAlias) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the full version Skart method on the PBN from file " + modelFileName + ".");
        SkartPBNLarge skart = new SkartPBNLarge(pbn, this.assalog);
        skart.setExpressions(ParseProperty.getProperties(pbn, property));
        skart.setAlpha(1.0 - confidence);
        skart.setPrecision(precision);
        if (!globalAlias) {
            skart.setDisableGlobalAlias(true);
        }
        if (outputName != null) {
            skart.setLogFile(outputName);
        } else {
            outputName = skart.getLogFile();
        }
        this.assalog.println("Detailed information is stored in the file " + outputName + ".");
        int sampleSize = 0;
        double halfLength = 0.0;
        double timeCost = 0.0;
        double average = 0.0;
        double[] estimate = skart.run();
        halfLength = estimate[2] - estimate[0];
        this.assalog.println("Sample size\t" + (sampleSize += (int)estimate[3]) + "\nProbability\t" + (average += estimate[2]) + "\nCI half-length\t" + halfLength + "\nCPU time cost\t" + (timeCost += estimate[4]) + "s");
    }

    public void run(String[] args) throws Exception {
        boolean gef = false;
        boolean skart = false;
        boolean ts = false;
        boolean ge = false;
        boolean cost = false;
        boolean skartLarge = false;
        boolean help = false;
        boolean gauss = false;
        boolean jacobi = false;
        boolean ps = false;
        boolean io = false;
        boolean isMatlab = false;
        boolean globalAlias = true;
        double precision = 0.01;
        double confidence = 0.95;
        double perturbation = 0.01;
        int maxFunction = 0;
        int maxVariable = 0;
        int maxIteration = 0;
        String parameterFileName = "";
        String modelFileName = "";
        String propertyName = "";
        String outputName = null;
        int n = 0;
        int i = 0;
        int type = 7;
        int minFunction = 0;
        int minVariable = 0;
        if (args == null || args.length == 0) {
            help = true;
        } else if (args[0].equals("-ge")) {
            ge = true;
            n = Integer.parseInt(args[++i]);
            perturbation = Double.parseDouble(args[++i]);
            modelFileName = args.length > ++i ? args[i] : null;
            type = Integer.parseInt(args[++i]);
            if (args.length > ++i) {
                maxFunction = Integer.parseInt(args[i]);
                minFunction = Integer.parseInt(args[++i]);
            }
            if (args.length > ++i) {
                maxVariable = Integer.parseInt(args[i]);
                minVariable = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-gef")) {
            gef = true;
            parameterFileName = args[++i];
            outputName = args[++i];
            type = Integer.parseInt(args[++i]);
        } else if (args[0].equals("-io")) {
            io = true;
            modelFileName = args[++i];
            isMatlab = Boolean.parseBoolean(args[++i]);
            outputName = args[++i];
            type = Integer.parseInt(args[++i]);
        } else if (args[0].equals("-gauss")) {
            gauss = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            propertyName = args[++i].equals("-dis") ? null : args[i];
            if (args.length > ++i) {
                precision = Double.parseDouble(args[i]);
                maxIteration = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-jacobi")) {
            jacobi = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            propertyName = args[++i].equals("-dis") ? null : args[i];
            if (args.length > ++i) {
                precision = Double.parseDouble(args[i]);
                maxIteration = Integer.parseInt(args[++i]);
            }
        } else if (args[0].equals("-ps")) {
            ps = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-global")) {
                    globalAlias = Boolean.parseBoolean(args[++i]);
                } else {
                    cost = Boolean.parseBoolean(args[i]);
                }
            }
            if (args.length > ++i) {
                cost = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-ts")) {
            ts = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            if (args[i + 1].startsWith("-epsilon")) {
                ++i;
                Parameters.epsilon = Double.parseDouble(args[++i]);
            }
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-skart")) {
            skart = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-skartfull")) {
            skartLarge = true;
            modelFileName = args[++i];
            String tmp = args[i + 1].toLowerCase();
            if (tmp.startsWith("true") || tmp.startsWith("false")) {
                isMatlab = Boolean.parseBoolean(args[++i]);
            }
            precision = Double.parseDouble(args[++i]);
            confidence = Double.parseDouble(args[++i]);
            propertyName = args[++i];
            if (args.length > ++i) {
                if (args[i].toLowerCase().equals("-log")) {
                    outputName = args[++i];
                } else {
                    outputName = null;
                    --i;
                }
            }
            if (args.length > ++i) {
                globalAlias = Boolean.parseBoolean(args[i]);
            }
        } else if (args[0].equals("-h") || args[0].equals("-help") || args[0].equals("-H")) {
            help = true;
        } else if (args[0].equals("-v") || args[0].equals("-V")) {
            new Version().showVersion();
            System.exit(0);
        } else {
            this.assalog.println("Wrong input parameter");
            this.showhelp();
            System.exit(0);
        }
        try {
            if (ge) {
                this.generatePBN(n, modelFileName, perturbation, type, maxFunction, maxVariable, minFunction, minVariable);
            } else if (gef) {
                this.generatePBNfromFile(parameterFileName, type, outputName);
            } else if (io) {
                this.runPBNIO(modelFileName, isMatlab, outputName, type);
            } else if (gauss) {
                this.runGauss(modelFileName, isMatlab, propertyName, precision, maxIteration);
            } else if (jacobi) {
                this.runJacobi(modelFileName, isMatlab, propertyName, precision, maxIteration);
            } else if (ps) {
                this.runStepPerfectSimulation(modelFileName, isMatlab, propertyName, confidence, precision, outputName, true, cost);
            } else if (ts) {
                this.runTwoStateBitSet(precision, confidence, modelFileName, propertyName, isMatlab, outputName, globalAlias);
            } else if (skart) {
                this.runSkartPBN(precision, confidence, modelFileName, propertyName, isMatlab, outputName, globalAlias);
            } else if (skartLarge) {
                this.runSkartPBNLarge(precision, confidence, modelFileName, propertyName, isMatlab, outputName, globalAlias);
            } else if (help) {
                this.showhelp();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runGauss(String modelFileName, boolean isMatlab, String property, double precision, int maxIteration) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the Gauss-Seidel method on the PBN from file " + modelFileName);
        GaussSeidel gauss = new GaussSeidel(pbn, this.assalog);
        if (maxIteration > 0) {
            gauss.setPrecsion(precision);
            gauss.setMaxIteration(maxIteration);
        }
        gauss.setProperty(property);
        gauss.run();
    }

    public void runJacobi(String modelFileName, boolean isMatlab, String property, double precision, int maxIteration) throws Exception {
        BitSetPBNIO io = new BitSetPBNIO(this.assalog);
        BitSetPBN pbn = io.loadPBN(modelFileName);
        this.assalog.println("Performing the Jacobi method on the PBN from file " + modelFileName);
        JacobGUI jacob = (JacobGUI)new Jacob(pbn, this.assalog);
        if (maxIteration > 0) {
            jacob.setPrecsion(precision);
            jacob.setMaxIteration(maxIteration);
        }
        jacob.setProperty(property);
        jacob.run();
    }

    public void showhelp() {
        this.assalog.println("-ge <number of node> <perturbation rate> <export file name> <export type> [<max function number> <min function number><max parents node><min parents node>]");
        this.assalog.println("Generate a PBN and export to a file in ASSA format or Matlab format.\n");
        this.assalog.println("-gef <parameter file name> <export file name> <export type>");
        this.assalog.println("Generate a PBN with given parameters in a file.\n");
        this.assalog.println("-io <import file name> <isMatlab> <export file name> <export type> ");
        this.assalog.println("Load a PBN from a file and export to a file in ASSA format or Matlab format.\n");
        this.assalog.println("-gauss <model file name>  [isMatlab] <property file name> [<precision> <max iteration>]");
        this.assalog.println("Perform the Gauss-Seidel method\n");
        this.assalog.println("-jacobi <model file name> [isMatlab]  <property file name> [<precision> <max iteration>]");
        this.assalog.println("Perform the Jacobi method.\n");
        this.assalog.println("-ps <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>] [useCost]");
        this.assalog.println("Perform the perfect simulation approach. If the model file is exported from Matlab, please add true after the model file name.\n");
        this.assalog.println("-ts <model file name> [isMatlab] <precision> <confidence level> [-epsilon <epsilon>] <property file name> [-log <log file name>] [useGlobalAlias]");
        this.assalog.println("Perform the two-state Markov chain approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command\n");
        this.assalog.println("-skart <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>] [useGlobalAlias]");
        this.assalog.println("Perform the fast version Skart approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        this.assalog.println("-skartfull <model file name> [isMatlab] <precision> <confidence level> <property file name> [-log <log file name>]  [useGlobalAlias]");
        this.assalog.println("Perform the full version Skart approach. If the model file is exported from Matlab, please add true after the model file name. If you want the simulator to use global alias table for simulation, please add true at the end of the command.\n");
        this.assalog.println("-v");
        this.assalog.println("Show version information.");
        this.assalog.println("-h");
        this.assalog.println("Show this help information.");
        this.assalog.println("");
        this.assalog.println("");
    }
}

