/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    transient Object[] elements;
    transient int head;
    transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int numElements) {
        int initialCapacity = 8;
        if (numElements >= initialCapacity) {
            initialCapacity = numElements;
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        this.elements = new Object[initialCapacity];
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] a = new Object[newCapacity];
        System.arraycopy(this.elements, p, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, p);
        this.elements = a;
        this.head = 0;
        this.tail = n;
    }

    public ArrayDeque() {
        this.elements = new Object[16];
    }

    public ArrayDeque(int numElements) {
        this.allocateElements(numElements);
    }

    public ArrayDeque(Collection<? extends E> c) {
        this.allocateElements(c.size());
        this.addAll(c);
    }

    @Override
    public void addFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E pollFirst() {
        Object[] elements = this.elements;
        int h = this.head;
        Object result = elements[h];
        if (result != null) {
            elements[h] = null;
            this.head = h + 1 & elements.length - 1;
        }
        return (E)result;
    }

    @Override
    public E pollLast() {
        Object[] elements = this.elements;
        int t = this.tail - 1 & elements.length - 1;
        Object result = elements[t];
        if (result != null) {
            elements[t] = null;
            this.tail = t;
        }
        return (E)result;
    }

    @Override
    public E getFirst() {
        Object result = this.elements[this.head];
        if (result == null) {
            throw new NoSuchElementException();
        }
        return (E)result;
    }

    @Override
    public E getLast() {
        Object result = this.elements[this.tail - 1 & this.elements.length - 1];
        if (result == null) {
            throw new NoSuchElementException();
        }
        return (E)result;
    }

    @Override
    public E peekFirst() {
        return (E)this.elements[this.head];
    }

    @Override
    public E peekLast() {
        return (E)this.elements[this.tail - 1 & this.elements.length - 1];
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (o != null) {
            Object x;
            int mask = this.elements.length - 1;
            int i = this.head;
            while ((x = this.elements[i]) != null) {
                if (o.equals(x)) {
                    this.delete(i);
                    return true;
                }
                i = i + 1 & mask;
            }
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o != null) {
            Object x;
            int mask = this.elements.length - 1;
            int i = this.tail - 1 & mask;
            while ((x = this.elements[i]) != null) {
                if (o.equals(x)) {
                    this.delete(i);
                    return true;
                }
                i = i - 1 & mask;
            }
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    private void checkInvariants() {
        assert (this.elements[this.tail] == null);
        assert (this.head != this.tail ? this.elements[this.head] != null && this.elements[this.tail - 1 & this.elements.length - 1] != null : this.elements[this.head] == null);
        assert (this.elements[this.head - 1 & this.elements.length - 1] == null);
    }

    private boolean delete(int i) {
        this.checkInvariants();
        Object[] elements = this.elements;
        int mask = elements.length - 1;
        int h = this.head;
        int t = this.tail;
        int front = i - h & mask;
        int back = t - i & mask;
        if (front >= (t - h & mask)) {
            throw new ConcurrentModificationException();
        }
        if (front < back) {
            if (h <= i) {
                System.arraycopy(elements, h, elements, h + 1, front);
            } else {
                System.arraycopy(elements, 0, elements, 1, i);
                elements[0] = elements[mask];
                System.arraycopy(elements, h, elements, h + 1, mask - h);
            }
            elements[h] = null;
            this.head = h + 1 & mask;
            return false;
        }
        if (i < t) {
            System.arraycopy(elements, i + 1, elements, i, back);
            this.tail = t - 1;
        } else {
            System.arraycopy(elements, i + 1, elements, i, mask - i);
            elements[mask] = elements[0];
            System.arraycopy(elements, 1, elements, 0, t);
            this.tail = t - 1 & mask;
        }
        return true;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new DeqIterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            Object x;
            int mask = this.elements.length - 1;
            int i = this.head;
            while ((x = this.elements[i]) != null) {
                if (o.equals(x)) {
                    return true;
                }
                i = i + 1 & mask;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public void clear() {
        int h = this.head;
        int t = this.tail;
        if (h != t) {
            this.tail = 0;
            this.head = 0;
            int i = h;
            int mask = this.elements.length - 1;
            do {
                this.elements[i] = null;
            } while ((i = i + 1 & mask) != t);
        }
    }

    @Override
    public Object[] toArray() {
        int tail = this.tail;
        int head = this.head;
        boolean wrap = tail < head;
        int end = wrap ? tail + this.elements.length : tail;
        Object[] a = Arrays.copyOfRange(this.elements, head, end);
        if (wrap) {
            System.arraycopy(this.elements, 0, a, this.elements.length - head, tail);
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int tail = this.tail;
        int head = this.head;
        boolean wrap = tail < head;
        int size = tail - head + (wrap ? this.elements.length : 0);
        int firstLeg = size - (wrap ? tail : 0);
        int len = a.length;
        if (size > len) {
            a = Arrays.copyOfRange(this.elements, head, head + size, a.getClass());
        } else {
            System.arraycopy(this.elements, head, a, 0, firstLeg);
            if (size < len) {
                a[size] = null;
            }
        }
        if (wrap) {
            System.arraycopy(this.elements, 0, a, firstLeg, tail);
        }
        return a;
    }

    public ArrayDeque<E> clone() {
        try {
            ArrayDeque result = (ArrayDeque)super.clone();
            result.elements = Arrays.copyOf(this.elements, this.elements.length);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size());
        int mask = this.elements.length - 1;
        int i = this.head;
        while (i != this.tail) {
            s.writeObject(this.elements[i]);
            i = i + 1 & mask;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.allocateElements(size);
        this.head = 0;
        this.tail = size;
        for (int i = 0; i < size; ++i) {
            this.elements[i] = s.readObject();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new DeqSpliterator(this, -1, -1);
    }

    static final class DeqSpliterator<E>
    implements Spliterator<E> {
        private final ArrayDeque<E> deq;
        private int fence;
        private int index;

        DeqSpliterator(ArrayDeque<E> deq, int origin, int fence) {
            this.deq = deq;
            this.index = origin;
            this.fence = fence;
        }

        private int getFence() {
            int t = this.fence;
            if (t < 0) {
                t = this.fence = this.deq.tail;
                this.index = this.deq.head;
            }
            return t;
        }

        @Override
        public Spliterator<E> trySplit() {
            int t = this.getFence();
            int h = this.index;
            int n = this.deq.elements.length;
            if (h != t && (h + 1 & n - 1) != t) {
                int m;
                if (h > t) {
                    t += n;
                }
                this.index = m = h + t >>> 1 & n - 1;
                return new DeqSpliterator<E>(this.deq, h, this.index);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Object[] a = this.deq.elements;
            int m = a.length - 1;
            int f = this.getFence();
            int i = this.index;
            this.index = f;
            while (i != f) {
                Object e = a[i];
                i = i + 1 & m;
                if (e == null) {
                    throw new ConcurrentModificationException();
                }
                consumer.accept(e);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Object[] a = this.deq.elements;
            int m = a.length - 1;
            int i = this.index;
            int f = this.getFence();
            if (i != f) {
                Object e = a[i];
                this.index = i + 1 & m;
                if (e == null) {
                    throw new ConcurrentModificationException();
                }
                consumer.accept(e);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            int n = this.getFence() - this.index;
            if (n < 0) {
                n += this.deq.elements.length;
            }
            return n;
        }

        @Override
        public int characteristics() {
            return 16720;
        }
    }

    private class DescendingIterator
    implements Iterator<E> {
        private int cursor;
        private int fence;
        private int lastRet;

        private DescendingIterator() {
            this.cursor = ArrayDeque.this.tail;
            this.fence = ArrayDeque.this.head;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public E next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            this.cursor = this.cursor - 1 & ArrayDeque.this.elements.length - 1;
            Object result = ArrayDeque.this.elements[this.cursor];
            if (ArrayDeque.this.head != this.fence || result == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            return result;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (!ArrayDeque.this.delete(this.lastRet)) {
                this.cursor = this.cursor + 1 & ArrayDeque.this.elements.length - 1;
                this.fence = ArrayDeque.this.head;
            }
            this.lastRet = -1;
        }
    }

    private class DeqIterator
    implements Iterator<E> {
        private int cursor;
        private int fence;
        private int lastRet;

        private DeqIterator() {
            this.cursor = ArrayDeque.this.head;
            this.fence = ArrayDeque.this.tail;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public E next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            Object result = ArrayDeque.this.elements[this.cursor];
            if (ArrayDeque.this.tail != this.fence || result == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & ArrayDeque.this.elements.length - 1;
            return result;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (ArrayDeque.this.delete(this.lastRet)) {
                this.cursor = this.cursor - 1 & ArrayDeque.this.elements.length - 1;
                this.fence = ArrayDeque.this.tail;
            }
            this.lastRet = -1;
        }
    }
}

