/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import sun.misc.Unsafe;

public class CompletableFuture<T>
implements Future<T>,
CompletionStage<T> {
    volatile Object result;
    volatile Completion stack;
    static final AltResult NIL = new AltResult(null);
    private static final boolean useCommonPool = ForkJoinPool.getCommonPoolParallelism() > 1;
    private static final Executor asyncPool = useCommonPool ? ForkJoinPool.commonPool() : new ThreadPerTaskExecutor();
    static final int SYNC = 0;
    static final int ASYNC = 1;
    static final int NESTED = -1;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long RESULT;
    private static final long STACK;
    private static final long NEXT;

    final boolean internalComplete(Object r) {
        return U.compareAndSwapObject(this, RESULT, null, r);
    }

    final boolean casStack(Completion cmp, Completion val) {
        return U.compareAndSwapObject(this, STACK, cmp, val);
    }

    final boolean tryPushStack(Completion c) {
        Completion h = this.stack;
        CompletableFuture.lazySetNext(c, h);
        return U.compareAndSwapObject(this, STACK, h, c);
    }

    final void pushStack(Completion c) {
        while (!this.tryPushStack(c)) {
        }
    }

    final boolean completeNull() {
        return U.compareAndSwapObject(this, RESULT, null, NIL);
    }

    final Object encodeValue(T t) {
        return t == null ? NIL : t;
    }

    final boolean completeValue(T t) {
        return U.compareAndSwapObject(this, RESULT, null, t == null ? NIL : t);
    }

    static AltResult encodeThrowable(Throwable x) {
        return new AltResult(x instanceof CompletionException ? x : new CompletionException(x));
    }

    final boolean completeThrowable(Throwable x) {
        return U.compareAndSwapObject(this, RESULT, null, CompletableFuture.encodeThrowable(x));
    }

    static Object encodeThrowable(Throwable x, Object r) {
        if (!(x instanceof CompletionException)) {
            x = new CompletionException(x);
        } else if (r instanceof AltResult && x == ((AltResult)r).ex) {
            return r;
        }
        return new AltResult(x);
    }

    final boolean completeThrowable(Throwable x, Object r) {
        return U.compareAndSwapObject(this, RESULT, null, CompletableFuture.encodeThrowable(x, r));
    }

    Object encodeOutcome(T t, Throwable x) {
        return x == null ? (t == null ? NIL : t) : CompletableFuture.encodeThrowable(x);
    }

    static Object encodeRelay(Object r) {
        Throwable x;
        return r instanceof AltResult && (x = ((AltResult)r).ex) != null && !(x instanceof CompletionException) ? new AltResult(new CompletionException(x)) : r;
    }

    final boolean completeRelay(Object r) {
        return U.compareAndSwapObject(this, RESULT, null, CompletableFuture.encodeRelay(r));
    }

    private static <T> T reportGet(Object r) throws InterruptedException, ExecutionException {
        if (r == null) {
            throw new InterruptedException();
        }
        if (r instanceof AltResult) {
            Throwable cause;
            Throwable x = ((AltResult)r).ex;
            if (x == null) {
                return null;
            }
            if (x instanceof CancellationException) {
                throw (CancellationException)x;
            }
            if (x instanceof CompletionException && (cause = x.getCause()) != null) {
                x = cause;
            }
            throw new ExecutionException(x);
        }
        Object t = r;
        return (T)t;
    }

    private static <T> T reportJoin(Object r) {
        if (r instanceof AltResult) {
            Throwable x = ((AltResult)r).ex;
            if (x == null) {
                return null;
            }
            if (x instanceof CancellationException) {
                throw (CancellationException)x;
            }
            if (x instanceof CompletionException) {
                throw (CompletionException)x;
            }
            throw new CompletionException(x);
        }
        Object t = r;
        return (T)t;
    }

    static Executor screenExecutor(Executor e) {
        if (!useCommonPool && e == ForkJoinPool.commonPool()) {
            return asyncPool;
        }
        if (e == null) {
            throw new NullPointerException();
        }
        return e;
    }

    static void lazySetNext(Completion c, Completion next) {
        U.putOrderedObject(c, NEXT, next);
    }

    final void postComplete() {
        CompletableFuture<?> f = this;
        while (true) {
            CompletableFuture<?> d;
            Completion t;
            Completion h;
            if ((h = f.stack) == null) {
                if (f == this) break;
                f = this;
                h = f.stack;
                if (h == null) break;
            }
            if (!f.casStack(h, t = h.next)) continue;
            if (t != null) {
                if (f != this) {
                    this.pushStack(h);
                    continue;
                }
                h.next = null;
            }
            f = (d = h.tryFire(-1)) == null ? this : d;
        }
    }

    final void cleanStack() {
        Completion p = null;
        Completion q = this.stack;
        while (q != null) {
            Completion s = q.next;
            if (q.isLive()) {
                p = q;
                q = s;
                continue;
            }
            if (p == null) {
                this.casStack(q, s);
                q = this.stack;
                continue;
            }
            p.next = s;
            if (p.isLive()) {
                q = s;
                continue;
            }
            p = null;
            q = this.stack;
        }
    }

    final void push(UniCompletion<?, ?> c) {
        if (c != null) {
            while (this.result == null && !this.tryPushStack(c)) {
                CompletableFuture.lazySetNext(c, null);
            }
        }
    }

    final CompletableFuture<T> postFire(CompletableFuture<?> a, int mode) {
        if (a != null && a.stack != null) {
            if (mode < 0 || a.result == null) {
                a.cleanStack();
            } else {
                a.postComplete();
            }
        }
        if (this.result != null && this.stack != null) {
            if (mode < 0) {
                return this;
            }
            this.postComplete();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <S> boolean uniApply(CompletableFuture<S> a, Function<? super S, ? extends T> f, UniApply<S, T> c) {
        Object r;
        if (a == null || (r = a.result) == null || f == null) {
            return false;
        }
        if (this.result != null) return true;
        if (r instanceof AltResult) {
            Throwable x = ((AltResult)r).ex;
            if (x != null) {
                this.completeThrowable(x, r);
                return true;
            }
            r = null;
        }
        try {
            if (c != null && !c.claim()) {
                return false;
            }
            Object s = r;
            this.completeValue(f.apply(s));
            return true;
        }
        catch (Throwable ex) {
            this.completeThrowable(ex);
        }
        return true;
    }

    private <V> CompletableFuture<V> uniApplyStage(Executor e, Function<? super T, ? extends V> f) {
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture d = this.newIncompleteFuture();
        if (e != null || !d.uniApply(this, f, null)) {
            UniApply<T, V> c = new UniApply<T, V>(e, d, this, f);
            this.push(c);
            c.tryFire(0);
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <S> boolean uniAccept(CompletableFuture<S> a, Consumer<? super S> f, UniAccept<S> c) {
        Object r;
        if (a == null || (r = a.result) == null || f == null) {
            return false;
        }
        if (this.result != null) return true;
        if (r instanceof AltResult) {
            Throwable x = ((AltResult)r).ex;
            if (x != null) {
                this.completeThrowable(x, r);
                return true;
            }
            r = null;
        }
        try {
            if (c != null && !c.claim()) {
                return false;
            }
            Object s = r;
            f.accept(s);
            this.completeNull();
            return true;
        }
        catch (Throwable ex) {
            this.completeThrowable(ex);
        }
        return true;
    }

    private CompletableFuture<Void> uniAcceptStage(Executor e, Consumer<? super T> f) {
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> d = this.newIncompleteFuture();
        if (e != null || !d.uniAccept(this, f, null)) {
            UniAccept<T> c = new UniAccept<T>(e, d, this, f);
            this.push(c);
            c.tryFire(0);
        }
        return d;
    }

    final boolean uniRun(CompletableFuture<?> a, Runnable f, UniRun<?> c) {
        Object r;
        if (a == null || (r = a.result) == null || f == null) {
            return false;
        }
        if (this.result == null) {
            Throwable x;
            if (r instanceof AltResult && (x = ((AltResult)r).ex) != null) {
                this.completeThrowable(x, r);
            } else {
                try {
                    if (c != null && !c.claim()) {
                        return false;
                    }
                    f.run();
                    this.completeNull();
                }
                catch (Throwable ex) {
                    this.completeThrowable(ex);
                }
            }
        }
        return true;
    }

    private CompletableFuture<Void> uniRunStage(Executor e, Runnable f) {
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> d = this.newIncompleteFuture();
        if (e != null || !d.uniRun(this, f, null)) {
            UniRun c = new UniRun(e, d, this, f);
            this.push(c);
            c.tryFire(0);
        }
        return d;
    }

    final boolean uniWhenComplete(CompletableFuture<T> a, BiConsumer<? super T, ? super Throwable> f, UniWhenComplete<T> c) {
        Object r;
        Throwable x = null;
        if (a == null || (r = a.result) == null || f == null) {
            return false;
        }
        if (this.result == null) {
            block8: {
                try {
                    Object t;
                    if (c != null && !c.claim()) {
                        return false;
                    }
                    if (r instanceof AltResult) {
                        x = ((AltResult)r).ex;
                        t = null;
                    } else {
                        Object tr;
                        t = tr = r;
                    }
                    f.accept(t, x);
                    if (x == null) {
                        this.internalComplete(r);
                        return true;
                    }
                }
                catch (Throwable ex) {
                    if (x != null) break block8;
                    x = ex;
                }
            }
            this.completeThrowable(x, r);
        }
        return true;
    }

    private CompletableFuture<T> uniWhenCompleteStage(Executor e, BiConsumer<? super T, ? super Throwable> f) {
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture d = this.newIncompleteFuture();
        if (e != null || !d.uniWhenComplete(this, f, null)) {
            UniWhenComplete<T> c = new UniWhenComplete<T>(e, d, this, f);
            this.push(c);
            c.tryFire(0);
        }
        return d;
    }

    final <S> boolean uniHandle(CompletableFuture<S> a, BiFunction<? super S, Throwable, ? extends T> f, UniHandle<S, T> c) {
        Object r;
        if (a == null || (r = a.result) == null || f == null) {
            return false;
        }
        if (this.result == null) {
            try {
                Object s;
                Throwable x;
                if (c != null && !c.claim()) {
                    return false;
                }
                if (r instanceof AltResult) {
                    x = ((AltResult)r).ex;
                    s = null;
                } else {
                    Object ss;
                    x = null;
                    s = ss = r;
                }
                this.completeValue(f.apply(s, x));
            }
            catch (Throwable ex) {
                this.completeThrowable(ex);
            }
        }
        return true;
    }

    private <V> CompletableFuture<V> uniHandleStage(Executor e, BiFunction<? super T, Throwable, ? extends V> f) {
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture d = this.newIncompleteFuture();
        if (e != null || !d.uniHandle(this, f, null)) {
            UniHandle<T, V> c = new UniHandle<T, V>(e, d, this, f);
            this.push(c);
            c.tryFire(0);
        }
        return d;
    }

    final boolean uniExceptionally(CompletableFuture<T> a, Function<? super Throwable, ? extends T> f, UniExceptionally<T> c) {
        Object r;
        if (a == null || (r = a.result) == null || f == null) {
            return false;
        }
        if (this.result == null) {
            try {
                Throwable x;
                if (r instanceof AltResult && (x = ((AltResult)r).ex) != null) {
                    if (c != null && !c.claim()) {
                        return false;
                    }
                    this.completeValue(f.apply(x));
                } else {
                    this.internalComplete(r);
                }
            }
            catch (Throwable ex) {
                this.completeThrowable(ex);
            }
        }
        return true;
    }

    private CompletableFuture<T> uniExceptionallyStage(Function<Throwable, ? extends T> f) {
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture d = this.newIncompleteFuture();
        if (!d.uniExceptionally(this, f, null)) {
            UniExceptionally<T> c = new UniExceptionally<T>(d, this, f);
            this.push(c);
            c.tryFire(0);
        }
        return d;
    }

    final boolean uniRelay(CompletableFuture<T> a) {
        Object r;
        if (a == null || (r = a.result) == null) {
            return false;
        }
        if (this.result == null) {
            this.completeRelay(r);
        }
        return true;
    }

    private CompletableFuture<T> uniCopyStage() {
        CompletableFuture d = this.newIncompleteFuture();
        Object r = this.result;
        if (r != null) {
            d.completeRelay(r);
        } else {
            UniRelay c = new UniRelay(d, this);
            this.push(c);
            c.tryFire(0);
        }
        return d;
    }

    private MinimalStage<T> uniAsMinimalStage() {
        Object r = this.result;
        if (r != null) {
            return new MinimalStage(CompletableFuture.encodeRelay(r));
        }
        MinimalStage d = new MinimalStage();
        UniRelay c = new UniRelay(d, this);
        this.push(c);
        c.tryFire(0);
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <S> boolean uniCompose(CompletableFuture<S> a, Function<? super S, ? extends CompletionStage<T>> f, UniCompose<S, T> c) {
        Object r;
        if (a == null || (r = a.result) == null || f == null) {
            return false;
        }
        if (this.result != null) return true;
        if (r instanceof AltResult) {
            Throwable x = ((AltResult)r).ex;
            if (x != null) {
                this.completeThrowable(x, r);
                return true;
            }
            r = null;
        }
        try {
            if (c != null && !c.claim()) {
                return false;
            }
            Object s = r;
            CompletableFuture<Object> g = f.apply(s).toCompletableFuture();
            if (g.result != null && this.uniRelay(g)) return true;
            UniRelay<Object> copy = new UniRelay<Object>(this, g);
            g.push(copy);
            copy.tryFire(0);
            if (this.result != null) return true;
            return false;
        }
        catch (Throwable ex) {
            this.completeThrowable(ex);
        }
        return true;
    }

    private <V> CompletableFuture<V> uniComposeStage(Executor e, Function<? super T, ? extends CompletionStage<V>> f) {
        Object r;
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture d = this.newIncompleteFuture();
        if (e == null && (r = this.result) != null) {
            if (r instanceof AltResult) {
                Throwable x = ((AltResult)r).ex;
                if (x != null) {
                    d.result = CompletableFuture.encodeThrowable(x, r);
                    return d;
                }
                r = null;
            }
            try {
                Object t = r;
                CompletableFuture<V> g = f.apply(t).toCompletableFuture();
                Object s = g.result;
                if (s != null) {
                    d.completeRelay(s);
                } else {
                    UniRelay c = new UniRelay(d, g);
                    g.push(c);
                    c.tryFire(0);
                }
                return d;
            }
            catch (Throwable ex) {
                d.result = CompletableFuture.encodeThrowable(ex);
                return d;
            }
        }
        UniCompose c = new UniCompose(e, d, this, f);
        this.push(c);
        c.tryFire(0);
        return d;
    }

    final void bipush(CompletableFuture<?> b, BiCompletion<?, ?, ?> c) {
        if (c != null) {
            Object r;
            while ((r = this.result) == null && !this.tryPushStack(c)) {
                CompletableFuture.lazySetNext(c, null);
            }
            if (b != null && b != this && b.result == null) {
                Completion q;
                Completion completion = q = r != null ? c : new CoCompletion(c);
                while (b.result == null && !b.tryPushStack(q)) {
                    CompletableFuture.lazySetNext(q, null);
                }
            }
        }
    }

    final CompletableFuture<T> postFire(CompletableFuture<?> a, CompletableFuture<?> b, int mode) {
        if (b != null && b.stack != null) {
            if (mode < 0 || b.result == null) {
                b.cleanStack();
            } else {
                b.postComplete();
            }
        }
        return this.postFire(a, mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <R, S> boolean biApply(CompletableFuture<R> a, CompletableFuture<S> b, BiFunction<? super R, ? super S, ? extends T> f, BiApply<R, S, T> c) {
        Throwable x;
        Object s;
        Object r;
        if (a == null || (r = a.result) == null || b == null || (s = b.result) == null || f == null) {
            return false;
        }
        if (this.result != null) return true;
        if (r instanceof AltResult) {
            x = ((AltResult)r).ex;
            if (x != null) {
                this.completeThrowable(x, r);
                return true;
            }
            r = null;
        }
        if (s instanceof AltResult) {
            x = ((AltResult)s).ex;
            if (x != null) {
                this.completeThrowable(x, s);
                return true;
            }
            s = null;
        }
        try {
            if (c != null && !c.claim()) {
                return false;
            }
            Object rr = r;
            Object ss = s;
            this.completeValue(f.apply(rr, ss));
            return true;
        }
        catch (Throwable ex) {
            this.completeThrowable(ex);
        }
        return true;
    }

    private <U, V> CompletableFuture<V> biApplyStage(Executor e, CompletionStage<U> o, BiFunction<? super T, ? super U, ? extends V> f) {
        CompletableFuture<U> b;
        if (f == null || (b = o.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<U> d = this.newIncompleteFuture();
        if (e != null || !d.biApply(this, b, f, null)) {
            BiApply<T, U, V> c = new BiApply<T, U, V>(e, d, this, b, f);
            this.bipush(b, c);
            c.tryFire(0);
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <R, S> boolean biAccept(CompletableFuture<R> a, CompletableFuture<S> b, BiConsumer<? super R, ? super S> f, BiAccept<R, S> c) {
        Throwable x;
        Object s;
        Object r;
        if (a == null || (r = a.result) == null || b == null || (s = b.result) == null || f == null) {
            return false;
        }
        if (this.result != null) return true;
        if (r instanceof AltResult) {
            x = ((AltResult)r).ex;
            if (x != null) {
                this.completeThrowable(x, r);
                return true;
            }
            r = null;
        }
        if (s instanceof AltResult) {
            x = ((AltResult)s).ex;
            if (x != null) {
                this.completeThrowable(x, s);
                return true;
            }
            s = null;
        }
        try {
            if (c != null && !c.claim()) {
                return false;
            }
            Object rr = r;
            Object ss = s;
            f.accept(rr, ss);
            this.completeNull();
            return true;
        }
        catch (Throwable ex) {
            this.completeThrowable(ex);
        }
        return true;
    }

    private <U> CompletableFuture<Void> biAcceptStage(Executor e, CompletionStage<U> o, BiConsumer<? super T, ? super U> f) {
        CompletableFuture<U> b;
        if (f == null || (b = o.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> d = this.newIncompleteFuture();
        if (e != null || !d.biAccept(this, b, f, null)) {
            BiAccept<T, U> c = new BiAccept<T, U>(e, d, this, b, f);
            this.bipush(b, c);
            c.tryFire(0);
        }
        return d;
    }

    final boolean biRun(CompletableFuture<?> a, CompletableFuture<?> b, Runnable f, BiRun<?, ?> c) {
        Object s;
        Object r;
        if (a == null || (r = a.result) == null || b == null || (s = b.result) == null || f == null) {
            return false;
        }
        if (this.result == null) {
            Throwable x;
            if (r instanceof AltResult && (x = ((AltResult)r).ex) != null) {
                this.completeThrowable(x, r);
            } else if (s instanceof AltResult && (x = ((AltResult)s).ex) != null) {
                this.completeThrowable(x, s);
            } else {
                try {
                    if (c != null && !c.claim()) {
                        return false;
                    }
                    f.run();
                    this.completeNull();
                }
                catch (Throwable ex) {
                    this.completeThrowable(ex);
                }
            }
        }
        return true;
    }

    private CompletableFuture<Void> biRunStage(Executor e, CompletionStage<?> o, Runnable f) {
        CompletableFuture<?> b;
        if (f == null || (b = o.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> d = this.newIncompleteFuture();
        if (e != null || !d.biRun(this, b, f, null)) {
            BiRun c = new BiRun(e, d, this, b, f);
            this.bipush(b, c);
            c.tryFire(0);
        }
        return d;
    }

    boolean biRelay(CompletableFuture<?> a, CompletableFuture<?> b) {
        Object s;
        Object r;
        if (a == null || (r = a.result) == null || b == null || (s = b.result) == null) {
            return false;
        }
        if (this.result == null) {
            Throwable x;
            if (r instanceof AltResult && (x = ((AltResult)r).ex) != null) {
                this.completeThrowable(x, r);
            } else if (s instanceof AltResult && (x = ((AltResult)s).ex) != null) {
                this.completeThrowable(x, s);
            } else {
                this.completeNull();
            }
        }
        return true;
    }

    static CompletableFuture<Void> andTree(CompletableFuture<?>[] cfs, int lo, int hi) {
        CompletableFuture<Void> d = new CompletableFuture<Void>();
        if (lo > hi) {
            d.result = NIL;
        } else {
            CompletableFuture<Object> b;
            int mid = lo + hi >>> 1;
            CompletableFuture<Object> a = lo == mid ? cfs[lo] : CompletableFuture.andTree(cfs, lo, mid);
            if (a == null || (lo == hi ? a : (b = hi == mid + 1 ? cfs[hi] : CompletableFuture.andTree(cfs, mid + 1, hi))) == null) {
                throw new NullPointerException();
            }
            if (!d.biRelay(a, b)) {
                BiRelay c = new BiRelay(d, a, b);
                a.bipush(b, c);
                c.tryFire(0);
            }
        }
        return d;
    }

    final void orpush(CompletableFuture<?> b, BiCompletion<?, ?, ?> c) {
        if (c != null) {
            while ((b == null || b.result == null) && this.result == null) {
                if (this.tryPushStack(c)) {
                    if (b == null || b == this || b.result != null) break;
                    CoCompletion q = new CoCompletion(c);
                    while (this.result == null && b.result == null && !b.tryPushStack(q)) {
                        CompletableFuture.lazySetNext(q, null);
                    }
                    break;
                }
                CompletableFuture.lazySetNext(c, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final <R, S extends R> boolean orApply(CompletableFuture<R> a, CompletableFuture<S> b, Function<? super R, ? extends T> f, OrApply<R, S, T> c) {
        if (a == null) return false;
        if (b == null) return false;
        Object r = a.result;
        if (r == null) {
            r = b.result;
            if (r == null) return false;
        }
        if (f == null) {
            return false;
        }
        if (this.result != null) return true;
        try {
            if (c != null && !c.claim()) {
                return false;
            }
            if (r instanceof AltResult) {
                Throwable x = ((AltResult)r).ex;
                if (x != null) {
                    this.completeThrowable(x, r);
                    return true;
                }
                r = null;
            }
            Object rr = r;
            this.completeValue(f.apply(rr));
            return true;
        }
        catch (Throwable ex) {
            this.completeThrowable(ex);
        }
        return true;
    }

    private <U extends T, V> CompletableFuture<V> orApplyStage(Executor e, CompletionStage<U> o, Function<? super T, ? extends V> f) {
        CompletableFuture<U> b;
        if (f == null || (b = o.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<U> d = this.newIncompleteFuture();
        if (e != null || !d.orApply(this, b, f, null)) {
            OrApply<T, U, V> c = new OrApply<T, U, V>(e, d, this, b, f);
            this.orpush(b, c);
            c.tryFire(0);
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final <R, S extends R> boolean orAccept(CompletableFuture<R> a, CompletableFuture<S> b, Consumer<? super R> f, OrAccept<R, S> c) {
        if (a == null) return false;
        if (b == null) return false;
        Object r = a.result;
        if (r == null) {
            r = b.result;
            if (r == null) return false;
        }
        if (f == null) {
            return false;
        }
        if (this.result != null) return true;
        try {
            if (c != null && !c.claim()) {
                return false;
            }
            if (r instanceof AltResult) {
                Throwable x = ((AltResult)r).ex;
                if (x != null) {
                    this.completeThrowable(x, r);
                    return true;
                }
                r = null;
            }
            Object rr = r;
            f.accept(rr);
            this.completeNull();
            return true;
        }
        catch (Throwable ex) {
            this.completeThrowable(ex);
        }
        return true;
    }

    private <U extends T> CompletableFuture<Void> orAcceptStage(Executor e, CompletionStage<U> o, Consumer<? super T> f) {
        CompletableFuture<U> b;
        if (f == null || (b = o.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> d = this.newIncompleteFuture();
        if (e != null || !d.orAccept(this, b, f, null)) {
            OrAccept<T, U> c = new OrAccept<T, U>(e, d, this, b, f);
            this.orpush(b, c);
            c.tryFire(0);
        }
        return d;
    }

    final boolean orRun(CompletableFuture<?> a, CompletableFuture<?> b, Runnable f, OrRun<?, ?> c) {
        Object r;
        if (a == null || b == null || (r = a.result) == null && (r = b.result) == null || f == null) {
            return false;
        }
        if (this.result == null) {
            try {
                Throwable x;
                if (c != null && !c.claim()) {
                    return false;
                }
                if (r instanceof AltResult && (x = ((AltResult)r).ex) != null) {
                    this.completeThrowable(x, r);
                } else {
                    f.run();
                    this.completeNull();
                }
            }
            catch (Throwable ex) {
                this.completeThrowable(ex);
            }
        }
        return true;
    }

    private CompletableFuture<Void> orRunStage(Executor e, CompletionStage<?> o, Runnable f) {
        CompletableFuture<?> b;
        if (f == null || (b = o.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> d = this.newIncompleteFuture();
        if (e != null || !d.orRun(this, b, f, null)) {
            OrRun c = new OrRun(e, d, this, b, f);
            this.orpush(b, c);
            c.tryFire(0);
        }
        return d;
    }

    final boolean orRelay(CompletableFuture<?> a, CompletableFuture<?> b) {
        Object r;
        if (a == null || b == null || (r = a.result) == null && (r = b.result) == null) {
            return false;
        }
        if (this.result == null) {
            this.completeRelay(r);
        }
        return true;
    }

    static CompletableFuture<Object> orTree(CompletableFuture<?>[] cfs, int lo, int hi) {
        CompletableFuture<Object> d = new CompletableFuture<Object>();
        if (lo <= hi) {
            CompletableFuture<Object> b;
            int mid = lo + hi >>> 1;
            CompletableFuture<Object> a = lo == mid ? cfs[lo] : CompletableFuture.orTree(cfs, lo, mid);
            if (a == null || (lo == hi ? a : (b = hi == mid + 1 ? cfs[hi] : CompletableFuture.orTree(cfs, mid + 1, hi))) == null) {
                throw new NullPointerException();
            }
            if (!d.orRelay(a, b)) {
                OrRelay c = new OrRelay(d, a, b);
                a.orpush(b, c);
                c.tryFire(0);
            }
        }
        return d;
    }

    static <U> CompletableFuture<U> asyncSupplyStage(Executor e, Supplier<U> f) {
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture d = new CompletableFuture();
        e.execute(new AsyncSupply(d, f));
        return d;
    }

    static CompletableFuture<Void> asyncRunStage(Executor e, Runnable f) {
        if (f == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> d = new CompletableFuture<Void>();
        e.execute(new AsyncRun(d, f));
        return d;
    }

    private Object waitingGet(boolean interruptible) {
        Object r;
        Signaller q = null;
        boolean queued = false;
        int spins = -1;
        while ((r = this.result) == null) {
            if (spins < 0) {
                spins = Runtime.getRuntime().availableProcessors() > 1 ? 256 : 0;
                continue;
            }
            if (spins > 0) {
                if (ThreadLocalRandom.nextSecondarySeed() < 0) continue;
                --spins;
                continue;
            }
            if (q == null) {
                q = new Signaller(interruptible, 0L, 0L);
                continue;
            }
            if (!queued) {
                queued = this.tryPushStack(q);
                continue;
            }
            if (interruptible && q.interruptControl < 0) {
                q.thread = null;
                this.cleanStack();
                return null;
            }
            if (q.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(q);
            }
            catch (InterruptedException ie) {
                q.interruptControl = -1;
            }
        }
        if (q != null) {
            q.thread = null;
            if (q.interruptControl < 0) {
                if (interruptible) {
                    r = null;
                } else {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.postComplete();
        return r;
    }

    private Object timedGet(long nanos) throws TimeoutException {
        Object r;
        if (Thread.interrupted()) {
            return null;
        }
        if (nanos <= 0L) {
            throw new TimeoutException();
        }
        long d = System.nanoTime() + nanos;
        Signaller q = new Signaller(true, nanos, d == 0L ? 1L : d);
        boolean queued = false;
        while ((r = this.result) == null) {
            if (!queued) {
                queued = this.tryPushStack(q);
                continue;
            }
            if (q.interruptControl < 0 || q.nanos <= 0L) {
                q.thread = null;
                this.cleanStack();
                if (q.interruptControl < 0) {
                    return null;
                }
                throw new TimeoutException();
            }
            if (q.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(q);
            }
            catch (InterruptedException ie) {
                q.interruptControl = -1;
            }
        }
        if (q.interruptControl < 0) {
            r = null;
        }
        q.thread = null;
        this.postComplete();
        return r;
    }

    public CompletableFuture() {
    }

    CompletableFuture(Object r) {
        this.result = r;
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return CompletableFuture.asyncSupplyStage(asyncPool, supplier);
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return CompletableFuture.asyncSupplyStage(CompletableFuture.screenExecutor(executor), supplier);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.asyncRunStage(asyncPool, runnable);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return CompletableFuture.asyncRunStage(CompletableFuture.screenExecutor(executor), runnable);
    }

    public static <U> CompletableFuture<U> completedFuture(U value) {
        return new CompletableFuture(value == null ? NIL : value);
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Object r = this.result;
        return CompletableFuture.reportGet(r == null ? this.waitingGet(true) : r);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        Object r = this.result;
        return CompletableFuture.reportGet(r == null ? this.timedGet(nanos) : r);
    }

    public T join() {
        Object r = this.result;
        return CompletableFuture.reportJoin(r == null ? this.waitingGet(false) : r);
    }

    public T getNow(T valueIfAbsent) {
        Object r = this.result;
        return r == null ? valueIfAbsent : CompletableFuture.reportJoin(r);
    }

    public boolean complete(T value) {
        boolean triggered = this.completeValue(value);
        this.postComplete();
        return triggered;
    }

    public boolean completeExceptionally(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        boolean triggered = this.internalComplete(new AltResult(ex));
        this.postComplete();
        return triggered;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.uniApplyStage(null, fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.uniApplyStage(this.defaultExecutor(), fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.uniApplyStage(CompletableFuture.screenExecutor(executor), fn);
    }

    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.uniAcceptStage(null, action);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.uniAcceptStage(this.defaultExecutor(), action);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.uniAcceptStage(CompletableFuture.screenExecutor(executor), action);
    }

    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.uniRunStage(null, action);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.uniRunStage(this.defaultExecutor(), action);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.uniRunStage(CompletableFuture.screenExecutor(executor), action);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.biApplyStage(null, other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.biApplyStage(this.defaultExecutor(), other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.biApplyStage(CompletableFuture.screenExecutor(executor), other, fn);
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.biAcceptStage(null, other, action);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.biAcceptStage(this.defaultExecutor(), other, action);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.biAcceptStage(CompletableFuture.screenExecutor(executor), other, action);
    }

    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.biRunStage(null, other, action);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.biRunStage(this.defaultExecutor(), other, action);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.biRunStage(CompletableFuture.screenExecutor(executor), other, action);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.orApplyStage(null, other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.orApplyStage(this.defaultExecutor(), other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.orApplyStage(CompletableFuture.screenExecutor(executor), other, fn);
    }

    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.orAcceptStage(null, other, action);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.orAcceptStage(this.defaultExecutor(), other, action);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.orAcceptStage(CompletableFuture.screenExecutor(executor), other, action);
    }

    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.orRunStage(null, other, action);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.orRunStage(this.defaultExecutor(), other, action);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.orRunStage(CompletableFuture.screenExecutor(executor), other, action);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.uniComposeStage(null, fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.uniComposeStage(this.defaultExecutor(), fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.uniComposeStage(CompletableFuture.screenExecutor(executor), fn);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.uniWhenCompleteStage(null, action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.uniWhenCompleteStage(this.defaultExecutor(), action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.uniWhenCompleteStage(CompletableFuture.screenExecutor(executor), action);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.uniHandleStage(null, fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.uniHandleStage(this.defaultExecutor(), fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.uniHandleStage(CompletableFuture.screenExecutor(executor), fn);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.uniExceptionallyStage(fn);
    }

    public static CompletableFuture<Void> allOf(CompletableFuture<?> ... cfs) {
        return CompletableFuture.andTree(cfs, 0, cfs.length - 1);
    }

    public static CompletableFuture<Object> anyOf(CompletableFuture<?> ... cfs) {
        return CompletableFuture.orTree(cfs, 0, cfs.length - 1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = this.result == null && this.internalComplete(new AltResult(new CancellationException()));
        this.postComplete();
        return cancelled || this.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        Object r = this.result;
        return r instanceof AltResult && ((AltResult)r).ex instanceof CancellationException;
    }

    public boolean isCompletedExceptionally() {
        Object r = this.result;
        return r instanceof AltResult && r != NIL;
    }

    public void obtrudeValue(T value) {
        this.result = value == null ? NIL : value;
        this.postComplete();
    }

    public void obtrudeException(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        this.result = new AltResult(ex);
        this.postComplete();
    }

    public int getNumberOfDependents() {
        int count = 0;
        Completion p = this.stack;
        while (p != null) {
            ++count;
            p = p.next;
        }
        return count;
    }

    public String toString() {
        Object r = this.result;
        int count = 0;
        Completion p = this.stack;
        while (p != null) {
            ++count;
            p = p.next;
        }
        return super.toString() + (r == null ? (count == 0 ? "[Not completed]" : "[Not completed, " + count + " dependents]") : (r instanceof AltResult && ((AltResult)r).ex != null ? "[Completed exceptionally]" : "[Completed normally]"));
    }

    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new CompletableFuture<T>();
    }

    public Executor defaultExecutor() {
        return asyncPool;
    }

    public CompletableFuture<T> copy() {
        return this.uniCopyStage();
    }

    public CompletionStage<T> minimalCompletionStage() {
        return this.uniAsMinimalStage();
    }

    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        if (supplier == null || executor == null) {
            throw new NullPointerException();
        }
        executor.execute(new AsyncSupply<T>(this, supplier));
        return this;
    }

    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        return this.completeAsync(supplier, this.defaultExecutor());
    }

    public CompletableFuture<T> orTimeout(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (this.result == null) {
            this.whenComplete((BiConsumer)new Canceller(Delayer.delay(new Timeout(this), timeout, unit)));
        }
        return this;
    }

    public CompletableFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (this.result == null) {
            this.whenComplete((BiConsumer)new Canceller(Delayer.delay(new DelayedCompleter<T>(this, value), timeout, unit)));
        }
        return this;
    }

    public static Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        if (unit == null || executor == null) {
            throw new NullPointerException();
        }
        return new DelayedExecutor(delay, unit, executor);
    }

    public static Executor delayedExecutor(long delay, TimeUnit unit) {
        return new DelayedExecutor(delay, unit, asyncPool);
    }

    public static <U> CompletionStage<U> completedStage(U value) {
        return new MinimalStage(value == null ? NIL : value);
    }

    public static <U> CompletableFuture<U> failedFuture(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        return new CompletableFuture(CompletableFuture.encodeThrowable(ex));
    }

    public static <U> CompletionStage<U> failedStage(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        return new MinimalStage(CompletableFuture.encodeThrowable(ex));
    }

    static {
        try {
            RESULT = U.objectFieldOffset(CompletableFuture.class.getDeclaredField("result"));
            STACK = U.objectFieldOffset(CompletableFuture.class.getDeclaredField("stack"));
            NEXT = U.objectFieldOffset(Completion.class.getDeclaredField("next"));
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        Class<LockSupport> clazz = LockSupport.class;
    }

    static final class MinimalStage<T>
    extends CompletableFuture<T> {
        MinimalStage() {
        }

        MinimalStage(Object r) {
            super(r);
        }

        @Override
        public <U> CompletableFuture<U> newIncompleteFuture() {
            return new MinimalStage<T>();
        }

        @Override
        public T get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T getNow(T valueIfAbsent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T join() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean complete(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void obtrudeValue(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void obtrudeException(Throwable ex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCancelled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCompletedExceptionally() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getNumberOfDependents() {
            throw new UnsupportedOperationException();
        }
    }

    static final class Canceller
    implements BiConsumer<Object, Throwable> {
        final Future<?> f;

        Canceller(Future<?> f) {
            this.f = f;
        }

        @Override
        public void accept(Object ignore, Throwable ex) {
            if (ex == null && this.f != null && !this.f.isDone()) {
                this.f.cancel(false);
            }
        }
    }

    static final class DelayedCompleter<U>
    implements Runnable {
        final CompletableFuture<U> f;
        final U u;

        DelayedCompleter(CompletableFuture<U> f, U u) {
            this.f = f;
            this.u = u;
        }

        @Override
        public void run() {
            this.f.complete(this.u);
        }
    }

    static final class Timeout
    implements Runnable {
        final CompletableFuture<?> f;

        Timeout(CompletableFuture<?> f) {
            this.f = f;
        }

        @Override
        public void run() {
            if (this.f != null && !this.f.isDone()) {
                this.f.completeExceptionally(new TimeoutException());
            }
        }
    }

    static final class TaskSubmitter
    implements Runnable {
        final Executor executor;
        final Runnable action;

        TaskSubmitter(Executor executor, Runnable action) {
            this.executor = executor;
            this.action = action;
        }

        @Override
        public void run() {
            this.executor.execute(this.action);
        }
    }

    static final class DelayedExecutor
    implements Executor {
        final long delay;
        final TimeUnit unit;
        final Executor executor;

        DelayedExecutor(long delay, TimeUnit unit, Executor executor) {
            this.delay = delay;
            this.unit = unit;
            this.executor = executor;
        }

        @Override
        public void execute(Runnable r) {
            Delayer.delay(new TaskSubmitter(this.executor, r), this.delay, this.unit);
        }
    }

    static final class Delayer {
        static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

        Delayer() {
        }

        static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
            return delayer.schedule(command, delay, unit);
        }

        static {
            delayer.setRemoveOnCancelPolicy(true);
        }

        static final class DaemonThreadFactory
        implements ThreadFactory {
            DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("CompletableFutureDelayScheduler");
                return t;
            }
        }
    }

    static final class Signaller
    extends Completion
    implements ForkJoinPool.ManagedBlocker {
        long nanos;
        final long deadline;
        volatile int interruptControl;
        volatile Thread thread = Thread.currentThread();

        Signaller(boolean interruptible, long nanos, long deadline) {
            this.interruptControl = interruptible ? 1 : 0;
            this.nanos = nanos;
            this.deadline = deadline;
        }

        @Override
        final CompletableFuture<?> tryFire(int ignore) {
            Thread w = this.thread;
            if (w != null) {
                this.thread = null;
                LockSupport.unpark(w);
            }
            return null;
        }

        @Override
        public boolean isReleasable() {
            if (this.thread == null) {
                return true;
            }
            if (Thread.interrupted()) {
                int i = this.interruptControl;
                this.interruptControl = -1;
                if (i > 0) {
                    return true;
                }
            }
            if (this.deadline != 0L && (this.nanos <= 0L || (this.nanos = this.deadline - System.nanoTime()) <= 0L)) {
                this.thread = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean block() {
            if (this.isReleasable()) {
                return true;
            }
            if (this.deadline == 0L) {
                LockSupport.park(this);
            } else if (this.nanos > 0L) {
                LockSupport.parkNanos(this, this.nanos);
            }
            return this.isReleasable();
        }

        @Override
        final boolean isLive() {
            return this.thread != null;
        }
    }

    static final class AsyncRun
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        CompletableFuture<Void> dep;
        Runnable fn;

        AsyncRun(CompletableFuture<Void> dep, Runnable fn) {
            this.dep = dep;
            this.fn = fn;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.run();
            return true;
        }

        @Override
        public void run() {
            Runnable f;
            CompletableFuture<Void> d = this.dep;
            if (d != null && (f = this.fn) != null) {
                this.dep = null;
                this.fn = null;
                if (d.result == null) {
                    try {
                        f.run();
                        d.completeNull();
                    }
                    catch (Throwable ex) {
                        d.completeThrowable(ex);
                    }
                }
                d.postComplete();
            }
        }
    }

    static final class AsyncSupply<T>
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        CompletableFuture<T> dep;
        Supplier<? extends T> fn;

        AsyncSupply(CompletableFuture<T> dep, Supplier<? extends T> fn) {
            this.dep = dep;
            this.fn = fn;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.run();
            return true;
        }

        @Override
        public void run() {
            Supplier<T> f;
            CompletableFuture<T> d = this.dep;
            if (d != null && (f = this.fn) != null) {
                this.dep = null;
                this.fn = null;
                if (d.result == null) {
                    try {
                        d.completeValue(f.get());
                    }
                    catch (Throwable ex) {
                        d.completeThrowable(ex);
                    }
                }
                d.postComplete();
            }
        }
    }

    static final class OrRelay<T, U>
    extends BiCompletion<T, U, Object> {
        OrRelay(CompletableFuture<Object> dep, CompletableFuture<T> src, CompletableFuture<U> snd) {
            super(null, dep, src, snd);
        }

        final CompletableFuture<Object> tryFire(int mode) {
            CompletableFuture b;
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.orRelay(a = this.src, b = this.snd)) {
                return null;
            }
            this.src = null;
            this.snd = null;
            this.dep = null;
            return d.postFire(a, b, mode);
        }
    }

    static final class OrRun<T, U>
    extends BiCompletion<T, U, Void> {
        Runnable fn;

        OrRun(Executor executor, CompletableFuture<Void> dep, CompletableFuture<T> src, CompletableFuture<U> snd, Runnable fn) {
            super(executor, dep, src, snd);
            this.fn = fn;
        }

        final CompletableFuture<Void> tryFire(int mode) {
            CompletableFuture b;
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.orRun(a = this.src, b = this.snd, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return d.postFire(a, b, mode);
        }
    }

    static final class OrAccept<T, U extends T>
    extends BiCompletion<T, U, Void> {
        Consumer<? super T> fn;

        OrAccept(Executor executor, CompletableFuture<Void> dep, CompletableFuture<T> src, CompletableFuture<U> snd, Consumer<? super T> fn) {
            super(executor, dep, src, snd);
            this.fn = fn;
        }

        final CompletableFuture<Void> tryFire(int mode) {
            CompletableFuture b;
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.orAccept(a = this.src, b = this.snd, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return d.postFire(a, b, mode);
        }
    }

    static final class OrApply<T, U extends T, V>
    extends BiCompletion<T, U, V> {
        Function<? super T, ? extends V> fn;

        OrApply(Executor executor, CompletableFuture<V> dep, CompletableFuture<T> src, CompletableFuture<U> snd, Function<? super T, ? extends V> fn) {
            super(executor, dep, src, snd);
            this.fn = fn;
        }

        final CompletableFuture<V> tryFire(int mode) {
            CompletableFuture b;
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.orApply(a = this.src, b = this.snd, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return d.postFire(a, b, mode);
        }
    }

    static final class BiRelay<T, U>
    extends BiCompletion<T, U, Void> {
        BiRelay(CompletableFuture<Void> dep, CompletableFuture<T> src, CompletableFuture<U> snd) {
            super(null, dep, src, snd);
        }

        final CompletableFuture<Void> tryFire(int mode) {
            CompletableFuture b;
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.biRelay(a = this.src, b = this.snd)) {
                return null;
            }
            this.src = null;
            this.snd = null;
            this.dep = null;
            return d.postFire(a, b, mode);
        }
    }

    static final class BiRun<T, U>
    extends BiCompletion<T, U, Void> {
        Runnable fn;

        BiRun(Executor executor, CompletableFuture<Void> dep, CompletableFuture<T> src, CompletableFuture<U> snd, Runnable fn) {
            super(executor, dep, src, snd);
            this.fn = fn;
        }

        final CompletableFuture<Void> tryFire(int mode) {
            CompletableFuture b;
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.biRun(a = this.src, b = this.snd, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return d.postFire(a, b, mode);
        }
    }

    static final class BiAccept<T, U>
    extends BiCompletion<T, U, Void> {
        BiConsumer<? super T, ? super U> fn;

        BiAccept(Executor executor, CompletableFuture<Void> dep, CompletableFuture<T> src, CompletableFuture<U> snd, BiConsumer<? super T, ? super U> fn) {
            super(executor, dep, src, snd);
            this.fn = fn;
        }

        final CompletableFuture<Void> tryFire(int mode) {
            CompletableFuture b;
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.biAccept(a = this.src, b = this.snd, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return d.postFire(a, b, mode);
        }
    }

    static final class BiApply<T, U, V>
    extends BiCompletion<T, U, V> {
        BiFunction<? super T, ? super U, ? extends V> fn;

        BiApply(Executor executor, CompletableFuture<V> dep, CompletableFuture<T> src, CompletableFuture<U> snd, BiFunction<? super T, ? super U, ? extends V> fn) {
            super(executor, dep, src, snd);
            this.fn = fn;
        }

        final CompletableFuture<V> tryFire(int mode) {
            CompletableFuture b;
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.biApply(a = this.src, b = this.snd, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return d.postFire(a, b, mode);
        }
    }

    static final class CoCompletion
    extends Completion {
        BiCompletion<?, ?, ?> base;

        CoCompletion(BiCompletion<?, ?, ?> base) {
            this.base = base;
        }

        @Override
        final CompletableFuture<?> tryFire(int mode) {
            CompletableFuture<?> d;
            BiCompletion<?, ?, ?> c = this.base;
            if (c == null || (d = c.tryFire(mode)) == null) {
                return null;
            }
            this.base = null;
            return d;
        }

        @Override
        final boolean isLive() {
            BiCompletion<?, ?, ?> c = this.base;
            return c != null && c.dep != null;
        }
    }

    static abstract class BiCompletion<T, U, V>
    extends UniCompletion<T, V> {
        CompletableFuture<U> snd;

        BiCompletion(Executor executor, CompletableFuture<V> dep, CompletableFuture<T> src, CompletableFuture<U> snd) {
            super(executor, dep, src);
            this.snd = snd;
        }
    }

    static final class UniCompose<T, V>
    extends UniCompletion<T, V> {
        Function<? super T, ? extends CompletionStage<V>> fn;

        UniCompose(Executor executor, CompletableFuture<V> dep, CompletableFuture<T> src, Function<? super T, ? extends CompletionStage<V>> fn) {
            super(executor, dep, src);
            this.fn = fn;
        }

        final CompletableFuture<V> tryFire(int mode) {
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.uniCompose(a = this.src, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return d.postFire(a, mode);
        }
    }

    static final class UniRelay<T>
    extends UniCompletion<T, T> {
        UniRelay(CompletableFuture<T> dep, CompletableFuture<T> src) {
            super(null, dep, src);
        }

        final CompletableFuture<T> tryFire(int mode) {
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.uniRelay(a = this.src)) {
                return null;
            }
            this.src = null;
            this.dep = null;
            return d.postFire(a, mode);
        }
    }

    static final class UniExceptionally<T>
    extends UniCompletion<T, T> {
        Function<? super Throwable, ? extends T> fn;

        UniExceptionally(CompletableFuture<T> dep, CompletableFuture<T> src, Function<? super Throwable, ? extends T> fn) {
            super(null, dep, src);
            this.fn = fn;
        }

        final CompletableFuture<T> tryFire(int mode) {
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.uniExceptionally(a = this.src, this.fn, this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return d.postFire(a, mode);
        }
    }

    static final class UniHandle<T, V>
    extends UniCompletion<T, V> {
        BiFunction<? super T, Throwable, ? extends V> fn;

        UniHandle(Executor executor, CompletableFuture<V> dep, CompletableFuture<T> src, BiFunction<? super T, Throwable, ? extends V> fn) {
            super(executor, dep, src);
            this.fn = fn;
        }

        final CompletableFuture<V> tryFire(int mode) {
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.uniHandle(a = this.src, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return d.postFire(a, mode);
        }
    }

    static final class UniWhenComplete<T>
    extends UniCompletion<T, T> {
        BiConsumer<? super T, ? super Throwable> fn;

        UniWhenComplete(Executor executor, CompletableFuture<T> dep, CompletableFuture<T> src, BiConsumer<? super T, ? super Throwable> fn) {
            super(executor, dep, src);
            this.fn = fn;
        }

        final CompletableFuture<T> tryFire(int mode) {
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.uniWhenComplete(a = this.src, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return d.postFire(a, mode);
        }
    }

    static final class UniRun<T>
    extends UniCompletion<T, Void> {
        Runnable fn;

        UniRun(Executor executor, CompletableFuture<Void> dep, CompletableFuture<T> src, Runnable fn) {
            super(executor, dep, src);
            this.fn = fn;
        }

        final CompletableFuture<Void> tryFire(int mode) {
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.uniRun(a = this.src, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return d.postFire(a, mode);
        }
    }

    static final class UniAccept<T>
    extends UniCompletion<T, Void> {
        Consumer<? super T> fn;

        UniAccept(Executor executor, CompletableFuture<Void> dep, CompletableFuture<T> src, Consumer<? super T> fn) {
            super(executor, dep, src);
            this.fn = fn;
        }

        final CompletableFuture<Void> tryFire(int mode) {
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.uniAccept(a = this.src, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return d.postFire(a, mode);
        }
    }

    static final class UniApply<T, V>
    extends UniCompletion<T, V> {
        Function<? super T, ? extends V> fn;

        UniApply(Executor executor, CompletableFuture<V> dep, CompletableFuture<T> src, Function<? super T, ? extends V> fn) {
            super(executor, dep, src);
            this.fn = fn;
        }

        final CompletableFuture<V> tryFire(int mode) {
            CompletableFuture a;
            CompletableFuture d = this.dep;
            if (d == null || !d.uniApply(a = this.src, this.fn, mode > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return d.postFire(a, mode);
        }
    }

    static abstract class UniCompletion<T, V>
    extends Completion {
        Executor executor;
        CompletableFuture<V> dep;
        CompletableFuture<T> src;

        UniCompletion(Executor executor, CompletableFuture<V> dep, CompletableFuture<T> src) {
            this.executor = executor;
            this.dep = dep;
            this.src = src;
        }

        final boolean claim() {
            Executor e = this.executor;
            if (this.compareAndSetForkJoinTaskTag((short)0, (short)1)) {
                if (e == null) {
                    return true;
                }
                this.executor = null;
                e.execute(this);
            }
            return false;
        }

        @Override
        final boolean isLive() {
            return this.dep != null;
        }
    }

    static abstract class Completion
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        volatile Completion next;

        Completion() {
        }

        abstract CompletableFuture<?> tryFire(int var1);

        abstract boolean isLive();

        @Override
        public final void run() {
            this.tryFire(1);
        }

        @Override
        public final boolean exec() {
            this.tryFire(1);
            return false;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }
    }

    static final class ThreadPerTaskExecutor
    implements Executor {
        ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }

    public static interface AsynchronousCompletionTask {
    }

    static final class AltResult {
        final Throwable ex;

        AltResult(Throwable x) {
            this.ex = x;
        }
    }
}

