/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import sun.misc.Unsafe;

public class ConcurrentSkipListMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Object BASE_HEADER = new Object();
    private volatile transient HeadIndex<K, V> head;
    final Comparator<? super K> comparator;
    private transient KeySet<K> keySet;
    private transient EntrySet<K, V> entrySet;
    private transient Values<V> values;
    private transient ConcurrentNavigableMap<K, V> descendingMap;
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long HEAD;

    private void initialize() {
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.descendingMap = null;
        this.head = new HeadIndex(new Node(null, BASE_HEADER, null), null, null, 1);
    }

    private boolean casHead(HeadIndex<K, V> cmp, HeadIndex<K, V> val) {
        return U.compareAndSwapObject(this, HEAD, cmp, val);
    }

    static final int cpr(Comparator c, Object x, Object y) {
        return c != null ? c.compare(x, y) : ((Comparable)x).compareTo(y);
    }

    private Node<K, V> findPredecessor(Object key, Comparator<? super K> cmp) {
        if (key == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            Index q = this.head;
            Index r = q.right;
            while (true) {
                Index d;
                if (r != null) {
                    Node n = r.node;
                    Object k = n.key;
                    if (n.value == null) {
                        if (!q.unlink(r)) continue block0;
                        r = q.right;
                        continue;
                    }
                    if (ConcurrentSkipListMap.cpr(cmp, key, k) > 0) {
                        q = r;
                        r = r.right;
                        continue;
                    }
                }
                if ((d = q.down) == null) {
                    return q.node;
                }
                q = d;
                r = d.right;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Node<K, V> findNode(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        cmp = this.comparator;
        block0: while (true) {
            b /* !! */  = this.findPredecessor(key, cmp);
            n = b /* !! */ .next;
            while (n != null) {
                f = n.next;
                if (n != b /* !! */ .next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b /* !! */ , f);
                    continue block0;
                }
                if (b /* !! */ .value != null && v != n) ** break;
                continue block0;
                c = ConcurrentSkipListMap.cpr(cmp, key, n.key);
                if (c == 0) {
                    return n;
                }
                if (c < 0) break block0;
                b /* !! */  = n;
                n = f;
            }
            break;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private V doGet(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        cmp = this.comparator;
        block0: while (true) {
            b /* !! */  = this.findPredecessor(key, cmp);
            n = b /* !! */ .next;
            while (n != null) {
                f = n.next;
                if (n != b /* !! */ .next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b /* !! */ , f);
                    continue block0;
                }
                if (b /* !! */ .value != null && v != n) ** break;
                continue block0;
                c = ConcurrentSkipListMap.cpr(cmp, key, n.key);
                if (c == 0) {
                    vv = v;
                    return (V)vv;
                }
                if (c < 0) break block0;
                b /* !! */  = n;
                n = f;
            }
            break;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private V doPut(K key, V value, boolean onlyIfAbsent) {
        if (key == null) {
            throw new NullPointerException();
        }
        cmp = this.comparator;
        block0: while (true) {
            b /* !! */  = this.findPredecessor(key, cmp);
            n = b /* !! */ .next;
            while (n != null) {
                f = n.next;
                if (n != b /* !! */ .next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b /* !! */ , f);
                    continue block0;
                }
                if (b /* !! */ .value == null || v == n) continue block0;
                c = ConcurrentSkipListMap.cpr(cmp, key, n.key);
                if (c > 0) {
                    b /* !! */  = n;
                    n = f;
                    continue;
                }
                if (c != 0) break;
                if (!onlyIfAbsent && !n.casValue(v, value)) continue block0;
                vv = v;
                return (V)vv;
            }
            if (b /* !! */ .casNext(n, z = new Node<K, V>(key, value, n))) break;
        }
        rnd = ThreadLocalRandom.nextSecondarySeed();
        if ((rnd & -2147483647) == 0) {
            block21: {
                level = 1;
                while (((rnd >>>= 1) & 1) != 0) {
                    ++level;
                }
                idx = null;
                h = this.head;
                max = h.level;
                if (level <= max) {
                    for (i = 1; i <= level; ++i) {
                        idx = new Index(z, idx, null);
                    }
                } else {
                    level = max + 1;
                    idxs = new Index[level + 1];
                    for (i = 1; i <= level; ++i) {
                        idx = new Index<K, V>(z, idx, null);
                        idxs[i] = idx;
                    }
                    do {
                        h = this.head;
                        oldLevel = h.level;
                        if (level <= oldLevel) break block21;
                        newh = h;
                        oldbase = h.node;
                        for (j = oldLevel + 1; j <= level; ++j) {
                            newh = new HeadIndex<K, V>(oldbase, newh, idxs[j], j);
                        }
                    } while (!this.casHead(h, newh));
                    h = newh;
                    level = oldLevel;
                    idx = idxs[level];
                }
            }
            insertionLevel = level;
            block7: while (true) {
                j = h.level;
                q = h;
                r = q.right;
                t = idx;
                while (q != null && t != null) {
                    if (r != null) {
                        n = r.node;
                        c = ConcurrentSkipListMap.cpr(cmp, key, n.key);
                        if (n.value == null) {
                            if (!q.unlink(r)) continue block7;
                            r = q.right;
                            continue;
                        }
                        if (c > 0) {
                            q = r;
                            r = r.right;
                            continue;
                        }
                    }
                    if (j == insertionLevel) {
                        if (q.link(r, t)) ** break;
                        continue block7;
                        if (t.node.value == null) {
                            this.findNode(key);
                            break block7;
                        }
                        if (--insertionLevel == 0) break block7;
                    }
                    if (--j >= insertionLevel && j < level) {
                        t = t.down;
                    }
                    q = q.down;
                    r = q.right;
                }
                break;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    final V doRemove(Object key, Object value) {
        Object v;
        Node f;
        Node n;
        Node b;
        if (key == null) {
            throw new NullPointerException();
        }
        Comparator<? super K> cmp = this.comparator;
        block0: while (true) {
            b = this.findPredecessor(key, cmp);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (b.value == null || v == n) continue block0;
                int c = ConcurrentSkipListMap.cpr(cmp, key, n.key);
                if (c < 0) {
                    return null;
                }
                if (c <= 0) break;
                b = n;
                n = f;
            }
            if (value != null && !value.equals(v)) {
                return null;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(key);
        } else {
            this.findPredecessor(key, cmp);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        Object vv = v;
        return (V)vv;
    }

    private void tryReduceLevel() {
        HeadIndex e;
        HeadIndex d;
        HeadIndex<K, V> h = this.head;
        if (h.level > 3 && (d = (HeadIndex)h.down) != null && (e = (HeadIndex)d.down) != null && e.right == null && d.right == null && h.right == null && this.casHead(h, d) && h.right != null) {
            this.casHead(d, h);
        }
    }

    final Node<K, V> findFirst() {
        while (true) {
            Node b = this.head.node;
            Node n = b.next;
            if (n == null) {
                return null;
            }
            if (n.value != null) {
                return n;
            }
            n.helpDelete(b, n.next);
        }
    }

    private Map.Entry<K, V> doRemoveFirstEntry() {
        Object v;
        Node f;
        Node n;
        Node b;
        while (true) {
            b = this.head.node;
            n = b.next;
            if (n == null) {
                return null;
            }
            f = n.next;
            if (n != b.next) continue;
            v = n.value;
            if (v == null) {
                n.helpDelete(b, f);
                continue;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        Object vv = v;
        return new AbstractMap.SimpleImmutableEntry(n.key, vv);
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index q = this.head;
            do {
                Index r;
                if ((r = q.right) != null && r.indexesDeletedNode() && !q.unlink(r)) continue block0;
            } while ((q = q.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    private Map.Entry<K, V> doRemoveLastEntry() {
        Object v;
        Node f;
        Node n;
        Node b;
        block0: while (true) {
            b = this.findPredecessorOfLast();
            n = b.next;
            if (n == null) {
                if (!b.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (b.value == null || v == n) continue block0;
                if (f == null) break;
                b = n;
                n = f;
            }
            if (n.casValue(v, null)) break;
        }
        Object key = n.key;
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(key);
        } else {
            this.findPredecessor(key, this.comparator);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        Object vv = v;
        return new AbstractMap.SimpleImmutableEntry(key, vv);
    }

    final Node<K, V> findLast() {
        Index q = this.head;
        while (true) {
            Index r;
            if ((r = q.right) != null) {
                if (r.indexesDeletedNode()) {
                    q.unlink(r);
                    q = this.head;
                    continue;
                }
                q = r;
                continue;
            }
            Index d = q.down;
            if (d != null) {
                q = d;
                continue;
            }
            Node b = q.node;
            Node n = b.next;
            while (true) {
                if (n == null) {
                    return b.isBaseHeader() ? null : b;
                }
                Node f = n.next;
                if (n != b.next) break;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    break;
                }
                if (b.value == null || v == n) break;
                b = n;
                n = f;
            }
            q = this.head;
        }
    }

    private Node<K, V> findPredecessorOfLast() {
        Index q;
        block0: while (true) {
            q = this.head;
            while (true) {
                Index d;
                Index r;
                if ((r = q.right) != null) {
                    if (r.indexesDeletedNode()) {
                        q.unlink(r);
                        continue block0;
                    }
                    if (r.node.next != null) {
                        q = r;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
            }
            break;
        }
        return q.node;
    }

    /*
     * Unable to fully structure code
     */
    final Node<K, V> findNear(K key, int rel, Comparator<? super K> cmp) {
        if (key == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            b = this.findPredecessor(key, cmp);
            n = b.next;
            while (true) {
                if (n == null) {
                    return (rel & 2) == 0 || b.isBaseHeader() != false ? null : b;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (b.value != null && v != n) ** break;
                continue block0;
                c = ConcurrentSkipListMap.cpr(cmp, key, n.key);
                if (c == 0 && (rel & 1) != 0 || c < 0 && (rel & 2) == 0) {
                    return n;
                }
                if (c <= 0 && (rel & 2) != 0) {
                    return b.isBaseHeader() != false ? null : b;
                }
                b = n;
                n = f;
            }
            break;
        }
    }

    final AbstractMap.SimpleImmutableEntry<K, V> getNear(K key, int rel) {
        Node<K, V> n;
        AbstractMap.SimpleImmutableEntry<? super K, V> e;
        Comparator<? super K> cmp = this.comparator;
        do {
            if ((n = this.findNear(key, rel, cmp)) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    public ConcurrentSkipListMap() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.initialize();
    }

    public ConcurrentSkipListMap(Map<? extends K, ? extends V> m) {
        this.comparator = null;
        this.initialize();
        this.putAll(m);
    }

    public ConcurrentSkipListMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        this.initialize();
        this.buildFromSorted(m);
    }

    @Override
    public ConcurrentSkipListMap<K, V> clone() {
        try {
            ConcurrentSkipListMap clone = (ConcurrentSkipListMap)super.clone();
            clone.initialize();
            clone.buildFromSorted(this);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void buildFromSorted(SortedMap<K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        HeadIndex<K, V> h = this.head;
        Node basepred = h.node;
        ArrayList preds = new ArrayList();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            int rnd = ThreadLocalRandom.current().nextInt();
            int j = 0;
            if ((rnd & 0x80000001) == 0) {
                do {
                    ++j;
                } while (((rnd >>>= 1) & 1) != 0);
                if (j > h.level) {
                    j = h.level + 1;
                }
            }
            K k = e.getKey();
            V v = e.getValue();
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            Node z = new Node(k, v, null);
            basepred.next = z;
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex<K, V>(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<K, V> n = this.findFirst();
        while (n != null) {
            V v = n.getValidValue();
            if (v != null) {
                s.writeObject(n.key);
                s.writeObject(v);
            }
            n = n.next;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object k;
        s.defaultReadObject();
        this.initialize();
        HeadIndex<Object, V> h = this.head;
        Node basepred = h.node;
        ArrayList preds = new ArrayList();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        while ((k = s.readObject()) != null) {
            Object v = s.readObject();
            if (v == null) {
                throw new NullPointerException();
            }
            Object key = k;
            Object val = v;
            int rnd = ThreadLocalRandom.current().nextInt();
            int j = 0;
            if ((rnd & 0x80000001) == 0) {
                do {
                    ++j;
                } while (((rnd >>>= 1) & 1) != 0);
                if (j > h.level) {
                    j = h.level + 1;
                }
            }
            Node z = new Node(key, val, null);
            basepred.next = z;
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex<Object, V>(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.doGet(key) != null;
    }

    @Override
    public V get(Object key) {
        return this.doGet(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.doGet(key);
        return v == null ? defaultValue : v;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, false);
    }

    @Override
    public V remove(Object key) {
        return this.doRemove(key, null);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Node<K, V> n = this.findFirst();
        while (n != null) {
            V v = n.getValidValue();
            if (v != null && value.equals(v)) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    @Override
    public int size() {
        long count = 0L;
        Node<K, V> n = this.findFirst();
        while (n != null) {
            if (n.getValidValue() != null) {
                ++count;
            }
            n = n.next;
        }
        return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    @Override
    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    @Override
    public void clear() {
        this.initialize();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V r;
        if (key == null || mappingFunction == null) {
            throw new NullPointerException();
        }
        V v = this.doGet(key);
        if (v == null && (r = mappingFunction.apply(key)) != null) {
            V p = this.doPut(key, r, true);
            v = p == null ? r : p;
        }
        return v;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Node<K, V> n;
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        while ((n = this.findNode(key)) != null) {
            Object v = n.value;
            if (v == null) continue;
            Object vv = v;
            V r = remappingFunction.apply(key, vv);
            if (r != null) {
                if (!n.casValue(vv, r)) continue;
                return r;
            }
            if (this.doRemove(key, vv) == null) continue;
            break;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        while (true) {
            V r;
            Node<K, V> n;
            if ((n = this.findNode(key)) == null) {
                r = remappingFunction.apply(key, null);
                if (r == null) return null;
                if (this.doPut(key, r, true) != null) continue;
                return r;
            }
            Object v = n.value;
            if (v == null) continue;
            Object vv = v;
            r = remappingFunction.apply(key, vv);
            if (r != null) {
                if (!n.casValue(vv, r)) continue;
                return r;
            }
            if (this.doRemove(key, vv) != null) return null;
        }
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (key == null || value == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        while (true) {
            Node<K, V> n;
            if ((n = this.findNode(key)) == null) {
                if (this.doPut(key, value, true) != null) continue;
                return value;
            }
            Object v = n.value;
            if (v == null) continue;
            Object vv = v;
            V r = remappingFunction.apply(vv, value);
            if (r != null) {
                if (!n.casValue(vv, r)) continue;
                return r;
            }
            if (this.doRemove(key, vv) != null) break;
        }
        return null;
    }

    @Override
    public NavigableSet<K> keySet() {
        KeySet<K> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    @Override
    public Collection<V> values() {
        Values<V> vs = this.values;
        return vs != null ? vs : (this.values = new Values(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet<K, V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this));
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        ConcurrentNavigableMap<K, V> dm = this.descendingMap;
        return dm != null ? dm : (this.descendingMap = new SubMap(this, null, false, null, false, true));
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                if (e.getValue().equals(m.get(e.getKey()))) continue;
                return false;
            }
            for (Map.Entry<K, V> e : m.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (k != null && v != null && v.equals(this.get(k))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return value != null && this.doRemove(key, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        while (true) {
            Node<K, V> n;
            if ((n = this.findNode(key)) == null) {
                return false;
            }
            Object v = n.value;
            if (v == null) continue;
            if (!oldValue.equals(v)) {
                return false;
            }
            if (n.casValue(v, newValue)) break;
        }
        return true;
    }

    @Override
    public V replace(K key, V value) {
        Node<K, V> n;
        Object v;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        do {
            if ((n = this.findNode(key)) != null) continue;
            return null;
        } while ((v = n.value) == null || !n.casValue(v, value));
        Object vv = v;
        return (V)vv;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        Node<K, V> n = this.findFirst();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    @Override
    public K lastKey() {
        Node<K, V> n = this.findLast();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, fromInclusive, toKey, toInclusive, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, null, false, toKey, inclusive, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, inclusive, null, false, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.getNear(key, 2);
    }

    @Override
    public K lowerKey(K key) {
        Node<? super K, V> n = this.findNear(key, 2, this.comparator);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.getNear(key, 3);
    }

    @Override
    public K floorKey(K key) {
        Node<? super K, V> n = this.findNear(key, 3, this.comparator);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.getNear(key, 1);
    }

    @Override
    public K ceilingKey(K key) {
        Node<? super K, V> n = this.findNear(key, 1, this.comparator);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.getNear(key, 0);
    }

    @Override
    public K higherKey(K key) {
        Node<? super K, V> n = this.findNear(key, 0, this.comparator);
        return n == null ? null : (K)n.key;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Node<K, V> n;
        AbstractMap.SimpleImmutableEntry<K, V> e;
        do {
            if ((n = this.findFirst()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Node<K, V> n;
        AbstractMap.SimpleImmutableEntry<K, V> e;
        do {
            if ((n = this.findLast()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.doRemoveFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.doRemoveLastEntry();
    }

    Iterator<K> keyIterator() {
        return new KeyIterator();
    }

    Iterator<V> valueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new EntryIterator();
    }

    static final <E> List<E> toList(Collection<E> c) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : c) {
            list.add(e);
        }
        return list;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        Node<K, V> n = this.findFirst();
        while (n != null) {
            V v = n.getValidValue();
            if (v != null) {
                action.accept(n.key, v);
            }
            n = n.next;
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        Node<K, V> n = this.findFirst();
        while (n != null) {
            V v;
            while ((v = n.getValidValue()) != null) {
                V r = function.apply(n.key, v);
                if (r == null) {
                    throw new NullPointerException();
                }
                if (!n.casValue(v, r)) continue;
                break;
            }
            n = n.next;
        }
    }

    final KeySpliterator<K, V> keySpliterator() {
        Comparator<? super K> cmp = this.comparator;
        while (true) {
            HeadIndex<K, V> h = this.head;
            Node b = h.node;
            Node p = b.next;
            if (p == null || p.value != null) {
                return new KeySpliterator<Object, V>(cmp, h, p, null, p == null ? 0 : Integer.MAX_VALUE);
            }
            p.helpDelete(b, p.next);
        }
    }

    final ValueSpliterator<K, V> valueSpliterator() {
        Comparator<? super K> cmp = this.comparator;
        while (true) {
            HeadIndex<K, V> h = this.head;
            Node b = h.node;
            Node p = b.next;
            if (p == null || p.value != null) {
                return new ValueSpliterator<Object, V>(cmp, h, p, null, p == null ? 0 : Integer.MAX_VALUE);
            }
            p.helpDelete(b, p.next);
        }
    }

    final EntrySpliterator<K, V> entrySpliterator() {
        Comparator<? super K> cmp = this.comparator;
        while (true) {
            HeadIndex<K, V> h = this.head;
            Node b = h.node;
            Node p = b.next;
            if (p == null || p.value != null) {
                return new EntrySpliterator<Object, V>(cmp, h, p, null, p == null ? 0 : Integer.MAX_VALUE);
            }
            p.helpDelete(b, p.next);
        }
    }

    static {
        try {
            HEAD = U.objectFieldOffset(ConcurrentSkipListMap.class.getDeclaredField("head"));
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    static final class EntrySpliterator<K, V>
    extends CSLMSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(Comparator<? super K> comparator, Index<K, V> row, Node<K, V> origin, K fence, int est) {
            super(comparator, row, origin, fence, est);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> trySplit() {
            Object ek;
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            if (e != null && (ek = e.key) != null) {
                Index q = this.row;
                while (q != null) {
                    Object sk;
                    Node n;
                    Node b;
                    Index s = q.right;
                    if (s != null && (b = s.node) != null && (n = b.next) != null && n.value != null && (sk = n.key) != null && ConcurrentSkipListMap.cpr(cmp, sk, ek) > 0 && (f == null || ConcurrentSkipListMap.cpr(cmp, sk, f) < 0)) {
                        this.current = n;
                        Index r = q.down;
                        this.row = s.right != null ? s : s.down;
                        this.est -= this.est >>> 2;
                        return new EntrySpliterator(cmp, r, e, sk, this.est);
                    }
                    q = this.row = q.down;
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            Object k;
            if (action == null) {
                throw new NullPointerException();
            }
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            this.current = null;
            while (e != null && ((k = e.key) == null || f == null || ConcurrentSkipListMap.cpr(cmp, f, k) > 0)) {
                Object v = e.value;
                if (v != null && v != e) {
                    Object vv = v;
                    action.accept(new AbstractMap.SimpleImmutableEntry(k, vv));
                }
                e = e.next;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            while (e != null) {
                Object k = e.key;
                if (k != null && f != null && ConcurrentSkipListMap.cpr(cmp, f, k) <= 0) {
                    e = null;
                    break;
                }
                Object v = e.value;
                if (v != null && v != e) {
                    this.current = e.next;
                    Object vv = v;
                    action.accept(new AbstractMap.SimpleImmutableEntry(k, vv));
                    return true;
                }
                e = e.next;
            }
            this.current = e;
            return false;
        }

        @Override
        public int characteristics() {
            return 4373;
        }

        @Override
        public final Comparator<Map.Entry<K, V>> getComparator() {
            if (this.comparator != null) {
                return Map.Entry.comparingByKey(this.comparator);
            }
            return (Comparator & Serializable)(e1, e2) -> {
                Comparable k1 = (Comparable)e1.getKey();
                return k1.compareTo(e2.getKey());
            };
        }
    }

    static final class ValueSpliterator<K, V>
    extends CSLMSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(Comparator<? super K> comparator, Index<K, V> row, Node<K, V> origin, K fence, int est) {
            super(comparator, row, origin, fence, est);
        }

        @Override
        public Spliterator<V> trySplit() {
            Object ek;
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            if (e != null && (ek = e.key) != null) {
                Index q = this.row;
                while (q != null) {
                    Object sk;
                    Node n;
                    Node b;
                    Index s = q.right;
                    if (s != null && (b = s.node) != null && (n = b.next) != null && n.value != null && (sk = n.key) != null && ConcurrentSkipListMap.cpr(cmp, sk, ek) > 0 && (f == null || ConcurrentSkipListMap.cpr(cmp, sk, f) < 0)) {
                        this.current = n;
                        Index r = q.down;
                        this.row = s.right != null ? s : s.down;
                        this.est -= this.est >>> 2;
                        return new ValueSpliterator(cmp, r, e, sk, this.est);
                    }
                    q = this.row = q.down;
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            Object k;
            if (action == null) {
                throw new NullPointerException();
            }
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            this.current = null;
            while (e != null && ((k = e.key) == null || f == null || ConcurrentSkipListMap.cpr(cmp, f, k) > 0)) {
                Object v = e.value;
                if (v != null && v != e) {
                    Object vv = v;
                    action.accept(vv);
                }
                e = e.next;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            while (e != null) {
                Object k = e.key;
                if (k != null && f != null && ConcurrentSkipListMap.cpr(cmp, f, k) <= 0) {
                    e = null;
                    break;
                }
                Object v = e.value;
                if (v != null && v != e) {
                    this.current = e.next;
                    Object vv = v;
                    action.accept(vv);
                    return true;
                }
                e = e.next;
            }
            this.current = e;
            return false;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    static final class KeySpliterator<K, V>
    extends CSLMSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(Comparator<? super K> comparator, Index<K, V> row, Node<K, V> origin, K fence, int est) {
            super(comparator, row, origin, fence, est);
        }

        @Override
        public Spliterator<K> trySplit() {
            Object ek;
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            if (e != null && (ek = e.key) != null) {
                Index q = this.row;
                while (q != null) {
                    Object sk;
                    Node n;
                    Node b;
                    Index s = q.right;
                    if (s != null && (b = s.node) != null && (n = b.next) != null && n.value != null && (sk = n.key) != null && ConcurrentSkipListMap.cpr(cmp, sk, ek) > 0 && (f == null || ConcurrentSkipListMap.cpr(cmp, sk, f) < 0)) {
                        this.current = n;
                        Index r = q.down;
                        this.row = s.right != null ? s : s.down;
                        this.est -= this.est >>> 2;
                        return new KeySpliterator(cmp, r, e, sk, this.est);
                    }
                    q = this.row = q.down;
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            Object k;
            if (action == null) {
                throw new NullPointerException();
            }
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            this.current = null;
            while (e != null && ((k = e.key) == null || f == null || ConcurrentSkipListMap.cpr(cmp, f, k) > 0)) {
                Object v = e.value;
                if (v != null && v != e) {
                    action.accept(k);
                }
                e = e.next;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Comparator cmp = this.comparator;
            Object f = this.fence;
            Node e = this.current;
            while (e != null) {
                Object k = e.key;
                if (k != null && f != null && ConcurrentSkipListMap.cpr(cmp, f, k) <= 0) {
                    e = null;
                    break;
                }
                Object v = e.value;
                if (v != null && v != e) {
                    this.current = e.next;
                    action.accept(k);
                    return true;
                }
                e = e.next;
            }
            this.current = e;
            return false;
        }

        @Override
        public int characteristics() {
            return 4373;
        }

        @Override
        public final Comparator<? super K> getComparator() {
            return this.comparator;
        }
    }

    static abstract class CSLMSpliterator<K, V> {
        final Comparator<? super K> comparator;
        final K fence;
        Index<K, V> row;
        Node<K, V> current;
        int est;

        CSLMSpliterator(Comparator<? super K> comparator, Index<K, V> row, Node<K, V> origin, K fence, int est) {
            this.comparator = comparator;
            this.row = row;
            this.current = origin;
            this.fence = fence;
            this.est = est;
        }

        public final long estimateSize() {
            return this.est;
        }
    }

    static final class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -7647078645895051609L;
        private final ConcurrentSkipListMap<K, V> m;
        private final K lo;
        private final K hi;
        private final boolean loInclusive;
        private final boolean hiInclusive;
        private final boolean isDescending;
        private transient KeySet<K> keySetView;
        private transient Set<Map.Entry<K, V>> entrySetView;
        private transient Collection<V> valuesView;

        SubMap(ConcurrentSkipListMap<K, V> map, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive, boolean isDescending) {
            Comparator cmp = map.comparator;
            if (fromKey != null && toKey != null && ConcurrentSkipListMap.cpr(cmp, fromKey, toKey) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = map;
            this.lo = fromKey;
            this.hi = toKey;
            this.loInclusive = fromInclusive;
            this.hiInclusive = toInclusive;
            this.isDescending = isDescending;
        }

        boolean tooLow(Object key, Comparator<? super K> cmp) {
            int c;
            return this.lo != null && ((c = ConcurrentSkipListMap.cpr(cmp, key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        boolean tooHigh(Object key, Comparator<? super K> cmp) {
            int c;
            return this.hi != null && ((c = ConcurrentSkipListMap.cpr(cmp, key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        boolean inBounds(Object key, Comparator<? super K> cmp) {
            return !this.tooLow(key, cmp) && !this.tooHigh(key, cmp);
        }

        void checkKeyBounds(K key, Comparator<? super K> cmp) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key, cmp)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        boolean isBeforeEnd(Node<K, V> n, Comparator<? super K> cmp) {
            if (n == null) {
                return false;
            }
            if (this.hi == null) {
                return true;
            }
            Object k = n.key;
            if (k == null) {
                return true;
            }
            int c = ConcurrentSkipListMap.cpr(cmp, k, this.hi);
            return c <= 0 && (c != 0 || this.hiInclusive);
        }

        Node<K, V> loNode(Comparator<? super K> cmp) {
            if (this.lo == null) {
                return this.m.findFirst();
            }
            if (this.loInclusive) {
                return this.m.findNear((K)this.lo, 1, cmp);
            }
            return this.m.findNear((K)this.lo, 0, cmp);
        }

        Node<K, V> hiNode(Comparator<? super K> cmp) {
            if (this.hi == null) {
                return this.m.findLast();
            }
            if (this.hiInclusive) {
                return this.m.findNear((K)this.hi, 3, cmp);
            }
            return this.m.findNear((K)this.hi, 2, cmp);
        }

        K lowestKey() {
            Comparator cmp = this.m.comparator;
            Node n = this.loNode(cmp);
            if (this.isBeforeEnd(n, cmp)) {
                return n.key;
            }
            throw new NoSuchElementException();
        }

        K highestKey() {
            Object last;
            Comparator cmp = this.m.comparator;
            Node n = this.hiNode(cmp);
            if (n != null && this.inBounds(last = n.key, cmp)) {
                return last;
            }
            throw new NoSuchElementException();
        }

        Map.Entry<K, V> lowestEntry() {
            Node n;
            AbstractMap.SimpleImmutableEntry e;
            Comparator cmp = this.m.comparator;
            do {
                if (this.isBeforeEnd(n = this.loNode(cmp), cmp)) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        Map.Entry<K, V> highestEntry() {
            Node n;
            AbstractMap.SimpleImmutableEntry e;
            Comparator cmp = this.m.comparator;
            do {
                if ((n = this.hiNode(cmp)) != null && this.inBounds(n.key, cmp)) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        Map.Entry<K, V> removeLowest() {
            Object k;
            V v;
            Comparator cmp = this.m.comparator;
            do {
                Node n;
                if ((n = this.loNode(cmp)) == null) {
                    return null;
                }
                k = n.key;
                if (this.inBounds(k, cmp)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        Map.Entry<K, V> removeHighest() {
            Object k;
            V v;
            Comparator cmp = this.m.comparator;
            do {
                Node n;
                if ((n = this.hiNode(cmp)) == null) {
                    return null;
                }
                k = n.key;
                if (this.inBounds(k, cmp)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        Map.Entry<K, V> getNearEntry(K key, int rel) {
            Object k;
            Node n;
            V v;
            Comparator cmp = this.m.comparator;
            if (this.isDescending) {
                rel = (rel & 2) == 0 ? (rel |= 2) : (rel &= 0xFFFFFFFD);
            }
            if (this.tooLow(key, cmp)) {
                return (rel & 2) != 0 ? null : this.lowestEntry();
            }
            if (this.tooHigh(key, cmp)) {
                return (rel & 2) != 0 ? this.highestEntry() : null;
            }
            do {
                if ((n = this.m.findNear(key, rel, cmp)) == null || !this.inBounds(n.key, cmp)) {
                    return null;
                }
                k = n.key;
            } while ((v = n.getValidValue()) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        K getNearKey(K key, int rel) {
            Object k;
            Node n;
            V v;
            Comparator cmp = this.m.comparator;
            if (this.isDescending) {
                rel = (rel & 2) == 0 ? (rel |= 2) : (rel &= 0xFFFFFFFD);
            }
            if (this.tooLow(key, cmp)) {
                Node n2;
                if ((rel & 2) == 0 && this.isBeforeEnd(n2 = this.loNode(cmp), cmp)) {
                    return n2.key;
                }
                return null;
            }
            if (this.tooHigh(key, cmp)) {
                Object last;
                Node n3;
                if ((rel & 2) != 0 && (n3 = this.hiNode(cmp)) != null && this.inBounds(last = n3.key, cmp)) {
                    return last;
                }
                return null;
            }
            do {
                if ((n = this.m.findNear(key, rel, cmp)) == null || !this.inBounds(n.key, cmp)) {
                    return null;
                }
                k = n.key;
            } while ((v = n.getValidValue()) == null);
            return k;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.inBounds(key, this.m.comparator) && this.m.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return !this.inBounds(key, this.m.comparator) ? null : (V)this.m.get(key);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key, this.m.comparator);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            return !this.inBounds(key, this.m.comparator) ? null : (V)this.m.remove(key);
        }

        @Override
        public int size() {
            Comparator cmp = this.m.comparator;
            long count = 0L;
            Node n = this.loNode(cmp);
            while (this.isBeforeEnd(n, cmp)) {
                if (n.getValidValue() != null) {
                    ++count;
                }
                n = n.next;
            }
            return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        }

        @Override
        public boolean isEmpty() {
            Comparator cmp = this.m.comparator;
            return !this.isBeforeEnd(this.loNode(cmp), cmp);
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Comparator cmp = this.m.comparator;
            Node n = this.loNode(cmp);
            while (this.isBeforeEnd(n, cmp)) {
                V v = n.getValidValue();
                if (v != null && value.equals(v)) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }

        @Override
        public void clear() {
            Comparator cmp = this.m.comparator;
            Node n = this.loNode(cmp);
            while (this.isBeforeEnd(n, cmp)) {
                if (n.getValidValue() != null) {
                    this.m.remove(n.key);
                }
                n = n.next;
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key, this.m.comparator);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.inBounds(key, this.m.comparator) && this.m.remove(key, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key, this.m.comparator);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key, this.m.comparator);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator<K> cmp = this.m.comparator();
            if (this.isDescending) {
                return Collections.reverseOrder(cmp);
            }
            return cmp;
        }

        SubMap<K, V> newSubMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            Comparator cmp = this.m.comparator;
            if (this.isDescending) {
                K tk = fromKey;
                fromKey = toKey;
                toKey = tk;
                boolean ti = fromInclusive;
                fromInclusive = toInclusive;
                toInclusive = ti;
            }
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    int c = ConcurrentSkipListMap.cpr(cmp, fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    int c = ConcurrentSkipListMap.cpr(cmp, toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive, this.isDescending);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public SubMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public SubMap<K, V> descendingMap() {
            return new SubMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive, !this.isDescending);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return this.getNearEntry(key, 1);
        }

        @Override
        public K ceilingKey(K key) {
            return this.getNearKey(key, 1);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return this.getNearEntry(key, 2);
        }

        @Override
        public K lowerKey(K key) {
            return this.getNearKey(key, 2);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return this.getNearEntry(key, 3);
        }

        @Override
        public K floorKey(K key) {
            return this.getNearKey(key, 3);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return this.getNearEntry(key, 0);
        }

        @Override
        public K higherKey(K key) {
            return this.getNearKey(key, 0);
        }

        @Override
        public K firstKey() {
            return this.isDescending ? this.highestKey() : this.lowestKey();
        }

        @Override
        public K lastKey() {
            return this.isDescending ? this.lowestKey() : this.highestKey();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.isDescending ? this.highestEntry() : this.lowestEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.isDescending ? this.lowestEntry() : this.highestEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.isDescending ? this.removeHighest() : this.removeLowest();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.isDescending ? this.removeLowest() : this.removeHighest();
        }

        @Override
        public NavigableSet<K> keySet() {
            KeySet<K> ks = this.keySetView;
            return ks != null ? ks : (this.keySetView = new KeySet(this));
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            KeySet<K> ks = this.keySetView;
            return ks != null ? ks : (this.keySetView = new KeySet(this));
        }

        @Override
        public Collection<V> values() {
            Collection<V> vs = this.valuesView;
            return vs != null ? vs : (this.valuesView = new Values<V>(this));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new EntrySet<K, V>(this));
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return ((SubMap)this.descendingMap()).navigableKeySet();
        }

        Iterator<K> keyIterator() {
            return new SubMapKeyIterator();
        }

        Iterator<V> valueIterator() {
            return new SubMapValueIterator();
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new SubMapEntryIterator();
        }

        final class SubMapEntryIterator
        extends SubMapIter<Map.Entry<K, V>> {
            SubMapEntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                Node n = this.next;
                Object v = this.nextValue;
                this.advance();
                return new AbstractMap.SimpleImmutableEntry(n.key, v);
            }

            @Override
            public int characteristics() {
                return 1;
            }
        }

        final class SubMapKeyIterator
        extends SubMapIter<K> {
            SubMapKeyIterator() {
            }

            @Override
            public K next() {
                Node n = this.next;
                this.advance();
                return n.key;
            }

            @Override
            public int characteristics() {
                return 21;
            }

            @Override
            public final Comparator<? super K> getComparator() {
                return SubMap.this.comparator();
            }
        }

        final class SubMapValueIterator
        extends SubMapIter<V> {
            SubMapValueIterator() {
            }

            @Override
            public V next() {
                Object v = this.nextValue;
                this.advance();
                return v;
            }

            @Override
            public int characteristics() {
                return 0;
            }
        }

        abstract class SubMapIter<T>
        implements Iterator<T>,
        Spliterator<T> {
            Node<K, V> lastReturned;
            Node<K, V> next;
            V nextValue;

            SubMapIter() {
                block3: {
                    Object x;
                    Comparator cmp = ((SubMap)SubMap.this).m.comparator;
                    do {
                        Node node = this.next = SubMap.this.isDescending ? SubMap.this.hiNode(cmp) : SubMap.this.loNode(cmp);
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (!SubMap.this.inBounds(this.next.key, cmp)) {
                        this.next = null;
                    } else {
                        Object vv = x;
                        this.nextValue = vv;
                    }
                }
            }

            @Override
            public final boolean hasNext() {
                return this.next != null;
            }

            final void advance() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.next;
                if (SubMap.this.isDescending) {
                    this.descend();
                } else {
                    this.ascend();
                }
            }

            private void ascend() {
                block3: {
                    Object x;
                    Comparator cmp = ((SubMap)SubMap.this).m.comparator;
                    do {
                        this.next = this.next.next;
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (SubMap.this.tooHigh(this.next.key, cmp)) {
                        this.next = null;
                    } else {
                        Object vv = x;
                        this.nextValue = vv;
                    }
                }
            }

            private void descend() {
                block3: {
                    Object x;
                    Comparator cmp = ((SubMap)SubMap.this).m.comparator;
                    do {
                        this.next = SubMap.this.m.findNear(this.lastReturned.key, 2, cmp);
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (SubMap.this.tooLow(this.next.key, cmp)) {
                        this.next = null;
                    } else {
                        Object vv = x;
                        this.nextValue = vv;
                    }
                }
            }

            @Override
            public void remove() {
                Node l = this.lastReturned;
                if (l == null) {
                    throw new IllegalStateException();
                }
                SubMap.this.m.remove(l.key);
                this.lastReturned = null;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (this.hasNext()) {
                    action.accept(this.next());
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }
        }
    }

    static final class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        final ConcurrentNavigableMap<K1, V1> m;

        EntrySet(ConcurrentNavigableMap<K1, V1> map) {
            this.m = map;
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).entryIterator();
            }
            return ((SubMap)this.m).entryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = this.m.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.m.remove(e.getKey(), e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }

        @Override
        public Spliterator<Map.Entry<K1, V1>> spliterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).entrySpliterator();
            }
            return (Spliterator)((Object)((SubMap)this.m).entryIterator());
        }
    }

    static final class Values<E>
    extends AbstractCollection<E> {
        final ConcurrentNavigableMap<?, E> m;

        Values(ConcurrentNavigableMap<?, E> map) {
            this.m = map;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).valueIterator();
            }
            return ((SubMap)this.m).valueIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsValue(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }

        @Override
        public Spliterator<E> spliterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).valueSpliterator();
            }
            return (Spliterator)((Object)((SubMap)this.m).valueIterator());
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        final ConcurrentNavigableMap<E, ?> m;

        KeySet(ConcurrentNavigableMap<E, ?> map) {
            this.m = map;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E pollFirst() {
            Map.Entry e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).keyIterator();
            }
            return ((SubMap)this.m).keyIterator();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new KeySet<E>(this.m.subMap((Object)fromElement, fromInclusive, (Object)toElement, toInclusive));
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new KeySet<E>(this.m.headMap((Object)toElement, inclusive));
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new KeySet<E>(this.m.tailMap((Object)fromElement, inclusive));
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public NavigableSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap());
        }

        @Override
        public Spliterator<E> spliterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).keySpliterator();
            }
            return (Spliterator)((Object)((SubMap)this.m).keyIterator());
        }
    }

    final class EntryIterator
    extends Iter<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            Node n = this.next;
            Object v = this.nextValue;
            this.advance();
            return new AbstractMap.SimpleImmutableEntry(n.key, v);
        }
    }

    final class KeyIterator
    extends Iter<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            Node n = this.next;
            this.advance();
            return n.key;
        }
    }

    final class ValueIterator
    extends Iter<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            Object v = this.nextValue;
            this.advance();
            return v;
        }
    }

    abstract class Iter<T>
    implements Iterator<T> {
        Node<K, V> lastReturned;
        Node<K, V> next;
        V nextValue;

        Iter() {
            while ((this.next = ConcurrentSkipListMap.this.findFirst()) != null) {
                Object x = this.next.value;
                if (x == null || x == this.next) continue;
                Object vv = x;
                this.nextValue = vv;
                break;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final void advance() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            while ((this.next = this.next.next) != null) {
                Object x = this.next.value;
                if (x == null || x == this.next) continue;
                Object vv = x;
                this.nextValue = vv;
                break;
            }
        }

        @Override
        public void remove() {
            Node l = this.lastReturned;
            if (l == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListMap.this.remove(l.key);
            this.lastReturned = null;
        }
    }

    static final class HeadIndex<K, V>
    extends Index<K, V> {
        final int level;

        HeadIndex(Node<K, V> node, Index<K, V> down, Index<K, V> right, int level) {
            super(node, down, right);
            this.level = level;
        }
    }

    static class Index<K, V> {
        final Node<K, V> node;
        final Index<K, V> down;
        volatile Index<K, V> right;
        private static final Unsafe U = Unsafe.getUnsafe();
        private static final long RIGHT;

        Index(Node<K, V> node, Index<K, V> down, Index<K, V> right) {
            this.node = node;
            this.down = down;
            this.right = right;
        }

        final boolean casRight(Index<K, V> cmp, Index<K, V> val) {
            return U.compareAndSwapObject(this, RIGHT, cmp, val);
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index<K, V> succ, Index<K, V> newSucc) {
            Node<K, V> n = this.node;
            newSucc.right = succ;
            return n.value != null && this.casRight(succ, newSucc);
        }

        final boolean unlink(Index<K, V> succ) {
            return this.node.value != null && this.casRight(succ, succ.right);
        }

        static {
            try {
                RIGHT = U.objectFieldOffset(Index.class.getDeclaredField("right"));
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
    }

    static final class Node<K, V> {
        final K key;
        volatile Object value;
        volatile Node<K, V> next;
        private static final Unsafe U = Unsafe.getUnsafe();
        private static final long VALUE;
        private static final long NEXT;

        Node(K key, Object value, Node<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        Node(Node<K, V> next) {
            this.key = null;
            this.value = this;
            this.next = next;
        }

        boolean casValue(Object cmp, Object val) {
            return U.compareAndSwapObject(this, VALUE, cmp, val);
        }

        boolean casNext(Node<K, V> cmp, Node<K, V> val) {
            return U.compareAndSwapObject(this, NEXT, cmp, val);
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node<K, V> f) {
            return this.casNext(f, new Node<K, V>(f));
        }

        void helpDelete(Node<K, V> b, Node<K, V> f) {
            if (f == this.next && this == b.next) {
                if (f == null || f.value != f) {
                    this.casNext(f, new Node<K, V>(f));
                } else {
                    b.casNext(this, f.next);
                }
            }
        }

        V getValidValue() {
            Object v = this.value;
            if (v == this || v == BASE_HEADER) {
                return null;
            }
            Object vv = v;
            return (V)vv;
        }

        AbstractMap.SimpleImmutableEntry<K, V> createSnapshot() {
            Object v = this.value;
            if (v == null || v == this || v == BASE_HEADER) {
                return null;
            }
            Object vv = v;
            return new AbstractMap.SimpleImmutableEntry<K, Object>(this.key, vv);
        }

        static {
            try {
                VALUE = U.objectFieldOffset(Node.class.getDeclaredField("value"));
                NEXT = U.objectFieldOffset(Node.class.getDeclaredField("next"));
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
    }
}

