/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Flow {
    static final int DEFAULT_BUFFER_SIZE = 256;

    private Flow() {
    }

    public static int defaultBufferSize() {
        return 256;
    }

    public static <T> CompletableFuture<Void> consume(long bufferSize, Publisher<T> publisher, Consumer<? super T> consumer) {
        if (bufferSize <= 0L) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        if (publisher == null || consumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> status = new CompletableFuture<Void>();
        publisher.subscribe(new ConsumeSubscriber<T>(bufferSize, status, consumer));
        return status;
    }

    public static <T> CompletableFuture<Void> consume(Publisher<T> publisher, Consumer<? super T> consumer) {
        return Flow.consume(Flow.defaultBufferSize(), publisher, consumer);
    }

    public static <T, R> CompletableFuture<R> stream(long bufferSize, Publisher<T> publisher, Function<? super Stream<T>, ? extends R> streamFunction) {
        if (bufferSize <= 0L) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        if (publisher == null || streamFunction == null) {
            throw new NullPointerException();
        }
        CompletableFuture status = new CompletableFuture();
        publisher.subscribe(new StreamSubscriber(bufferSize, status, streamFunction));
        return status;
    }

    public static <T, R> CompletableFuture<R> stream(Publisher<T> publisher, Function<? super Stream<T>, ? extends R> streamFunction) {
        return Flow.stream(Flow.defaultBufferSize(), publisher, streamFunction);
    }

    static final class StreamSubscriber<T, R>
    extends CompletableSubscriber<T, R> {
        final Function<? super Stream<T>, ? extends R> fn;
        final ArrayList<T> items;

        StreamSubscriber(long bufferSize, CompletableFuture<R> status, Function<? super Stream<T>, ? extends R> fn) {
            super(bufferSize, status);
            this.fn = fn;
            this.items = new ArrayList();
        }

        @Override
        public void accept(T item) {
            this.items.add(item);
        }

        @Override
        public void onComplete() {
            this.status.complete(this.fn.apply(this.items.stream()));
        }
    }

    static final class ConsumeSubscriber<T>
    extends CompletableSubscriber<T, Void> {
        final Consumer<? super T> consumer;

        ConsumeSubscriber(long bufferSize, CompletableFuture<Void> status, Consumer<? super T> consumer) {
            super(bufferSize, status);
            this.consumer = consumer;
        }

        @Override
        public void accept(T item) {
            this.consumer.accept(item);
        }

        @Override
        public void onComplete() {
            this.status.complete(null);
        }
    }

    static abstract class CompletableSubscriber<T, U>
    implements Subscriber<T>,
    Consumer<T> {
        final CompletableFuture<U> status;
        Subscription subscription;
        long requestSize;
        long count;

        CompletableSubscriber(long bufferSize, CompletableFuture<U> status) {
            this.status = status;
            this.requestSize = bufferSize;
        }

        @Override
        public final void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            this.subscription.request(this.requestSize);
            this.count = this.requestSize -= this.requestSize >>> 1;
        }

        @Override
        public final void onError(Throwable ex) {
            this.status.completeExceptionally(ex);
        }

        @Override
        public void onNext(T item) {
            try {
                if (--this.count <= 0L) {
                    this.count = this.requestSize;
                    this.subscription.request(this.count);
                }
                this.accept(item);
            }
            catch (Throwable ex) {
                this.status.completeExceptionally(ex);
            }
        }
    }

    public static interface Processor<T, R>
    extends Subscriber<T>,
    Publisher<R> {
    }

    public static interface Subscription {
        public void request(long var1);

        public void cancel();
    }

    public static interface Subscriber<T> {
        public void onSubscribe(Subscription var1);

        public void onNext(T var1);

        public void onError(Throwable var1);

        public void onComplete();
    }

    @FunctionalInterface
    public static interface Publisher<T> {
        public void subscribe(Subscriber<? super T> var1);
    }
}

