/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class Phaser {
    private volatile long state;
    private static final int MAX_PARTIES = 65535;
    private static final int MAX_PHASE = Integer.MAX_VALUE;
    private static final int PARTIES_SHIFT = 16;
    private static final int PHASE_SHIFT = 32;
    private static final int UNARRIVED_MASK = 65535;
    private static final long PARTIES_MASK = 0xFFFF0000L;
    private static final long COUNTS_MASK = 0xFFFFFFFFL;
    private static final long TERMINATION_BIT = Long.MIN_VALUE;
    private static final int ONE_ARRIVAL = 1;
    private static final int ONE_PARTY = 65536;
    private static final int ONE_DEREGISTER = 65537;
    private static final int EMPTY = 1;
    private final Phaser parent;
    private final Phaser root;
    private final AtomicReference<QNode> evenQ;
    private final AtomicReference<QNode> oddQ;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int SPINS_PER_ARRIVAL = NCPU < 2 ? 1 : 256;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long STATE;

    private static int unarrivedOf(long s) {
        int counts = (int)s;
        return counts == 1 ? 0 : counts & 0xFFFF;
    }

    private static int partiesOf(long s) {
        return (int)s >>> 16;
    }

    private static int phaseOf(long s) {
        return (int)(s >>> 32);
    }

    private static int arrivedOf(long s) {
        int counts = (int)s;
        return counts == 1 ? 0 : (counts >>> 16) - (counts & 0xFFFF);
    }

    private AtomicReference<QNode> queueFor(int phase) {
        return (phase & 1) == 0 ? this.evenQ : this.oddQ;
    }

    private String badArrive(long s) {
        return "Attempted arrival of unregistered party for " + this.stateToString(s);
    }

    private String badRegister(long s) {
        return "Attempt to register more than 65535 parties for " + this.stateToString(s);
    }

    private int doArrive(int adjust) {
        int unarrived;
        int phase;
        long s;
        Phaser root = this.root;
        do {
            if ((phase = (int)((s = root == this ? this.state : this.reconcileState()) >>> 32)) < 0) {
                return phase;
            }
            int counts = (int)s;
            int n = unarrived = counts == 1 ? 0 : counts & 0xFFFF;
            if (unarrived > 0) continue;
            throw new IllegalStateException(this.badArrive(s));
        } while (!U.compareAndSwapLong(this, STATE, s, s -= (long)adjust));
        if (unarrived == 1) {
            long n = s & 0xFFFF0000L;
            int nextUnarrived = (int)n >>> 16;
            if (root == this) {
                n = this.onAdvance(phase, nextUnarrived) ? (n |= Long.MIN_VALUE) : (nextUnarrived == 0 ? (n |= 1L) : (n |= (long)nextUnarrived));
                int nextPhase = phase + 1 & Integer.MAX_VALUE;
                U.compareAndSwapLong(this, STATE, s, n |= (long)nextPhase << 32);
                this.releaseWaiters(phase);
            } else if (nextUnarrived == 0) {
                phase = this.parent.doArrive(65537);
                U.compareAndSwapLong(this, STATE, s, s | 1L);
            } else {
                phase = this.parent.doArrive(1);
            }
        }
        return phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRegister(int registrations) {
        int phase;
        long adjust = (long)registrations << 16 | (long)registrations;
        Phaser parent = this.parent;
        while (true) {
            long s = parent == null ? this.state : this.reconcileState();
            int counts = (int)s;
            int parties = counts >>> 16;
            int unarrived = counts & 0xFFFF;
            if (registrations > 65535 - parties) {
                throw new IllegalStateException(this.badRegister(s));
            }
            phase = (int)(s >>> 32);
            if (phase < 0) break;
            if (counts != 1) {
                if (parent != null && this.reconcileState() != s) continue;
                if (unarrived == 0) {
                    this.root.internalAwaitAdvance(phase, null);
                    continue;
                }
                if (!U.compareAndSwapLong(this, STATE, s, s + adjust)) continue;
                break;
            }
            if (parent == null) {
                long next = (long)phase << 32 | adjust;
                if (!U.compareAndSwapLong(this, STATE, s, next)) continue;
                break;
            }
            Phaser phaser = this;
            synchronized (phaser) {
                if (this.state == s) {
                    phase = parent.doRegister(1);
                    if (phase < 0) {
                        break;
                    }
                    while (!U.compareAndSwapLong(this, STATE, s, (long)phase << 32 | adjust)) {
                        s = this.state;
                        phase = (int)(this.root.state >>> 32);
                    }
                    break;
                }
            }
        }
        return phase;
    }

    private long reconcileState() {
        Phaser root = this.root;
        long s = this.state;
        if (root != this) {
            int phase;
            while ((phase = (int)(root.state >>> 32)) != (int)(s >>> 32)) {
                int p;
                if (U.compareAndSwapLong(this, STATE, s, s = (long)phase << 32 | (phase < 0 ? s & 0xFFFFFFFFL : ((p = (int)s >>> 16) == 0 ? 1L : s & 0xFFFF0000L | (long)p)))) break;
                s = this.state;
            }
        }
        return s;
    }

    public Phaser() {
        this(null, 0);
    }

    public Phaser(int parties) {
        this(null, parties);
    }

    public Phaser(Phaser parent) {
        this(parent, 0);
    }

    public Phaser(Phaser parent, int parties) {
        if (parties >>> 16 != 0) {
            throw new IllegalArgumentException("Illegal number of parties");
        }
        int phase = 0;
        this.parent = parent;
        if (parent != null) {
            Phaser root;
            this.root = root = parent.root;
            this.evenQ = root.evenQ;
            this.oddQ = root.oddQ;
            if (parties != 0) {
                phase = parent.doRegister(1);
            }
        } else {
            this.root = this;
            this.evenQ = new AtomicReference();
            this.oddQ = new AtomicReference();
        }
        this.state = parties == 0 ? 1L : (long)phase << 32 | (long)parties << 16 | (long)parties;
    }

    public int register() {
        return this.doRegister(1);
    }

    public int bulkRegister(int parties) {
        if (parties < 0) {
            throw new IllegalArgumentException();
        }
        if (parties == 0) {
            return this.getPhase();
        }
        return this.doRegister(parties);
    }

    public int arrive() {
        return this.doArrive(1);
    }

    public int arriveAndDeregister() {
        return this.doArrive(65537);
    }

    public int arriveAndAwaitAdvance() {
        int unarrived;
        int phase;
        long s;
        Phaser root = this.root;
        do {
            if ((phase = (int)((s = root == this ? this.state : this.reconcileState()) >>> 32)) < 0) {
                return phase;
            }
            int counts = (int)s;
            int n = unarrived = counts == 1 ? 0 : counts & 0xFFFF;
            if (unarrived > 0) continue;
            throw new IllegalStateException(this.badArrive(s));
        } while (!U.compareAndSwapLong(this, STATE, s--, s));
        if (unarrived > 1) {
            return root.internalAwaitAdvance(phase, null);
        }
        if (root != this) {
            return this.parent.arriveAndAwaitAdvance();
        }
        long n = s & 0xFFFF0000L;
        int nextUnarrived = (int)n >>> 16;
        n = this.onAdvance(phase, nextUnarrived) ? (n |= Long.MIN_VALUE) : (nextUnarrived == 0 ? (n |= 1L) : (n |= (long)nextUnarrived));
        int nextPhase = phase + 1 & Integer.MAX_VALUE;
        if (!U.compareAndSwapLong(this, STATE, s, n |= (long)nextPhase << 32)) {
            return (int)(this.state >>> 32);
        }
        this.releaseWaiters(phase);
        return nextPhase;
    }

    public int awaitAdvance(int phase) {
        Phaser root = this.root;
        long s = root == this ? this.state : this.reconcileState();
        int p = (int)(s >>> 32);
        if (phase < 0) {
            return phase;
        }
        if (p == phase) {
            return root.internalAwaitAdvance(phase, null);
        }
        return p;
    }

    public int awaitAdvanceInterruptibly(int phase) throws InterruptedException {
        Phaser root = this.root;
        long s = root == this ? this.state : this.reconcileState();
        int p = (int)(s >>> 32);
        if (phase < 0) {
            return phase;
        }
        if (p == phase) {
            QNode node = new QNode(this, phase, true, false, 0L);
            p = root.internalAwaitAdvance(phase, node);
            if (node.wasInterrupted) {
                throw new InterruptedException();
            }
        }
        return p;
    }

    public int awaitAdvanceInterruptibly(int phase, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        Phaser root = this.root;
        long s = root == this ? this.state : this.reconcileState();
        int p = (int)(s >>> 32);
        if (phase < 0) {
            return phase;
        }
        if (p == phase) {
            QNode node = new QNode(this, phase, true, true, nanos);
            p = root.internalAwaitAdvance(phase, node);
            if (node.wasInterrupted) {
                throw new InterruptedException();
            }
            if (p == phase) {
                throw new TimeoutException();
            }
        }
        return p;
    }

    public void forceTermination() {
        long s;
        Phaser root = this.root;
        while ((s = root.state) >= 0L) {
            if (!U.compareAndSwapLong(root, STATE, s, s | Long.MIN_VALUE)) continue;
            this.releaseWaiters(0);
            this.releaseWaiters(1);
            return;
        }
    }

    public final int getPhase() {
        return (int)(this.root.state >>> 32);
    }

    public int getRegisteredParties() {
        return Phaser.partiesOf(this.state);
    }

    public int getArrivedParties() {
        return Phaser.arrivedOf(this.reconcileState());
    }

    public int getUnarrivedParties() {
        return Phaser.unarrivedOf(this.reconcileState());
    }

    public Phaser getParent() {
        return this.parent;
    }

    public Phaser getRoot() {
        return this.root;
    }

    public boolean isTerminated() {
        return this.root.state < 0L;
    }

    protected boolean onAdvance(int phase, int registeredParties) {
        return registeredParties == 0;
    }

    public String toString() {
        return this.stateToString(this.reconcileState());
    }

    private String stateToString(long s) {
        return super.toString() + "[phase = " + Phaser.phaseOf(s) + " parties = " + Phaser.partiesOf(s) + " arrived = " + Phaser.arrivedOf(s) + "]";
    }

    private void releaseWaiters(int phase) {
        QNode q;
        AtomicReference<QNode> head;
        AtomicReference<QNode> atomicReference = head = (phase & 1) == 0 ? this.evenQ : this.oddQ;
        while ((q = head.get()) != null && q.phase != (int)(this.root.state >>> 32)) {
            Thread t;
            if (!head.compareAndSet(q, q.next) || (t = q.thread) == null) continue;
            q.thread = null;
            LockSupport.unpark(t);
        }
    }

    private int abortWait(int phase) {
        AtomicReference<QNode> head = (phase & 1) == 0 ? this.evenQ : this.oddQ;
        while (true) {
            Thread t;
            QNode q = head.get();
            int p = (int)(this.root.state >>> 32);
            if (q == null || (t = q.thread) != null && q.phase == p) {
                return p;
            }
            if (!head.compareAndSet(q, q.next) || t == null) continue;
            q.thread = null;
            LockSupport.unpark(t);
        }
    }

    private int internalAwaitAdvance(int phase, QNode node) {
        long s;
        int p;
        this.releaseWaiters(phase - 1);
        boolean queued = false;
        int lastUnarrived = 0;
        int spins = SPINS_PER_ARRIVAL;
        while ((p = (int)((s = this.state) >>> 32)) == phase) {
            if (node == null) {
                boolean interrupted;
                int unarrived = (int)s & 0xFFFF;
                if (unarrived != lastUnarrived && (lastUnarrived = unarrived) < NCPU) {
                    spins += SPINS_PER_ARRIVAL;
                }
                if (!(interrupted = Thread.interrupted()) && --spins >= 0) continue;
                node = new QNode(this, phase, false, false, 0L);
                node.wasInterrupted = interrupted;
                continue;
            }
            if (node.isReleasable()) break;
            if (!queued) {
                AtomicReference<QNode> head = (phase & 1) == 0 ? this.evenQ : this.oddQ;
                node.next = head.get();
                QNode q = node.next;
                if (q != null && q.phase != phase || (int)(this.state >>> 32) != phase) continue;
                queued = head.compareAndSet(q, node);
                continue;
            }
            try {
                ForkJoinPool.managedBlock(node);
            }
            catch (InterruptedException cantHappen) {
                node.wasInterrupted = true;
            }
        }
        if (node != null) {
            if (node.thread != null) {
                node.thread = null;
            }
            if (node.wasInterrupted && !node.interruptible) {
                Thread.currentThread().interrupt();
            }
            if (p == phase && (p = (int)(this.state >>> 32)) == phase) {
                return this.abortWait(phase);
            }
        }
        this.releaseWaiters(phase);
        return p;
    }

    static {
        try {
            STATE = U.objectFieldOffset(Phaser.class.getDeclaredField("state"));
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        Class<LockSupport> clazz = LockSupport.class;
    }

    static final class QNode
    implements ForkJoinPool.ManagedBlocker {
        final Phaser phaser;
        final int phase;
        final boolean interruptible;
        final boolean timed;
        boolean wasInterrupted;
        long nanos;
        final long deadline;
        volatile Thread thread;
        QNode next;

        QNode(Phaser phaser, int phase, boolean interruptible, boolean timed, long nanos) {
            this.phaser = phaser;
            this.phase = phase;
            this.interruptible = interruptible;
            this.nanos = nanos;
            this.timed = timed;
            this.deadline = timed ? System.nanoTime() + nanos : 0L;
            this.thread = Thread.currentThread();
        }

        @Override
        public boolean isReleasable() {
            if (this.thread == null) {
                return true;
            }
            if (this.phaser.getPhase() != this.phase) {
                this.thread = null;
                return true;
            }
            if (Thread.interrupted()) {
                this.wasInterrupted = true;
            }
            if (this.wasInterrupted && this.interruptible) {
                this.thread = null;
                return true;
            }
            if (this.timed) {
                if (this.nanos > 0L) {
                    this.nanos = this.deadline - System.nanoTime();
                }
                if (this.nanos <= 0L) {
                    this.thread = null;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean block() {
            while (!this.isReleasable()) {
                if (this.timed) {
                    LockSupport.parkNanos(this, this.nanos);
                    continue;
                }
                LockSupport.park(this);
            }
            return true;
        }
    }
}

