/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiPredicate;
import sun.misc.Contended;
import sun.misc.Unsafe;

public class SubmissionPublisher<T>
implements Flow.Publisher<T>,
AutoCloseable {
    static final int BUFFER_CAPACITY_LIMIT = 0x40000000;
    BufferedSubscription<T> clients;
    volatile boolean closed;
    final Executor executor;
    final int maxBufferCapacity;

    static final int roundCapacity(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) <= 0 ? 2 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public SubmissionPublisher(Executor executor, int maxBufferCapacity) {
        if (executor == null) {
            throw new NullPointerException();
        }
        if (maxBufferCapacity <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.executor = executor;
        this.maxBufferCapacity = SubmissionPublisher.roundCapacity(maxBufferCapacity);
    }

    public SubmissionPublisher() {
        this(ForkJoinPool.commonPool(), Flow.defaultBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        BufferedSubscription<T> subscription = new BufferedSubscription<T>(subscriber, this.executor, this.maxBufferCapacity);
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> b = this.clients;
            BufferedSubscription<T> pred = null;
            while (true) {
                if (b == null) {
                    subscription.onSubscribe();
                    if (this.closed) {
                        subscription.onComplete();
                        break;
                    }
                    if (pred == null) {
                        this.clients = subscription;
                        break;
                    }
                    pred.next = subscription;
                    break;
                }
                BufferedSubscription next = b.next;
                if (b.isDisabled()) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    if (subscriber.equals(b.subscriber)) {
                        b.onError(new IllegalStateException("Duplicate subscribe"));
                        break;
                    }
                    pred = b;
                }
                b = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submit(T item) {
        boolean complete;
        if (item == null) {
            throw new NullPointerException();
        }
        int lag = 0;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            complete = this.closed;
            BufferedSubscription<T> b = this.clients;
            if (!complete) {
                int stat;
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> r = null;
                BufferedSubscription<T> rtail = null;
                while (b != null) {
                    BufferedSubscription next = b.next;
                    stat = b.offer(item);
                    if (stat < 0) {
                        b.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        if (stat > lag) {
                            lag = stat;
                        } else if (stat == 0) {
                            b.nextRetry = null;
                            if (rtail == null) {
                                r = b;
                            } else {
                                rtail.nextRetry = b;
                            }
                            rtail = b;
                        }
                        pred = b;
                    }
                    b = next;
                }
                while (r != null) {
                    BufferedSubscription<T> nextRetry = r.nextRetry;
                    r.nextRetry = null;
                    stat = r.submit(item);
                    if (stat > lag) {
                        lag = stat;
                    } else if (stat < 0 && this.clients == r) {
                        this.clients = r.next;
                    }
                    r = nextRetry;
                }
            }
        }
        if (complete) {
            throw new IllegalStateException("Closed");
        }
        return lag;
    }

    public int offer(T item, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        return this.doOffer(0L, item, onDrop);
    }

    public int offer(T item, long timeout, TimeUnit unit, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        return this.doOffer(unit.toNanos(timeout), item, onDrop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int doOffer(long nanos, T item, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        boolean complete;
        if (item == null) {
            throw new NullPointerException();
        }
        int lag = 0;
        int drops = 0;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            complete = this.closed;
            BufferedSubscription<T> b = this.clients;
            if (!complete) {
                int stat;
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> r = null;
                BufferedSubscription<T> rtail = null;
                while (b != null) {
                    BufferedSubscription next = b.next;
                    stat = b.offer(item);
                    if (stat < 0) {
                        b.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        if (stat > lag) {
                            lag = stat;
                        } else if (stat == 0) {
                            b.nextRetry = null;
                            if (rtail == null) {
                                r = b;
                            } else {
                                rtail.nextRetry = b;
                            }
                            rtail = b;
                        } else if (stat > lag) {
                            lag = stat;
                        }
                        pred = b;
                    }
                    b = next;
                }
                while (r != null) {
                    BufferedSubscription nextRetry = r.nextRetry;
                    r.nextRetry = null;
                    int n = stat = nanos > 0L ? r.timedOffer(item, nanos) : r.offer(item);
                    if (stat == 0 && onDrop != null && onDrop.test(r.subscriber, item)) {
                        stat = r.offer(item);
                    }
                    if (stat == 0) {
                        ++drops;
                    } else if (stat > lag) {
                        lag = stat;
                    } else if (stat < 0 && this.clients == r) {
                        this.clients = r.next;
                    }
                    r = nextRetry;
                }
            }
        }
        if (complete) {
            throw new IllegalStateException("Closed");
        }
        return drops > 0 ? -drops : lag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            BufferedSubscription<T> b;
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                b = this.clients;
                this.clients = null;
                this.closed = true;
            }
            while (b != null) {
                BufferedSubscription next = b.next;
                b.next = null;
                b.onComplete();
                b = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeExceptionally(Throwable error) {
        if (error == null) {
            throw new NullPointerException();
        }
        if (!this.closed) {
            BufferedSubscription<T> b;
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                b = this.clients;
                this.clients = null;
                this.closed = true;
            }
            while (b != null) {
                BufferedSubscription next = b.next;
                b.next = null;
                b.onError(error);
                b = next;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscribers() {
        boolean nonEmpty = false;
        if (!this.closed) {
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                BufferedSubscription<T> b = this.clients;
                while (b != null) {
                    BufferedSubscription next = b.next;
                    if (b.isDisabled()) {
                        b.next = null;
                        this.clients = next;
                        b = this.clients;
                        continue;
                    }
                    nonEmpty = true;
                    break;
                }
            }
        }
        return nonEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfSubscribers() {
        int count = 0;
        if (!this.closed) {
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> b = this.clients;
                while (b != null) {
                    BufferedSubscription next = b.next;
                    if (b.isDisabled()) {
                        b.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        pred = b;
                        ++count;
                    }
                    b = next;
                }
            }
        }
        return count;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getMaxBufferCapacity() {
        return this.maxBufferCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Flow.Subscriber<? super T>> getSubscribers() {
        ArrayList<Flow.Subscriber<T>> subs = new ArrayList<Flow.Subscriber<T>>();
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            Object pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                if (b.isDisabled()) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    subs.add(b.subscriber);
                }
                b = next;
            }
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        if (!this.closed) {
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> b = this.clients;
                while (b != null) {
                    BufferedSubscription next = b.next;
                    if (b.isDisabled()) {
                        b.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        if (subscriber.equals(b.subscriber)) {
                            return true;
                        }
                        pred = b;
                    }
                    b = next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long estimateMinimumDemand() {
        long min = Long.MAX_VALUE;
        boolean nonEmpty = false;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                int n = b.estimateLag();
                if (n < 0) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    long d = b.demand - (long)n;
                    if (d < min) {
                        min = d;
                    }
                    nonEmpty = true;
                    pred = b;
                }
                b = next;
            }
        }
        return nonEmpty ? min : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int estimateMaximumLag() {
        int max = 0;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                int n = b.estimateLag();
                if (n < 0) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    if (n > max) {
                        max = n;
                    }
                    pred = b;
                }
                b = next;
            }
        }
        return max;
    }

    @Contended
    static final class BufferedSubscription<T>
    implements Flow.Subscription,
    ForkJoinPool.ManagedBlocker {
        long timeout;
        volatile long demand;
        int maxCapacity;
        int putStat;
        int helpDepth;
        volatile int ctl;
        volatile int head;
        volatile int tail;
        Object[] array;
        Flow.Subscriber<? super T> subscriber;
        Executor executor;
        volatile Throwable pendingError;
        volatile Thread waiter;
        T putItem;
        BufferedSubscription<T> next;
        BufferedSubscription<T> nextRetry;
        static final int ACTIVE = 1;
        static final int CONSUME = 2;
        static final int DISABLED = 4;
        static final int ERROR = 8;
        static final int SUBSCRIBE = 16;
        static final int COMPLETE = 32;
        static final long INTERRUPTED = -1L;
        static final int MINCAP = 8;
        private static final Unsafe U = Unsafe.getUnsafe();
        private static final long CTL;
        private static final long TAIL;
        private static final long HEAD;
        private static final long DEMAND;
        private static final int ABASE;
        private static final int ASHIFT;

        BufferedSubscription(Flow.Subscriber<? super T> subscriber, Executor executor, int maxBufferCapacity) {
            this.subscriber = subscriber;
            this.executor = executor;
            this.maxCapacity = maxBufferCapacity;
        }

        final boolean isDisabled() {
            return this.ctl == 4;
        }

        final int estimateLag() {
            int n;
            return this.ctl == 4 ? -1 : ((n = this.tail - this.head) > 0 ? n : 0);
        }

        final int offer(T item) {
            int stat;
            int i;
            int cap;
            Object[] a = this.array;
            int t = this.tail;
            int size = t + 1 - this.head;
            if (a == null || (cap = a.length) < size || (i = t & cap - 1) < 0) {
                stat = this.growAndAdd(a, item);
            } else {
                a[i] = item;
                U.putOrderedInt(this, TAIL, t + 1);
                stat = size;
            }
            return stat > 0 && (this.ctl & 3) != 3 ? this.startOnOffer(stat) : stat;
        }

        private int growAndAdd(Object[] a, T item) {
            int stat;
            int cap;
            if ((this.ctl & 0xC) != 0) {
                cap = 0;
                stat = -1;
            } else if (a == null) {
                cap = 0;
                stat = 1;
            } else {
                cap = a.length;
                stat = cap >= this.maxCapacity ? 0 : cap + 1;
            }
            if (stat > 0) {
                int newCap;
                int n = cap > 0 ? cap << 1 : (this.maxCapacity >= 8 ? 8 : (newCap = this.maxCapacity >= 2 ? this.maxCapacity : 2));
                if (newCap <= cap) {
                    stat = 0;
                } else {
                    Object[] newArray = null;
                    try {
                        newArray = new Object[newCap];
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    if (newArray == null) {
                        if (cap > 0) {
                            this.maxCapacity = cap;
                        }
                        stat = 0;
                    } else {
                        this.array = newArray;
                        int t = this.tail;
                        int newMask = newCap - 1;
                        if (a != null && cap > 0) {
                            int mask = cap - 1;
                            for (int j = this.head; j != t; ++j) {
                                int k = j & mask;
                                Object x = a[k];
                                if (x == null || !U.compareAndSwapObject(a, ((long)k << ASHIFT) + (long)ABASE, x, null)) continue;
                                newArray[j & newMask] = x;
                            }
                        }
                        newArray[t & newMask] = item;
                        this.tail = t + 1;
                    }
                }
            }
            return stat;
        }

        final int submit(T item) {
            Executor e;
            int stat = this.offer(item);
            if (stat == 0 && this.helpDepth == 0 && (e = this.executor) instanceof ForkJoinPool) {
                Thread thread = Thread.currentThread();
                if (thread instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)thread).getPool() == e) {
                    ForkJoinTask<?> t;
                    while ((t = ForkJoinTask.peekNextLocalTask()) != null && t instanceof ConsumerTask && (stat = this.offer(item)) == 0 && t.tryUnfork()) {
                        super.helpConsume();
                    }
                } else if (e == ForkJoinPool.commonPool()) {
                    ForkJoinTask<?> t;
                    while ((t = ForkJoinTask.peekNextLocalTask()) != null && t instanceof ConsumerTask && (stat = this.offer(item)) == 0 && t.tryUnfork()) {
                        super.helpConsume();
                    }
                }
            }
            if (stat == 0 && (stat = this.offer(item)) == 0) {
                this.putItem = item;
                this.timeout = 0L;
                try {
                    ForkJoinPool.managedBlock(this);
                }
                catch (InterruptedException ie) {
                    this.timeout = -1L;
                }
                stat = this.putStat;
                if (this.timeout < 0L) {
                    Thread.currentThread().interrupt();
                }
            }
            return stat;
        }

        final int timedOffer(T item, long nanos) {
            Thread thread;
            Executor e;
            int stat = this.offer(item);
            if (stat == 0 && this.helpDepth == 0 && (e = this.executor) instanceof ForkJoinPool && ((thread = Thread.currentThread()) instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)thread).getPool() == e || e == ForkJoinPool.commonPool())) {
                ForkJoinTask<?> t;
                long deadline = System.nanoTime() + nanos;
                while ((t = ForkJoinTask.peekNextLocalTask()) != null && t instanceof ConsumerTask && (stat = this.offer(item)) == 0 && (nanos = deadline - System.nanoTime()) > 0L && t.tryUnfork()) {
                    super.helpConsume();
                }
            }
            if (stat == 0 && (stat = this.offer(item)) == 0 && (this.timeout = nanos) > 0L) {
                this.putItem = item;
                try {
                    ForkJoinPool.managedBlock(this);
                }
                catch (InterruptedException ie) {
                    this.timeout = -1L;
                }
                stat = this.putStat;
                if (this.timeout < 0L) {
                    Thread.currentThread().interrupt();
                }
            }
            return stat;
        }

        private void helpConsume() {
            this.helpDepth = 1;
            this.consume();
            this.helpDepth = 0;
        }

        private int startOnOffer(int stat) {
            block6: {
                Executor e;
                int c;
                while (true) {
                    if ((c = this.ctl) == 4 || (e = this.executor) == null) {
                        stat = -1;
                        break block6;
                    }
                    if ((c & 1) != 0) {
                        if ((c & 2) == 0 && !U.compareAndSwapInt(this, CTL, c, c | 2)) continue;
                        break block6;
                    }
                    if (this.demand == 0L || this.tail == this.head) break block6;
                    if (U.compareAndSwapInt(this, CTL, c, c | 3)) break;
                }
                try {
                    e.execute(new ConsumerTask(this));
                }
                catch (Error | RuntimeException ex) {
                    while (((c = this.ctl) & 4) == 0 && (c & 1) != 0 && !U.compareAndSwapInt(this, CTL, c, c & 0xFFFFFFFE)) {
                    }
                    throw ex;
                }
            }
            return stat;
        }

        private void detach() {
            Thread w = this.waiter;
            this.array = null;
            this.executor = null;
            this.subscriber = null;
            this.pendingError = null;
            this.waiter = null;
            if (w != null) {
                LockSupport.unpark(w);
            }
        }

        final void onError(Throwable ex) {
            int c;
            while (((c = this.ctl) & 0xC) == 0) {
                if ((c & 1) != 0) {
                    this.pendingError = ex;
                    if (!U.compareAndSwapInt(this, CTL, c, c | 8)) continue;
                    break;
                }
                if (!U.compareAndSwapInt(this, CTL, c, 4)) continue;
                Flow.Subscriber<T> s = this.subscriber;
                if (s != null && ex != null) {
                    try {
                        s.onError(ex);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                this.detach();
                break;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void startOrDisable() {
            Executor e = this.executor;
            if (e == null) return;
            try {
                e.execute(new ConsumerTask(this));
                return;
            }
            catch (Throwable ex) {
                int c;
                do {
                    if ((c = this.ctl) == 4) return;
                    if ((c & 1) != 0) continue;
                    return;
                } while (!U.compareAndSwapInt(this, CTL, c, c & 0xFFFFFFFE));
                this.onError(ex);
                return;
            }
        }

        final void onComplete() {
            int c;
            while ((c = this.ctl) != 4) {
                if (!U.compareAndSwapInt(this, CTL, c, c | 0x23)) continue;
                if ((c & 1) != 0) break;
                this.startOrDisable();
                break;
            }
        }

        final void onSubscribe() {
            int c;
            while ((c = this.ctl) != 4) {
                if (!U.compareAndSwapInt(this, CTL, c, c | 0x13)) continue;
                if ((c & 1) != 0) break;
                this.startOrDisable();
                break;
            }
        }

        @Override
        public void cancel() {
            int c;
            while ((c = this.ctl) != 4) {
                if ((c & 1) != 0) {
                    if (!U.compareAndSwapInt(this, CTL, c, c | 0xA)) continue;
                    break;
                }
                if (!U.compareAndSwapInt(this, CTL, c, 4)) continue;
                this.detach();
                break;
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                int c;
                long d;
                long prev;
                do {
                    if ((d = (prev = this.demand) + n) >= prev) continue;
                    d = Long.MAX_VALUE;
                } while (!U.compareAndSwapLong(this, DEMAND, prev, d));
                while ((c = this.ctl) != 4) {
                    if ((c & 1) != 0) {
                        if ((c & 2) != 0 || U.compareAndSwapInt(this, CTL, c, c | 2)) {
                            break;
                        }
                    } else {
                        int h = this.head;
                        if (h != this.tail) {
                            if (U.compareAndSwapInt(this, CTL, c, c | 3)) {
                                this.startOrDisable();
                                break;
                            }
                        } else if (this.head == h && this.tail == h) break;
                    }
                    if (this.demand != 0L) continue;
                    break;
                }
            } else if (n < 0L) {
                this.onError(new IllegalArgumentException("negative subscription request"));
            }
        }

        @Override
        public final boolean isReleasable() {
            block4: {
                T item = this.putItem;
                if (item != null) {
                    int spins = 8;
                    int r = 0;
                    while (true) {
                        if ((this.putStat = this.offer(item)) != 0) {
                            this.putItem = null;
                            break block4;
                        }
                        if (r == 0) {
                            r = ThreadLocalRandom.nextSecondarySeed();
                            continue;
                        }
                        r ^= r << 6;
                        r ^= r >>> 21;
                        if ((r ^= r << 7) >= 0 && --spins <= 0) break;
                    }
                    return false;
                }
            }
            return true;
        }

        @Override
        public final boolean block() {
            T item = this.putItem;
            if (item != null) {
                long deadline;
                this.putItem = null;
                long nanos = this.timeout;
                long l = deadline = nanos > 0L ? System.nanoTime() + nanos : 0L;
                while ((this.putStat = this.offer(item)) == 0) {
                    if (Thread.interrupted()) {
                        this.timeout = -1L;
                        if (nanos <= 0L) continue;
                        break;
                    }
                    if (nanos > 0L && (nanos = deadline - System.nanoTime()) <= 0L) break;
                    if (this.waiter == null) {
                        this.waiter = Thread.currentThread();
                        continue;
                    }
                    if (nanos > 0L) {
                        LockSupport.parkNanos(this, nanos);
                    } else {
                        LockSupport.park(this);
                    }
                    this.waiter = null;
                }
            }
            this.waiter = null;
            return true;
        }

        final void consume() {
            Flow.Subscriber<Object> s = this.subscriber;
            if (s != null) {
                int h = this.head;
                while (true) {
                    int i;
                    Object x;
                    int n;
                    long d = this.demand;
                    int c = this.ctl;
                    if ((c & 0x1C) != 0) {
                        if ((c & 8) != 0) {
                            Throwable ex = this.pendingError;
                            this.ctl = 4;
                            if (ex == null) continue;
                            try {
                                s.onError(ex);
                            }
                            catch (Throwable ignore) {}
                            continue;
                        }
                        if ((c & 0x10) != 0) {
                            if (!U.compareAndSwapInt(this, CTL, c, c & 0xFFFFFFEF)) continue;
                            try {
                                s.onSubscribe(this);
                            }
                            catch (Throwable ex) {
                                this.onError(ex);
                            }
                            continue;
                        }
                        this.detach();
                        break;
                    }
                    if (h == this.tail) {
                        if ((c & 2) != 0) {
                            U.compareAndSwapInt(this, CTL, c, c & 0xFFFFFFFD);
                            continue;
                        }
                        if ((c & 0x20) != 0) {
                            if (!U.compareAndSwapInt(this, CTL, c, 4)) continue;
                            try {
                                s.onComplete();
                            }
                            catch (Throwable ignore) {}
                            continue;
                        }
                        if (!U.compareAndSwapInt(this, CTL, c, c & 0xFFFFFFFE)) continue;
                        break;
                    }
                    if (d == 0L) {
                        if (this.demand != 0L) continue;
                        if ((c & 2) != 0) {
                            U.compareAndSwapInt(this, CTL, c, c & 0xFFFFFFFD);
                            continue;
                        }
                        if (!U.compareAndSwapInt(this, CTL, c, c & 0xFFFFFFFE)) continue;
                        break;
                    }
                    Object[] a = this.array;
                    if (this.array == null || (n = a.length) == 0 || (x = a[i = h & n - 1]) == null) continue;
                    if ((c & 2) == 0) {
                        U.compareAndSwapInt(this, CTL, c, c | 2);
                        continue;
                    }
                    if (!U.compareAndSwapObject(a, ((long)i << ASHIFT) + (long)ABASE, x, null)) continue;
                    U.putOrderedInt(this, HEAD, ++h);
                    while (!U.compareAndSwapLong(this, DEMAND, d, d - 1L)) {
                        d = this.demand;
                    }
                    Thread w = this.waiter;
                    if (w != null) {
                        this.waiter = null;
                        LockSupport.unpark(w);
                    }
                    try {
                        Object y = x;
                        s.onNext(y);
                    }
                    catch (Throwable ex) {
                        this.onError(ex);
                    }
                }
            }
        }

        static {
            try {
                CTL = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("ctl"));
                TAIL = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("tail"));
                HEAD = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("head"));
                DEMAND = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("demand"));
                ABASE = U.arrayBaseOffset(Object[].class);
                int scale = U.arrayIndexScale(Object[].class);
                if ((scale & scale - 1) != 0) {
                    throw new Error("data type scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
            Class<LockSupport> clazz = LockSupport.class;
        }
    }

    static final class ConsumerTask<T>
    extends ForkJoinTask<Void>
    implements Runnable {
        final BufferedSubscription<T> consumer;

        ConsumerTask(BufferedSubscription<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.consumer.consume();
            return false;
        }

        @Override
        public final void run() {
            this.consumer.consume();
        }
    }
}

